typedef unsigned char u_char;

struct operands {int reg, base, index, scale, disp, op2; u_char *pc;};

struct operands *__modrmdec(pc)
u_char *pc;
{
	static struct operands ops;
	int mod, rm, ss, index, base, sib;
	
	ops.op2 = ((pc[0] >> 3) & 7);
	
	mod = pc[0] >> 6;
	rm = (pc[0] & 7);
	
	ops.reg = -1;
		
	if(mod == 0 && rm == 5)
	{
		ops.disp = *(long *)(pc+1);
		ops.index = ops.base = -1;
		ops.pc = pc + 5;
		return &ops;
	}
	
	sib = rm == 4;
	
	switch(mod)
	{
	    case 0:
	    	ops.disp = 0;
		ops.pc = pc+1+sib;
		break;
	    case 1:
		ops.disp = *(signed char *)(pc+1+sib);
		ops.pc = pc+2+sib;
		break;
	    case 2:
	    	ops.disp = *(int *)(pc+1+sib);
		ops.pc = pc+5+sib;
		break;
	    case 3:
		ops.reg = rm;
		ops.pc = pc+1;
		return &ops;
	}

	if(!sib)
	{
		ops.index = -1;
		ops.base = rm;
		return &ops;
	}
	
	/* There's a SIB */

	ss = pc[1] >> 6;
	index = ((pc[1] >> 3) & 7);		
	base = (pc[1] & 7);
	
	if(index == 4)
		ops.index = -1;
	else
		ops.index = index;
		
	ops.scale = 1 << ss;
	
	if(base == 5 && mod == 0)
	{
		ops.base = -1;
		ops.disp = *(int *)(pc+2);
		ops.pc += 4;
	}
	else
		ops.base = base;
		
	return &ops;
}

#ifdef test
main(argc, argv)
int argc;
char **argv;
{
	static u_char code[6] = {0, 0, 5, 6, 7, 8}, *p;
	int a, b;
	struct operands *ops;
	static char *name[] = {"eax","ecx","edx","ebx","esp","ebp","esi","edi"};
	
	sscanf(argv[1], "%x", &a);
	if(argc > 2)
	{
		sscanf(argv[2], "%x", &b);
		code[0] = a;
		code[1] = b;
		p = code;
	}
	else
	{
		code[1] = a;
		p = code + 1;
	}
	ops = modrmdec(p);

	if(ops->reg != -1)
	{
		printf("\n  op  %s, %s", name[ops->op2], name[ops->reg]);
		printf("        length %d\n\n", ops->pc - p);
		exit(0);
	}
	printf("\n  op  %s, %08x[%s,%s*%d]\n\n", name[ops->op2], ops->disp,
	       ops->base == -1 ? "" : name[ops->base],
	       ops->index == -1 ? "" : name[ops->index],
	       ops->index == -1 ? 0 : ops->scale);
	printf("        length %d\n\n", ops->pc - p);
	exit(0);
}
#endif


