;
;
YES	EQU	0FFH
NO	EQU	0
;
;
;-----------------------------------------------------------------------
;
ESC	EQU	'['-40H	; ^[ = Escape
BELL	EQU	'G'-40H	; ^G = Bell character
LF	EQU	'J'-40H	; ^J = Linefeed
NEXTRY	EQU	'K'-40H	; ^K = Try next phone number, abort this try
CR	EQU	'M'-40H	; ^M = Carriage return
CLEARSC	EQU	'Z'-40H	; ^Z = Clear screen, command mode only
EOFCHAR	EQU	'Z'-40H	; ^Z = End of file
;
;
;====================== CUSTOMIZATION EQUATES ==========================
;
;
SLOT	EQU	2		; Slot of serial interface
SLOTOFF	EQU	16*SLOT		; Serial card slot offset
;
;
; CP/M adapter cards for Apple ][
;
APPLICARD  EQU	YES		; YES if using PCPI Applicard CP/M card
;
;
; Serial I/O cards for Apple ][
;
SABA	EQU	YES		; YES FOR SABA'S *RAY KLIEN SIO CARD*
;
;
;
;
;=======================================================================
;
;
	 IF	APPLICARD
MAPOFF	EQU	0		; No memory remapping for either
	 ENDIF			; ALSCARD
;
;-----------------------------------------------------------------------
;
	IF SABA
CPORT		EQU	80H		;Aplicard CTC baud rate port
					; USE 80H FOR PRIMARY SERIAL PORT
					; USE 81H FOR SECONDARY SERIAL PORT
PORT:		EQU	0FCH		;Aplicard serial output port
					; USE FCH FOR PRIMARY SERIAL PORT
					; USE FEH FOR SECONDARY SERIAL PORT
MODCTL1:	EQU	PORT+1		;Modem control port
MODDATP:	EQU	PORT		;Modem data port
MODCTL2:	EQU	PORT+1		;Modem control port
MODRCVB:	EQU	01H		;Your bit to test for receive
MODRCVR:	EQU	01H		;Your value when receive ready
MODSNDB:	EQU	04H		;Your bit to test for send
MODSNDR:	EQU	04H		;Your value when send ready	

MDDATP	EQU	PORT		; SABA data port
MDCTL1	EQU	PORT+1		; SABA status port
MDRCV	EQU	01H		; Bit to test for received data
MDSND	EQU	04H		; Bit to test for ready to send
MDTXE	EQU	04H		; Modem send buffer empty
	ENDIF 				;SABA 
;
;
; We have software control over the CCS, CPS, SSC and Versacard (if the
; hardware mod is made.)
;
;=======================================================================
;
;
ORG	0100H
;
;
	DS	3	; Skip the data area below
;
;
; These routines and equates are at the beginning of the program so
; they can be patched by a monitor or overlay file without re-assembling
; the program.
;
MSPEED:	 DB	6	; 0=300 1=1200 2=2400 3=9600 4=19200 5=38400	103H
			; 6=57600 7=115200: default = 19200
 IF SABA
IMSPEED	 EQU	6	; Set default baud rate.  This can be set to a
 ENDIF ;SABA		; value of '10' for 38400 bps even though MSPEED
			; will still only be 9.

HS2400:	 DB	NO	; Yes=2400 bps highest speed			104H
HS1200:	 DB	YES	; Yes=1200 bps highest speed			105H
RACAL:	 DB	NO	; Yes=Racal-Vadic 1200V or 2400V or 2400PA	106H
PROMODM: DB	NO	; Yes=Prometheus ProModem 1200 bps		107H
RESVD1:	 DB	NO	; Reserved for special modems			108H
RESVD2:	 DB	NO	; Reserved for special modems			109H
;
;
CLEAR:	 DB	'*'	; Clear screen character (ESC not needed)	10AH
;
;
	  IF	APPLICARD
CLOCK:	 DB	60	; Clock speed in MHz, 25.5 MHz max.		10BH
			; NOTE:  MUST MULTIPLY BY 10 FOR APPLICARD
	  ENDIF		; APPLICARD
;
;
			; 20=2 MHh, 37=3.68 MHz, 40=4 MHz, etc.
BYTDLY:	 DB	2	; 0=0 delay  1=10ms  5=50 ms - 9=90 ms		10CH
			;   default time to send character in ter-
			;   minal mode file transfer for slow BBS
CRDLY:	 DB	2	; 0=0 delay 1=100 ms 5=500 ms - 9=900 ms	10DH
			;   default time for extra wait after CRLF
			;   in terminal mode file transfer
NOFCOL:	 DB	5	; Number of directory columns shown		10EH
TCHPUL:	 DB	'T'	; T=tone, P=Pulse (Hayes 2400 modems)		10FH
;.....
;
;
ADDLFD:	 DB	NO	; Yes=add LF after CR to send file in terminal	110H
			;   mode (normally added by remote echo)
CONVRUB: DB	YES	; Yes=convert rub to backspace			111H
CRCDFLT: DB	YES	; Yes=default to CRC checking			112H
IGNRCTL: DB	NO	; Yes=CTL-chars above ^M not displayed		113H
;.....
;
;
EXTCHR:	 DB	'['-40H	; ESC = preceeds local control character	114H
EXITCHR: DB	'E'	; Exit character				115H
FILESND: DB	'F'	; Send file when in terminal mode		116H
NOCONCT: DB	'N'	; Disconnect from phone line			117H
LOGCHR:	 DB	'L'	; Send logon					118H
LSTCHR:	 DB	'P'	; Toggle printer				119H
UNSAVCH: DB	'R'	; Close input text buffer			11AH
SAVECHR: DB	'Y'	; Open input text buffer			11BH
CLEARS:	 DB	'Z'	; Clears screen, terminal mode			11CH
SPARE1:	 DB	0	; For future development			11DH
SPARE2:	 DB	0	; For future development			11EH
;.....
;
;
; Handles in/out ports for data and status
;
I$MDCTL1: JMP	RCVCTL1		; In modem control port 		11FH
	  DB	0,0,0,0,0,0,0	; Spares if needed			122H
;
I$MDTXE:  JMP	RCVCTL1		;					129H
	  DB	0,0,0,0,0,0,0	;					12CH
;
I$MDDATP: JMP	RCVDATP		;in modem data port			133H
	  DB	0,0,0,0,0,0,0	;					146H
;
O$MDDATP: JMP	SNDDATP		; Out modem data port			13DH
	  DB	0,0,0,0,0,0,0	; Spares if needed			140H
;.....
;
;
A$MDRCV:  ANI	MDRCV		;					147H
	  RET			;					149H
;
C$MDRCV:  CPI	MDRCV		;					14AH
	  RET			;					14CH
;
A$MDSND:  ANI	MDSND		;					14DH
	  RET			;					14FH
;
C$MDSND:  CPI	MDSND		;					150H
	  RET			;					152H
;
A$MDTXE:  ANI	MDTXE		;					153H
	  RET			;					155H
;
C$MDTXE:  CPI	MDTXE		;					156H
	  RET			;					158H
;.....
;
;
; Special exit vector, used by some computers to reset interrupt vectors
;
J$EXITVEC:RET			;					159H
	  DB	0,0		;					15AH
;.....
;
;
; Jump vectors needed by each overlay
;
J$GOODBYE:JMP	GOODBYE		; Disconnects modem by dropping DTR	15CH
J$INITMOD:JMP	INITMOD		; Initializes modem, autosets baudrate	15FH
J$STUPR:  JMP	STUPR		; SET routine to change baudrate	162H
J$SYSVR:  JMP	SYSVR		; Signon message			165H
;.....
;
;
; "AT" command strings, can be replaced in individual overlay if needed
;
J$STRNGA: DS	3		; 1200 bps "AT" string			168H
J$STRNG1: DS	3		; 2400 bps "AT" string			16B:IMP
;
;
; Next fourteen lines should not be changed by user overlay as these go
; to specific locations in the main program, not in the overlay.
;
;
J$CMDSPL: DS	3		; Allows entry of baudrate on CMD line	16EH
J$CRLF:	  DS	3		; Turns up one new line on display	171H
J$DIAL:	  DS	3		; Start of dialing routine		174H
J$DSCONT: DS	3		; Terminates modem use			177H
J$GOLST:  DS	3		; Printer routine, needed by Apple //e	17AH
J$ILPRT:  DS	3		; Prints an inline string, 0 to end	17DH
J$INBUF:  DS	3		; Stores a keybd string for comparison	180H
J$INLNCP: DS	3		; Inline "compare strings" routine	183H
J$INMDM:  DS	3		; Max .1 sec wait for modem character	186H
J$RCVRSP: DS	3		; For 3801 I/O use (TV-803)		189H
J$SNDCHR: DS	3		; Sends a character to the modem	18CH
J$SNDSTR: DS	3		; Sends a string to the modem, $ to end 18FH
J$TIMER:  DS	3		; .1 second timer (amount in 'B' reg.)	192H
J$NEW1:	  DB	0,0,0		; For future needs			195H
J$NEW2:	  DB	0,0,0		; For future needs			198H
;.....
;
;
; For 2400 bps auto-stepdown units
;
MANUAL:	  DB	0		; For manual selection flag		19BH
J$300:	  JMP	OK300		; Sets baudrate to 300 baud		19CH
J$1200:	  JMP	OK1200		; Sets baudrate to 1200 bps		19FH
J$2400:	  JMP	OK2400		; Sets baudrate to 2400 bps		1A2H
;.....
;
;
LOGPTR:	  DW	LOGON		; Pointer to display LOGON message	1A5H
;
SYSVR:	  CALL	J$ILPRT		; Display the following line		1A7H
	  DB	'Apple ][ and '	;					1AAH
;
	 IF APPLICARD
	DB	'Applicard '
	 ENDIF
;
	 IF SABA
	DB	'with Klein-Baker SIO CARD'
	 ENDIF
;
	DB	' in slot ',SLOT+30H,CR,LF
	DB	0
	RET
;.....
;
;
;-----------------------------------------------------------------------
;
; NOTE:  You can change the SYSVER message to be longer or shorter.  The
;	 end of your last routine should terminate by 0400H (601 bytes
;	 available after start of SYSVER).
;
;-----------------------------------------------------------------------
;
; You can put in a message at this location which can be called up with
; (special character-L).  You can put in several lines.  End with a 0.
;
LOGON:	DB	'Hello there from an Apple user',CR,0
;
;-----------------------------------------------------------------------
;
; This routine sets DTR low for 1 second to disconnect the phone
;
GOODBYE	EQU	$
;
	MVI	A,'S'-40H	; X-off to stop host if needed
	CALL	J$SNDCHR
	MVI	B,1		; Wait a moment to let it react
	CALL	J$TIMER

	 IF SABA
; This routine sends a 300 ms. break tone and sets DTR low for the 
; same length of time to disconnect some modems such as the Bell 212A, etc.
;
          MVI	A,15H
	  OUT	MDCTL1		;SEND TO THE STATUS PORT
	  MVI	A,68H		;TURN OFF DTR
;
GOODBYE1: OUT	MDCTL1
	  MVI	B,3		;DELAY 300 MS.
	  CALL	J$TIMER
	  MVI	A,15H
	  OUT	MDCTL1
	  MVI	A,0E8H		;RESTORE TO NORMAL, 8 BITS, DTR ON, ETC.
	  OUT	MDCTL1
	  RET
	ENDIF ;SABA
;
;
;=========================== INITMOD ===================================
;
;
INITMOD	EQU	$
;
;
;
	 IF 	SABA
; Aplicard initialization -- sets CTC timer 00H for send and receive
; baudrate.
;
INITMOD:  
	  MVI	A,10H		;SELECT REG.
	  OUT	MDCTL1
	  MVI	A,18H		;THROW OUT OF MODE
	  OUT	MDCTL1
	  MVI	A,14H		;SELECT REG.
	  OUT	MDCTL1
	  MVI	A,44H		;SET ASCII PARAMETERS X16 CLOCK
	  OUT	MDCTL1
	  MVI	A,13H		;SELECT REG.
	  OUT	MDCTL1
	  MVI	A,0C1H		;ENABLE RECEIVE
	  OUT	MDCTL1
	  MVI	A,15H		;SELECT REG.
	  OUT	MDCTL1
	  MVI	A,0EAH		;ENABLE SEND, DTR, RTS
	  OUT	MDCTL1
;
        MVI	A,IMSPEED
	CPI	0		; 300 bps
	JZ	OK300
	CPI	1		; 1200 bps
	JZ	OK1200
	CPI	2		; 2400 bps
	JZ	OK2400
	CPI	3		; 9600 bps
	JZ	OK9600
	CPI	4  		;19200 bps
	JZ	OK19200
	CPI	5		;38400 bps (only IMSPEED can be 10)
	JZ	OK38400
	CPI	6		;57600 bps (only IMSPEED can be 10)
	JZ	OK57600
	CPI	7		;38400 bps (only IMSPEED can be 10)
	JZ	OK115200
	JMP	STUPR1		; Else ask what is wanted
	 ENDIF ;SABA
;.....
;
;
; If none of the above cards
;
	RET			; From CALL INITMOD
;.....
;
;
; The routine that checks to see if the printer is ready does not work
; with the CPS card.  This routine changes it.	It overwrites the area
; in the main program that normally checks printer status from a BDOS
; call with our own status checks.
;
CPSPRINT:
	RET			; In case CPSPRT was set to 'NO'
;.....
;
;
	  IF SABA
RCVCTL1: IN  MDCTL1
	 RET
;
RCVDATP: IN  MDDATP
	 RET
;
SNDCTL1: OUT MDCTL1 
	 RET
;
SNDDATP: OUT MDDATP
	 RET
	  ENDIF 		;SABA

;
;
; Use the 'SET' command to select a desired baud rate
;
STUPR:	CALL	J$CMDSPL	; Gives us CMDBUF+6
	JNC	STUPR2
;
STUPR1:	CALL	J$ILPRT
	DB	'Input Baud Rate '

IF SABA
	DB	'(300,1200,2400,9600,19200,38400,57600,115200):',0
ENDIF ;SABA

	LXI	D,BAUDBUF	; Point to new input buffer
	CALL	J$INBUF
	CALL	J$CRLF
	LXI	D,BAUDBUF+2
;
STUPR2:	CALL	J$INLNCP	; Compare BAUDBUF+2 with chars. below
	DB	'300',0
	JNC	OK300		; Go if got match
	CALL	J$INLNCP
	DB	'1200',0
	JNC	OK1200
	CALL	J$INLNCP
	DB	'2400',0
	JNC	OK2400
	CALL	J$INLNCP
	DB	'9600',0
	JNC	OK9600
	CALL	J$INLNCP
	DB	'19200',0
	JNC	OK19200
	CALL	J$INLNCP
	DB	'38400',0
	JNC	OK38400
	CALL	J$INLNCP
	DB	'57600',0
	JNC	OK57600
	CALL	J$INLNCP
	DB	'115200',0
	JNC	OK115200
	CALL	J$ILPRT		; All matches failed, tell operator
	DB	'++ Incorrect entry ++',CR,LF,BELL,CR,LF,0
	JMP	STUPR1		; Try again
;
;
	 IF SABA
;
OK300:	  MVI	A,7
	  OUT	CPORT
	  MVI	A,78
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MDCTL1
	  MVI	A,044H		; SET X16 CLOCK
	  OUT	MDCTL1
	  MVI	A,0
	  STA	MSPEED
	  RET
;
OK1200:	  MVI	A,47H
	  OUT	CPORT
	  MVI	A,96
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MDCTL1
	  MVI	A,044H		; SET X16 CLOCK
	  OUT	MDCTL1
	  MVI	A,1
	  STA   MSPEED
	  RET
;
OK2400:	  MVI	A,47H
	  OUT	CPORT
	  MVI	A,48
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MDCTL1
	  MVI	A,044H		; SET X16 CLOCK
	  OUT	MDCTL1
	  MVI	A,2
	  STA   MSPEED
	  RET
;
OK9600:	  MVI	A,47H
	  OUT	CPORT
	  MVI	A,12		; off by 2.34%
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MDCTL1
	  MVI	A,44H		; SET X16 CLOCK 
	  OUT	MDCTL1
	  MVI	A,3
	  STA   MSPEED
	  RET
;
OK19200:  MVI	A,47H
	  OUT	CPORT
	  MVI	A,6		; off by 2.4%
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MDCTL1
	  MVI	A,44H		; SET X16 CLOCK
	  OUT	MDCTL1
	  MVI	A,4
	  STA   MSPEED
	  RET
;
OK38400:  MVI	A,47H
	  OUT	CPORT
	  MVI	A,3		; off by 2.4% but it works fine on mine!
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MDCTL1
	  MVI	A,44H		; SET X16 CLOCK
	  OUT	MDCTL1
	  MVI	A,5
	  STA   MSPEED
	  RET
;
OK57600:  MVI	A,47H
	  OUT	CPORT
	  MVI	A,2		; off by 2.4% but it works fine on mine!
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MDCTL1
	  MVI	A,44H		; SET X16 CLOCK
	  OUT	MDCTL1
	  MVI	A,6
	  STA   MSPEED
	  RET
;
OK115200: MVI	A,47H
	  OUT	CPORT
	  MVI	A,1		; off by 2.4% but it works fine on mine!
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MDCTL1
	  MVI	A,44H		; SET X16 CLOCK
	  OUT	MDCTL1
	  MVI	A,7
	  STA   MSPEED
	  RET
;
	 ENDIF ;SABA
BAUDBUF:DB	10,0,0,0,0,0
	DB	0,0,0,0,0,0
;
;-----------------------------------------------------------------------
;
; NOTE: Must terminate prior to 0400H
;
	END
