; stdhdr - header module for assembler

; macros to access local vars via ix

.macro	load	r1,r2,offset
	ld	r2,(ix+offset)
	ld	r1,(ix+offset+1)
.endm

.macro	save	r1,r2,offset
	ld	(ix+offset),r2
	ld	(ix+offset+1),r1
.endm

; generate address of local var from offset & ix

.macro	addr	offset
	push	ix
	pop	de
	ld	hl,offset
	add	hl,de
.endm

; macros to inc & dec words addressed via ix & offset

.macro	incx	offset
	inc	(ix+offset)
	jr	nz,3
	inc	(ix+offset+1)
.endm

.macro	decx	offset
	ld	a,(ix+offset)
	dec	(ix+offset)
	or	a
	jr	nz,3
	dec	(ix+offset+1)
.endm

; standard CP/M devices as fp's for putc, getc etc.

.var	stdin	1
.var	stdout	2
.var	stderr	3
.var	stdrdr	4
.var	stdpun	5
.var	stdlst	6
.var	stdkbd	7

; size of a fp structure

.var	fbsize	36 + 5 + 512
