
; I2NM-2.ASM  Telephone number overlay file for IMP2 - 08/20/85
;
;
; This file can be edited to make a new library of telephone numbers.
; Each entry must be 34 bytes long.  36 telephone numbers are allowed,
; (A-Z and 0-9).  Follow the format for the library entries already in
; the file.  (Be sure to use spaces, not tabs.)
;
; At least 1 period (.) must precede each phone number in the table.
;
; Room has been left if your phone system requires extra characters such
; as:  1-313-846-6127 rather than the 313-846-6127 used in some areas.
;
;
;	TO USE: First edit this file filling in answers for your own
;		equipment.  Then assemble with ASM.COM or equivalent
;		assembler.
;
;		A>MLOAD IMP2.COM=IMP240.COM,I2NM-1.HEX
;
; NOTE: For those revising the main program, check the location of
;	   NUMBLIB to see if the ORG value used here is correct.  If
;	   not, change as needed.
;
;=======================================================================
;
; 08/20/85 - Added optional delay for dial tone - Irv Hoff
; 06/01/85 - First version for IMP2		- Irv Hoff
;
;=======================================================================
;
;
YES	EQU	0FFH
NO	EQU	0
;
WTDIAL	EQU	5	; Tenths-seconds to wait for dial tone after
			;   busy signal, minimum size redials quicker.
			;   Use 10 for 1 second, 15 for 1-1/2, etc.
XFRSIZ	EQU	16	; File transfer buffer in Kbytes.  Do not make
			;   any larger than BUFSIZ.  16k works fine on
			;   but slowest systems.
;
	ORG	0C00H-50  ;so 'NUMLIB' starts on even page
;
;=======================================================================
;
; Long distance alternate dialing such as MCI, SPRINT, etc.  Must end
; with a '$', use as many commas (2 seconds delay, each) as needed to
; let the alternate dialing code return with a new dial tone.  Fill in
; any character (periods are fine) after the $ to keep number of columns
; to 24, i.e.,	'1234567,,,,12345,,$.....'   --   the first group is the
; MCI or SPRINT access number, the second group is the user number.  A
; small delay is usually required after the billing number also.
;
ALTDIAL1:DB	'xxxxxxx,,,,,,xxxxxxxx,,$'   ;accessed by a < character
ALTDIAL2:DB	'xxxxxxx,,,,,,xxxxxxxx,,$'   ;accessed by a > character
;
;=======================================================================
;
DIALWT:	DB	WTDIAL		; Waits for dial tone after busy signal
SAVSIZ:	DB	XFRSIZ*8	; Can easily change buffer size for file
				;   transfers with DDT for "NUMBLIB-1"
				;   address.
;
;=======================================================================
;
; Phone number library table for auto-dialing.	Each number must be as
; long as"LIBLEN" (EQU at start of program).  Some areas require extra
; characters such as:	1-313-846-7127.  Room is left for those.  Use
; a (<) for alternate dialing system #1, and a (>) for alternate dialing
; System #2.  Either would preceed the actual number, for example:
;
;	DB    'A=Alan Alda..........<123-456-7890'    ;'A'
;
; -	-     -     -	  -	-     -     -	  -	-     -     -
;
; NOTE: At least one dot (.) MUST precede the actual phone number
;
;		'----5---10---15---20---25---30--34'
NUMBLIB:DB	'A=Abel Iwaz.........1-818-956-6164' ; 'A'
	DB	'B=Norman Beeler.....1-408-245-1420' ; 'B'
	DB	'C=Bob Clyne.........1-313-759-6569' ; 'C'
	DB	'D=Bob Dean..........1-215-623-4040' ; 'D'
	DB	'E=Peter Essl........1-215-356-0860' ; 'E'
	DB	'F=Bill Earnest......1-215-398-3937' ; 'F'
	DB	'G=Norm Gregory......1-206-325-1325' ; 'G'
	DB	'H=Dave Hardy TCBBS..1-313-846-6127' ; 'H'
	DB	'I=Gary Inman........1-213-838-9229' ; 'I'
	DB	'J=Al Jewer..........1-414-563-9932' ; 'J'
	DB	'K=Kevin Murphy......1-415-949-1072' ; 'K'
	DB	'L=Tim Linehan.......1-206-357-1325' ; 'L'
	DB	'M=Trevor Marshall...1-805-492-5472' ; 'M'
	DB	'N=Al Mehr...........1-408-238-9621' ; 'N'
	DB	'O=Chuck Metz........1-408-354-5934' ; 'O'
	DB	'P=PRACSA RCPM.......1-415-948-2513' ; 'P'
	DB	'Q=Mitch Orysh.......1-408-559-8843' ; 'Q'
	DB	'R=Ken Reid..........1-713-937-8886' ; 'R'
	DB	'S=Ken Stritzel......1-312-983-5147' ; 'S'
	DB	'T=Douglas Thom......1-408-253-1309' ; 'T'
	DB	'U=..................1-xxx-xxx-xxxx' ; 'U'
	DB	'V=..................1-xxx-xxx-xxxx' ; 'V'
	DB	'W=Clay Walker.......1-408-733-4670' ; 'W'
	DB	'X=..................1-xxx-xxx-xxxx' ; 'X'
	DB	'Y=..................1-xxx-xxx-xxxx' ; 'Y'
	DB	'Z=Znode Central.....1-415-948-6656' ; 'Z'
	DB	'0=Ernest Dryden.....1-615-292-0710' ; '0'
	DB	'1=Tom Ensminger.....1-513-879-6263' ; '1'
	DB	'2=Ben Grey..........1-503-644-4621' ; '2'
	DB	'3=Adam Heath........1-617-776-6029' ; '3'
	DB	'4=Dave Holmes.......1-804-898-7493' ; '4'
	DB	'5=Erwin Reyer.......1-802-393-7399' ; '5'
	DB	'6=Larry Snyder......1-305-677-8086' ; '6'
	DB	'7=Pete Zuroff.......1-201-942-2576' ; '7'
	DB	'8=Spare.............1-xxx-xxx-xxxx' ; '8'
	DB	'9=Spare.............1-xxx-xxx-xxxx' ; '9'
	DB	0		; End
;		'----5---10---15---20---25---30--34'
;
;;;;	END	; (read the note just below this line)
;
; NOTE: IF YOU DO NOT (REPEAT DO NOT) WANT THE FUNCTION KEY ASSIGNMENTS
;	BELOW TO GO INTO THE PROGRAM AT THE SAME TIME, REMOVE THE SEMI-
;	COLONS SO THE WORD "END" IS ACTIVATED.	IF THE SEMICOLONS ARE
;	NOT THERE AT PRESENT, ADDING A FEW AHEAD OF THE "END" LINE WILL
;	ALLOW THE FUNCTION KEY ASSIGNMENTS TO BE ENTERED.
;
;
; IMP240 function key overlay
;
CIRCUM	EQU	5EH		; Circumflex character displays on CRT
ESC	EQU	1BH		; Escape character, if you prefer
CR	EQU	0DH
;
;
INTCPT:	DB	ESC		; Intercept character (prefix)
;
;
; The total characters, indluding CR, 0, etc. is limited to 256.  Use
; I2FUNC.COM to make fast and easy changes of any or all function key
; assignments.	You can change any of them to suit your own purposes,
; using the ones below as an example.
;
FNCTBL:
KEY1:	DB	0,'DIR ',CR,0
KEY2:	DB	1,'DIR *.* $U0AD ',CR,0
KEY3:	DB	2,'KMD S ',0
KEY4:	DB	3,'KMD R ',0
KEY5:	DB	4,'BYE ',CR,0
KEY6:	DB	5,'BBS ',CR,0
KEY7:	DB	6,'(vacant)',0
KEY8:	DB	7,'(vacant)',0
KEY9:	DB	8,'(vacant)',0
KEY0:	DB	9,'Nice chatting, see you again soon... ',CR,0
;
	DS	256-($-FNCTBL)	; Shows characters remaining to 11CA
TBLEND	EQU	$		; The table must terminate by 11CA

	END
