;       MACRO Library for B-Sharp language Version 1 Revision 7 of 06/02/84
;
;       Copyright (c) 1984 by   David A. Wallace
;                               146 Westford St.
;                               Chelmsford,  Ma.
;
;       The BSHARP macro language is a series of macro definitions which provide
;       an "almost-but-not-quite-C" language facility (for those who are
;       musically inclined, the term BSHARP now becomes obvious).
;

;       Function definition

fnc     MACRO   fncname,autosize
fncname&_as equ     autosize
_dn     =       0
	PUSH    BP
	MOV     BP,SP
	SUB     SP,fncname&_as
	ENDM

;       End of function

endfnc  MACRO   fncname
fncname&_return:
	ADD     SP,fncname&_as
	POP     BP
	RET
	ENDM

;       get argument value -- assumes push puts data high-byte-at-the-bottom.

arg     MACRO   argno
	MOV     DX,[BP+(&argno&*2)+4]
	ENDM

;       return -- normal program termination

return  MACRO   fncname,var
	IFNB    <var>
	MOV     DX,var
	ENDIF
	JMP     fncname&_return
	ENDM

;       exit procedure -- abnormal program termination

exit    MACRO
	INT     DOSI_TERM
	ENDM

;       declare automatic storage

declare MACRO   name,length
	IFNB    <length>
	define  name,%_dn,length
_dn     =       _dn+length
	ELSE
	define  name,%_dn,2
_dn     =       _dn+2
	ENDIF
	ENDM

define  MACRO   name,offset,length
name    equ     word ptr [bp-&offset&-&length&]
	ENDM

;       while

while   MACRO   lbl,var1,rel,var2
	LOCAL   a
lbl&_cont:
	IFNB    <var1>
	MOV     DX,var1
	ENDIF
	IFNB    <rel>
	CMP     DX,var2
	J&rel   a
	ELSE
	AND     DX,DX
	JNZ     a
	ENDIF
	JMP     lbl&_break
a:
	ENDM

;       end of while

endwh   MACRO   lbl
	JMP     lbl&_cont
lbl&_break:
	ENDM

;       if

bsif    MACRO   lbl,var1,rel,var2
	LOCAL   a
	IFNB    <var1>
	MOV     DX,var1
	ENDIF
	IFNB    <rel>
	CMP     DX,var2
	J&rel   a
	ELSE
	AND     DX,DX
	JNZ     a
	ENDIF
	JMP     lbl&_else
a:
	ENDM

;       else

bselse  MACRO   lbl
	JMP     lbl&_endelse
lbl&_else:
	ENDM

;       end of else clause

bsendelse       MACRO   lbl
lbl&_endelse:
	ENDM

;       end of else-less if

bsendif MACRO   lbl
lbl&_else:
	ENDM

;       for

for     MACRO   lbl,var,set,rel,var2,inc
	LOCAL   a
	IFNB    <set>
	MOV     DX,set
	MOV     var,DX
	ENDIF
	JMP     a
lbl&_cont:
	MOV     DX,var
	IFNB    <inc>
	ADD     DX,inc
	MOV     var,DX
	ENDIF
a:
	bsif    lbl&xif,var,rel,var2
	ENDM

;       end of for

endfor  MACRO   lbl
	JMP     lbl&_cont
	bsendif lbl&xif
lbl&_break:
	ENDM

;       break

break   MACRO   lbl
	JMP     lbl&_break
	ENDM

;       continue

continue        MACRO   lbl
	JMP     lbl&_cont
	ENDM

;       call function

callfnc MACRO   name,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9
	IFNB    <a9>
	MOV     DX,a9
	PUSH    DX
	ENDIF
	IFNB    <a8>
	MOV     DX,a8
	PUSH    DX
	ENDIF
	IFNB    <a7>
	MOV     DX,a7
	PUSH    DX
	ENDIF
	IFNB    <a6>
	MOV     DX,a6
	PUSH    DX
	ENDIF
	IFNB    <a5>
	MOV     DX,a5
	PUSH    DX
	ENDIF
	IFNB    <a4>
	MOV     DX,a4
	PUSH    DX
	ENDIF
	IFNB    <a3>
	MOV     DX,a3
	PUSH    DX
	ENDIF
	IFNB    <a2>
	MOV     DX,a2
	PUSH    DX
	ENDIF
	IFNB    <a1>
	MOV     DX,a1
	PUSH    DX
	ENDIF
	IFNB    <a0>
	MOV     DX,a0
	PUSH    DX
	ENDIF
	CALL    name
	IFNB    <a0>
	ADD     SP,2
	ENDIF
	IFNB    <a1>
	ADD     SP,2
	ENDIF
	IFNB    <a2>
	ADD     SP,2
	ENDIF
	IFNB    <a3>
	ADD     SP,2
	ENDIF
	IFNB    <a4>
	ADD     SP,2
	ENDIF
	IFNB    <a5>
	ADD     SP,2
	ENDIF
	IFNB    <a6>
	ADD     SP,2
	ENDIF
	IFNB    <a7>
	ADD     SP,2
	ENDIF
	IFNB    <a8>
	ADD     SP,2
	ENDIF
	IFNB    <a9>
	ADD     SP,2
	ENDIF
	ENDM
                              the initial value of V1
;         