
	TITLE	DLIST - A ZDOS Disk Cataloging Program
	PAGE	56,132
;
	.XLIST
INCLUDE DEFMS.ASM
INCLUDE	DEFASCII.ASM
	.LIST
 
;       Because DSEG must be last, it is necessary to impose absolute
;       control on the linker by making a dummy CLASS.ASM/OBJ file
;       as described in the ZDOS manual for LINK.  The order will be
;       ASEG,BSEG,CSEG,DSEG.
;
;       To assemble:
;
;       MASM DLIST;
;       LINK CLASS+DLIST,DLIST,DLIST;
;       TYPE DLIST.MAP (to confirm the order of the segments)

 
ASEG  	SEGMENT STACK   'STACK'
	DB	200H DUP(?)
ASEG  	ENDS


BSEG  	SEGMENT	PUBLIC  'CODE'

	ASSUME	CS:BSEG,SS:ASEG,DS:CSEG,ES:DSEG
START:
	MOV	AX,CSEG   		;Set up CSEG   
	MOV	DS,AX
        MOV     SAVESTK,SP
	MOV	WORD PTR RTADDR+2,ES	;Save program hdr addr
        CLD
        MOV     SI,PHD_DIOA             ;Lets see if he wants suppression
        XOR     CH,CH                   ;by checking for /S switch
        MOV     CL,BYTE PTR ES:[SI]
        INC     SI
STA4:   MOV     AL,BYTE PTR ES:[SI]
        INC     SI
        CMP     AL,CC_CR                ;anything there?
        JNZ     STA1
        JMP     STA2
STA1:   CMP     AL,'/'                  ;operator has switch for me?
        JZ      STA3
        CMP     AL,'?'                  ;wants help?
        JNZ     STAT1
        JMP     DSPHELP
STAT1:  LOOP    STA4
        JMP     STA2
STA3:   MOV     AL,BYTE PTR ES:[SI]
        CALL    CHKIT
        JNC     STA2
        JMP     DSPHELP                 ;whats he want? Offer him ur best
STA2:   MOV	AH,DOSF_GETDISK         ;get system default drive
	INT	DOSI_FUNC
	MOV	DEFALT,AL		;save default drive for exit
        MOV     DRIVE,AL                ;latest search disk
        INC     AL
        MOV     BYTE PTR DLISTIO,AL
        DEC     AL
        ADD     AL,'A'
        MOV     BYTE PTR DRTYPE,AL
        MOV     DX,OFFSET FER_TAKEOVER  ;set INT 24 (fatal disk error address)
        PUSH    DS                      ;to something more reasonable
        MOV     AX,BSEG                 ;than a program bombout under ZDOS
        MOV     DS,AX                   ;       |
        MOV     AH,DOSF_SIVEC           ;       |
        MOV     AL,DOSI_FERADDR         ;      \|/
        INT     DOSI_FUNC               ;       V
        POP     DS                      ;Fatal error address now set
;
;       Set up parameters and memory
;
BEGIN:
        MOV     AX,CSEG                 ;set segreg to intended known value
        MOV     DS,AX                   ; (ES is done below)
        MOV     DX,OFFSET SORTEM        ;set cntrl-c processing
        PUSH    DS                      ; to end of cataloging
        MOV     AX,BSEG                 ;         |
        MOV     DS,AX                   ;         |
        MOV     AH,DOSF_SIVEC           ;       \ | /
        MOV     AL,DOSI_CADDR           ;        \|/
        INT     DOSI_FUNC               ;         V
        POP     DS
        MOV     SI,OFFSET DLISTIC
        MOV     CX,2
        CALL    BMPCNT                  ;since a msg on the screen tells
        MOV     SI,OFFSET DRT2          ; op of his voluminous work,
        MOV     CX,2                    ; no checks are made if he does
        CALL    BMPCNT                  ; a hundred files or more
        MOV     WORD PTR RECSUP,0       ;zero suppressed records counter
        MOV     DX,OFFSET MYDTA         ;set disk xfer address
        MOV     AH,DOSF_SDIOA           ;at MYDTA
        INT     DOSI_FUNC
        CLD
        MOV     BX,OFFSET CLS           ;clear screen
        CALL    PUTLINE
        MOV     BX,OFFSET SIGNON
        CALL    PUTLINE
        MOV     WORD PTR FERPLAC,0
        MOV     WORD PTR MYPLACE,0
        MOV     WORD PTR MYPLACE+2,DSEG
        MOV     CX,0FFFFH               ;clear DSEG memory
        LES     DI,DWORD PTR MYPLACE    ; (my hang-up on clean slates)
        MOV     AL,' '                  ; (also easier to DEBUG)
        REP     STOSB                   ;65536 bytes cleared to spaces
        MOV     WORD PTR RECHK,0
        MOV     WORD PTR RECTOTL,0      ;clear record count
        MOV     DI,0                    ; and other parameters
        MOV     SI,OFFSET NUMASS
        MOV     BYTE PTR [SI],'0'
        MOV     BYTE PTR [SI+1],'0'
        MOV     BYTE PTR [SI+2],'0'
;
;     Get drive to catalog
;
START1:
        MOV     AX,WORD PTR MYPLACE     ;backup value in case of partial disk
        MOV     WORD PTR FERPLAC,AX     ;  read before fatal error
        MOV     AX,WORD PTR RECTOTL
        MOV     WORD PTR RECHK,AX       ;backup record count
        MOV     SI,OFFSET NUMASS+2
STT1:
        MOV     CX,3                    ;set disk number assignment
        CALL    BMPCNT

START2:
	MOV	BX,OFFSET DRIVEM	;which drive?
	CALL	PUTLINE
	CALL	GETCHAR
	CMP	AL,'A'			;is it a-p?
	JB	SETDFLT         	;no - default it to present
	CMP	AL,'P'
	JA	SETB
	SUB	AL,'A'
	JMP	SHORT SETA
SETB:
	CMP	AL,'a'
	JB	SETDFLT
	CMP	AL,'p'
	JA	SETDFLT
	SUB	AL,'a'
        JMP     SETA
SETDFLT:
	MOV	AL,DRIVE                ;use default
SETA:
	MOV	DRIVE,AL                ;save drive wanted
        INC     AL                      ;correct AL for template
        MOV     BYTE PTR TMPFCB,AL      ;set table template
        MOV     BYTE PTR TMPFCB1,AL
        DEC     AL
        MOV     AH,AL                   ; AH = AL
        ADD     AL,AL                   ; AL = AL x 2
        ADD     AL,AH                   ; AL = AL x 3
        XOR     AH,AH
	MOV	BX,OFFSET DRVPTR        ;compute msg in table
	ADD	BX,AX
	CALL	PUTLINE                 ;tell op of choice

GET_FILES:
        MOV     SI,OFFSET EXTIO
        CALL    SETFCB                  ;clear fcb table
        MOV     DX,OFFSET EXFCB
        MOV     AH,DOSF_SRHFI           ;search directory for first file
        INT     DOSI_FUNC
        CMP     AL,0FFH                 ;is there a hidden file?
        JZ      NOBOOT                  ;no hidden file - so blank space
        MOV     BYTE PTR BOOT,'B'       ;hidden file - so show B for Bootable
        JMP     GFILES
NOBOOT:
        MOV     BYTE PTR BOOT,' '+080H  ;show blank

GFILES:
        MOV     SI,OFFSET EXTPFCB
        CALL    SETFCB                  ;reset by fcb template
        MOV     DX,OFFSET MYFCB         ;let's look for first file
        MOV     AH,DOSF_SRHFI
        INT     DOSI_FUNC
        CMP     AL,0FFH                 ;no files?
        JNZ     GETDATA                 ;got first file - process it
        JMP     START2                  ;no files!  - next disk

GETDATA:
        CALL    MOVDATA                 ;move data from mydta to table
        INC     RECTOTL
        CMP     WORD PTR MYPLACE,65400  ;out of memory?
        JAE     SORT1M
        MOV     DX,OFFSET MYFCB         ;get next file
        MOV     AH,DOSF_SRHNX
        INT     DOSI_FUNC
        CMP     AL,0FFH                 ;is there a file?
        JNZ     GETDATA                 ;yes - continue
        JMP     START1                  ;nope - next disk

SORT1M:
        MOV     BX,OFFSET OMEMO         ;tell op we're out of memory
        CALL    PUTLINE                 ;  in this segment
        MOV     AX,WORD PTR FERPLAC     ;let him do disk over
        MOV     WORD PTR MYPLACE,AX     ;  at another session
        MOV     AX,WORD PTR RECHK
        MOV     WORD PTR RECTOTL,AX     ;reset rectotl too
SORTEM:
        MOV     DX,OFFSET PRENDIT       ;set cntrl-c processing
        PUSH    DS                      ; to end of program
        MOV     AX,BSEG                 ;         |
        MOV     DS,AX                   ;         |
        MOV     AH,DOSF_SIVEC           ;       \ | /
        MOV     AL,DOSI_CADDR           ;        \|/
        INT     DOSI_FUNC               ;         V
        POP     DS
        MOV     BX,OFFSET PLCDSK        ;tell op to insert disk for file
        CALL    PUTLINE
        CALL    GETCHAR
;
        MOV     BX,OFFSET OSORT         ;tell op we're sorting now
        CALL    PUTLINE                 ; so he knows to wait
        CMP     WORD PTR RECTOTL,1      ;enough to sort?
        JBE     SKPSORT                 ;nothing to do if so few records
        TEST    BYTE PTR SUPP,04H       ;wants no sorting?
        JNZ     SKPSORT                 ;yes - just dump data
        TEST    BYTE PTR SUPP,02H       ;want sort by disk #?
        JZ      NRMFUNC                 ;no - just sort
        CALL    SRTINDSK                ;sort by disk number
        JMP     SKPSORT
NRMFUNC:
        MOV     BX,WORD PTR RECTOTL
        MOV     DX,32                   ;keysize
        MOV     CX,33                   ;recsize
        MOV     AX,DSEG
        MOV     DS,AX
        MOV     ES,AX
        MOV     AX,BX                   ;record count
        MOV     BX,0                    ;starting base address
        CALL    SORTIT
SKPSORT:
        MOV     AX,CSEG
        MOV     DS,AX

        CALL    OPENF                   ;OPENFILE
        CALL    HEADER                  ;SEND HEADER LINE TO FILE
        CALL    MOVRECS                 ;SEND DATA TO FILE
        CALL    SNDINFO                 ;SEND STATISTICS
        CALL    CLOSEIT                 ;CLOSE FILE

        JMP     PRENDIT

;I was unable to fully comprehend the ZDOS manual on INT 24.  Hopefully, this
;will make the prgm more user friendly.  No bad side effects noticed so far.
FER_TAKEOVER:
        MOV     AX,CSEG                 ;I'm on ZDOS stack now
        MOV     DS,AX                   ;get DS for DS:SAVESTK
        CLI                             ;overcome comprimising states
        MOV     AX,ASEG                 ;set SS
        MOV     SS,AX
        MOV     SP,SAVESTK              ;set SP
        STI                             ;turn hardware back on
        MOV     AX,DSEG                 ;recover ES
        MOV     ES,AX
        MOV     BX,OFFSET DSKERR        ;tell a tale
        CALL    PUTLINE
        MOV     AX,WORD PTR FERPLAC     ;ignore drive access attempt
        MOV     WORD PTR MYPLACE,AX
        MOV     AX,WORD PTR RECHK
        MOV     WORD PTR RECTOTL,AX     ;reset rectotl too
        JMP     START2                  ;and try again

        ASSUME  DS:DSEG
INCLUDE SORT.ASM
        ASSUME  DS:CSEG


MOVRECS PROC    NEAR
        MOV     DL,BYTE PTR SUPP        ;set up for listing compression
        MOV     WORD PTR MYPLACE,0
        CALL    SDCRLF
        MOV     CX,WORD PTR RECTOTL
        CMP     CX,0                    ;NOT JCXZ instruction
        JNZ     OUTAL1
        JMP     OUTAL6
OUTAL1:
        PUSH    CX
        PUSH    DS
        LDS     SI,DWORD PTR MYPLACE
        MOV     DI,SI
        CMP     DL,01H                  ;wants record suppressed?
        JNZ     OUTAL                   ;no
        PUSH    SI
        SUB     DI,33                   ;now compare with last record
        MOV     CX,28
        REPZ    CMPSB
        POP     SI
        JCXZ    OUTAL9                  ;if two equal then forget it
        JMP     OUTAL                   ;else printit
OUTAL9:
        MOV     AX,DS
        POP     DS
        PUSH    DS
        INC     WORD PTR RECSUP         ;else increment suppress counter
        MOV     DS,AX
        JMP     OUTAL7                  ;   and forget to printit
OUTAL:
        MOV     CX,8
        CALL    SENDCHR                 ;send title
        MOV     AL,' '                  ;send separator
        CALL    OUTIT
        MOV     CX,3                    ;send ext
        CALL    SENDCHR
        MOV     AL,' '                  ;change fm: Y M D p H M
        MOV     CX,3                    ;       to: M D Y H M p
        CALL    FILLIT
        ADD     SI,11
        MOV     CX,6
        CALL    SENDCHR                 ;send file size
        MOV     CX,2
        MOV     AL,' '
        CALL    FILLIT
        SUB     SI,15                   ;set to internal format
        MOV     CX,1
        LODSB                           ;suppress leading 0's of month
        CMP     AL,'0'
        JNZ     OUTAL2
        MOV     AL,' '
OUTAL2:
        CALL    FILLIT                  ;send char in AL
        MOV     CX,1
        CALL    SENDCHR                 ;send rest of month
        MOV     AL,'-'
        CALL    OUTIT
        MOV     CX,2                    ;day
        CALL    SENDCHR
        MOV     AL,'-'
        CALL    OUTIT
        MOV     CX,2                    ;year
        SUB     SI,6
        CALL    SENDCHR
        MOV     AL,' '
        MOV     CX,2
        CALL    FILLIT
        MOV     CX,1
        ADD     SI,5
        LODSB                           ;suppress leading 0's
        CMP     AL,'0'
        JNZ     OUTAL3
        MOV     AL,' '
OUTAL3:
        CALL    FILLIT                  ;send first char of hour
        MOV     CX,1
        CALL    SENDCHR                 ;send rest of hour
        MOV     AL,':'
        CALL    OUTIT
        MOV     CX,2                    ;min
        CALL    SENDCHR
        MOV     CX,1
        SUB     SI,5                    ;am/pm
        CALL    SENDCHR
        MOV     AL,' '
        MOV     CX,2
        CALL    FILLIT
        ADD     SI,10                   ;point to disk no.
        MOV     CX,3
        CALL    SENDCHR
        MOV     AL,BYTE PTR [SI]        ;strip sort additive
        AND     AL,07FH                 ; for bootable/unbootable disk
        MOV     BYTE PTR [SI],AL
        MOV     CX,1                    ;SEND B/spc
        CALL    SENDCHR
        MOV     AL,' '                  ;send 2 spcs
        MOV     CX,2
        CALL    FILLIT
        MOV     CX,1
        CALL    SENDCHR                 ;send 5/8 data
        CALL    SDCRLF                  ;clean up line
OUTAL7:
        POP     DS
        ADD     WORD PTR MYPLACE,33
        POP     CX
        DEC     CX
        CMP     CX,0
        JE      OUTAL5
        JMP     OUTAL1
OUTAL5:
        CALL    SDCRLF                  ;clean up listing
OUTAL6:
        RET
MOVRECS ENDP


MOVDATA PROC    NEAR
        NOP
        NOP
        MOV     AX,CSEG
        MOV     DS,AX
        MOV     SI,OFFSET MYDTA
        LES     DI,DWORD PTR MYPLACE
        ADD     DI,32                   ;point to 8 or 5 inch drive
        LODSB
        CMP     AL,2
        JA      MK8
        MOV     AL,'5'
        JMP     MVD1
MK8:    CMP     AL,4
        JA      WINNIE
        MOV     AL,'8'
        JMP     MVD1
WINNIE: CMP     AL,6
        JA      UIDRV
        MOV     AL,'W'
        JMP     MVD1
UIDRV:  MOV     AL,'U'
MVD1:
        STOSB                           ;set 8 or 5 setting
        SUB     DI,5
        MOV     SI,OFFSET NUMASS        ;set disk number assignment
        MOV     CX,3
        REP     MOVSB
        MOV     AL,BOOT                 ;set if bootable of not
        STOSB
        MOV     SI,OFFSET MYDTA+1       ;move   name & ext
        MOV     DI,WORD PTR MYPLACE
        ADD     WORD PTR MYPLACE,33     ;point to next record for later use
        MOV     CX,11
        REP     MOVSB
        ADD     SI,8                            ;SI -> date
        MOV     AX,WORD PTR MYDTA+DE_DATE+1
        PUSH    AX
        MOV     CL,5
        SHR     AX,CL                           ;set in sort format of:
        AND     AL,0FH                          ;  Y M D p H M
        ADD     DI,2                            ;get month
	CALL	PRNDEC2
	POP	AX
	PUSH	AX
	AND	AL,31				;get day
	CALL	PRNDEC2				;bits 0-4
	POP	AX
	MOV	AL,AH				;get year
	SHR	AL,1				;bits 9-15
	ADD	AL,80				;make yr+80
        SUB     DI,6
	CALL	PRNDEC2
	MOV	AX,WORD PTR MYDTA+DE_TIME+1
	PUSH	AX				;save time
	MOV	AL,AH				;get hours
	MOV	CL,3				;bits 11-15
	SHR	AL,CL
	AND	AL,01FH
	CMP	AL,12
	JB	AM				;if <12 then am
	MOV	BYTE PTR AMPM,'p'		;if = then no subtract
	JE	T1				;if >12 then sub 12
	SUB	AL,12
	JMP	T1
AM:
	MOV	BYTE PTR AMPM,'a'
        CMP     AL,0
        JNZ     T1
        MOV     AL,12
T1:
        ADD     DI,5
	CALL	PRNDEC2
	POP	AX				;get minutes
	MOV	CX,5				;bits 5-10
	SHR	AX,CL
	AND	AL,03FH
	CALL	PRNDEC2
        SUB     DI,5
	MOV	AL,BYTE PTR AMPM                ;move 'a' or 'p' to new loc
        STOSB                                   ;DI is now -> size

        JMP     ASCONV
MKZRO:
        MOV     CX,6
        MOV     AL,'0'
        REP     STOSB
        JMP     ASCON8
MAKEX:
        MOV     CX,6
        MOV     AL,'x'
        REP     STOSB
        RET

ASCONV:
        NOP                                     ;asconv/ascont aren't efficient
        NOP                                     ;  but they're good for 6 figs
        ADD     DI,4                            ;  If a file is larger than
        MOV     CX,3                            ;  that . . . .
        MOV     SI,OFFSET MULTBL
        MOV     AX,WORD PTR MYDTA+DE_FSIZE+1
        MOV     DX,WORD PTR MYDTA+DE_FSIZE+3
ASCONT:
        MOV     BX,[SI]
        INC     SI
        INC     SI
        AND     DX,0FFFH                        ;set flag and drop high nibble
        JNZ     ASCN11
        CMP     AX,0
        JZ      MKZRO
        CMP     AX,BX                           ;is divisor too large?
        JAE     ASCN11
        PUSH    AX
        MOV     AL,'0'                          ;(suppress 0's later)
        STOSB
        STOSB
        POP     DX
        JMP     ASCON1
ASCN11:
        DIV     BX                              ;/10000
        CMP     AX,100
        JAE     MAKEX
        AAM
        XCHG    AH,AL                           ;make pretty printout
        OR      AL,'0'
        STOSB
        XCHG    AH,AL
        OR      AL,'0'
        STOSB
ASCON1:
        MOV     AX,DX
        XOR     DX,DX                           ;no overflows!!!
        MOV     BX,[SI]
        INC     SI
        INC     SI
        CMP     AX,BX                           ;is divisor too large?
        JAE     ASCON3
        PUSH    AX
        MOV     AL,'0'
        STOSB
        POP     DX
        LOOP    ASCON1
        JMP     ASCON4
ASCON3:
        DIV     BX                              ;/1000,100,10
        OR      AL,'0'
        STOSB
        LOOP    ASCON1
ASCON4:
        MOV     AX,DX                           ;do last byte
        OR      AL,'0'
        STOSB
ASCON8:
        SUB     DI,6
        MOV     CX,5                            ;suppress leading 0's
ASCON2:
        MOV     AL,'0'
        SCASB
        JNZ     MVDT
        DEC     DI
        MOV     AL,' '
        STOSB
        LOOP    ASCON2
MVDT:
        RET
MOVDATA ENDP


PUTLINE PROC    NEAR
        PUSH    AX
        PUSH    DX
EPUTL1:
        MOV     AL,BYTE PTR [BX]                ;move a line of text that
        INC     BX                              ;ends with a null (0)
        CMP     AL,0                            ; a '$' sign can be used in text
        JZ      EPUTL                           ; so I avoid system outstr func
        MOV     DL,AL                           ;
        MOV     AH,DOSF_CONOUT
        INT     DOSI_FUNC
        JMP     EPUTL1
EPUTL:
        POP     DX
        POP     AX
        RET
PUTLINE ENDP


BMPCNT  PROC    NEAR
BMP3:   CMP     BYTE PTR [SI],'9'               ;set disk number assignment
        JAE     MAKE0
        INC     BYTE PTR [SI]
        JMP     BMP2
MAKE0:
        MOV     BYTE PTR [SI],'0'
        DEC     SI
        LOOP    BMP3
BMP2:   RET
BMPCNT  ENDP


SRTINDSK PROC   NEAR
        PUSH    DS
        MOV     CX,WORD PTR RECTOTL             ;GET RECORD COUNT
        PUSH    CX
        MOV     AX,DSEG                         ;SET ES,DS TO DSEG
        MOV     DS,AX
        MOV     ES,AX
        MOV     SI,0                            ;START WITH FIRST RECORD
SWAPNXT:
        PUSH    CX                              ;SAVE RECORD COUNT
        MOV     DI,TEMPREC                      ;TEMP PLACE TO PUT DATA
        MOV     CX,31                           ;MOV ALL BUT 'B' & '5/8'
        REP     MOVSB
        XCHG    SI,DI                           ;MOV BACK DOWN TO SORT ORDER
        SUB     DI,31                           ;AT BEGINNING OF RECORD
        SUB     SI,3                            ;PUT DISK #
        MOV     CX,3                            ;OF 3 BYTES
        REP     MOVSB
        SUB     SI,31                           ;AND THEN THE BEGINNING
        MOV     CX,28                           ;28 BYTES
        REP     MOVSB
        XCHG    SI,DI                           ;POINT TO TEMPREC AGAIN
        ADD     SI,2                            ;OFFSET FOR LAST OF RECORD
        POP     CX
        LOOP    SWAPNXT                         ;DO ALL RECORDS
        POP     AX                              ;GET RECTOTL
        PUSH    AX                              ;SAVE AGAIN FOR LATER
        MOV     DX,32                           ;PASS DATA TO SORTIT ROUTINE
        MOV     CX,33
        MOV     BX,0
        CALL    SORTIT
        POP     CX                              ;GET RECTOTL
        MOV     SI,0
SWAPNX1:
        PUSH    CX                              ;AND DO REVERSE OF ABOVE
        MOV     DI,TEMPREC
        MOV     CX,31                           ;SAVE 31 BYTES
        REP     MOVSB
        XCHG    SI,DI
        SUB     SI,31                           ;PUT DISK # IN LAST OF
        SUB     DI,3                            ;  RECORD AGAIN
        MOV     CX,3
        REP     MOVSB
        SUB     DI,31                           ;AND PUT BACK FIRST 28 BYTES
        MOV     CX,28
        REP     MOVSB
        XCHG    SI,DI
        ADD     SI,5                            ;OFFSET FOR DATA SKIP
        POP     CX
        LOOP    SWAPNX1                         ;FOR FULL RECORD COUNT
        POP     DS                              ;   THIS REALLY IS FASTER THAN
        RET                                     ;   HAVING SORTIT DO 1000s OF
SRTINDSK ENDP                                   ;   TESTS,ADDS & CONTORTIONS


PRNDEC2	PROC	NEAR
	MOV	AH,0				;set AX for division
	AAM					;divide AL by 10
	PUSH	AX				;AH=10s AL=1s
	MOV	AL,AH
	OR	AL,'0'				;make it ASCII
	STOSB                   		;print it
	POP	AX				;get saved low byte
	OR	AL,'0'				;make it ASCII
	STOSB                   		;print it
	RET
PRNDEC2	ENDP


SENDCHR PROC NEAR
        LODSB
        CALL    OUTIT                           ;send char string SI ->
        LOOP    SENDCHR                         ;CX times
        RET
SENDCHR ENDP


FILLIT  PROC    NEAR
        CALL    OUTIT                           ;AL = char to send
        LOOP    FILLIT                          ;CX = times to send
        RET
FILLIT  ENDP


GETDATE	PROC	NEAR
	MOV	AH,DOSF_GDATE
	INT	DOSI_FUNC	                ;get system date
	MOV	AL,DH		        	;get month
	CALL	GD1
	MOV	AL,'-'
	CALL	OUTIT
	MOV	AL,DL			        ;get day
	CALL	GD1
	MOV	AL,'-'
	CALL	OUTIT
	MOV	AX,CX	        		;get year
	SUB	AX,1900
GD1:
	AAM			        	;div al by 10 and put in ah
	PUSH	AX
	MOV	AL,AH		        	;get the amount of 10's
	OR	AL,'0' 		        	;make it ASCII
	CALL	OUTIT
	POP	AX			        ;get the amount of 1's
	OR	AL,'0' 
	CALL	OUTIT
	RET
GETDATE	ENDP


DSPHELP PROC    NEAR
        MOV     BX,OFFSET SIGNON
        CALL    PUTLINE
        MOV     BX,OFFSET HELPMSG
        CALL    PUTLINE
        JMP     ENDEARLY
DSPHELP ENDP


SDCRLF  PROC    NEAR
        MOV     AL,CC_CR
        CALL    OUTIT
        MOV     AL,CC_LF
        CALL    OUTIT
        RET
SDCRLF  ENDP


OUTIT   PROC    NEAR
        PUSH    AX
        PUSH    DX                              ;this bogs output down
        PUSH    CX                              ; some but is general
        PUSH    SI                              ; purpose enough to be
        PUSH    DS                              ; safe program wide.
        XCHG    AX,DX
        MOV     AX,CSEG
        MOV     DS,AX
        XCHG    AX,DX
        MOV     BYTE PTR MYDTA,AL               ;DS:MYDTA HAS CHAR
        MOV     DX,OFFSET MYFCB                 ;SEND A CHAR TO FILE
        MOV     CX,1
        MOV     AH,DOSF_RBLWRITE
        INT     DOSI_FUNC
        AND     AL,AL                           ;IS THERE A PROBLEM?
        JZ      EOUTE                           ;NO
        MOV     BX,OFFSET PROBLM                ;YES - TELL OF PROBLEM
        CALL    PUTLINE
        MOV     DX,OFFSET MYFCB                 ;TRY TO SAVE WHAT YOU CAN
        MOV     AH,DOSF_CLFILE
        INT     DOSI_FUNC
        JMP     ENDIT                           ;GET OUT...HE'S GOT TO FIX THIS
EOUTE:
        POP     DS
        POP     SI
        POP     CX
        POP     DX
        POP     AX
        RET
OUTIT   ENDP


GETCHAR	PROC	NEAR
        MOV     AH,DOSF_DRCINE                  ;input routine
        INT     DOSI_FUNC                       ;w/ cntrl-c processing
	RET
GETCHAR	ENDP


OPENF   PROC    NEAR
        MOV     SI,OFFSET DLISTI1
        CALL    SETFCB
        MOV     DX,OFFSET MYFCB
        MOV     AH,DOSF_DEFILE                  ;CLEAR OLD FILE
        INT     DOSI_FUNC
        MOV     DX,OFFSET MYFCB
        MOV     AH,DOSF_CRFILE                  ;OPEN NEW FILE
        INT     DOSI_FUNC
        AND     AL,AL
        JZ      MORE_OPENF
        MOV     BX,OFFSET OHNO                  ;HAVE A PROBLEM
        CALL    PUTLINE
        JMP     ENDIT                           ;QUIT WHILE OP'S AHEAD & FIX IT
MORE_OPENF:
        MOV     WORD PTR MYFCB+FCB_CURBLK,0
        MOV     WORD PTR MYFCB+FCB_RECSZ,1
        MOV     WORD PTR MYFCB+FCB_CURREC,0
        MOV     DX,OFFSET MYFCB
        MOV     AH,DOSF_SFPOS
        INT     DOSI_FUNC
        RET
OPENF   ENDP


HEADER  PROC    NEAR
        CALL    SDCRLF
        MOV     SI,OFFSET LDATE                 ;give date for future ref
        MOV     CX,20                           ; of listing validity
        CALL    SENDCHR
        CALL    GETDATE
        MOV     CX,54
        MOV     SI,OFFSET HEADLIN               ;explain columns
        CALL    SENDCHR
        RET
HEADER  ENDP

ASSUME  ES:CSEG

SNDINFO PROC    NEAR
        TEST    BYTE PTR SUPP,01H               ;add applicable data to end
        JZ      SNDI1                           ;of listing?
        MOV     SI,OFFSET RECSP
        MOV     CX,19
        CALL    SENDCHR
        MOV     AX,OFFSET SLIN
        MOV     DI,AX
        MOV     DX,WORD PTR RECSUP
        CALL    SETUP
        CALL    SDCRLF
SNDI1:  MOV     SI,OFFSET RECNO                 ;always add this at end listg
        MOV     CX,19
        CALL    SENDCHR
        MOV     AX,OFFSET SBUFF
        MOV     DI,AX
        MOV     DX,WORD PTR RECTOTL
        CALL    SETUP
        CALL    SDCRLF
        RET
SNDINFO ENDP


SETUP   PROC    NEAR
        PUSH    DS                              ;just supporting code for
        PUSH    ES                              ; sndinfo.  It formats regs
        PUSH    DI                              ; for binary to ascii output.
        MOV     AX,CSEG
        MOV     DS,AX
        MOV     ES,AX
        MOV     SI,OFFSET MULTBL
        MOV     CX,3
        MOV     AX,DX
        XOR     DX,DX
        CALL    ASCONT
        POP     SI                              ;SI now = DI (no mistake)
        MOV     CX,6                            ; what we put before is
        CALL    SENDCHR                         ; source now
        POP     ES
        POP     DS
        RET
SETUP   ENDP


CLOSEIT PROC    NEAR
        CALL    SDCRLF
        MOV     AL,CC_SUB                       ;End Of File mark then
        CALL    OUTIT
        MOV     DX,OFFSET MYFCB
        MOV     AH,DOSF_CLFILE                  ;close file
        INT     DOSI_FUNC
        RET
CLOSEIT ENDP


SETFCB PROC    NEAR
        PUSH    ES
        PUSH    DS
        MOV     AX,CSEG                         ;moves data for FCB
        MOV     DS,AX                           ; setup
        MOV     ES,AX
        MOV     CX,40
        MOV     DI,OFFSET EXFCB
        REP     MOVSB
        POP     DS
        POP     ES
        RET
SETFCB  ENDP


CHKIT   PROC    NEAR
        CMP     AL,'Y'                          ;is switch or answer?
        JZ      DOAGN1
        CMP     AL,'y'
        JZ      DOAGN1
        CMP     AL,'S'
        JNZ     DO2
DO3:    MOV     BYTE PTR SUPP,01H
        JMP     DOAGN1
DO2:    CMP     AL,'s'
        JZ      DO3
        CMP     AL,'D'
        JNZ     DO4
DO5:    MOV     BYTE PTR SUPP,02H
        JMP     DOAGN1
DO4:    CMP     AL,'d'
        JZ      DO5
        CMP     AL,'K'
        JNZ     DO6
DO7:    MOV     BYTE PTR SUPP,04H
        JMP     DOAGN1
DO6:    CMP     AL,'k'
        JZ      DO7
        CMP     AL,'A'
        JZ      DO8
        CMP     AL,'a'
        JNZ     BADCR
DO8:    MOV     BYTE PTR SUPP,0
DOAGN1:
        CLC
        RET
BADCR:
        STC
        RET
CHKIT   ENDP


REDOIT:
        MOV     BX,OFFSET REDOAGN
        CALL    PUTLINE
        CALL    GETCHAR
        PUSH    AX
        MOV     DL,AL
        MOV     AH,DOSF_CONOUT
        INT     DOSI_FUNC
        POP     AX
        CALL    CHKIT                   ;want redo?  and set prcessing flag
        JC      REDO2                   ;must not
        MOV     DX,OFFSET SORTEM        ;set cntrl-c processing
        PUSH    DS                      ; to end of cataloging
        MOV     AX,BSEG                 ;         |
        MOV     DS,AX                   ;         |
        MOV     AH,DOSF_SIVEC           ;       \ | /
        MOV     AL,DOSI_CADDR           ;        \|/
        INT     DOSI_FUNC               ;         V
        POP     DS
        MOV     SI,OFFSET DLISTIC
        MOV     CX,2
        CALL    BMPCNT                  ;since a msg on the screen tells
        MOV     SI,OFFSET DRT2          ; op of his voluminous work,
        MOV     CX,2                    ; no checks are made if he does
        CALL    BMPCNT                  ; a hundred files or more
        MOV     WORD PTR RECSUP,0       ;zero suppressed records counter
        MOV     AX,WORD PTR FERPLAC
        MOV     WORD PTR MYPLACE,AX     ;recover myplace
        JMP     START2
REDO2:  JMP     ENDIT


PRENDIT:
        MOV     AX,CSEG
        MOV     DS,AX
        PUSH    DS
        MOV     DX,OFFSET ENDIT                 ;set cntrl-c processing
        MOV     AX,BSEG                         ;
        MOV     DS,AX                           ;         |
        MOV     AH,DOSF_SIVEC                   ;         |
        MOV     AL,DOSI_CADDR                   ;        \|/
        INT     DOSI_FUNC                       ;         V
        POP     DS
        MOV     BX,OFFSET DOAGN
        CALL    PUTLINE
        CALL    GETCHAR
        CMP     AL,'R'
        JZ      PREN2
        CMP     AL,'r'
        JNZ     PREN1
PREN2:  JMP     REDOIT
PREN1:  CALL    CHKIT
        JC      ENDIT
        JMP     BEGIN


ENDIT:
        MOV     AX,CSEG
        MOV     DS,AX
	MOV	AH,DOSF_SELDISK
	MOV	DL,DEFALT
	INT	DOSI_FUNC		;reset default drive
        MOV	BX,OFFSET CLS
        CALL	PUTLINE			;CLS
ENDEARLY:
	MOV	SP,SAVESTK		;reclaim original SP
	JMP	RTADDR
BSEG  	ENDS



CSEG   	SEGMENT PUBLIC  'DATA'
RTADDR	DD	0
IDENT	DB	'DLIST written by C. H. Eaton.',CC_CR,CC_LF
SIGNON  DB      CC_CR,CC_LF,'DLIST Version 1.25',CC_CR,CC_LF,0
DRIVEM	DB	CC_CR,CC_LF,CC_LF,'Use Cntrl-C to begin next program phase.'
      	DB	CC_CR,CC_LF,'Enter drive to catalog'
        DB      ' <default drive>   >',0
CRLF	DB	CC_CR,CC_LF,0
DOAGN   DB      CC_CR,CC_LF,'Another catalog session?  (R,Y,N,A,S,K,D)  '
        DB      '<N>   >',0
REDOAGN DB      'R',CC_CR,CC_LF,CC_LF,'Relist or add to same listing with '
        DB      'another switch (A,S,K,D)  <N>   >',0
DRVPTR  DB	'A:',0
	DB	'B:',0
	DB	'C:',0
	DB	'D:',0,'E:',0,'F:',0,'G:',0,'H:',0,'I:',0,'J:',0,'K:',0,'L:',0
        DB      'M:',0,'N:',0,'O:',0,'P:',0,'U/I:',0
CR3LF   DB	CC_CR,CC_LF
	DB	CC_CR,CC_LF,CC_CR,CC_LF,0
CLS 	DB	CC_ESC,'E',0
SUPP    DB      0
RECSUP  DW      0
SLIN    DB      '0000000'
RECHK   DW      0
RECTOTL DW      0
MULTBL  DW      10000,1000,100,10,1
SAVESTK	DW	?
PLCDSK  DB	CC_CR,CC_LF,'Use Cntrl-C to quit.'
        DB      CC_CR,CC_LF,'Place a disk in drive '
DRTYPE  DB      'C: for DLIST0'
DRT2    DB      '0.DAT creation and'
        DB      CC_CR,CC_LF,'press any other key when ready.....',0
DEFALT  DB	0
HELPMSG DB      CC_CR,CC_LF,CC_LF,'DLIST is a disk cataloging program for '
        DB      'ZDOS.  By default it will',CC_CR,CC_LF
        DB      'sort directory entries starting with the name as in a `DIR`.'
        DB      CC_CR,CC_LF,CC_LF
        DB      'Any one of the following switches/options are available with'
        DB      ' DLIST:'
        DB      CC_CR,CC_LF,CC_LF,'   /A      Sort alphabetically (default).'
        DB      CC_CR,CC_LF,'   /S      Sort but suppress multiple '
        DB      'directory entries.'
        DB      CC_CR,CC_LF,'   /D      Sort using disk as primary key.'
        DB      CC_CR,CC_LF,'   /K      Catalog only.  Do no sorting.'
        DB      CC_CR,CC_LF,'    ?      Print this message.',CC_CR,CC_LF,CC_LF
        DB      CC_LF,CC_LF,CC_LF,CC_LF,CC_LF,CC_LF,0
COUNT	DB	3
SBUFF   DB      '0000000'
OMEMO   DB      CC_CR,CC_LF,CC_LF,'Internal buffer is full.  This disk'
        DB      ' will be ignored.',CC_CR,CC_LF,0
OSORT   DB      CC_CR,CC_LF,CC_LF,'Preparing file.',CC_CR,CC_LF,CC_LF,0
OHNO    DB      CC_BEL,CC_CR,CC_LF,'Unable to open file.',CC_CR,CC_LF,0
DLISTI1 DB      0FFH,6 DUP(0)
DLISTIO DB      0,'DLIST0'
DLISTIC DB      '0 DAT',40 DUP(0)
PROBLM  DB      CC_BEL,CC_CR,CC_LF,'File write error.',CC_CR,CC_LF,0
LDATE   DB      'DLIST Listing Date: ',0                       ;20 BYTES
HEADLIN DB      CC_CR,CC_LF,CC_LF
        DB      '  Name   Ext    Size     Date     '
        DB      'Time   No. Media',CC_CR,CC_LF,0               ;55 BYTES
RECSP   DB      'Files suppressed:  ',0                        ;19 BYTES
RECNO   DB      'Total file(s):     ',0                        ;19 BYTES
DSKERR  DB      CC_CR,CC_LF,CC_LF,CC_BEL,'Disk error.',CC_CR,CC_LF,0
DRIVE	DB	0		;a=0, b=1
POSI	DW	0
M4	DB	16
MULTF	DW	1		;mult x10
BOOT    DB      'B'
        DB      '000'
NUMASS  DB      '000'
FERPLAC DW      0
MYPLACE DD      0
AMPM    DB      'p'
EXTIO   DB      0FFH,5 DUP (0),06H
TMPFCB1 DB      0,'IO      SYS',25 DUP(0)
EXTPFCB DB      0FFH,6 DUP (0)
TMPFCB  DB      0,11 DUP(03FH),25 DUP(0)
EXFCB   DB      0FFH,6 DUP (0)
MYFCB   DB      32 DUP (0)
MORFCB  DB      25 DUP (0)
MYDTA   DB      50 DUP(0)
CSEG   	ENDS

 
DSEG    SEGMENT PUBLIC  'MEMORY'
BUFFR   DB      ?
;
;
RECSRT  STRUC
TTNAME  DB      8 DUP(?)        ;NAME
TTEXT   DB      3 DUP(?)        ;EXT
TTDATE  DB      6 DUP(?)        ;DATE
TTTIME  DB      5 DUP(?)        ;TIME
TTSIZE  DB      6 DUP(?)        ;SIZE
TTASNO  DB      3 DUP(?)        ;3 BYTE ASCII DISK ASSIGNMENT NUMBER
TTBOOT  DB      ?               ;B=BOOT  SPC=DATA DISK
TT8OR5  DB      ?               ;8/5/W
RECSRT  ENDS
;
;
DSEG    ENDS

	END	START
0 DUP(0)
CSEG   	ENDS

 
DSEG    SE