/***********************************************************************/
/*	findnext.c                                                    */
/***********************************************************************/

/*  find next matching file after using findfrst  */
findnext(filespec)
struct filedata *filespec; /* 43 byte area of info returned by findfrst */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */
  unsigned saveseg; /* save current DTA segment address */
  unsigned saveoff;  /* save current DTA offset address  */
  int i;

#ifdef LPTR
  unsigned j,k,hiword();                              
#endif
  i = getdta(&saveseg,&saveoff);  /* get current dta and save address */
  if ( i != 0 )  /* return if error */
     return(i);

#ifdef LPTR
 
  j = hiword(filespec);  /* get segment part of filespec address */
  k = (unsigned) filespec; /* get offset part of address */
  i = setdta(j,k);

#else

  ret_code = gdosint(0x00,&regs,&regs);
  i = setdta(regs.ds,filespec);

#endif

  if ( i != 0 )  /* return if error */
     return(i);

  regs.es=0;    /* use default */
  regs.ah=0x4F; /* DOS function number */
  int_no=0x21; /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  if ( ret_code != 0 )  /* return if error */
     return(ret_code);
  i = setdta(saveseg,saveoff); /* restore dta */
    if ( i != 0 )  /* return if error */
       return(i);
    else
       return(0);
}
