/***********************************************************************/
/*	getatrib.c                                                    */
/***********************************************************************/

/* Retrieve the attributes of a file */
getatrib(pname,attrib)
char *pname; /* pointer to pname to be acted upon */
int *attrib; /* attribute to be set or returned */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */


#ifdef LPTR
			/* if big data models => get segment part of */
			/*     ASCII string address pointer          */
  regs.ds= hiword(pname);

#else

  regs.ds=0;		/* else => use default DS */

#endif

  regs.es=0;   /* default value for registers */
			/* put offset address into dx register */
  regs.dh= (unsigned) (pname) >> 8; 
  regs.dl= (unsigned) (pname) - (regs.dh << 8); 

  regs.al=0;  /* get attribute option of function 0x43 */
  regs.ah=0x43;
  int_no=0x21;  /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  *attrib = (regs.ch << 8) + regs.cl; /* attribute returned in cx */
  return(ret_code);
}
