/***********************************************************************/
/*	getdta.c                                                      */
/***********************************************************************/

/*  get the address (segment and offset) of the active disk transfer address */
getdta(segment,offset)
unsigned *segment; /* segment address of current disk transfer area */
unsigned *offset; /* offset address of current disk transfer area */

{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */
 
  regs.ds=regs.es=0;   /* default value for registers */
  regs.ah=0x2f; /* DOS function number */
  int_no=0x21; /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  *segment = regs.es;
  *offset = (regs.bh * 256) + regs.bl; /* offset returned in bx register */
  return(ret_code);
}
