/***********************************************************************/
/*	setdta.c                                                      */
/***********************************************************************/

/*  set the address (segment and offset) of the active disk transfer address */
setdta(segment,offset)
unsigned segment; /* segment address of new disk transfer area */
unsigned offset; /* offset address of new disk transfer area */

{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */
 
  regs.es=0;   /* default value for registers */
  
#ifdef LPTR
  regs.ds = segment;
#else
  regs.ds = 0;
#endif

  regs.dh = offset / 256; /* dx register is initialized to offset for call */
  regs.dl = offset - (regs.dh * 256); 
  regs.ah=0x1A; /* DOS function number */
  int_no=0x21; /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  return(ret_code);
}
