/***********************************************************************/
/*	bothpags.c                                                    */
/***********************************************************************/

bothpags(page_no) /* set active display page and reference page */
int page_no; /* page to be set to active */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */
  int mode; /* current mode setting */
  int num_cols; /* number of columns in active display */
  int active_page; /* current active page */  

  if(page_no < 0 || page_no > 7 )
    return(-1);
  getscmod(&mode,&num_cols,&active_page);
  if ( mode > 3 ) /* not good for graphics modes or mono adapter */
     return(-1);
  if ( mode < 2 && page_no > 7 ) /* 7 available for mode 1 */
     return(-1);
  if ( (mode == 2 || mode == 3 )  && page_no > 3 )
     return(-1); /* only 4 available for these modes */
  regs.al=page_no;
  regs.es=regs.ds=0;   /* default value - no changes to register */
  regs.ah=5; /* set active display page through bios */
  int_no=0x10; /* video I/O BIOS call */
  ret_code = gdosint(int_no,&regs,&regs);
  return(0);
}
