;	UNMAP -- UNLOAD KEYMAP
;
;	THIS PROGRAM UNLOADS THE HUG CP/M-85 KEYMAP PROGRAM
;	FROM MEMORY
;
;	BY P. SWAYNE, HUG  25-FEB-85
;
;	COPYRIGHT (C) 1985 BY HEATH USERS' GROUP

BIOS	EQU	0		;BIOS VECTOR
BDOS	EQU	5		;BDOS VECTOR
PRINTF	EQU	9		;PRINT FUNCTION
CNSOFF	EQU	303H-2F4H	;OFFSET TO CONST VECTOR IN KEYMAP
CONOFF	EQU	445H-2F4H	;OFFSET TO CONIN VECTOR IN KEYMAP

	ORG	100H

UNLOAD	LHLD	BIOS+1		;GET BIOS VECTOR
	INX	H		;SKIP JUMP
	MOV	E,M
	INX	H
	MOV	D,M		;DE = WARM BOOT
	CALL	CPHD		;TEST IF KEYMAP ALREADY OUT
	JC	UNLOAD1		;SOMETHING'S IN, GO AHEAD
NUNLD	LXI	D,ITSOUT
	CALL	PMSG		;ELSE, SAY "IT'S OUT"
	JMP	BIOS		;RETURN TO CP/M
UNLOAD1	LHLD	BDOS+1		;GET BDOS ADDRESS ("JBDOS")
	PUSH	H		;SAVE IT
	LXI	D,5
	DAD	D		;MOVE TO SIGNATURE
	MOV	A,M		;GET FIRST CHARACTER
	CPI	'K'		;IS IT "K"?
	JNZ	NUNLD		;IF NOT, DO NOT UNLOAD
	INX	H
	MOV	A,M		;GET SECOND CHARACTER
	CPI	'M'		;IS IT "M"?
	JNZ	NUNLD		;IF NOT, DO NOT UNLOAD
	POP	H		;RESTORE BDOS ADDRESS
	PUSH	H		;SAVE AGAIN
	INX	H		;MOVE TO OLD BDOS ADDRESS
	MOV	E,M		;GET IT
	INX	H
	MOV	D,M
	XCHG
	SHLD	BDOS+1		;RESTORE IT
	XCHG
	INX	H		;MOVE TO ORIGINAL WARM BOOT ADDR
	MOV	E,M		;GET IT
	INX	H
	MOV	D,M
	XCHG
	SHLD	WBADR		;SAVE IT
	POP	H		;RESTORE BDOS ADDRESS
	PUSH	H		;SAVE AGAIN
	LXI	D,CNSOFF
	DAD	D		;LOCATE CONST ADDRESS
	MOV	E,M		;GET IT
	INX	H
	MOV	D,M
	XCHG
	SHLD	CNSADR		;SAVE IT
	POP	H		;RESTORE BDOS ADDRESS
	LXI	D,CONOFF
	DAD	D		;LOCATE CONIN ADDRESS
	MOV	C,M		;GET IT
	INX	H
	MOV	B,M		;BC = CONIN ADDRESS
	LHLD	BIOS+1		;GET BIOS ADDRESS
	INX	H		;SKIP JUMP
	XCHG
	LHLD	WBADR		;GET WARM BOOT ADDRESS
	XCHG
	MOV	M,E		;REPLACE WARM BOOT ADDRESS
	INX	H
	MOV	M,D
	INX	H
	INX	H		;SKIP JUMP INST.
	XCHG
	LHLD	CNSADR		;GET CONST ADDRESS
	XCHG
	MOV	M,E		;REPLACE IT
	INX	H
	MOV	M,D
	INX	H		;SKIP JUMP INST.
	INX	H
	MOV	M,C		;REPLACE CONIN
	INX	H
	MOV	M,B
	LXI	D,OUTM
	CALL	PMSG		;REPORT KEYMAP UNLOADED
	JMP	BIOS		;RETURN TO CP/M

; COMPARE HL TO DE

CPHD	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	RET

;	PRINT MESSAGES

PMSG	MVI	C,PRINTF
	JMP	BDOS

;	DATA AREA

WBADR	DW	0		;WARM BOOT ADDRESS
CNSADR	DW	0		;CONSOLE STATUS ADDRESS

OUTM	DB	13,10,'CP/M-85 KEYMAP Version 1.0 has been disabled.'
	DB	27,'y1',27,'y6$'	;KILL 25TH LINE, KEYPAD
ITSOUT	DB	13,10,'ERROR -- CP/M-85 KEYMAP is not installed.$'

	END
