/***********************************************************************/
/*	setdrive.c                                                    */
/***********************************************************************/

/*   set the system default drive letter                                    */
setdrive(drive,actual)
int drive;  /* the drive number (0 = A, 1 = B, etc.) to be set to default   */
int *actual; /* the number of drives returned - note: will return 2 even if */
             /* there is only one drive present. This is a DOS quirk. you   */
             /* can use clequip function to get actual number.              */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  regs.ds=regs.es=0;   /* default value for registers */
  regs.dl=drive;
  regs.ah=0xE; /* DOS function number */
  int_no=0x21; /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  *actual=regs.al;
  return(ret_code);
}
