/***********************************************************************/
/*	grarc.c                                                       */
/***********************************************************************/

/* function to draw a line arc */
grarc(x0,y0,r,d,sa,ea,c,fill)
int x0; /* column coordinate of center of arc */
int y0; /* row coordinate of center of arc */
int r; /* radius of arc */
int d; /* angle increment in degrees */
int sa; /* start of arc in degrees */
int ea; /* end of arc in degrees */
int c; /* color of arc */
int fill; /* fill arc with color (1-yes,0-no) */
{
extern struct plotpos base;
int y,x,i,m,n,a,col; /* temp variables */
int f[200][2],top,bot; /* fill in variables */
float grtrig(); /* sin,cos function */
/* check passed parameters */
getscmod(&m,&n,&a);
if(m < 3) return(-1);
if(m == 3) col = 320;
  else if(m == 4) col = 320;
    else col = 640;
if((y0 < 0)||(y0 > 199)) return(-2);
if((x0 < 0)||(x0 > col - 1)) return(-3);
if((r < 0)||(r > col -1)) return(-4);
if((d < 0)||(d > 360)) return(-5);
if((c < 1)||(c > 3)) return(-6);
if((fill != 0)&&(fill != 1)) return(-7);
if((sa < 0)||(sa > 360)) return(-8);
if((ea < 0)||(ea > 360)) return(-9);
if(sa > ea) return(-10);
/* set base to our start arc */
y = (r * -1) * grtrig(sa,0);
x = r * grtrig(sa,1);
y = y0 + y;
x = x0 + x;
base.row = y;
base.col = x;
if(fill == 1)
  {
  for(i = 0; i < 200; ++i)
    {
    f[i][0] = f[i][1] = -1;
    }
  top = y;
  bot = y;
  f[y][0] = x;
  f[y][1] = x;
  }
for(i = sa; i < ea; i = i + d)
  {
  y = (r * -1) * grtrig(i,0);
  x = r * grtrig(i,1);
  y = y0 + y;
  x = x0 + x;
  gramov(x,y,c,&f[0][0],&top,&bot);
  }
/* make sure arc is closed */
y = (r * -1) * grtrig(ea,0);
x = r * grtrig(ea,1);
y = y0 + y;
x = x0 + x;
gramov(x,y,c,&f[0][0],&top,&bot);
/* fill in ?? */
if(fill == 1)
  {
  /* draw lines of sides of arc */
  grarcl(x0,y0,x,y,c,&f[0][0],&top,&bot);
  y = (r * -1) * grtrig(sa,0);
  x = r * grtrig(sa,1);
  y = y0 + y;
  x = x0 + x;
  grarcl(x0,y0,x,y,c,&f[0][0],&top,&bot);
  for(i = top; i < bot + 1; ++i)
    {
    if(f[i][0] == -1)
      {
      for(m = 1; i - m > -1; ++m)
        {
        if(f[i - m] != -1)
          {
          grline(f[i - m][0],i,f[i - m][1],i,c);
          break;
          }
        }
      }
    else grline(f[i][0],i,f[i][1],i,c);
    }
  }
return(0);
}
