/***********************************************************************/
/*	shrinkm.c                                                     */
/***********************************************************************/

/*  free all memory not used by current program  */
shrinkm(size)
unsigned *size;  /* return the size of the current program + data */
{
  extern unsigned _top; /* address of top of stack stored in XCMAIN (C.obj) */
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  unsigned pspseg;  /* segment address of program segment prefix  */
  unsigned prog; /* size of program code */
  unsigned data; /* size of data area plus stack */
  unsigned total; /* size of both of the above added together */
  unsigned *ptr;  /* pointer used to fetch psp from stack */

  int_no=0x00;  /* special call to gdosint to return current register values*/
  ret_code = gdosint(int_no,&regs,&regs);
  ptr = _top - 2; /* address of pspseg is first thing pushed onto stack by */
                 /* XCMAIN. Therefore, it can be found at _top - 2        */
  pspseg = *ptr;
  prog = regs.ds - pspseg; /* code size = data segment - psp segment address */
  data = _top/16 + 1; /* top of stack is offset from data segment */
  total = prog + data;
  return(setmblk(pspseg,total,size));
}
