;	SYSINFO - PRINT SYSTEM MEMORY INFORMATION
;
;	THIS PROGRAM PRINTS OUT THE FOLLOWING INFORMATION
;	ABOUT MEMORY UTILIZATION IN YOUR SYSTEM.
;
;	BY P. SWAYNE  19-JUL-83

	ORG	100H

START	LXI	D,IMSG
	MVI	C,9
	CALL	5		;PRINT INTRO MESSAGE
	LXI	H,0FFH		;INITIALIZE FOR MEMORY TOP SEARCH
FMEM	DCR	H		;MOVE DOWN ONE PAGE
	MOV	A,M		;GET BYTE THERE
	DCR	M		;TRY TO CHANGE MEMORY
	CMP	M		;COMPARE
	MOV	M,A		;REPLACE BYTE
	JZ	FMEM		;NO CHANGE, KEEP LOOKING
	CALL	PADDR		;PRINT MEMORY LIMIT ADDRESS
	PUSH	H		;SAVE LIMIT
	LXI	D,BIOMSG
	MVI	C,9
	CALL	5		;PRINT BIOS MESSAGE
	LHLD	1
	CALL	PADDR		;PRINT BIOS ADDRESS
	POP	D		;DE = MEMORY LIMIT
	MOV	A,E
	SUB	L		;SUBTRACT BIOS ADDR FROM LIMIT
	MOV	A,D
	SBB	H
	CPI	40H		;TOO MUCH BIOS SPACE?
	JC	SYSOK		;NO, SYSTEM IS OK
	LXI	D,MOVMSG
	MVI	C,9
	CALL	5		;SAY "RUN MOVCPM"
SYSOK	LXI	D,BDMSG
	MVI	C,9
	CALL	5		;PRINT BDOS MESSAGE
	LHLD	6
	CALL	PADDR		;PRINT BDOS ADDRESS
	LXI	D,-806H
	DAD	D		;SUBTRACT CCP AND SERIAL NO. SIZES
	PUSH	H		;SAVE RESULT
	LXI	D,CMSG
	MVI	C,9
	CALL	5		;PRINT CCP MESSAGE
	POP	H		;GET CCP START ADDR
	CALL	PADDR		;PRINT IT
	LXI	D,SMSG
	MVI	C,9
	CALL	5		;PRINT STACK MESSAGE
	LXI	H,0
	DAD	SP		;FIND STACK

PADDR	MOV	A,H		;GET HIGH BYTE
	CALL	PBYTE		;PRINT IT
	MOV	A,L		;GET LOW BYTE

PBYTE	PUSH	PSW		;SAVE BYTE
	ANI	0F0H		;STRIP HIGH NIBBLE
	RRC			;MOVE IT DOWN
	RRC
	RRC
	RRC
	CALL	PNIBBLE		;PRINT IT
	POP	PSW		;GET BYTE
	ANI	0FH		;STRIP LOW NIBBLE
PNIBBLE	ADI	90H		;CONVERT TO ASCII
	DAA
	ACI	40H
	DAA
	MOV	E,A		;RESULT TO E
	MVI	C,2		;CONOUT
	PUSH	H		;SAVE NUMBER
	CALL	5		;PRINT DIGIT
	POP	H
	RET

IMSG	DB	13,10,'CP/M SYSTEM MEMORY UTILIZATION',13,10,10
	DB	'The high memory limit is	$'
BIOMSG	DB	13,10,'The BIOS warm boot entry is at	$'
BDMSG	DB	13,10,'The BDOS entry is at		$'
CMSG	DB	13,10,'The normal CCP entry is at	$'
SMSG	DB	13,10,'This system''s stack is at	$'
MOVMSG	DB	13,10,10,'Your CP/M system does not seem to utilize all '
	DB	'available memory.',13,10
	DB	'See your manual for instructions on using '
	DB	'MOVCPM and SYSGEN to',13,10
	DB	'adjust your CP/M software.',13,10,'$'
	END	START
 manual for instructi