	PAGE	60,132

	TITLE	CPU.COM - CPU Clock Speed Measurement Program

;	Version 2.0 (C) 06-Jul-86 by John Stetson

;	This program provides a simple measurement of CPU
;	computational performance using a software timing loop.

;	A conditional assembly option allows the program to be
;	assembled for either the Zenith Z-100 or PC compatibles.
;	Due to the overhead associated with video interrupt
;	processing on the Z-100, interrupts are disabled during
;	the speed measurement, to insure an accurate result.

;	Use of NEC V20 type CPU chips may result in unrealistically
;	high performance values being reported.  In this case, the
;	reported data can still be used as a relative measure of
;	performance when compared to that for other similar CPU chips.

;	Summary of Reported Benchmark Results

;	Computer    MHz      Perf. Factor    Comments

;	Z-248	    8		6.09	     No wait states
;	Z-248	    8		5.71	     One wait state
;	Z-100	    8		5.29	     NEC V-20
;	Z-241	    6		4.44
;	IBM-PC/AT   8		4.23
;	Z-150	    4.77	2.98	     NEC V-20
;	Z-100	    8		1.69
;	Z-150	    4.77	1.00
;	IBM-PC/XT   4.77	1.00

;	MASM, LINK, and EXE2BIN to make CPU.COM

;	System Definitions

FALSE	EQU	0
TRUE	EQU	NOT FALSE

Z100	EQU	TRUE		;set TRUE for Z-100, FALSE for IBM-PC
IBMPC	EQU	NOT Z100

;	MS-DOS Definitions

MSDOS	EQU	21H		;interrupt for system functions
EXIT	EQU	20H		;interrupt for program termination

OUTSTR	EQU	09H		;output string to console
GTIME	EQU	2CH		;get system time

;	ASCII Character Definitions

LF	EQU	0AH		;line feed
CR	EQU	0DH		;carriage return
EOS	EQU	'$'             ;end of string indicator

;	Segment Definitions

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	100H

;	Start of Program

CPU:	MOV	DX,OFFSET INITMSG
	MOV	AH,OUTSTR
	INT	MSDOS		;display initial message

;	Get the starting time

	MOV	AH,GTIME	;get starting time
	INT	MSDOS		;DH = secs, DL = secs/100
	MOV	STIME,DX	;save for later

;	Perform a series of instructions which requires
;	a known number of clock cycles at 4.77 MHz

	IF	Z100
	CLI			;interrupts off
	ENDIF

	XOR	AX,AX		;init work register
	MOV	DX,10		;10 outer loops

LOOP1:	MOV	CX,47227	;47227 inner loops

LOOP2:	AAM			;ASCII adjust for multiplication
	DEC	CX
	JNZ	LOOP2

	DEC	DX
	JNZ	LOOP1

	IF	Z100
	STI			;interrupts on
	ENDIF

;	Get the ending time

	MOV	AH,GTIME	;get ending time
	INT	MSDOS		;DH = secs, DL = secs/100

	MOV	AX,100		;compute 100 * seconds
	MUL	DH		;(AL)*(DH) -> (AH,AL)

	MOV	DH,0
	ADD	AX,DX
	MOV	BX,AX		;BX = ending time in secs/100

	MOV	DX,STIME	;starting time secs & secs/100
	MOV	AX,100		;compute 100 * seconds
	MUL	DH		;(AL)*(DH) -> (AH,AL)

	MOV	DH,0
	ADD	AX,DX		;AX = starting time in secs/100

;	Compute the elapsed time

	SUB	BX,AX		;BX = elapsed time in secs/100
	JNB	SKIP		;jump if ending time > starting time

	ADD	BX,6000 	;account for minute boundary

SKIP:	MOV	AX,BX
	MOV	ETIME,BX	;save elapsed time in seconds/100

;	Format the elapsed time string

	MOV	BP,OFFSET TIME	;address of ASCII time string

	MOV	BX,1000 	;compute elapsed time tens digit
	CWD			;sign extend AX into DX
	DIV	BX		;(DX,AX)/(BX) -> (AX) QUO, (DX) REM
	CALL	STORE		;convert and store digit

	MOV	BX,100		;compute elapsed time units digit
	MOV	AX,DX		;remainder becomes dividend
	CWD			;sign extend AX into DX
	DIV	BX		;(DX,AX)/(BX) -> (AX) QUO, (DX) REM
	CALL	STORE		;convert and store digit

	INC	BP		;point past decimal point

	MOV	BX,10		;compute elapsed time tenths digit
	MOV	AX,DX		;remainder becomes dividend
	CWD			;sign extend AX into DX
	DIV	BX		;(DX,AX)/(BX) -> (AX) QUO, (DX) REM
	CALL	STORE		;convert and store digit

	MOV	AX,DX		;compute elapsed time hundredths digit
	CALL	STORE		;convert and store digit

;	Display elapsed time message

	MOV	AH,OUTSTR
	MOV	DX,OFFSET TIMMSG
	INT	MSDOS

;	Format the clock speed string

	MOV	BP,OFFSET MHZ	;address of ASCII MHz string

	MOV	AX,4770 	;4.77 MHz normalization factor
	CWD			;sign extend AX into DX
	MOV	BX,ETIME	;elapsed time in seconds/100
	DIV	BX		;(DX,AX)/(BX) -> (AX) QUO, (DX) REM
	PUSH	DX		;save remainder

	MOV	BX,10		;compute clock speed tens digit
	CWD			;sign extend AX into DX
	DIV	BX		;(DX,AX)/(BX) -> (AX) QUO, (DX) REM
	CALL	STORE		;convert and store tens digit

	MOV	AX,DX		;remainder becomes value
	CALL	STORE		;convert and store units digit

	INC	BP		;point past decimal point

	POP	AX		;restore original remainder
	MOV	BX,100		;compute 100 * clock speed
	MUL	BX		;(AX)*(BX) -> (DX,AX)
	MOV	BX,ETIME	;elapsed time in seconds/100
	DIV	BX		;(DX,AX)/(BX) -> (AX) QUO, (DX) REM

	CWD			;sign extend AX into DX
	MOV	BX,10		;compute clock speed tenths digit
	DIV	BX		;(DX,AX)/(BX) -> (AX) QUO, (DX) REM
	CALL	STORE		;convert and store tenths digit

	MOV	AX,DX		;remainder becomes value
	CALL	STORE		;convert and store hundredths digit

;	Display clock speed message

	MOV	AH,OUTSTR
	MOV	DX,OFFSET MHZMSG
	INT	MSDOS

;	Format the performance factor

	MOV	BP,OFFSET PF	;address of ASCII performance string

	MOV	AX,1000 	;4.77 MHz normalization factor
	CWD			;sign extend AX into DX
	MOV	BX,ETIME	;elapsed time in seconds/100
	DIV	BX		;(DX,AX)/(BX) -> (AX) QUO, (DX) REM
	PUSH	DX		;save remainder

	MOV	BX,10		;compute performance tens digit
	CWD			;sign extend AX into DX
	DIV	BX		;(DX,AX)/(BX) -> (AX) QUO, (DX) REM
	CALL	STORE		;convert and store tens digit

	MOV	AX,DX		;remainder becomes value
	CALL	STORE		;convert and store units digit

	INC	BP		;point past decimal point

	POP	AX		;restore original remainder
	MOV	BX,100		;compute 100 * performance
	MUL	BX		;(AX)*(BX) -> (DX,AX)
	MOV	BX,ETIME	;elapsed time in seconds/100
	DIV	BX		;(DX,AX)/(BX) -> (AX) QUO, (DX) REM

	CWD			;sign extend AX into DX
	MOV	BX,10		;compute performance tenths digit
	DIV	BX		;(DX,AX)/(BX) -> (AX) QUO, (DX) REM
	CALL	STORE		;convert and store tenths digit

	MOV	AX,DX		;remainder becomes value
	CALL	STORE		;convert and store hundredths digit

;	Display performance message

	MOV	AH,OUTSTR
	MOV	DX,OFFSET PERMSG
	INT	MSDOS

;	Exit to DOS

	INT	EXIT

;	Convert and store a binary digit

STORE:	OR	AL,30H		;make binary digit printable
	MOV	[BP],AL 	;store it
	INC	BP		;point to next character
	RET			;return to caller

;	Data Areas

STIME	DW	0		;starting time (secs & secs/100)
ETIME	DW	0		;elapsed time  (secs/100)

INITMSG DB	CR,LF
	DB	'System CPU Clock Speed Measurement - Please Wait',CR,LF
	DB	CR,LF,EOS

TIMMSG	DB	'Elapsed Time = '
TIME	DB	'00.00 Seconds (10.00 is nominal for 4.77 MHz)',CR,LF
	DB	CR,LF,EOS

MHZMSG	DB	'Calculated System CPU Clock Speed = '
MHZ	DB	'00.00 MHz',CR,LF,CR,LF,EOS

PERMSG	DB	'Performance Relative to Standard IBM-PC = '
PF	DB	'00.00',CR,LF,EOS

CODE	ENDS

	END	CPU
