	PAGE	60,132

	TITLE	LOCK.COM - MS-DOS Password Program

;	Version 1.0 (C) 06-Oct-86 by John Stetson

;	This utility program is designed to provide a simple
;	security mechanism for MS-DOS computer systems with hard
;	disk drives (when used in conjunction with the associated
;	PASSWORD.DVD device driver).

;	When the user expects to be away from the computer for a
;	period of time, this program can be run to temporarily
;	secure access to the system, without necessitating a
;	system reboot.	The program asks the operator for a
;	password, and denies access to the system if the correct
;	word is not entered.  The associated PASSWORD.DVD device
;	driver secures access to the system at system boot time.

;	For added security, you can replace the printable prompt
;	message with either a null string ($) or just a BELL character
;	and a null string (7,$) as a signal that it's time to enter
;	the password.  This way, an unsuspecting interloper may
;	conclude that the machine has a hardware malfunction, and
;	may well abandon further attempts to access the system.

;	Use of the Control-C or Control-Break functions will not
;	abort this program.  The keyboard is intentionally left active
;	so that the user can perform CTRL-RESET or ALT-CTRL-DEL
;	sequences without cycling the power on the computer.

;	One limitation is that any previously loaded resident
;	programs which intercept the keyboard interrupt in order
;	to process their activation keys will still be accessible.

;	The default password can be changed by editing this file
;	and changing the LPSWD and PSWD data values, below.  The
;	.ASM file is then reassembled and linked as described below.
;	Alternatively, you can just use DEBUG to patch these areas.

;	MASM, LINK, and EXE2BIN to make LOCK.COM.

;	Definitions

FALSE	EQU	0			;Logical FALSE value
TRUE	EQU	NOT FALSE		;Logical TRUE value

Z100	EQU	TRUE			;Set TRUE for Z-100
IBMPC	EQU	NOT Z100		;or FALSE for IBM-PC

EXIT	EQU	20H			;Program Termination
MSDOS	EQU	21H			;System Interrupt

OUTCHR	EQU	02H			;Output Character
DCIN	EQU	07H			;Direct Console Input
OUTSTR	EQU	09H			;Output String

BELL	EQU	07H			;Bell
LF	EQU	0AH			;Line Feed
CR	EQU	0DH			;Carriage Return
ESC	EQU	1BH			;Escape
EOS	EQU	'$'			;End of String

;	Start of Program

CODE	SEGMENT BYTE
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	100H

LOCK:
	IF	Z100
	MOV	DX,OFFSET CLSMSG
	MOV	AH,OUTSTR		;Clear the screen
	INT	MSDOS
	ENDIF

	IF	IBMPC
	MOV	AX,6*256+0		;Scroll entire screen upwards
	MOV	BH,7			;Screen attribute
	SUB	CX,CX			;Upper Left = Row 00 Col 00
	MOV	DX,24*256+79		;Lower Right = Row 24 Col 79
	INT	10H			;ROM BIOS Video Interrupt

	MOV	AH,2			;Set Cursor Position
	XOR	BH,BH			;Page Number = 0
	XOR	DX,DX			;Row 00 Col 00
	INT	10H			;ROM BIOS Video Interrupt
	ENDIF

	MOV	DX,OFFSET PROMPT
	MOV	AH,OUTSTR		;Display prompt message
	INT	MSDOS

INIT:	MOV	DL,BELL
	MOV	AH,OUTCHR		;Synchronize with user
	INT	MSDOS

	XOR	CX,CX
	MOV	DI,OFFSET BUFF

LOOP:	MOV	AH,DCIN 		;Get next character
	INT	MSDOS

	CMP	AL,CR			;Carriage return?
	JZ	COMP			;Done, if so

	MOV	[DI],AL 		;Store character
	INC	DI
	INC	CX
	CMP	CX,8			;8 characters typed?
	JL	LOOP			;Continue, if not

COMP:	MOV	DX,OFFSET CRLF
	MOV	AH,OUTSTR		;Output CR/LF
	INT	MSDOS

	CMP	CX,0			;Any characters typed?
	JZ	INIT			;Try again, if not

	CMP	CX,LPSWD		;Correct length?
	JNZ	INIT			;Try again, if not

	CLD
	MOV	SI,OFFSET BUFF
	MOV	DI,OFFSET PSWD
	REPZ	CMPSB			;Does password match?
	JNZ	INIT			;Try again, if not

	INT	EXIT			;Return to DOS

;	Data Areas

	IF	Z100
CLSMSG	DB	ESC,'E',EOS
	ENDIF

PROMPT	DB	'Enter password: ',EOS
CRLF	DB	CR,LF,EOS
BUFF	DB	8 DUP (?)

;	Change the following 2 values to set the password

LPSWD	DW	5			;Length of password (1-8)
PSWD	DB	'xyzzy   '		;User password (8 chars max)

CODE	ENDS

	END	LOCK
