	PAGE	60,132

	TITLE	SD: MS-DOS Sorted Directory Utility Program

	comment $

	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	SD.COM Version 5.3 (C) 14-Oct-86 by John F. Stetson

	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	This is a sorted directory utility program which operates
	under the Microsoft Disk Operating System Version 2 and above.

	Conditional assembly equates are used to tailor the program
	for either the Zenith Z-100 or IBM-PC compatible computers.

	Design criteria include the following:

	Small size for minimum use of disk space and fast loading.

	Fast screen output without the loss of output redirection.

	Maximum possible use of the horizontal dimension of the screen
	to minimize loss of previously displayed data by scrolling.

	Support for a variety of screen display formats with varying
	amounts of detailed file information displayed.

	User customizable command line switch default values and
	screen field display colors.

	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	Command Line Syntax

	sd [drive:][path][filespec] [/switches] [>device/file]

	[drive:] specifies any valid disk drive letter.

	[path] specifies the path to the desired directory.

	[filespec] specifies which files are selected (?,*).

	[/switches] modify the command as described below.

	[>device/file] specifies that console output is to be
	redirected to either a device (such as PRN) or a file.
	The /r switch must be specified for this to work.

	Console output may be paused by typing any character
	and is restarted when another character is typed.

	Typing Control-C will terminate the program prematurely.

	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	Description of Switches

	File Selection (only specified files)

	/s - All /sd - Dir /sa - Arch /sr - Read /sh - Hid /ss - Sys

	Sort Fields (mutually exclusive)

	/a - Ascending by date & time	 /e - File extension and name
	/b - File sizes in bytes	 /f - File name and extension
	/d - Descending by date & time	 /n - Normal order (no sort)

	Output Control (digits specify columns)

	/1 - All file information	 /m - Display system RAM usage
	/2 - Name, size, date and time	 /p - Display disk parameters
	/4 - File name and size only	 /q - Quick output (no pauses)
	/6 - File names only		 /r - Allow output redirection
	/c - Clear console screen	 /t - Totals output lines only
	/k - Display space in kbytes	 /v - Volume label information

	File selection switches may be combined: D>sd/sar

	Specifying the /m switch will display the DOS System Version
	and RAM usage: System RAM Used, Free, and the Total Available.

	Specifying the /p switch will display disk parameters:
	Media Byte, Bytes/Sector, Bytes/Cluster and Total Clusters.

	Specifying the /t switch suppresses the display of detailed
	information for individual files and directories.

	Specifying the /v switch will display the volume label and
	creation date and time and the current day, date and time.

	The default switch values may be altered by using DEBUG.COM
	to modify the following bytes in the SD.COM file:

	Offset	  Switch    Default    Possible Value(s)
	------	  ------    -------    -----------------
	 0102	   Sort       'F'      'A', 'B', 'D', 'E', 'F', 'N'
	 0103	   Cols       '4'      '1', '2', '4', '6'
	 0104	    /c	       0	0, 1=Clear console screen
	 0105	    /k	       0	0, 1=Display space in kbytes
	 0106	    /m	       0	0, 1=Display system RAM usage
	 0107	    /p	       0	0, 1=Display disk parameters
	 0108	    /q	       0	0, 1=Quick output (no pauses)
	 0109	    /r	       0	0, 1=Allow output redirection
	 010A	    /t	       0	0, 1=Totals output lines only
	 010B	    /v	       0	0, 1=Volume label information

	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	Screen Color Selection

	The default foreground and background colors used for the
	following fields of the displayed output may be patched:

	File Colors - apply to individual disk file entries.

	Directory Colors - apply to individual directory entries.

	Separator Colors - apply to the separator characters which
		are used to divide the entry columns vertically.

	Text Colors - apply to the leading and trailing text lines.

	Normal Colors - apply to the normal state of the screen
		before and after SD.COM is executed.  These colors
		should be changed to match the standard screen
		colors used, if they are other than white on black.


	For the Z-100:

	Offset	  Field Color		  Def.(Color)	 Def.(Mono)
	------	  -----------		  -----------	 ----------
	 010C	  File Fore Color	   '7' White      '7' White
	 010D	  File Back Color	   '1' Blue       '0' Black
	 010E	  Directory Fore Color	   '0' Black      '0' Black
	 010F	  Directory Back Color	   '4' Green      '4' Green
	 0110	  Separator Fore Color	   '2' Red        '7' White
	 0111	  Separator Back Color	   '0' Black      '0' Black
	 0112	  Text Fore Color	   '6' Yellow     '7' White
	 0113	  Text Back Color	   '0' Black      '0' Black
	 0114	  Normal Fore Color	   '7' White      '7' White
	 0115	  Normal Back Color	   '0' Black      '0' Black

	'0' = Black,   '1' = Blue,    '2' = Red,     '3' = Magenta
	'4' = Green,   '5' = Cyan,    '6' = Yellow,  '7' = White

	Two different sets of default colors are shown in the table
	above for color and monochrome monitors.  As supplied, the
	Z-100 version of SD.COM is configured for a color monitor.


	For the IBM-PC:

	Offset	  Field Attribute	      Default  Description
	------	  ---------------	      -------  -----------
	 010C	  File Fore/Back Colors       7+16*1   White on Blue
	 010D	  Directory Fore/Back Colors  0+16*2   Black on Green
	 010E	  Separator Fore/Back Colors  4+16*0   Red on Black
	 010F	  Text Fore/Back Colors       6+16*0   Brown on Black
	 0110	  Normal Fore/Back Colors     7+16*0   White on Black

	 0111	  File Mono Attributes	      7+16*0   Normal Video
	 0112	  Directory Mono Attributes   0+16*7   Reverse Video
	 0113	  Separator Mono Attributes   7+16*0   Normal Video
	 0114	  Text Mono Attributes	      7+16*0   Normal Video
	 0115	  Normal Mono Attributes      7+16*0   Normal Video

	 0 = Black,	1 = Blue,      2 = Green,     3 = Cyan
	 4 = Red,	5 = Magenta,   6 = Brown,     7 = White

	The PC version of SD.COM uses either the color or monochrome
	attributes specified at the offsets in the table above, based
	on the type of monitor being used.

	Once the desired foreground and background colors (attributes)
	have been selected for an output field, compute the field
	attribute byte using the formula: attribute = fcolor+16*bcolor,
	where fcolor and bcolor are the foreground and background
	colors (attributes), respectively.

	Intensified foreground colors corresponding to the 8 standard
	colors may be selected by adding 8 to the foreground color
	number.  For example, specify foreground color 14=(6+8) to get
	a foreground yellow color instead of the unintensified brown.
	The blinking attribute may be selected by adding 8 to the
	background color number.  However, use of this attribute is
	not recommended, since it may be distracting.  For a monochrome
	monitor, selecting Blue on Black (1+16*0) will cause the output
	field to be underlined.

	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	end comment $.

;	Conditional Assembly Definitions

FALSE	EQU	0			;Logical FALSE for conditionals
TRUE	EQU	NOT FALSE		;Logical TRUE  for conditionals

Z100	EQU	TRUE			;Set TRUE for Zenith Z-100 Computer
IBMPC	EQU	NOT Z100		;or FALSE for IBM Personal Computer

	IF	Z100
ZCOLOR	EQU	TRUE			;Set TRUE for Z-100 Color Monitor
	ENDIF				;or FALSE for Z-100 Mono. Monitor

;	MS-DOS Interrupt Definitions

EXIT	EQU	20H			;Program Termination
DOS	EQU	21H			;System Functions

;	MS-DOS System Function Definitions

OUTCHR	EQU	02H			;Output Character to Console
DCIN	EQU	07H			;Direct Console Input
OUTSTR	EQU	09H			;Output String to Console
SDISK	EQU	0EH			;Select Default Disk
SRCHF	EQU	11H			;Search for First Directory Entry
SRCHN	EQU	12H			;Search for Next Directory Entry
GDISK	EQU	19H			;Get Default Disk
SDTA	EQU	1AH			;Set Disk Transfer Address
GFAT	EQU	1CH			;Get FAT Information for Drive
GDATE	EQU	2AH			;Get System Date
GTIME	EQU	2CH			;Get System Time

GVERS	EQU	30H			;Get DOS System Version
GPARMS	EQU	36H			;Get Disk Parameters
CHDIR	EQU	3BH			;Change Current Directory
GDIR	EQU	47H			;Get Current Directory

;	Program Segment Prefix Definitions

MEM	EQU	02H			;Total RAM Paragraphs Available
DTA	EQU	80H			;Default Disk Transfer Address

;	File Attribute Definitions

ATTRA	EQU	20H			;Archive
ATTRD	EQU	10H			;Directory
ATTRV	EQU	08H			;Volume label
ATTRS	EQU	04H			;System
ATTRH	EQU	02H			;Hidden
ATTRR	EQU	01H			;Read-only

	IF	Z100
;	Z-100 BIOS Entry Point Definitions

BIOSSG	SEGMENT AT 40H			;Z-100 BIOS Segment
	ORG	1*3
BIOSCS	LABEL	FAR			;Console Input Status
	ORG	2*3
BIOSCI	LABEL	FAR			;Console Input
	ORG	3*3
BIOSCO	LABEL	FAR			;Console Output
BIOSSG	ENDS
	ENDIF

	IF	IBMPC
;	IBM-PC ROM BIOS Definitions

VIDEO	EQU	10H			;Video I/O interrupt
KEYBD	EQU	16H			;Keyboard I/O interrupt

ROM_DATA SEGMENT AT 40H 		;ROM BIOS Data Segment
	ORG	4AH
CRT_COLS DW	?			;Number of columns on screen
	ORG	62H
ACTIVE_PAGE DB	?			;Current page being displayed
ROM_DATA ENDS
	ENDIF

;	ASCII Character Definitions

NULL	EQU	00H			;Null
CTLC	EQU	03H			;Control-C
LF	EQU	0AH			;Line feed
CR	EQU	0DH			;Carriage return
ESC	EQU	1BH			;Escape
EOS	EQU	'$'                     ;End of string

;	Program Definitions

SWTCHR	EQU	'/'                     ;Command line switch character
BAR	EQU	'|'                     ;Non-graphics delimiter character
PCBAR	EQU	0B3H			;IBM-PC graphics delimiter character
BUFLEN	EQU	23			;Length of file buffer entry

	IF	Z100
NLS	EQU	24			;Number of scrollable lines on screen
	ENDIF

	IF	IBMPC
NLS	EQU	25			;Number of scrollable lines on screen
	ENDIF

;	Segment Definitions

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	100H			;Origin past PSP

;	Start of Program

SD:	JMP	SHORT INIT		;Jump past patch area

;	Patch Area for Switch Defaults

SFLAG	DB	'F'                     ;Sort type (/A,B,D,E,F,N)
OFLAG	DB	'4'                     ;Number of columns (/1,2,4,6)
CFLAG	DB	0			;Clear screen (/C)
KFLAG	DB	0			;Space in kbytes (/K)
MFLAG	DB	0			;Display system RAM (/M)
PFLAG	DB	0			;Display disk parms (/P)
QFLAG	DB	0			;Quick output (/Q)
RFLAG	DB	0			;Redirected output (/R)
TFLAG	DB	0			;Totals only (/T)
VFLAG	DB	0			;Volume label (/V)

;	Patch Area for Screen Colors

	IF	Z100
BLACK	EQU	30H
BLUE	EQU	31H
RED	EQU	32H
MAGENTA EQU	33H
GREEN	EQU	34H
CYAN	EQU	35H
YELLOW	EQU	36H
WHITE	EQU	37H

	IF	ZCOLOR			;Z-100 Color Monitor
FCOLORS DB	WHITE,BLUE		;File	   F/B Colors
DCOLORS DB	BLACK,GREEN		;Directory F/B Colors
SCOLORS DB	RED,BLACK		;Separator F/B Colors
TCOLORS DB	YELLOW,BLACK		;Text	   F/B Colors
NCOLORS DB	WHITE,BLACK		;Normal    F/B Colors
	ELSE				;Z-100 Mono. Monitor
FCOLORS DB	WHITE,BLACK		;File	   F/B Colors
DCOLORS DB	BLACK,GREEN		;Directory F/B Colors
SCOLORS DB	WHITE,BLACK		;Separator F/B Colors
TCOLORS DB	WHITE,BLACK		;Text	   F/B Colors
NCOLORS DB	WHITE,BLACK		;Normal    F/B Colors
	ENDIF

	ENDIF

	IF	IBMPC
BLACK	EQU	00H
BLUE	EQU	01H
GREEN	EQU	02H
CYAN	EQU	03H
RED	EQU	04H
MAGENTA EQU	05H
BROWN	EQU	06H
WHITE	EQU	07H

;	Color Attributes

FCOLORS DB	WHITE+16*BLUE		;File	   F/B Colors
DCOLORS DB	BLACK+16*GREEN		;Directory F/B Colors
SCOLORS DB	RED+16*BLACK		;Separator F/B Colors
TCOLORS DB	BROWN+16*BLACK		;Text	   F/B Colors
NCOLORS DB	WHITE+16*BLACK		;Normal    F/B Colors

;	Monochrome Attributes

FATTR	DB	WHITE+16*BLACK		;File	   F/B Attr
DATTR	DB	BLACK+16*WHITE		;Directory F/B Attr
SATTR	DB	WHITE+16*BLACK		;Separator F/B Attr
TATTR	DB	WHITE+16*BLACK		;Text	   F/B Attr
NATTR	DB	WHITE+16*BLACK		;Normal    F/B Attr
	ENDIF

INIT:
	IF	IBMPC

;	Determine video mode

	MOV	AH,15			;Get video mode
	INT	VIDEO
	MOV	PCVMODE,AL		;Save for later
	CMP	AL,7			;Monochrome monitor?
	JNZ	INIT2			;Jump if not
	MOV	SI,OFFSET FATTR 	;Move mono. attributes
	MOV	DI,OFFSET FCOLORS	;to color attributes
	MOV	CX,5
	CLD
	REPZ	MOVSB
INIT2:	MOV	PCTEXT,1		;Set text mode
	ENDIF

;	Determine DOS Version

	MOV	AH,GVERS
	INT	DOS

;	(AL,AH) = (Major,Minor) DOS Version Numbers
;	(AL) = zero, if version is pre MS-DOS 2.0

	CMP	AL,2			;At least DOS 2.0?
	JNL	DOSOK			;Jump if so
	MOV	DX,OFFSET VERMSG
	MOV	AH,OUTSTR
	CALL	OUTLIN			;Give DOS error message
	JMP	BYE			;Exit to DOS

DOSOK:	ADD	AL,'0'
	MOV	DOSMAJ,AL		;Store major version number

	MOV	AL,AH
	XOR	AH,AH			;AX = minor version number
	MOV	BL,10
	DIV	BL			;(AX)/(BL) -> AL(QUO), AH(REM)
	ADD	AL,'0'
	MOV	DOSMIN,AL		;Store minor 10ths digit
	ADD	AH,'0'
	MOV	DOSMIN+1,AH		;Store minor 100ths digit

;	Determine and save current drive

	MOV	AH,GDISK		;Get currently logged-in drive
	INT	DOS
	MOV	LDRIVE,AL		;Save logged-in drive # (0=A,1=B,...)
	ADD	AL,'A'                  ;Convert to drive letter

;	Store default target path

	MOV	BYTE PTR PATH,AL
	MOV	BYTE PTR PATH+1,':'
	MOV	BYTE PTR PATH+2,'\'
	MOV	BYTE PTR PATH+3,NULL

;	Store current directory for target drive

	MOV	BYTE PTR PATHS,AL
	MOV	BYTE PTR PATHS+1,':'
	MOV	BYTE PTR PATHS+2,'\'
	SUB	AL,'@'                  ;Normalize to (1,2,...)
	MOV	DL,AL			;Desired drive number
	MOV	SI,OFFSET PATHS+3	;Output area
	MOV	AH,GDIR 		;Get current directory
	INT	DOS

;	Initialize File Control Block

	MOV	BYTE PTR XFCBS,0FFH	;Initialize extended FCB
	MOV	BYTE PTR XFCBA,ATTRD	;Set directory attribute
	MOV	BYTE PTR FDRIVE,0	;Select default target drive
	MOV	SI,OFFSET WILD
	MOV	DI,OFFSET FNAME
	MOV	CX,11
	CLD
	REPZ	MOVSB			;Set wildcard file name

;	Parse command line

	CALL	PARSE

	IF	Z100
	CMP	BYTE PTR RFLAG,0	;Redirected output?
	JNZ	CHKSYN			;Jump if so
	MOV	AX,WORD PTR TCOLORS	;Set text colors
	MOV	WORD PTR COLORS,AX
	MOV	DX,OFFSET SETCOL
	MOV	AH,OUTSTR
	CALL	OUTLIN
	ENDIF

;	Handle syntax errors

CHKSYN: CMP	BYTE PTR ERROR,0	;Syntax error?
	JZ	GETDRV			;Jump if not
	CMP	BYTE PTR ERROR,1	;Bad filespec?
	JNZ	BADSW			;Jump if not

	MOV	DX,OFFSET FILEMSG
	MOV	AH,OUTSTR
	CALL	OUTLIN			;Give filespec message
	JMP	BYE			;Exit to DOS

BADSW:
	MOV	BYTE PTR CFLAG,1
	CALL	CLEAR			;Clear screen

	MOV	DX,OFFSET HLPMSG
	MOV	AH,OUTSTR
	CALL	OUTLIN			;Give help message

	JMP	BYE			;Exit to DOS

;	Determine drive to process

GETDRV: MOV	DL,BYTE PTR FDRIVE	;Get possible drive #
	DEC	DL			;Was one specified?
	JNS	GOTDRV			;Jump if so (GE zero)
	MOV	DL,LDRIVE		;Use logged-in drive

GOTDRV: INC	DL			;Normalize to (1=A,2=B,...)
	MOV	BYTE PTR FDRIVE,DL	;Store binary drive #

;	Determine if drive exists

	MOV	DL,BYTE PTR FDRIVE	;Desired binary drive #
	DEC	DL			;Normalize to zero
	MOV	AH,SDISK		;Select Disk as Default
	INT	DOS			;AL = Maximum valid drive #
	INC	DL			;Normalize to one
	CMP	DL,AL			;Drive # LE Max Drive?
	JNA	MAIN			;Jump if so
	CALL	LOGIN			;Reset default drive

BADDRV: MOV	DX,OFFSET DRVMSG
	MOV	AH,OUTSTR
	CALL	OUTLIN			;Give drive message
	JMP	SHORT BYE		;Exit to DOS

;	Main processing section

MAIN:	CALL	COMPUTE 		;Compute disk parameters
	CALL	SETDIR			;Change to target directory
	CALL	FILES			;Determine file entries
	CALL	RESDIR			;Reset the current directory
	CALL	SORT			;Sort file entries
	CALL	SPLIT			;Split linked list into columns

	CALL	CLEAR			;Clear console screen
	CALL	RAM			;Display system memory used
	CALL	VOLUME			;Display volume information
	CALL	PARMS			;Display disk parameters
	CALL	OUTPUT			;Display file entries
	CALL	TOTALS			;Display trailer lines

BYE:
	IF	Z100

;	Reset Video State

	CMP	BYTE PTR RFLAG,0	;Redirected output?
	JNZ	BYE2			;Jump if so
	MOV	AX,WORD PTR NCOLORS	;Set normal colors
	MOV	WORD PTR COLORS,AX
	MOV	DX,OFFSET SETCOL
	MOV	AH,OUTSTR
	CALL	OUTLIN
BYE2:
	ENDIF

	MOV	DL,NULL
	MOV	AH,OUTCHR
	CALL	OUTLIN			;Write any remaining text

	INT	EXIT			;Exit to DOS

;	Parse command line operands

;	sd <switches> <drive:><path><filespec> <switches> CR

;	The default DTA contains the length and text of the
;	DOS command line 'tail' or the characters after the
;	program name, but before the carriage return.

PARSE:	MOV	SI,DTA			;A(Length of command line tail)
	MOV	CL,[SI] 		;CL=number of bytes to parse
	CMP	CL,2			;Command line operands present?
	JGE	PARS05			;Jump if so
	RET				;Return if not

PARS05: INC	SI			;Point past length byte
	MOV	BX,SI
	XOR	CH,CH
	ADD	BX,CX			;BX = address of trailing CR

;	Parse leading switches

	DEC	SI
	CALL	SWITCH
	CMP	SI,BX			;At end of command line?
	JNB	PARS10			;Jump if so

;	Parse drive name

	CMP	BYTE PTR [SI+1],':'     ;Drive name present?
	JNZ	PARS10			;Jump if not
	MOV	AL,[SI] 		;Get drive letter
	CALL	UPPER			;Convert to upper case
	CMP	AL,'A'                  ;Check if too low
	JB	BADDRV
	CMP	AL,'Z'                  ;Check if too high
	JA	BADDRV
	MOV	BYTE PTR PATH,AL	;Store in target path
	MOV	BYTE PTR PATHS,AL	;Store in saved path
	SUB	AL,'@'                  ;Normalize to 1
	MOV	BYTE PTR FDRIVE,AL	;Store binary drive number
	ADD	SI,2			;Point past drive name and colon

;	Store current directory for target drive

PARS10: PUSH	SI			;Save registers
	PUSH	BX
	MOV	DL,BYTE PTR PATHS	;Target drive (A,B,...)
	SUB	DL,'@'                  ;Normalize to (1,2,...)
	MOV	SI,OFFSET PATHS+3	;Output area
	MOV	AH,GDIR 		;Get current directory
	INT	DOS
	POP	BX			;Restore registers
	POP	SI

;	Parse path name

;	Check for path name without file spec

	MOV	CX,SI			;Save buffer pointer
	MOV	DI,OFFSET PATH+2	;Destination for path name
	MOV	DX,DI			;Save for later

;	Scan forward for end of path name

PARS15: MOV	AL,[SI] 		;Get next character
	CMP	AL,CR			;End of command line?
	JZ	PARS20			;Jump if so
	CMP	AL,' '                  ;Space delimiter?
	JZ	PARS20			;Jump if so
	CMP	AL,SWTCHR		;Switch character?
	JZ	PARS20			;Jump if so
	CALL	UPPER			;Convert to upper case
	MOV	[DI],AL 		;Store character
	INC	SI			;Increment pointers
	INC	DI
	JMP	SHORT PARS15

PARS20: CMP	DI,DX			;Any characters found?
	JZ	PARS55			;Jump if not
	CMP	BYTE PTR [DI-2],':'     ;Possible root directory?
	JZ	PARS25			;Jump if so
	CMP	BYTE PTR [DI-1],'\'     ;Trailing \?
	JNZ	PARS25			;Jump if not
	DEC	DI			;Remove it

PARS25: MOV	BYTE PTR [DI],NULL	;Mark end of path name

;	Determine if the specified path exists

;	Try to change to the specified directory

	PUSH	BX			;Save registers
	PUSH	CX
	MOV	DX,OFFSET PATH		;Possible path name
	MOV	AH,CHDIR		;Change to specified dir path
	INT	DOS			;Does path exist?
	POP	CX			;Restore resisters
	POP	BX
	JC	PARS30			;Jump if not

;	Restore the current directory for the target drive

	MOV	DX,OFFSET PATHS 	;Saved directory path name
	MOV	AH,CHDIR		;Restore current directory
	INT	DOS
	MOV	BYTE PTR PSFLAG,1	;Indicate path specified
	JMP	PARS90			;Full path name - no file spec

;	Check for path name with file spec

PARS30: MOV	SI,CX			;Restore buffer pointer
	MOV	DI,OFFSET PATH+2	;Restore path destination
	MOV	BYTE PTR PATH+2,'\'     ;Restore default path name
	MOV	BYTE PTR PATH+3,NULL

;	Scan backward for end of path name (\)

PARS35: DEC	BX			;Point to previous char
	MOV	AL,[BX] 		;Get character
	CMP	AL,'\'                  ;Trailing path delimiter?
	JZ	PARS40			;Jump if so
	CMP	BX,SI			;More path delimiters possible?
	JZ	PARS55			;Jump if not
	JMP	SHORT PARS35		;Jump if so

PARS40: CMP	SI,BX			;Root directory?
	JZ	PARS50			;Jump if so

;	Store path name

PARS45: MOV	AL,[SI] 		;Get next character
	CALL	UPPER			;Convert to upper case
	MOV	[DI],AL 		;Store character
	INC	SI			;Increment pointers
	INC	DI
	CMP	SI,BX			;End of path name?
	JL	PARS45			;Jump if not
	MOV	BYTE PTR [DI],NULL	;Mark end of path name

PARS50: INC	SI			;Point past delimiter
	MOV	BYTE PTR PSFLAG,1	;Indicate path specified

;	Parse file name

PARS55: MOV	DI,OFFSET FNAME 	;Place to move file name
	MOV	CL,8			;Maximum file name length

PARS60: MOV	AL,[SI] 		;Get next file name character
	CMP	AL,CR			;End of command line?
	JZ	PARS82			;Jump if so
	CMP	AL,' '                  ;Space?
	JZ	PARS92			;Jump if so
	CMP	AL,SWTCHR		;Switch character?
	JZ	PARS92			;Jump if so
	CMP	AL,'.'                  ;Extension delimiter?
	JZ	PARS65			;Jump if so
	CMP	AL,'*'                  ;Wild card indicator?
	JZ	PARS75			;Jump if so
	CALL	UPPER			;Convert to upper case
	MOV	[DI],AL 		;Store character
	INC	DI
	INC	SI			;Point to next character
	DEC	CL			;Any characters left?
	JNZ	PARS60			;Jump if so
	JMP	SHORT PARS80

PARS65: CMP	CL,8			;No file name specified?
	JZ	PARS80			;Jump if so

PARS70: MOV	BYTE PTR [DI],' '       ;Pad with trailing spaces
	DEC	CL
	JNZ	PARS70
	JMP	SHORT PARS84

PARS75: INC	SI			;Point to next character

PARS80: MOV	AL,[SI] 		;Get next character
	CMP	AL,CR			;End of command line?
	JZ	PARS82			;Jump if so
	CMP	AL,'.'                  ;Extension delimiter?
	JZ	PARS84			;Jump if so
	CMP	AL,SWTCHR		;Switch character?
	JZ	PARS92			;Jump if so
	MOV	ERROR,1 		;Indicate syntax error

PARS82: RET

;	Parse file extension

PARS84: INC	SI			;Point past . delimiter
	MOV	DI,OFFSET FEXT		;Place to move file extension
	MOV	CL,3			;Maximum file extension length

PARS86: MOV	AL,[SI] 		;Get next file ext character
	CMP	AL,CR			;End of command line?
	JZ	PARS88			;Jump if so
	CMP	AL,' '                  ;Space?
	JZ	PARS88			;Jump if so
	CMP	AL,SWTCHR		;Switch character?
	JZ	PARS88			;Jump if so
	CMP	AL,'*'                  ;Wild card indicator?
	JZ	PARS94			;Jump if so
	CALL	UPPER			;Convert to upper case
	MOV	[DI],AL 		;Store character
	INC	DI
	INC	SI			;Point to next character
	DEC	CL			;Any characters left?
	JNZ	PARS86			;Jump if so
	JMP	SHORT PARS90

PARS88: MOV	BYTE PTR [DI],' '       ;Pad with trailing spaces
	DEC	CL
	JNZ	PARS88

PARS90: CMP	BYTE PTR [SI],CR	;End of command line?
	JZ	PARS82			;Jump if so

PARS92: DEC	SI			;Decrement pointer

;	Parse trailing switches

PARS94: CALL	SWITCH
	RET

;	Parse command line switches either before
;	or after filespec, skipping embedded spaces

;	Enter with SI -> before switch char (/)
;	Exit with SI -> filespec or CR, or ERROR set

SWITCH: INC	SI			;Point to next character
	MOV	AL,[SI] 		;Get character
	CMP	AL,CR			;End of command line?
	JZ	SWIT05			;Jump if so
	CMP	AL,' '                  ;Space?
	JZ	SWITCH			;Jump if so
	CMP	AL,SWTCHR		;Switch character?
	JZ	SWIT10			;Jump if so
SWIT05: RET

SWIT10: INC	SI			;Point past switch character
	MOV	AL,[SI] 		;Get next character
	CMP	AL,CR			;End of command line?
	JZ	SWIT05			;Jump if so
	CMP	AL,' '                  ;Space?
	JZ	SWIT10			;Jump if so
	CALL	UPPER			;Convert to upper case

;	Parse file selection switches

	CMP	AL,'S'                  ;Select subset of files?
	JNZ	SWIT45			;Jump if not
	MOV	BYTE PTR XFCBA,ATTRD+ATTRH+ATTRS ;Select all files

SWIT15: INC	SI			;Point to operand
	MOV	AL,[SI] 		;Get next character
	CMP	AL,CR			;End of command line?
	JZ	SWIT05			;Jump if so
	CMP	AL,' '                  ;Space?
	JZ	SWITCH			;Jump if so
	CMP	AL,SWTCHR		;Switch character?
	JZ	SWIT10			;Jump if so
	CALL	UPPER			;Convert to upper case

	CMP	AL,'D'                  ;Select directories?
	JNZ	SWIT20			;Jump if not
	OR	BYTE PTR ATTR,ATTRD
	JMP	SHORT SWIT15

SWIT20: CMP	AL,'A'                  ;Select archive files?
	JNZ	SWIT25			;Jump if not
	OR	BYTE PTR ATTR,ATTRA
	JMP	SHORT SWIT15

SWIT25: CMP	AL,'R'                  ;Select read-only files?
	JNZ	SWIT30			;Jump if not
	OR	BYTE PTR ATTR,ATTRR
	JMP	SHORT SWIT15

SWIT30: CMP	AL,'H'                  ;Select hidden files?
	JNZ	SWIT35			;Jump if not
	OR	BYTE PTR ATTR,ATTRH
	JMP	SHORT SWIT15

SWIT35: CMP	AL,'S'                  ;Select system files?
	JZ	SWIT40			;Jump if so
	JMP	SWIT95			;Error if not

SWIT40: OR	BYTE PTR ATTR,ATTRS
	JMP	SHORT SWIT15

;	Parse sort field switches

SWIT45: CMP	AL,'A'                  ;Sort in ascending order?
	JZ	SWIT50
	CMP	AL,'B'                  ;Sort by file size in bytes?
	JZ	SWIT50
	CMP	AL,'D'                  ;Sort in descending order?
	JZ	SWIT50
	CMP	AL,'E'                  ;Sort by file ext. and name?
	JZ	SWIT50
	CMP	AL,'F'                  ;Sort by file name and ext.?
	JZ	SWIT50
	CMP	AL,'N'                  ;No sort?
	JNZ	SWIT55
SWIT50: MOV	SFLAG,AL
	JMP	SWITCH

;	Parse output control switches

SWIT55: CMP	AL,'1'                  ;One output column?
	JZ	SWIT60
	CMP	AL,'2'                  ;Two output columns?
	JZ	SWIT60
	CMP	AL,'4'                  ;Four output columns?
	JZ	SWIT60
	CMP	AL,'6'                  ;Six output columns?
	JNZ	SWIT65
SWIT60: MOV	OFLAG,AL
	JMP	SWITCH

SWIT65: CMP	AL,'C'                  ;Clear screen?
	JNZ	SWIT70
	MOV	AL,1
	SUB	AL,CFLAG
	MOV	CFLAG,AL
	JMP	SWITCH

SWIT70: CMP	AL,'K'                  ;Space in kbytes?
	JNZ	SWIT72
	MOV	AL,1
	SUB	AL,KFLAG
	MOV	KFLAG,AL
	JMP	SWITCH

SWIT72: CMP	AL,'M'                  ;Display system RAM?
	JNZ	SWIT74
	MOV	AL,1
	SUB	AL,MFLAG
	MOV	MFLAG,AL
	JMP	SWITCH

SWIT74: CMP	AL,'P'                  ;Display disk parms?
	JNZ	SWIT75
	MOV	AL,1
	SUB	AL,PFLAG
	MOV	PFLAG,AL
	JMP	SWITCH

SWIT75: CMP	AL,'Q'                  ;Quick output?
	JNZ	SWIT80
	MOV	AL,1
	SUB	AL,QFLAG
	MOV	QFLAG,AL
	JMP	SWITCH

SWIT80: CMP	AL,'R'                  ;Redirected output?
	JNZ	SWIT85
	MOV	AL,1
	SUB	AL,RFLAG
	MOV	RFLAG,AL
	MOV	AL,1
	SUB	AL,QFLAG
	MOV	QFLAG,AL
	JMP	SWITCH

SWIT85: CMP	AL,'T'                  ;Display totals line only?
	JNZ	SWIT90
	MOV	AL,1
	SUB	AL,TFLAG
	MOV	TFLAG,AL
	JMP	SWITCH

SWIT90: CMP	AL,'V'                  ;Display volume label info?
	JNZ	SWIT95
	MOV	AL,1
	SUB	AL,VFLAG
	MOV	VFLAG,AL
	JMP	SWITCH

SWIT95: MOV	ERROR,2 		;Indicate bad switch
	RET

;	Compute disk parameter values

COMPUTE:MOV	DL,BYTE PTR FDRIVE	;Desired drive in binary
	DEC	DL			;Normalize to zero
	MOV	AH,SDISK		;Select Disk as Default
	INT	DOS

	XOR	DL,DL			;(DL) = 0 (default drive)
	MOV	AH,GPARMS		;Get Disk Parameter Values
	INT	DOS

;	(AX) = FFFFH if drive number was invalid or
;	       Number of Sectors Per Allocation Unit
;	(BX) = Number of Free Allocation Units
;	(CX) = Physical Sector Size (Bytes Per Sector)
;	(DX) = Total Number of Allocation Units

	MOV	SPC,AX			;Save Number of Sectors/Cluster
	MOV	BPS,CX			;Save Bytes Per Sector
	MOV	NCLUS,DX		;Save Number of Clusters

;	Compute Percent of Disk Space Used as:

;	Percent Used = ((Total AUs - Free AUs) * 100 +
;			 Total AUs/2) / Total AUs

	MOV	AX,DX			;(AX) = Total AUs
	SUB	AX,BX			;(AX) = Total - Free = AUs Used
	MOV	SI,100			;To compute percent
	MUL	SI			;(AX)*(SI) -> (DX,AX)
	MOV	DI,NCLUS		;(DI) = Total AUs
	SHR	DI,1			;(DI) = Total AUs/2
	ADD	AX,DI			;Round Upward
	ADC	DX,0			;Handle Carry
	DIV	NCLUS			;(DX,AX)/(NCLUS) -> AX(QUO), DX(REM)
	MOV	PCT,AX			;Save percent of disk space used

;	Compute Bytes Per Cluster (Allocation Unit) as:

;	Bytes Per Cluster = Bytes Per Sector * Sectors Per Cluster

	MOV	AX,SPC
	MUL	BPS			;(AX)*(BPS) -> (DX,AX) = BPC
	MOV	BPC,AX			;Save Bytes Per Cluster

;	Compute Kbytes Per Cluster (Allocation Unit) as:

;	Kbytes Per Cluster = (Bytes Per Cluster + 1023)/1024

	XOR	DX,DX
	ADD	AX,1023
	ADC	DX,0
	MOV	SI,1024
	DIV	SI			;(DX,AX)/(SI) -> AX(QUO), DX(REM)
	MOV	KPC,AX			;Save Kbytes Per Cluster

;	Compute Total Disk Bytes as:

;	Total Disk Bytes = Total Number of Allocation Units *
;	      Sectors Per Allocation Unit * Bytes Per Sector

	MOV	AX,SPC
	MUL	NCLUS			;(AX)*(NCLUS) -> (DX,AX)
	MUL	BPS			;(AX)*(BPS) -> (DX,AX) = Bytes
	MOV	TOTLLO,AX		;Save LSW of Total Space
	MOV	TOTLHI,DX		;Save MSW of Total Space

;	Compute Total Bytes Free as:

;	Total Bytes Free = Number of Free Allocation Units *
;	      Sectors Per Allocation Unit * Bytes Per Sector

	MOV	AX,SPC
	MUL	BX			;(AX)*(BX) -> (DX,AX)
	MUL	BPS			;(AX)*(BPS) -> (DX,AX) = Bytes
	MOV	FREELO,AX		;Save LSW of Free Space
	MOV	FREEHI,DX		;Save MSW of Free Space
	CALL	LOGIN			;Reset default drive
	RET				;Return to caller

;	Change to the target directory

SETDIR: CMP	BYTE PTR PSFLAG,0	;Path specified?
	JNZ	SETD05			;Jump if so

;	Set default target directory to current

	MOV	DL,BYTE PTR PATH	;Desired drive (A,B,...)
	SUB	DL,'@'                  ;Normalize to (1,2,...)
	MOV	SI,OFFSET PATH+3	;Init target dir path
	MOV	AH,GDIR 		;Get current directory
	INT	DOS
	JMP	SHORT SETD10		;No need to change

;	Change to the target directory

SETD05: MOV	DX,OFFSET PATH		;Desired directory path name
	MOV	AH,CHDIR		;Change current directory
	INT	DOS			;Does path exist?
	JNC	SETD10			;Jump if so

	MOV	DX,OFFSET PATHMSG
	MOV	AH,OUTSTR		;Give error message
	CALL	OUTLIN
	POP	AX			;Clear stack
	JMP	BYE			;Exit to DOS

SETD10: RET

;	Determine files in the directory and save info

FILES:	MOV	DX,OFFSET XFCB
	MOV	AH,SDTA 		;Set Disk Transfer Address
	INT	DOS

	MOV	DX,OFFSET XFCBS
	MOV	AH,SRCHF		;Search for First
	INT	DOS

FILE05: OR	AL,AL			;Any files found?
	JZ	FILE15			;Jump if so (AX=FF, if not)
	CMP	BYTE PTR ATTR,0 	;/s switch with operand?
	JNZ	FILE10			;Jump if so
	MOV	AL,BYTE PTR XFCBA	;Get file select attributes
	MOV	BYTE PTR ATTR,AL	;Store for later test
FILE10: RET				;Return to caller

FILE15: CMP	BYTE PTR ATTR,0 	;File subset requested?
	JZ	FILE20			;Jump if not
	MOV	AL,BYTE PTR FCBATTR	;Get file attributes
	AND	AL,ATTR 		;Do they match desired files?
	JNZ	FILE20			;Jump if so
	JMP	FILE60			;Jump if not

FILE20: CMP	BYTE PTR FCBNAME,'.'    ;Current or parent dir entry?
	JZ	FILE60			;Skip, if so
	MOV	BX,LAST 		;Point to file entry
	LEA	DI,[BX+2]
	MOV	SI,OFFSET FCBNAME
	MOV	CX,8
	CLD
	REPZ	MOVSB			;Save file name
	CMP	BYTE PTR [SI],' '       ;Null extension?
	JNZ	FILE25			;Jump if not
	MOV	BYTE PTR [DI],' '       ;Insert a space
	JMP	SHORT FILE30

FILE25: MOV	BYTE PTR [DI],'.'       ;Insert separator

FILE30: INC	DI
	MOV	CX,3
	REPZ	MOVSB			;Save file extension
	MOV	SI,OFFSET FCBATTR	;Point to file attributes

	TEST	BYTE PTR [SI],ATTRD	;Directory entry?
	JZ	FILE35			;Jump if not
	INC	WORD PTR NDIRS		;Increment directory count

FILE35: TEST	BYTE PTR [SI],ATTRA	;Archive file entry?
	JZ	FILE40			;Jump if not
	INC	WORD PTR NARCH		;Increment archive file count

FILE40: TEST	BYTE PTR [SI],ATTRR	;Read-Only file entry?
	JZ	FILE45			;Jump if not
	INC	WORD PTR NREAD		;Increment read-only file count

FILE45: TEST	BYTE PTR [SI],ATTRH	;Hidden file entry?
	JZ	FILE50			;Jump if not
	INC	WORD PTR NHID		;Increment hidden file count

FILE50: TEST	BYTE PTR [SI],ATTRS	;System file entry?
	JZ	FILE55			;Jump if not
	INC	WORD PTR NSYS		;Increment system file count

FILE55: MOVSB				;Move attribute byte

	MOV	SI,OFFSET FCBTIME	;Save file creation time & date
	MOVSW
	MOVSW

	MOV	SI,OFFSET FCBSIZE	;Get A(file size in bytes)
	PUSH	SI			;Save registers
	PUSH	DI
	MOV	DI,[SI+2]		;MSW of file size
	MOV	SI,[SI] 		;LSW of file size
	CALL	CNVT			;Round to kbytes, if necessary
	ADD	USEDLO,SI		;Update LSW of total space used
	ADC	USEDHI,DI		;Update MSW of total space used
	POP	DI			;Restore registers
	POP	SI
	MOVSW				;Save file size in bytes
	MOVSW

	ADD	BX,BUFLEN
	MOV	LAST,BX
	INC	WORD PTR NFILES 	;Increment file count

FILE60: MOV	DX,OFFSET XFCBS
	MOV	AH,SRCHN		;Search for Next
	INT	DOS
	JMP	FILE05

;	Restore the current directory

RESDIR: MOV	DX,OFFSET PATHS 	;Saved directory path name
	MOV	AH,CHDIR		;Change current directory
	INT	DOS

;	Modify the path name for output

	MOV	SI,OFFSET PATH+3

RESD05: CMP	BYTE PTR [SI],NULL
	JZ	RESD10
	INC	SI
	JMP	SHORT RESD05

RESD10: CMP	BYTE PTR [SI-1],'\'
	JNZ	RESD15
	MOV	PFFLAG,1		;Indicate full path name

RESD15: MOV	BYTE PTR [SI],EOS	;Change NULL to EOS
	RET

;	Sort file entry pointers using Exchange Sort
;	according to sort option specified

SORT:	MOV	DI,OFFSET BUFFER

SORT05: CMP	DI,LAST 		;All entries sorted?
	JB	SORT10			;Jump if not
	RET

SORT10: MOV	SI,OFFSET COL1

SORT15: MOV	BX,SI			;Sort next entry
	MOV	SI,[BX]
	OR	SI,SI			;Null entry?
	JNZ	SORT20			;Jump if not
	JMP	SORT50			;Jump if so

SORT20: CMP	BYTE PTR SFLAG,'N'      ;No sort?
	JZ	SORT15			;Jump if so
	MOV	AX,SI			;Save entry pointers
	MOV	DX,DI
	CMP	BYTE PTR SFLAG,'B'      ;Sort by file size in bytes?
	JZ	SORT35
	CMP	BYTE PTR SFLAG,'A'      ;Sort by file date/time?
	JZ	SORT30
	CMP	BYTE PTR SFLAG,'D'      ;Sort by file date/time?
	JZ	SORT30
	CMP	BYTE PTR SFLAG,'E'      ;Sort by file ext. and name?
	JZ	SORT25

;	Default sort by file name and extension

	LEA	SI,[SI+2]
	LEA	DI,[DI+2]
	MOV	CX,12
	JMP	SHORT SORT45

;	Sort by file extension and name

SORT25: LEA	SI,[SI+11]		;Address of 1st extension
	MOV	DI,OFFSET CBUFF 	;Destination address
	MOV	CX,3
	CLD
	REPZ	MOVSB			;Move 1st extension
	MOV	SI,AX
	LEA	SI,[SI+2]		;Address of 1st file name
	MOV	CX,8
	REPZ	MOVSB			;Move 1st file name
	MOV	SI,DX
	LEA	SI,[SI+11]		;Address of 2nd extension
	MOV	CX,3
	REPZ	MOVSB			;Move 2nd extension
	MOV	SI,DX
	LEA	SI,[SI+2]		;Address of 2nd file name
	MOV	CX,8
	REPZ	MOVSB			;Move 2nd file name
	MOV	SI,OFFSET CBUFF
	MOV	DI,OFFSET CBUFF+11
	MOV	CX,11
	JMP	SHORT SORT45

;	Sort by file creation date and time

SORT30: LEA	SI,[SI+17]
	LEA	DI,[DI+17]
	CMP	BYTE PTR SFLAG,'A'      ;Ascending sort?
	JZ	SORT40			;Jump if so
	MOV	CX,2			;Perform descending sort
	STD				;Compare right to left
	REPZ	CMPSW			;Compare word sort fields
	MOV	DI,DX			;Restore entry pointers
	MOV	SI,AX
	JNA	SORT50			;Jump if entries not in order
	JMP	SORT15			;Jump if entries in order

;	Sort by file size

SORT35: LEA	SI,[SI+21]		;Sort by MSW of file size
	LEA	DI,[DI+21]

;	Compare word fields

SORT40: MOV	CX,2
	STD				;Compare right to left
	REPZ	CMPSW			;Compare word sort fields
	MOV	DI,DX			;Restore entry pointers
	MOV	SI,AX
	JA	SORT50			;Jump if entries not in order
	JMP	SORT15			;Jump if entries in order

;	Compare byte fields

SORT45: CLD				;Compare left to right
	REPZ	CMPSB			;Compare byte sort fields
	MOV	DI,DX			;Restore entry pointers
	MOV	SI,AX
	JA	SORT50			;Jump if entries not in order
	JMP	SORT15			;Jump if entries in order

;	Exchange entry pointers

SORT50: MOV	[DI],SI 		;Exchange sort entry pointers
	MOV	[BX],DI
	ADD	DI,BUFLEN
	JMP	SORT05			;Resume sort from first entry

;	Split the linked list of file entries into columns

;	Determine the address of the first entry which
;	should appear at the top of each output column

SPLIT:	XOR	AH,AH
	MOV	AL,OFLAG		;Get ASCII # cols
	SUB	AL,'0'                  ;Convert to binary
	MOV	NCOLS,AX		;Save for later
	CMP	AL,1			;One output column?
	JNZ	SPLT05			;Jump if not
	JMP	SPLT75			;Exit if so

;	Process 2nd column

SPLT05: MOV	AX,NFILES		;Get number of files
	CWD				;Sign extend AX into DX
	DIV	WORD PTR NCOLS		;NFILES/NCOLS -> AX(QUO), DX(REM)
	OR	AX,AX			;NFILES/NCOLS=0?
	JNZ	SPLT10			;Jump if not
	OR	DX,DX			;MOD(NFILES,NCOLS)=0?
	JNZ	SPLT10			;Jump if not
	JMP	SHORT SPLT75		;Exit - should never happen

SPLT10: MOV	CX,AX			;CX = # of ROWS(-1)
	OR	DL,DL			;Remainder = 0?
	JZ	SPLT15			;Jump if so; CX is Ok
	INC	CX			;Adjust # ROWS

SPLT15: PUSH	CX
	MOV	BX,OFFSET COL1		;First file entry address

SPLT20: MOV	BX,[BX] 		;Loop through entry addresses
	LOOP	SPLT20			;Until CX=0

	MOV	AX,[BX] 		;Save file entry address
	MOV	COL2,AX
	MOV	[BX],CX 		;Zero entry address
	POP	CX

	CMP	BYTE PTR NCOLS,2	;Two output columns?
	JNZ	SPLT25			;Jump if not
	JMP	SHORT SPLT75		;Exit if so

;	Process 3rd and 4th columns

SPLT25: DEC	DL			;Remainder = 1?
	JNZ	SPLT30			;Jump if not; CX is Ok
	DEC	CX			;Adjust # ROWS

SPLT30: PUSH	CX
	MOV	BX,OFFSET COL2		;Next file entry address

SPLT35: MOV	BX,[BX] 		;Loop through entry addresses
	LOOP	SPLT35			;Until CX=0

	MOV	AX,[BX] 		;Save file entry address
	MOV	COL3,AX
	MOV	[BX],CX 		;Zero entry address
	POP	CX

	DEC	DL			;Remainder = 2?
	JNZ	SPLT40			;Jump if not; CX is Ok
	DEC	CX			;Adjust # ROWS

SPLT40: PUSH	CX
	MOV	BX,OFFSET COL3		;Next file entry address

SPLT45: MOV	BX,[BX] 		;Loop through entry addresses
	LOOP	SPLT45			;Until CX=0

	MOV	AX,[BX] 		;Save file entry address
	MOV	COL4,AX
	MOV	[BX],CX 		;Zero entry address
	POP	CX

	CMP	BYTE PTR NCOLS,4	;Four output columns?
	JNZ	SPLT50			;Jump if not
	JMP	SHORT SPLT75		;Exit if so

;	Process 5th and 6th columns

SPLT50: DEC	DL			;Remainder = 1?
	JNZ	SPLT55			;Jump if not; CX is Ok
	DEC	CX			;Adjust # ROWS

SPLT55: PUSH	CX
	MOV	BX,OFFSET COL4		;Next file entry address

SPLT60: MOV	BX,[BX] 		;Loop through entry addresses
	LOOP	SPLT60			;Until CX=0

	MOV	AX,[BX] 		;Save file entry address
	MOV	COL5,AX
	MOV	[BX],CX 		;Zero entry address
	POP	CX

	DEC	DL			;Remainder = 2?
	JNZ	SPLT65			;Jump if not; CX is Ok
	DEC	CX			;Adjust # ROWS

SPLT65: PUSH	CX
	MOV	BX,OFFSET COL5		;Next file entry address

SPLT70: MOV	BX,[BX] 		;Loop through entry addresses
	LOOP	SPLT70			;Until CX=0

	MOV	AX,[BX] 		;Save file entry address
	MOV	COL6,AX
	MOV	[BX],CX 		;Zero entry address
	POP	CX

SPLT75: RET

;	Clear the console screen

CLEAR:	CMP	BYTE PTR CFLAG,0	;Clear screen?
	JZ	CLR05			;Jump if not

	IF	Z100
	MOV	DX,OFFSET CLS
	MOV	AH,OUTSTR
	INT	DOS
	ENDIF

	IF	IBMPC
	MOV	AX,6*256+0		;Scroll entire screen upwards
	MOV	BH,NCOLORS		;Screen attribute
	SUB	CX,CX			;Upper Left = Row 00 Col 00
	MOV	DX,24*256+79		;Lower Right = Row 24 Col 79
	INT	VIDEO

	MOV	AH,2			;Set Cursor Position
	XOR	BH,BH			;Page Number = 0
	XOR	DX,DX			;Row 00 Col 00
	INT	VIDEO
	ENDIF

CLR05:	RET

;	Display DOS version and System RAM utilization

RAM:	CMP	BYTE PTR MFLAG,0	;Display RAM information?
	JZ	RAM05			;Jump if not

	MOV	DX,OFFSET DOSMSG	;Store DOS version string
	MOV	AH,OUTSTR		;and Bytes Used string
	CALL	OUTLIN

	MOV	AX,CS			;RAM Used = Start of CS
	CALL	OUTRAM			;Store Bytes Used

	MOV	DX,OFFSET RAMFREE
	MOV	AH,OUTSTR		;Store Bytes Free string
	CALL	OUTLIN

	MOV	SI,MEM			;Total RAM from PSP
	MOV	AX,[SI]
	MOV	BX,CS			;RAM Used from CS
	SUB	AX,BX			;RAM Free = Total - Used
	CALL	OUTRAM			;Store Bytes Free

	MOV	DX,OFFSET RAMTOTL
	MOV	AH,OUTSTR		;Store Total Bytes string
	CALL	OUTLIN

	MOV	SI,MEM			;Total RAM from PSP
	MOV	AX,[SI]
	CALL	OUTRAM			;Store Total Bytes

	MOV	DX,OFFSET CRLF2
	MOV	AH,OUTSTR		;Store CR/LF and write line
	CALL	OUTLIN

	ADD	WORD PTR NLINES,2

RAM05:	RET

;	Display disk volume information

VOLUME: CMP	BYTE PTR VFLAG,0	;Display volume information?
	JZ	VOL05			;Jump if not

	MOV	BYTE PTR XFCBA,ATTRV	;Set volume label attribute
	MOV	SI,OFFSET WILD
	MOV	DI,OFFSET FNAME
	MOV	CX,11
	CLD
	REPZ	MOVSB			;Set wildcard file name

	MOV	DX,OFFSET XFCB
	MOV	AH,SDTA 		;Set Disk Transfer Address
	INT	DOS

	MOV	DX,OFFSET XFCBS
	MOV	AH,SRCHF		;Search for Volume Label
	INT	DOS
	OR	AL,AL			;Label found?
	JNZ	VOL05			;Jump if not

	MOV	SI,OFFSET FCBNAME
	MOV	DI,OFFSET VOLLAB
	MOV	CX,11
	CLD
	REPZ	MOVSB			;Move volume label

	MOV	DX,OFFSET MSG00
	MOV	AH,OUTSTR		;Store volume label message
	CALL	OUTLIN
	MOV	AX,WORD PTR FCBDATE
	CALL	FDATE			;Store volume creation date
	MOV	DL,' '
	MOV	AH,OUTCHR		;Store a space
	CALL	OUTLIN
	MOV	AX,WORD PTR FCBTIME
	CALL	FTIME			;Store volume creation time

	CALL	DATTIM			;Store current date and time

	MOV	DX,OFFSET CRLF2
	MOV	AH,OUTSTR		;Store CR/LF and write line
	CALL	OUTLIN

	ADD	WORD PTR NLINES,2

VOL05:	RET

;	Display disk parameter values

PARMS:	CMP	BYTE PTR PFLAG,0	;Display disk parms?
	JZ	PARM05			;Jump if not

	MOV	DX,OFFSET MSG02
	MOV	AH,OUTSTR		;Store media byte message
	CALL	OUTLIN

	PUSH	DS
	MOV	DL,BYTE PTR FDRIVE	;(DL) = target drive
	MOV	AH,GFAT 		;Get FAT information
	INT	DOS
	MOV	DL,[BX] 		;(DL) = FAT media byte
	POP	DS
	CALL	HEXOUT			;Store media byte in hex

	MOV	DX,OFFSET MSG03
	MOV	AH,OUTSTR		;Store Bytes/Sector string
	CALL	OUTLIN
	MOV	SI,BPS
	XOR	DI,DI
	MOV	FILL,0			;No leading spaces
	CALL	BINASC			;Store Bytes Per Sector

	MOV	DX,OFFSET MSG04
	MOV	AH,OUTSTR		;Store Bytes/Cluster string
	CALL	OUTLIN
	MOV	SI,BPC
	XOR	DI,DI
	CALL	BINASC			;Store Bytes Per Cluster

	MOV	DX,OFFSET MSG05
	MOV	AH,OUTSTR		;Store Clusters string
	CALL	OUTLIN
	MOV	SI,NCLUS
	XOR	DI,DI
	CALL	BINASC			;Store Number of Clusters

	MOV	DX,OFFSET CRLF2
	MOV	AH,OUTSTR		;Store CR/LF and write line
	CALL	OUTLIN

	ADD	WORD PTR NLINES,2

PARM05: RET

;	Output file entries, delimiters, and CR/LF

OUTPUT: CMP	BYTE PTR TFLAG,0	;Totals only?
	JZ	OUT05			;Jump if not
	JMP	OUT35			;Jump if so

OUT05:	MOV	BX,COL1
	OR	BX,BX			;All entries processed?
	JNZ	OUT10			;Jump if not
	JMP	OUT35			;Exit if so

OUT10:	CMP	BYTE PTR RFLAG,0	;Redirected output?
	JNZ	OUT12			;Jump if so

	IF	Z100
	MOV	AX,WORD PTR FCOLORS	;Set file colors
	MOV	WORD PTR COLORS,AX
	MOV	DX,OFFSET SETCOL
	MOV	AH,OUTSTR
	CALL	OUTLIN
	ENDIF

	IF	IBMPC
	MOV	PCTEXT,0		;Reset text mode
	ENDIF

OUT12:	MOV	AX,[BX]
	MOV	COL1,AX
	CALL	FORMAT			;Format 1st entry on line

	CMP	BYTE PTR OFLAG,'1'      ;One output column?
	JNZ	OUT15			;Jump if not
	JMP	OUT25			;Jump if so

OUT15:	CMP	NFILES,1		;Last entry on 1st line?
	JNZ	OUT20			;Jump if not
	JMP	OUT25			;Jump if so

OUT20:	CALL	OUTDLM			;Store delimiter string
	MOV	BX,COL2
	OR	BX,BX			;Last entry on line?
	JZ	OUT25			;Jump if so

	MOV	AX,[BX]
	MOV	COL2,AX
	CALL	FORMAT			;Format 2nd entry on line

	CMP	BYTE PTR OFLAG,'2'      ;Two output columns?
	JZ	OUT25			;Jump if so
	CMP	NFILES,2		;Last entry on 1st line?
	JZ	OUT25			;Jump if so

	CALL	OUTDLM			;Store delimiter string
	MOV	BX,COL3
	OR	BX,BX			;Last entry on line?
	JZ	OUT25			;Jump if so

	MOV	AX,[BX]
	MOV	COL3,AX
	CALL	FORMAT			;Format 3rd entry on line

	CMP	NFILES,3		;Last entry on 1st line?
	JZ	OUT25			;Jump if so

	CALL	OUTDLM			;Store delimiter string
	MOV	BX,COL4
	OR	BX,BX			;Last entry on line?
	JZ	OUT25			;Jump if so

	MOV	AX,[BX]
	MOV	COL4,AX
	CALL	FORMAT			;Format 4th entry on line

	CMP	BYTE PTR OFLAG,'4'      ;Four output columns?
	JZ	OUT25			;Jump if so
	CMP	NFILES,4		;Last entry on 1st line?
	JZ	OUT25			;Jump if so

	CALL	OUTDLM			;Store delimiter string
	MOV	BX,COL5
	OR	BX,BX			;Last entry on line?
	JZ	OUT25			;Jump if so

	MOV	AX,[BX]
	MOV	COL5,AX
	CALL	FORMAT			;Format 5th entry on line

	CMP	NFILES,5		;Last entry on 1st line?
	JZ	OUT25			;Jump if so

	CALL	OUTDLM			;Store delimiter string
	MOV	BX,COL6
	OR	BX,BX			;Last entry on line?
	JZ	OUT25			;Jump if so

	MOV	AX,[BX]
	MOV	COL6,AX
	CALL	FORMAT			;Format 6th entry on line

OUT25:
	IF	Z100
	CMP	BYTE PTR RFLAG,0	;Redirected output?
	JNZ	OUT26			;Jump if so
	MOV	AX,WORD PTR NCOLORS	;Set normal colors
	MOV	WORD PTR COLORS,AX
	MOV	DX,OFFSET SETCOL
	MOV	AH,OUTSTR
	CALL	OUTLIN
	ENDIF

OUT26:	MOV	DX,OFFSET CRLF
	MOV	AH,OUTSTR		;Store CR/LF and write line
	CALL	OUTLIN

	INC	WORD PTR NLINES

	CMP	BYTE PTR QFLAG,0	;Quick (no pause) output?
	JNZ	OUT30			;Jump if so

	CMP	WORD PTR NLINES,NLS-1	;Bottom of screen?
	JL	OUT30			;Jump if not

	MOV	WORD PTR NLINES,0
	MOV	AH,DCIN 		;Read char without echo
	INT	DOS

	CMP	AL,CTLC 		;Control-C typed?
	JNZ	OUT30			;Jump if not
	POP	AX			;Clear stack
	JMP	BYE			;and exit

OUT30:	JMP	OUT05			;Go process next entry

OUT35:	RET				;Return to caller

;	Format file entry pointed to by BX register.

;	Internal entry format is:

;	BX+00 (02)	Address of Next Entry
;	BX+02 (12)	'Filename.Ext'
;	BX+14 (01)	File Attributes
;	BX+15 (02)	File Creation Time
;	BX+17 (02)	File Creation Date
;	BX+19 (02)	File Size in Bytes (LSW)
;	BX+21 (02)	File Size in Bytes (MSW)

;	BUFLEN = total entry length

;	Output format is:

;	Directory Path		(1 column mode)
;	Filename and Extension	(1,2,4,6 column modes)
;	File Size in Bytes	(1,2,4 column modes)
;	File Date and Time	(1,2 column modes)
;	File Attributes 	(1 column mode)

FORMAT: CMP	BYTE PTR OFLAG,'1'      ;One output column?
	JNZ	FORM05			;Jump if not

	MOV	DX,OFFSET PATH
	MOV	AH,OUTSTR		;Store Directory Path
	CALL	OUTLIN

	CMP	PFFLAG,1		;Full path name?
	JZ	FORM05			;Jump if so
	MOV	DL,'\'
	MOV	AH,OUTCHR		;Store \ after path
	CALL	OUTLIN

FORM05: CMP	BYTE PTR RFLAG,0	;Redirected output?
	JNZ	FORM07			;Jump if so

	IF	Z100
	MOV	AX,WORD PTR FCOLORS	;Set file colors
	TEST	BYTE PTR [BX+14],ATTRD	;Directory entry?
	JZ	FORM06			;Jump if not
	MOV	AX,WORD PTR DCOLORS	;Set directory colors

FORM06: MOV	WORD PTR COLORS,AX
	MOV	DX,OFFSET SETCOL
	MOV	AH,OUTSTR
	CALL	OUTLIN
	ENDIF

	IF	IBMPC
	TEST	BYTE PTR [BX+14],ATTRD	;Directory entry?
	JZ	FORM07			;Jump if not
	MOV	PCDIR,80H		;Set directory flag
	ENDIF

FORM07: MOV	CX,12
	XOR	DI,DI

FORM10: MOV	DL,[BX+DI+2]		;Store Filename.Ext
	MOV	AH,OUTCHR
	CALL	OUTLIN
	INC	DI
	LOOP	FORM10

	CMP	BYTE PTR OFLAG,'6'      ;Six output columns?
	JNZ	FORM15			;Jump if not

	CMP	BYTE PTR RFLAG,0	;Redirected output?
	JZ	FORM12			;Jump if not
	JMP	FORM50			;Exit if so

FORM12: TEST	BYTE PTR [BX+14],ATTRD	;Directory entry?
	JNZ	FORM13			;Jump if so
	JMP	FORM50			;Exit if not

FORM13:
	IF	Z100
	MOV	AX,WORD PTR FCOLORS	;Reset file colors
	MOV	WORD PTR COLORS,AX
	MOV	DX,OFFSET SETCOL
	MOV	AH,OUTSTR
	CALL	OUTLIN
	ENDIF

	IF	IBMPC
	MOV	PCDIR,0 		;Reset directory flag
	ENDIF

	JMP	FORM50			;Exit

FORM15: TEST	BYTE PTR [BX+14],ATTRD	;Directory entry?
	JZ	FORM20			;Jump if not

	MOV	DX,OFFSET DIRMSG
	MOV	AH,OUTSTR		;Store directory message
	CALL	OUTLIN

	CMP	BYTE PTR RFLAG,0	;Redirected output?
	JNZ	FORM25			;Jump if so

	IF	Z100
	MOV	AX,WORD PTR FCOLORS	;Reset file colors
	MOV	WORD PTR COLORS,AX
	MOV	DX,OFFSET SETCOL
	MOV	AH,OUTSTR
	CALL	OUTLIN
	ENDIF

	IF	IBMPC
	MOV	PCDIR,0 		;Reset directory flag
	ENDIF

	JMP	SHORT FORM25

FORM20: PUSH	BX
	MOV	SI,[BX+19]
	MOV	DI,[BX+21]
	MOV	FILL,1			;Leading spaces
	CALL	OUTDSK			;Store File Size
	POP	BX

FORM25: CMP	BYTE PTR OFLAG,'4'      ;Four output columns?
	JZ	FORM50			;Jump if so

	MOV	DL,' '
	MOV	AH,OUTCHR		;Store a space
	CALL	OUTLIN

	MOV	AX,[BX+17]		;Store Creation Date
	CALL	FDATE

	MOV	DL,' '
	MOV	AH,OUTCHR		;Store a space
	CALL	OUTLIN

	MOV	AX,[BX+15]		;Store Creation Time
	CALL	FTIME

	CMP	BYTE PTR OFLAG,'1'      ;One output column?
	JNZ	FORM50			;Jump if not

	MOV	DL,' '
	MOV	AH,OUTCHR		;Store a space
	CALL	OUTLIN

	MOV	DL,' '
	TEST	BYTE PTR [BX+14],ATTRA	;Archive?
	JZ	FORM30			;Jump if not
	MOV	DL,'A'
FORM30: MOV	AH,OUTCHR
	CALL	OUTLIN

	MOV	DL,' '
	TEST	BYTE PTR [BX+14],ATTRR	;Read Only?
	JZ	FORM35			;Jump if not
	MOV	DL,'R'
FORM35: MOV	AH,OUTCHR
	CALL	OUTLIN

	MOV	DL,' '
	TEST	BYTE PTR [BX+14],ATTRH	;Hidden?
	JZ	FORM40			;Jump if not
	MOV	DL,'H'
FORM40: MOV	AH,OUTCHR
	CALL	OUTLIN

	MOV	DL,' '
	TEST	BYTE PTR [BX+14],ATTRS	;System?
	JZ	FORM45			;Jump if not
	MOV	DL,'S'
FORM45: MOV	AH,OUTCHR
	CALL	OUTLIN

FORM50: RET

;	Convert a 16 bit RAM space value in paragraphs in
;	(AX) to kbytes, if necessary, and then to ASCII,
;	and store the resulting string in the buffer

OUTRAM: MOV	BX,16			;Bytes = 16 * paragraphs
	MUL	BX			;(AX)*(BX) -> (DX,AX)

	CMP	BYTE PTR KFLAG,0	;Space in bytes?
	JZ	OUTR05			;Jump if so
	ADD	AX,512
	ADC	DX,0			;(DX,AX) = Bytes+512
	MOV	BX,1024
	DIV	BX			;(DX,AX)/(BPC) -> AX(QUO), DX(REM)
	XOR	DX,DX			;(DX,AX) = (Bytes+512)/1024

OUTR05: MOV	DI,DX
	MOV	SI,AX
	CALL	BINASC			;Convert to ASCII

	CMP	BYTE PTR KFLAG,0	;Space in bytes?
	JZ	OUTR10			;Jump if so
	MOV	DL,'k'
	MOV	AH,OUTCHR
	CALL	OUTLIN			;Store the 'k'

OUTR10: RET

;	Convert a 32 bit disk space value in bytes in
;	(DI,SI) to kbytes, if necessary, and then to ASCII,
;	and store the resulting string in the buffer

OUTDSK: CALL	CNVT			;Convert to kbytes
	CALL	BINASC			;Convert to ASCII
	CALL	KBYTES			;Store the 'k'
	RET

;	Convert disk space values from bytes to kbytes,
;	rounded up to the disk cluster (allocation unit) size

;	Enter with bytes in (DI,SI), exit with kbytes

;	Compute Kbytes = Kbytes Per Cluster *
;		(Bytes + Bytes Per Cluster - 1) / Bytes Per Cluster

;	If BPC < 1024 then compute Rounded Bytes = Kbytes * BPC

CNVT:	CMP	BYTE PTR KFLAG,0	;Space in bytes?
	JZ	CNVT10			;Jump if so

	MOV	DX,DI
	MOV	AX,SI			;(DX,AX) = Bytes
	MOV	SI,BPC
	DEC	SI
	ADD	AX,SI
	ADC	DX,0			;(DX,AX) = Bytes + BPC - 1
	DIV	WORD PTR BPC		;(DX,AX)/(BPC) -> AX(QUO), DX(REM)
	MUL	WORD PTR KPC		;(AX)*(KPC) -> (DX,AX) = Kbytes
	CMP	WORD PTR BPC,1024	;Bytes/Cluster GE 1024?
	JNL	CNVT05			;Jump if so
	MUL	WORD PTR BPC		;(AX)*(BPC) -> (DX,AX) = Rounded Bytes
	MOV	BYTE PTR KFLAG,2	;Indicate processing rounded bytes

CNVT05: MOV	DI,DX
	MOV	SI,AX

CNVT10: RET

;	Convert 32 bit binary integer to ASCII and store in console
;	output buffer in either right-justified 8 char blank-filled
;	field, or with no leading spaces (var. length 1-8 chars).

;	Location FILL=0/1 specifies nofill/fill of output field.

;	(DI,SI) = Most/Least significant words of the binary value.

BINASC: MOV	NDIGS,0
	XOR	AX,AX
	MOV	BX,AX
	MOV	BP,AX
	MOV	CX,32

BIN05:	SHL	SI,1
	RCL	DI,1
	XCHG	BP,AX
	CALL	M2BCD
	XCHG	BP,AX
	XCHG	BX,AX
	CALL	M2BCD
	XCHG	BX,AX
	ADC	AL,0
	LOOP	BIN05

	MOV	CX,1710H
	MOV	AX,BX
	CALL	BIN10
	MOV	AX,BP

BIN10:	PUSH	AX
	MOV	DL,AH
	CALL	BIN15
	POP	DX

BIN15:	MOV	DH,DL
	SHR	DL,1
	SHR	DL,1
	SHR	DL,1
	SHR	DL,1
	CALL	BIN20
	MOV	DL,DH

BIN20:	AND	DL,0FH
	JZ	BIN25
	XOR	CL,CL

BIN25:	DEC	CH
	AND	CL,CH
	OR	DL,'0'
	SUB	DL,CL

	TEST	BYTE PTR FILL,1 	;Leading spaces needed?
	JZ	BIN35			;Jump if not
	INC	NDIGS
	CMP	BYTE PTR KFLAG,1	;Kbytes requested?
	JNZ	BIN30			;Jump if not
	CMP	NDIGS,2 		;Don't print first 2 digits
	JLE	BIN45			;for file entries in kbytes
BIN30:	CMP	NDIGS,1 		;Don't print first digit
	JLE	BIN45			;for file entries in bytes

BIN35:	CMP	DL,' '
	JNZ	BIN40
	TEST	BYTE PTR FILL,1
	JZ	BIN45

BIN40:	MOV	AH,OUTCHR		;Store character
	CALL	OUTLIN

BIN45:	RET

;	Multiply the AX register by 2 in BCD format

M2BCD:	ADC	AL,AL			;AL=2*AL
	DAA				;AL -> BCD
	XCHG	AL,AH
	ADC	AL,AL			;AL=2*AL
	DAA				;AL -> BCD
	XCHG	AL,AH
	RET

;	Store 'k' character after kbytes value

KBYTES: CMP	BYTE PTR KFLAG,1	;Kbytes requested?
	JNZ	KBYT05			;Jump if not
	MOV	DL,'k'
	MOV	AH,OUTCHR
	CALL	OUTLIN
KBYT05: RET

;	Format file creation date as DD-MMM-YY

;	Binary date format:
;	7 bits: 15...09 = year-1980 (0 to 127)
;	4 bits: 08...05 = month     (1 to 12)
;	5 bits: 04...00 = day	    (1 to 31)

FDATE:	OR	AX,AX			;Non-zero date?
	JNZ	FDAT05			;Jump if so
	MOV	DX,OFFSET NODATE
	MOV	AH,OUTSTR		;Store dots for no date
	CALL	OUTLIN
	RET

FDAT05: PUSH	AX			;Save date
	AND	AX,1FH			;Mask day bits
	CALL	OUTAX			;Store them
	MOV	DL,'-'
	MOV	AH,OUTCHR		;Store day/month separator
	CALL	OUTLIN
	POP	AX			;Restore date
	PUSH	AX			;Save date

	AND	AX,01E0H		;Mask month bits
	MOV	CL,5			;Number of bits to shift
	SHR	AX,CL			;Right justify in AX
	DEC	AL			;month-1
	MOV	AH,AL
	ADD	AL,AH
	ADD	AL,AH			;3*(month-1)
	MOV	SI,OFFSET MONTHS
	XOR	AH,AH
	ADD	SI,AX			;A(ASCII month in table)

	MOV	DL,[SI] 		;Store month
	MOV	AH,OUTCHR
	CALL	OUTLIN
	MOV	DL,[SI+1]
	MOV	AH,OUTCHR
	CALL	OUTLIN
	MOV	DL,[SI+2]
	MOV	AH,OUTCHR
	CALL	OUTLIN

	MOV	DL,'-'
	MOV	AH,OUTCHR		;Store month/year separator
	CALL	OUTLIN

	POP	AX			;Restore date
	AND	AX,0FE00H		;Mask year bits
	MOV	CL,9			;Number of bits to shift
	SHR	AX,CL			;Right justify in AX
	ADD	AX,80			;Account for year-1980 bias
	CMP	AX,100			;Year GE 2000?
	JL	FDAT10			;Jump if not
	SUB	AX,100			;Normalize to 0
FDAT10: CALL	OUTAX			;Send to console
	RET

;	Format file creation time as HH:MM:SS

;	Binary time format:
;	5 bits: 15...11 = hours     (0 to 23)
;	6 bits: 10...05 = minutes   (0 to 59)
;	5 bits: 04...00 = seconds/2 (0 to 29)

FTIME:	OR	AX,AX			;Non-zero time?
	JNZ	FTIM05			;Jump if so
	MOV	DX,OFFSET NOTIME
	MOV	AH,OUTSTR		;Store dots for no time
	CALL	OUTLIN
	RET

FTIM05: PUSH	AX			;Save time
	AND	AX,0F800H		;Mask hour bits
	MOV	CL,11			;Number of bits to shift
	SHR	AX,CL			;Right justify in AX
	CALL	OUTAX			;Store them
	MOV	DL,':'
	MOV	AH,OUTCHR		;Store hour/minute separator
	CALL	OUTLIN

	POP	AX			;Restore time
	PUSH	AX			;Save again
	AND	AX,07E0H		;Mask minute bits
	MOV	CL,5			;Number of bits to shift
	SHR	AX,CL			;Right justify in AX
	CALL	OUTAX			;Store them

	MOV	DL,':'
	MOV	AH,OUTCHR		;Store minute/second separator
	CALL	OUTLIN

	POP	AX			;Restore time
	AND	AX,001FH		;Mask second bits
	SHL	AX,1			;Multiply by 2
	CALL	OUTAX			;Store them
	RET

;	Convert two digit (00-99) binary number in
;	AX to ASCII and store in console output buffer

OUTAX:	AAM				;(AL/10) -> AH, MOD(AL,10) -> AL
	OR	AX,03030H		;Convert from binary to ASCII
	PUSH	AX
	MOV	DL,AH
	MOV	AH,OUTCHR		;Store Most Significant Digit
	CALL	OUTLIN
	POP	AX
	MOV	DL,AL
	MOV	AH,OUTCHR		;Store Least Significant Digit
	CALL	OUTLIN
	RET

;	Convert binary number in DL to ASCII hexadecimal
;	and store in console output buffer.  Uses AX, CX.

HEXOUT: MOV	CX,2

HEX05:	PUSH	CX
	MOV	CL,4
	ROL	DL,CL
	MOV	AL,DL
	AND	AL,00FH
	DAA
	ADD	AL,0F0H
	ADC	AL,040H
	PUSH	DX
	MOV	DL,AL
	MOV	AH,OUTCHR
	CALL	OUTLIN
	POP	DX
	POP	CX
	LOOP	HEX05

	RET

;	Format delimiter string between file entries

OUTDLM: CMP	BYTE PTR OFLAG,'4'      ;Four or six output columns?
	JNL	OUTD05			;Jump if so
	MOV	DL,' '
	MOV	AH,OUTCHR		;Store a space
	CALL	OUTLIN

OUTD05: CMP	BYTE PTR RFLAG,0	;Redirected output?
	JZ	OUTD10			;Jump if not

	MOV	DL,BAR
	MOV	AH,OUTCHR		;Store default delimiter
	CALL	OUTLIN
	JMP	SHORT OUTD15

OUTD10:
	IF	Z100
	MOV	AX,WORD PTR SCOLORS	;Set separator colors
	MOV	WORD PTR COLORS,AX
	MOV	DX,OFFSET SETCOL
	MOV	AH,OUTSTR
	CALL	OUTLIN

	MOV	DX,OFFSET ZBAR		;Store Z-100 graphics delimiter
	MOV	AH,OUTSTR
	CALL	OUTLIN
	ENDIF

	IF	IBMPC
	MOV	DL,0FFH 		;Set special flag for PCBAR
	MOV	AH,OUTCHR		;Store IBM-PC graphics delimiter
	CALL	OUTLIN
	ENDIF

OUTD15: CMP	BYTE PTR OFLAG,'4'      ;Four or six output columns?
	JNL	OUTD20			;Jump if so

	IF	Z100
	CMP	BYTE PTR RFLAG,0	;Redirected output?
	JNZ	OUTD16			;Jump if so
	MOV	AX,WORD PTR FCOLORS	;Reset file colors
	MOV	WORD PTR COLORS,AX
	MOV	DX,OFFSET SETCOL
	MOV	AH,OUTSTR
	CALL	OUTLIN
	ENDIF

OUTD16: MOV	DL,' '
	MOV	AH,OUTCHR		;Store a space
	CALL	OUTLIN

OUTD20: RET

;	Format Totals Trailer Lines

TOTALS: CMP	BYTE PTR RFLAG,0	;Redirected output?
	JNZ	TOTL02			;Jump if so

	IF	Z100
	MOV	AX,WORD PTR TCOLORS	;Set text colors
	MOV	WORD PTR COLORS,AX
	MOV	DX,OFFSET SETCOL
	MOV	AH,OUTSTR
	CALL	OUTLIN
	ENDIF

	IF	IBMPC
	MOV	PCTEXT,1		;Set text mode
	ENDIF

TOTL02: CMP	WORD PTR NFILES,0	;Any files found?
	JNZ	TOTL04			;Jump if so
	CMP	BYTE PTR TFLAG,0	;Totals only?
	JNZ	TOTL04			;Jump if so

	MOV	DX,OFFSET NOFILES
	MOV	AH,OUTSTR		;Inform user of no files
	CALL	OUTLIN
	JMP	TOTL16			;and exit

TOTL04: MOV	DX,OFFSET MSG06
	MOV	AH,OUTSTR		;Store Path string
	CALL	OUTLIN

	MOV	DX,OFFSET MSG07
	MOV	AH,OUTSTR		;Store Dirs string
	CALL	OUTLIN

	MOV	SI,NDIRS
	XOR	DI,DI
	MOV	FILL,0			;No leading spaces
	CALL	BINASC			;Store Number of Dirs

	MOV	DX,OFFSET MSG08
	MOV	AH,OUTSTR		;Store Files string
	CALL	OUTLIN

	MOV	SI,NFILES
	SUB	SI,NDIRS
	XOR	DI,DI
	CALL	BINASC			;Store Number of Files

	MOV	DX,OFFSET MSG09
	MOV	AH,OUTSTR		;Store Archive string
	CALL	OUTLIN

	MOV	SI,NARCH
	XOR	DI,DI
	CALL	BINASC			;Store Number of Archive Files

	MOV	DX,OFFSET MSG10
	MOV	AH,OUTSTR		;Store Read-Only string
	CALL	OUTLIN

	MOV	SI,NREAD
	XOR	DI,DI
	CALL	BINASC			;Store Number of Read-Only Files

	TEST	BYTE PTR ATTR,ATTRH	;Hidden files selected?
	JZ	TOTL05			;Jump if not

	MOV	DX,OFFSET MSG11
	MOV	AH,OUTSTR		;Store Hidden string
	CALL	OUTLIN

	MOV	SI,NHID
	XOR	DI,DI
	CALL	BINASC			;Store Number of Hidden Files

TOTL05: TEST	BYTE PTR ATTR,ATTRS	;System files selected?
	JZ	TOTL10			;Jump if not

	MOV	DX,OFFSET MSG12
	MOV	AH,OUTSTR		;Store System string
	CALL	OUTLIN

	MOV	SI,NSYS
	XOR	DI,DI
	CALL	BINASC			;Store Number of System Files

TOTL10: MOV	DX,OFFSET CRLF
	MOV	AH,OUTSTR		;Store CR/LF and write line
	CALL	OUTLIN

	INC	WORD PTR NLINES

	CMP	BYTE PTR QFLAG,0	;Quick output?
	JNZ	TOTL12			;Jump if so

	CMP	WORD PTR NLINES,NLS-1	;Bottom of screen?
	JL	TOTL12			;Jump if not

	MOV	WORD PTR NLINES,0
	MOV	AH,DCIN 		;Read char without echo
	INT	DOS

TOTL12: CMP	BYTE PTR TFLAG,0	;Totals only?
	JZ	TOTL14			;Jump if not

	MOV	DX,OFFSET CRLF
	MOV	AH,OUTSTR		;Store CR/LF and write line
	CALL	OUTLIN

	INC	WORD PTR NLINES

	CMP	BYTE PTR QFLAG,0	;Quick output?
	JNZ	TOTL14			;Jump if so

	CMP	WORD PTR NLINES,NLS-1	;Bottom of screen?
	JL	TOTL14			;Jump if not

	MOV	WORD PTR NLINES,0
	MOV	AH,DCIN 		;Read char without echo
	INT	DOS

;	Format Second Trailer Line

TOTL14: MOV	DX,OFFSET MSG13
	MOV	AH,OUTSTR		;Store Bytes Used string
	CALL	OUTLIN

	MOV	SI,USEDLO		;Already in kbytes, if necessary
	MOV	DI,USEDHI
	CALL	BINASC			;Store Bytes Used
	CALL	KBYTES

	MOV	DX,OFFSET MSG14
	MOV	AH,OUTSTR		;Store Total Bytes Used string
	CALL	OUTLIN

	MOV	DI,TOTLHI
	SUB	DI,FREEHI		;Compute MSW Total Bytes Used
	MOV	SI,TOTLLO
	SUB	SI,FREELO		;Compute LSW Total Bytes Used
	JNC	TOTL15
	DEC	DI
TOTL15: CALL	OUTDSK			;Store Total Bytes Used

	MOV	DX,OFFSET MSG15
	MOV	AH,OUTSTR		;Store Percent Used string
	CALL	OUTLIN

	MOV	SI,PCT
	XOR	DI,DI
	CALL	BINASC			;Store Percent Used

	MOV	DX,OFFSET MSG16
	MOV	AH,OUTSTR		;Store Total Bytes Free string
	CALL	OUTLIN

	MOV	SI,FREELO
	MOV	DI,FREEHI
	CALL	OUTDSK			;Store Total Bytes Free

	MOV	DX,OFFSET MSG17
	MOV	AH,OUTSTR		;Store Total Bytes string
	CALL	OUTLIN

	MOV	SI,TOTLLO
	MOV	DI,TOTLHI
	CALL	OUTDSK			;Store Total Bytes

TOTL16: CMP	BYTE PTR RFLAG,0	;Redirecting output?
	JNZ	TOTL17			;Jump if so

	IF	Z100
	MOV	AX,WORD PTR NCOLORS	;Set normal colors
	MOV	WORD PTR COLORS,AX
	MOV	DX,OFFSET SETCOL
	MOV	AH,OUTSTR
	CALL	OUTLIN
	ENDIF

	CMP	BYTE PTR TFLAG,0	;Totals only?
	JNZ	TOTL17			;Jump if so

	IF	IBMPC
	CMP	BYTE PTR PCVMODE,7	;Monochrome monitor?
	JNZ	TOTL17			;Jump if not
	ENDIF

	MOV	DL,NULL
	MOV	AH,OUTCHR		;Force line to be written
	CALL	OUTLIN
	JMP	SHORT TOTL20

TOTL17: MOV	DX,OFFSET CRLF
	MOV	AH,OUTSTR		;Store CR/LF and write line
	CALL	OUTLIN

	INC	WORD PTR NLINES

	CMP	BYTE PTR QFLAG,0	;Quick output?
	JNZ	TOTL20			;Jump if so

	CMP	WORD PTR NLINES,NLS-1	;Bottom of screen?
	JL	TOTL20			;Jump if not

	MOV	WORD PTR NLINES,0
	MOV	AH,DCIN 		;Read char without echo
	INT	DOS

TOTL20: RET

;	Get current system date and time, convert
;	to ASCII, and store in the output buffer.

;	Get current system date and convert
;	from binary to ASCII format (DD-MMM-YY)

DATTIM: MOV	AH,GDATE		;Get Current Date
	INT	DOS

;	(AL) = Weekday (0=Sun, ... ,6=Sat)

	MOV	BL,AL
	ADD	AL,AL
	ADD	AL,BL			;(AL) = 3*(AL)
	MOV	SI,OFFSET DAYS
	XOR	AH,AH
	ADD	SI,AX			;(SI) = A(Text of Weekday)
	MOV	DI,OFFSET WDAY		;(DI) = A(Destination)
	PUSH	CX
	MOV	CX,3
	CLD
	REPZ	MOVSB			;Move text of weekday
	POP	CX

;	(CX) = Year (1980-2099), (DH) = Month (1-12), (DL) = Day (1-31)

	MOV	AL,DH			;(AL) = binary month
	DEC	AL			;month-1
	MOV	AH,AL
	ADD	AL,AH
	ADD	AL,AH			;3*(month-1)
	MOV	SI,OFFSET MONTHS
	XOR	AH,AH
	ADD	SI,AX			;A(ASCII month in table)
	MOV	DI,OFFSET MONTH 	;A(ASCII month field)
	PUSH	CX
	MOV	CX,3
	CLD
	REPZ	MOVSB			;move ASCII month
	POP	CX

	MOV	AL,DL			;(AL) = binary day
	AAM
	XCHG	AL,AH
	OR	WORD PTR MDAY,AX

	MOV	AX,CX			;(AL) = binary year
	SUB	AX,1900 		;Adjust to 2 digits
	CMP	AX,100			;Year GE 2000?
	JL	DAT05			;Jump if not
	SUB	AX,100			;Normalize to 0
DAT05:	AAM
	XCHG	AL,AH
	OR	WORD PTR YEAR,AX

;	Get current system time and convert
;	from binary to ASCII format (HH:MM:SS)

	MOV	AH,GTIME		;Get Current Time
	INT	DOS

;	(CH) = hours	   (0-23)
;	(CL) = minutes	   (0-59)
;	(DH) = seconds	   (0-59)
;	(DL) = seconds/100 (0-99)

	MOV	AL,CH			;(AL) = binary hours
	AAM
	XCHG	AL,AH
	OR	WORD PTR HOUR,AX

	MOV	AL,CL			;(AL) = binary minutes
	AAM
	XCHG	AL,AH
	OR	WORD PTR MINUTE,AX

	MOV	AL,DH			;(AL) = binary seconds
	AAM
	XCHG	AL,AH
	OR	WORD PTR SECOND,AX

;	Store date and time in output buffer

	MOV	DX,OFFSET MSG01
	MOV	AH,OUTSTR		;Store Date and Time
	CALL	OUTLIN
	RET

;	Put characters and strings into the output line buffer
;	and write to the screen or the standard output device.

;	BIOS calls are used for high-speed console output.

;	Output is buffered ahead a full line so that only complete
;	lines are displayed, even if a Control-C/Break occurs.

;	Enter with (AH)=OUTCHR/OUTSTR, (DL)=CHAR/(DX)=OFFSET STRING EOS.
;	Characters are stored in the buffer and written if a NULL is seen.

OUTLIN: PUSH	BX			;Save registers
	PUSH	SI
	CMP	AH,OUTSTR		;Process string?
	JZ	OUTL05			;Jump if so
	CMP	DL,NULL 		;Null character?
	JZ	OUTL15			;Jump if so
	MOV	BX,LPTR
	ADD	BX,OFFSET LBUFF

	IF	IBMPC
	OR	DL,PCDIR		;Set directory flag bit
	ENDIF

	MOV	[BX],DL 		;Store character
	INC	WORD PTR LPTR		;Increment pointer
	JMP	OUTL50

OUTL05: MOV	SI,DX			;Pointer to string

OUTL10: MOV	AH,[SI] 		;Get next character
	CMP	AH,EOS			;End of string?
	JNZ	OUTL12			;Jump if not
	JMP	OUTL50			;Jump if so

OUTL12: CMP	AH,NULL 		;Null character?
	JZ	OUTL15			;Jump if so
	MOV	BX,LPTR
	ADD	BX,OFFSET LBUFF

	IF	IBMPC
	OR	AH,PCDIR		;Set directory flag bit
	ENDIF

	MOV	[BX],AH 		;Store character
	INC	SI			;Point to next char
	INC	WORD PTR LPTR		;Increment pointer
	JMP	SHORT OUTL10		;Continue looping

OUTL15: MOV	BX,LPTR
	ADD	BX,OFFSET LBUFF
	MOV	BYTE PTR [BX],NULL	;Mark end of string
	MOV	SI,OFFSET LBUFF 	;Send line to console

;	Send an output line to the console

OUTL20: MOV	DL,[SI] 		;Get next character
	CMP	DL,NULL 		;End of string?
	JZ	OUTL35			;Jump if so

;	Send a character to the console

	IF	Z100
	CMP	BYTE PTR RFLAG,0	;Redirected output?
	JNZ	OUTL25			;Jump if so
	MOV	AL,DL			;Character to write
	PUSH	CX
	PUSH	SI
	PUSH	DI
	CLD
	CALL	BIOSCO			;Write char via BIOS
	POP	DI
	POP	SI
	POP	CX
	JMP	SHORT OUTL30

OUTL25: MOV	AH,OUTCHR		;Write char via DOS
	INT	DOS
	ENDIF

	IF	IBMPC
	CMP	BYTE PTR RFLAG,0	;Redirected output?
	JNZ	OUTL25			;Jump if so

;	Since the extended ASCII code for PCBAR (B3H) is greater
;	than 80H, we must use another code (FFH) to represent
;	it and then convert it back prior to output, in order
;	to avoid misinterpreting it as a reverse video 33H.

	CMP	DL,0FFH 		;PCBAR flag?
	JNZ	OUTL21			;Jump if not
	MOV	DL,PCBAR		;Get real character
	MOV	AH,SCOLORS		;Separator attribute
	JMP	SHORT OUTL24

OUTL21: CMP	BYTE PTR PCTEXT,0	;Text mode?
	JZ	OUTL22			;Jump if not
	MOV	AH,TCOLORS		;Text attribute
	JMP	SHORT OUTL24

OUTL22: TEST	DL,80H			;Directory flag set?
	JNZ	OUTL23			;Jump if so
	MOV	AH,FCOLORS		;File attribute
	JMP	SHORT OUTL24

OUTL23: AND	DL,7FH			;Mask off directory flag bit
	MOV	AH,DCOLORS		;Directory attribute

OUTL24: MOV	AL,DL			;Character to write
	CALL	OUTROM			;Write the char & attribute
	JMP	SHORT OUTL30

OUTL25: MOV	AH,OUTCHR		;Write char via DOS
	INT	DOS
	ENDIF

OUTL30: INC	SI			;Increment pointer
	JMP	SHORT OUTL20

OUTL35: MOV	WORD PTR LPTR,0 	;Zero pointer

;	Pause output if user types a character.
;	Resume output when another character is typed.
;	Exit if Control-C is typed by user.

	IF	Z100
	CALL	BIOSCS			;Character ready?
	JZ	OUTL50			;Jump if not
	CALL	BIOSCI			;Read character
	CMP	AL,CTLC 		;Control-C?
	JNZ	OUTL45			;Jump if not

OUTL40: POP	SI			;Restore registers
	POP	BX
	JMP	BYE			;Exit to DOS

OUTL45: CALL	BIOSCI			;Read character
	CMP	AL,CTLC 		;Control-C?
	JZ	OUTL40			;Jump if so
	ENDIF

	IF	IBMPC
	MOV	AH,1			;Character ready?
	INT	KEYBD			;ROM BIOS Keyboard I/O
	JZ	OUTL50			;Jump if not
	XOR	AH,AH			;Read character
	INT	KEYBD			;ROM BIOS Keyboard I/O
	CMP	AL,CTLC 		;Control-C?
	JNZ	OUTL45			;Jump if not

OUTL40: POP	SI			;Restore registers
	POP	BX
	JMP	BYE			;Exit to DOS

OUTL45: XOR	AH,AH			;Read character
	INT	KEYBD			;ROM BIOS Keyboard I/O
	CMP	AL,CTLC 		;Control-C?
	JZ	OUTL40			;Jump if so
	ENDIF

OUTL50: POP	SI			;Restore registers
	POP	BX
	RET

	IF	IBMPC
;	Substitute for PC ROM BIOS INT 10H Video I/O
;	Write TTY Routine to support video attributes
;	(AL) = character to write, (AH) = attribute
;	Uses registers AX, BX, CX, DX

OUTROM: CLD
	PUSH	DS			;Save registers
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI

	PUSH	AX
	MOV	AX,ROM_DATA		;Set ROM BIOS data segment
	MOV	DS,AX
	ASSUME	DS:ROM_DATA

;	Read cursor position

	MOV	AH,3			;Read the current cursor position
	MOV	BH,ACTIVE_PAGE		;Active page number
	INT	VIDEO			;DH, DL = cursor row, column

	POP	AX			;Restore register, AL=char
	CMP	AL,CR			;Is it a carriage return?
	JE	OUTR5			;Jump if so
	CMP	AL,LF			;Is it a line feed?
	JE	OUTR6			;Jump if so

;	Write the character to the screen

	MOV	BH,0			;Page 0
	MOV	BL,AH			;Screen attribute
	MOV	CX,1			;Number of characters
	MOV	AH,9			;Write character and attribute
	INT	VIDEO

;	Position the cursor for the next character

	INC	DL			;Increment cursor column
	CMP	DL,BYTE PTR CRT_COLS	;Has column overflowed?
	JNZ	OUTR4			;Jump if not
	MOV	DL,0			;New cursor column
	CMP	DH,24			;Has row overflowed?
	JNZ	OUTR3			;Jump if not

;	Set new cursor position

OUTR1:	MOV	AH,2
	INT	VIDEO

;	Scroll screen up one line

	MOV	AX,0601H		;Scroll screen up one line
	SUB	CX,CX			;Upper left corner = 0,0
	MOV	DH,24			;Lower right row = 24
	MOV	DL,BYTE PTR CRT_COLS	;Lower right column
	DEC	DL			;Less one
	MOV	BH,CS:NCOLORS		;Screen attribute

OUTR2:	INT	VIDEO
	JMP	OUTR7			;Return to caller

OUTR3:	INC	DH			;Increment cursor row

OUTR4:	MOV	AH,2			;Set cursor position
	JMP	OUTR2

;	Handle carriage return

OUTR5:	MOV	DL,0			;Set new column value
	JMP	OUTR4

;	Handle line feed

OUTR6:	CMP	DH,24			;Bottom of screen?
	JNE	OUTR3			;Jump if not
	JMP	OUTR1			;Jump if so - scroll

;	Restore registers and return

OUTR7:	POP	DI			;Restore registers
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	DS
	ASSUME	DS:CODE
	RET
	ENDIF

;	Re-select the default drive

LOGIN:	MOV	DL,LDRIVE		;Logged-in Drive
	MOV	AH,SDISK		;Select Disk as Default
	INT	DOS
	RET

;	Convert lower case letter to upper case

UPPER:	CMP	AL,'a'
	JL	UP05
	CMP	AL,'z'
	JG	UP05
	SUB	AL,32
UP05:	RET

;	Data Areas

;	Messages

HLPMSG	DB	8 DUP (' ')
	IF	Z100
	DB	'Z-100'
	ENDIF
	IF	IBMPC
	DB	'IBM-PC'
	ENDIF
	DB	' Sorted Directory Utility V5.3 (C) 1986 by John Stetson'
	DB	CR,LF,CR,LF,8 DUP (' ')
	DB	'Usage: sd [drive:][path][filespec] [/switches] [>device/file]'
	DB	CR,LF,CR,LF,21 DUP (' ')
	DB	'File Selection (only specified files)',CR,LF
	DB	CR,LF,8 DUP (' ')
	DB	'/s - All /sd - Dir /sa - Arch /sr - Read /sh - Hid /ss - Sys'
	DB	CR,LF,CR,LF,23 DUP (' ')
	DB	'Sort Fields (mutually exclusive)',CR,LF
	DB	CR,LF,8 DUP (' ')
	DB	'/a - Ascending by date & time    /e - File extension and name'
	DB	CR,LF,8 DUP (' ')
	DB	'/b - File sizes in bytes         /f - File name and extension'
	DB	CR,LF,8 DUP (' ')
	DB	'/d - Descending by date & time   /n - Normal order (no sort)'
	DB	CR,LF,CR,LF,20 DUP (' ')
	DB	'Output Control (digits specify columns)',CR,LF
	DB	CR,LF,8 DUP (' ')
	DB	'/1 - All file information        /m - Display system RAM usage'
	DB	CR,LF,8 DUP (' ')
	DB	'/2 - Name, size, date and time   /p - Display disk parameters'
	DB	CR,LF,8 DUP (' ')
	DB	'/4 - File name and size only     /q - Quick output (no pauses)'
	DB	CR,LF,8 DUP (' ')
	DB	'/6 - File names only             /r - Allow output redirection'
	DB	CR,LF,8 DUP (' ')
	DB	'/c - Clear console screen        /t - Totals output lines only'
	DB	CR,LF,8 DUP (' ')
	DB	'/k - Display space in kbytes     /v - Volume label information'
	DB	CR,LF,EOS

VERMSG	DB	'Bad DOS version',EOS
DRVMSG	DB	'Bad drive',EOS
PATHMSG DB	'Bad path',EOS
FILEMSG DB	'Bad filespec',EOS
NOFILES DB	'No files found',EOS

	IF	Z100
CLS	DB	ESC,'E',EOS             ;Clear screen & home cursor
ZBAR	DB	ESC,'F','`',ESC,'G',EOS ;Graphics delimiter
SETCOL	DB	ESC,'m'                 ;Set foreground and
COLORS	DB	'7','0',EOS             ;background colors
	ENDIF

	IF	IBMPC
PCTEXT	DB	0			;Text Mode Flag
PCDIR	DB	0			;Directory/File Flag
PCVMODE DB	0			;Saved video mode
PCCURS	DW	0			;Saved cursor position
	ENDIF

DIRMSG	DB	'  <Dir>',EOS
WILD	DB	11 DUP ('?')
NODATE	DB	'.'
NOTIME	DB	'........',EOS

MONTHS	DB	'JanFebMarAprMayJunJulAugSepOctNovDec'
DAYS	DB	'SunMonTueWedThuFriSat'

CRLF2	DB	CR,LF			;Write 2 CR/LF's
CRLF	DB	CR,LF,NULL		;NULL indicates write out buffer

DOSMSG	DB	'DOS Version: '
DOSMAJ	DB	'0.'
DOSMIN	DB	'00'
	DB	'  System RAM Used: ',EOS
RAMFREE DB	'  Free: ',EOS
RAMTOTL DB	'  Total: ',EOS

MSG00	DB	'Volume: '
VOLLAB	DB	11 DUP (' ')            ;Volume label
	DB	'  Created: ',EOS

MSG01	DB	'  Date: '
WDAY	DB	'Sun '                  ;Week Day
MDAY	DB	'00-'                   ;Month Day
MONTH	DB	'Mon-'                  ;Month
YEAR	DB	'00'                    ;Year
	DB	' '
HOUR	DB	'00:'                   ;Hour
MINUTE	DB	'00:'                   ;Minute
SECOND	DB	'00',EOS                ;Second

MSG02	DB	'Media Byte: ',EOS
MSG03	DB	'  Bytes/Sector: ',EOS
MSG04	DB	'  Bytes/Cluster: ',EOS
MSG05	DB	'  Clusters: ',EOS

MSG07	DB	'  Dirs: ',EOS
MSG08	DB	'  Files: ',EOS
MSG09	DB	'  Arch: ',EOS
MSG10	DB	'  Read: ',EOS
MSG11	DB	'  Hid: ',EOS
MSG12	DB	'  Sys: ',EOS

MSG13	DB	'Bytes: ',EOS
MSG14	DB	'  Space Used: ',EOS
MSG15	DB	' (',EOS
MSG16	DB	'%)  Free: ',EOS
MSG17	DB	'  Total: ',EOS

;	Misc. Data Areas

COL1	DW	0			;A(1st output column file entry)
COL2	DW	0			;A(2nd output column file entry)
COL3	DW	0			;A(3rd output column file entry)
COL4	DW	0			;A(4th output column file entry)
COL5	DW	0			;A(5th output column file entry)
COL6	DW	0			;A(6th output column file entry)

NCLUS	DW	0			;Number of clusters
NDIRS	DW	0			;Number of directories
NFILES	DW	0			;Number of files
NARCH	DW	0			;Number of archive files
NREAD	DW	0			;Number of read-only files
NHID	DW	0			;Number of hidden files
NSYS	DW	0			;Number of system files
NCOLS	DW	0			;Number of columns
NLINES	DW	0			;Number of lines MOD NLS
NDIGS	DB	0			;Number of digits printed

LDRIVE	DB	0			;Logged-in drive (0,1,2,...)
PSFLAG	DB	0			;Path specified flag
PFFLAG	DB	0			;Full path name flag

BPS	DW	0			;Bytes Per Sector
BPC	DW	0			;Bytes Per Cluster
SPC	DW	0			;Sectors Per Cluster
KPC	DW	0			;Kbytes Per Cluster
PCT	DW	0			;Percent Disk Space Used
USEDLO	DW	0			;LSW Space Used on Disk
USEDHI	DW	0			;MSW Space Used on Disk
FREELO	DW	0			;LSW Free Space on Disk
FREEHI	DW	0			;MSW Free Space on Disk
TOTLLO	DW	0			;LSW Total Space on Disk
TOTLHI	DW	0			;MSW Total Space on Disk

ATTR	DB	0			;Attributes to select files
FILL	DB	0			;Blank fill flag for BINASC
ERROR	DB	0			;Syntax error flag

LPTR	DW	0			;Output line buffer pointer
LAST	DW	OFFSET BUFFER		;A(Last file entry in buffer)

;	Path Name ASCIIZ Strings

MSG06	DB	'Path: '
PATH	EQU	$			;Target path name
PATHS	EQU	PATH+67 		;Saved path name

;	Input File Control Block for Directory Search

XFCBS	EQU	PATHS+67		;Extended FCB for dir. search
XFCBA	EQU	XFCBS+6 		;Attribute byte for dir. search
FCBS	EQU	XFCBA+1 		;Normal FCB for dir. search
FDRIVE	EQU	FCBS			;Selected drive (1,2,3,...)
FNAME	EQU	FDRIVE+1		;File name
FEXT	EQU	FNAME+8 		;File extension
FRES	EQU	FEXT+3			;Reserved

;	Output File Control Block for Directory Entry

XFCB	EQU	FRES+21 		;Extended FCB for dir. entry
FCB	EQU	XFCB+7			;Normal FCB for dir. entry
FCBNAME EQU	FCB+1			;File name and extension
FCBATTR EQU	FCBNAME+11		;File attributes
FCBRES	EQU	FCBATTR+1		;Reserved
FCBTIME EQU	FCBRES+10		;File creation time
FCBDATE EQU	FCBTIME+2		;File creation date
FCBALOC EQU	FCBDATE+2		;File first allocation unit
FCBSIZE EQU	FCBALOC+2		;File size in bytes (LSW, MSW)

;	Buffers

;	Max line buffer size required is for Z-100 /6 switch:
;	6*(2*color ESC seq length + file name length) +
;	5*(color ESC seq length + separator ESC seq length) +
;	(color ESC seq length) = 6*(2*4+12) + 5*(4+5) + 4 = 169

LBUFF	EQU	FCBSIZE+4		;Output line buffer
CBUFF	EQU	LBUFF+169		;Compare buffer for /e
BUFFER	EQU	CBUFF+22		;Buffer for directory entries

CODE	ENDS

	END	SD
 