	PAGE	60,132

	TITLE	SHELL.COM - MS-DOS Command Shell Program

	comment $

	Version 2.3 (C) 06-Jul-86 by John Stetson

	This is an experimental program which acts as an MS-DOS
	"SHELL" - it runs COMMAND.COM as a child process in such
	a way that the user can temporarily escape from almost
	any program to COMMAND.COM, and subsequently return.
	Conditional assembly equates tailor the program for
	either the Z-100 or IBM-PC compatible computers.

	The program allows the user to first execute a program
	(such as a text editor or modem communications program)
	and to subsequently suspend execution of this program
	and be placed inside a child COMMAND.COM process.  This
	allows the user to perform a number of functions (within
	reason) and to subsequently return to the initial program.

	The following diagram illustrates the environment:


		    COMMAND.COM
			|
			V
		    SHELL.COM ---hot key--> COMMAND.COM
			|			|
			V			V
		    COMMAND.COM 	    program-2
			|
			V
		    program-1


	The SHELL program installs a resident Interrupt Service
	Routine (ISR) which services the Keyboard Interrupt
	(50H for Z-100, and 09H for IBM-PC ROM BIOS).  After
	installation, pressing the hot key will cause the
	keyboard ISR to receive control and set a flag value
	indicating that command shell processing is in effect.
	The Z-100 hot key is BREAK, for the IBM-PC the hot key
	is CTRL-RETURN (to avoid conflicts with other programs).

	The SHELL program also installs front and back ends for
	Interrupt 21H.	If the proper conditions are satisfied
	each time INT 21H terminates, the resident code will
	attempt to execute COMMAND.COM as a child process.

	The user may then execute whatever commands are desired.
	When the resident 'EXIT' command is given, control will
	return to the ISR and in turn to whatever program the
	user was originally running.  It takes about 4k bytes of
	available memory to execute COMMAND.COM under MS-DOS 2.X.
	The program attempts to allocate 128k of memory for use
	by the COMMAND.COM child process.

	Limitations:

	As previously mentioned, this is an experimental program;
	it is intended to be used as a test-bed for experimenting
	with the "advanced" features in MS-DOS - dynamic memory
	management and child process creation.	It is provided as
	an example of how to use these features and to encourage
	the advanced user to try additional or different ideas.
	It is not all unusual to run into either a system hang,
	or memory allocation problems, depending on the function
	begin performed; running .COM programs usually works fine.
	Running large .EXE programs, or terminate-and-stay-resident
	type programs which "steal" or "hook" the interrupts used
	by this program may lead to unpredictable results.

	Pressing the SHELL activation key while running a program
	which steals the keyboard interrupt under SHELL may either
	cause the processing of the activation key to be deferred
	until after the program has terminated, or a system crash.
	To detect and prevent this situation, we might use the main
	MS-DOS keyboard interrupt function, rather than the user
	keyboard interrupt function.  In the keyboard ISR, we would
	then check the keyboard ISR vector and take no action if it
	doesn't point to the SHELL keyboard ISR.

	Enhancements:

	We should use the PROMPT string from the parent's environment.

	We should save the state of the keyboard (expanded/shifted)
	before executing the child process and restore it when done.

	We should save the cursor state and location and turn it
	on at entry, and restore the cursor state & location at exit.

	We should save the screen at entry & restore it at exit.

	We should support the following command line options:

	KEY=NN	    - specifies the scan code for the special key
	PATH=<PATH> - specifies the search path for COMMAND.COM
	SAVE=M|C    - specifies save Monochrome or Color VRAM
	SIZE=NNNK   - specifies the desired child memory size

	MASM, LINK, and EXE2BIN to make SHELL.COM

	end comment $.

;	System Equates

FALSE	EQU	0		;Logical FALSE for conditional ASM
TRUE	EQU	NOT FALSE	;Logical TRUE  for conditional ASM

Z100	EQU	TRUE		;Set to TRUE for Z-100 or
IBMPC	EQU	NOT Z100	;FALSE for IBM-PC compatibles

;	MS-DOS Interrupt Equates

EXIT	EQU	20H		;Program Termination
MSDOS	EQU	21H		;System Functions
CTLC	EQU	23H		;Control-C Handler

;	MS-DOS System Function Equates

OUTSTR	EQU	09H		;Output string to console
INBUFF	EQU	0AH		;Buffered keyboard input
GETDSK	EQU	19H		;Get current disk
SETINT	EQU	25H		;Set interrupt address
GETCRT	EQU	34H		;Get MS-DOS critical flag address
GETINT	EQU	35H		;Get interrupt address
MEMALL	EQU	48H		;Allocate memory
MEMFRE	EQU	49H		;Release memory
MEMMOD	EQU	4AH		;Modify allocated memory blocks
EXECP	EQU	4BH		;Load and execute a program
EXITP   EQU     4CH             ;Terminate process

;	MS-DOS Interrupt Segment Equates

INTDOS	EQU	21H		;System functions interrupt number
INTCTC	EQU	23H		;CTRL-C/BREAK interrupt number

	IF	Z100
INTUKB	EQU	50H		;Z-100 User keyboard interrupt number
	ELSE
INTUKB	EQU	09H		;IBM-PC keyboard interrupt number
	ENDIF

INTSEG	SEGMENT AT 00H		;MS-DOS interrupt segment
	ORG	4*INTDOS
DOSINT	LABEL	FAR		;Pointer to MS-DOS INT 21H ISR
DOSLAB	LABEL	FAR		;Dummy label for DOSJMP
	ORG	4*INTCTC
CTCINT	LABEL	FAR		;Pointer to MS-DOS INT 23H ISR
CTCLAB	LABEL	FAR		;Dummy label for CTCJMP
	ORG	4*INTUKB
UKBINT	LABEL	FAR		;Pointer to User Keyboard ISR
UKBLAB	LABEL	FAR		;Dummy label for UKBJMP
INTSEG	ENDS

;	MS-DOS Program Segment Prefix Equates

PSPENV	EQU	02CH		;Offset of environment segment
PSPEND	EQU	100H		;Offset of program entry point

	IF	IBMPC
;	IBM-PC ROM BIOS Equates

VIDEO	EQU	10H		;Video I/O interrupt number
KEYBD	EQU	16H		;User keyboard interrupt number
	ENDIF

;	ASCII Character Equates

BELL	EQU	07H		;Bell
LF	EQU	0AH		;Line feed
CR	EQU	0DH		;Carriage return
ESC	EQU	1BH		;Escape
EOS	EQU	'$'		;End of string symbol

;	Program Equates

JMPFAR	EQU	0EAH		;Opcode for FAR JMP instruction
MSIZE	EQU	2000H		;Paragraphs for child process (128k)

	IF	Z100
SPECKEY EQU	0AAH		;Z-100 keyboard code for BREAK
	ELSE
SPECKEY EQU	1C0AH		;IBM-PC key codes for CTRL-RETURN
	ENDIF

;	Program Initialization

CODE	SEGMENT BYTE PUBLIC 'CODE'

	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	PSPEND		;Origin after PSP

;	Start of program

SHELL:	CALL	CLS		;Clear the screen

;	Verify that the SHELL K.B. ISR is not already installed

	MOV	AX,SEG INTSEG	;Interrupt segment address
	MOV	ES,AX		;ES = MS-DOS ISR segment
	MOV	BX,OFFSET UKBINT ;Offset of User K.B. ISR address

	MOV	DI,ES:[BX]	;DI = offset of User K.B. ISR
	ADD	DI,3		;DI = offset of possible literal
	MOV	ES,ES:[BX+2]	;ES = segment of User K.B. ISR
	MOV	SI,OFFSET UKBLIT ;SI = address of literal 'SHELL'

	CLD			;Clear direction flag
	MOV	CX,5		;Compare 5 bytes
	REPZ	CMPSB		;Compare DS:[SI] and ES:[DI]
	JNZ	INITOK		;Jump if no match

;	SHELL K.B. ISR already installed - display error message

	MOV	AH,OUTSTR
	MOV	DX,OFFSET ERRMSG
	INT	MSDOS		;Display message

	INT	EXIT		;Exit to ourselves!

;	Release all allocated memory

INITOK: MOV	AX,CS
	MOV	ES,AX		;ES = segment
	MOV	BX,OFFSET ENDSH ;BX = offset
	MOV	CL,4		;paragraphs = bytes / 16
	SHR	BX,CL		;BX = size of SHELL in paragraphs
	MOV	AH,MEMMOD	;Modify allocated memory block
	INT	MSDOS
	JNC	FREEOK		;Jump if release ok

	ADD	AL,'0'
	MOV	MEMERR1,AL
	MOV	DX,OFFSET MEMMSG1
	MOV	AH,OUTSTR
	INT	MSDOS		;Display message

	INT	EXIT		;Exit to COMMAND.COM

;	Save the BIOS User K.B. ISR address
;	so that the SHELL ISR can front-end it

FREEOK: MOV	AH,GETINT
	MOV	AL,INTUKB
	INT	MSDOS		;Get User K.B. ISR address in ES:BX

	MOV	WORD PTR UKBJMP+1,BX ;Store address in instruction
	MOV	WORD PTR UKBJMP+3,ES

;	Install the address of the SHELL User K.B. ISR
;	in the MS-DOS Interrupt Page Vector Table

	MOV	AX,CS
	MOV	DS,AX		;DS:DX = SHELL ISR address
	MOV	DX,OFFSET UKBISR

	MOV	AH,SETINT
	MOV	AL,INTUKB
	INT	MSDOS		;Set new User K.B. ISR address

;	Save the MS-DOS Critical Flag address

	MOV	AH,GETCRT
	INT	MSDOS
	MOV	CRTFLG,BX
	MOV	CRTFLG+2,ES

;	Save the MS-DOS INT 23H CTRL-C ISR address
;	so that the SHELL ISR can replace it

	MOV	AH,GETINT
	MOV	AL,INTCTC
	INT	MSDOS		;Get MS-DOS INT 23H ISR address in ES:BX

	MOV	WORD PTR CTCJMP+1,BX ;Store address in JMP instruction
	MOV	WORD PTR CTCJMP+3,ES

;	Install the address of the SHELL INT 23H ISR
;	in the MS-DOS Interrupt Page Vector Table

	MOV	AX,CS
	MOV	DS,AX		;DS:DX = SHELL ISR address
	MOV	DX,OFFSET CTCISR

	MOV	AH,SETINT
	MOV	AL,INTCTC
	INT	MSDOS		;Set new MS-DOS INT 23H ISR address

;	Save the MS-DOS INT 21H ISR address
;	so that the SHELL ISR can front-end it

	MOV	AH,GETINT
	MOV	AL,INTDOS
	INT	MSDOS		;Get MS-DOS INT 21H ISR address in ES:BX

	MOV	WORD PTR DOSJMP+1,BX ;Store address in JMP instruction
	MOV	WORD PTR DOSJMP+3,ES

;	Install the address of the SHELL INT 21H ISR
;	in the MS-DOS Interrupt Page Vector Table

	MOV	AX,CS
	MOV	DS,AX		;DS:DX = SHELL ISR address
	MOV	DX,OFFSET DOSISR

	MOV	AH,SETINT
	MOV	AL,INTDOS
	INT	MSDOS		;Set new MS-DOS INT 21H ISR address

;	Print installed message on console

	MOV	AH,OUTSTR
	MOV	DX,OFFSET INSTMSG
	INT	MSDOS		;Display message

;	Get the current disk

LOOP:	MOV	AH,GETDSK
	INT	MSDOS		;Get binary disk number
	ADD	AL,'A'		;Make printable
	MOV	DRIVE,AL	;Store in prompt string

;	Prompt the user for a command

	MOV	AH,OUTSTR
	MOV	DX,OFFSET PROMPT
	INT	MSDOS		;Display prompt

;	Read the user's response

	MOV	AH,INBUFF
	MOV	DX,OFFSET BUFFMAX
	INT	MSDOS		;Read reply

;	Check length of command line text

	MOV	CL,BUFFLEN	;CL=length of command line
	CMP	CL,1		;Null line entered?
	JL	LOOP		;Jump if so

;	Check for EXIT commands

	CMP	CL,4
	JNZ	NOEXIT

	MOV	AX,CS
	MOV	ES,AX
	MOV	SI,OFFSET BUFFER
	MOV	DI,OFFSET EXITL ;Try for lower case
	CLD			;Clear direction flag
	MOV	CX,4		;Length to compare
	REPZ	CMPSB		;Compare DS:[SI] and ES:[DI]
	JNZ	CHKUP		;Jump if no match
	JMP	BYE		;Jump if EXIT

CHKUP:	MOV	SI,OFFSET BUFFER
	MOV	DI,OFFSET EXITU ;Try for upper case
	CLD			;Clear direction flag
	MOV	CX,4		;Length to compare
	REPZ	CMPSB		;Compare DS:[SI] and ES:[DI]
	JNZ	REST		;Jump if no match
	JMP	BYE		;Jump if EXIT

REST:	MOV	CX,4		;Restore command length

;	Move command line text to command buffer

NOEXIT: MOV	AL,CL		;Command text length
	ADD	AL,2		;Account for /C
	MOV	CMDLEN,AL	;Set command text length

	MOV	SI,OFFSET BUFFER  ;A(command line text)
	MOV	DI,OFFSET CMDBUFF ;Destination for move
	XOR	CH,CH		;CX = command length

CLOOP:	MOV	AL,[SI] 	;Move command text
	MOV	[DI],AL
	INC	SI
	INC	DI
	LOOP	CLOOP

	MOV	[DI],BYTE PTR CR ;Mark end of command line

;	Print CR/LF

	MOV	AH,OUTSTR
	MOV	DX,OFFSET CRLF
	INT	MSDOS

;	Allocate memory for later use

	CMP	MEMFLG,BYTE PTR 0 ;Allocate memory?
	JZ	MEMOK		  ;Jump if not
	MOV	MEMFLG,BYTE PTR 0 ;Indicate allocated

	MOV	BX,MSIZE	;Memory size in paragraphs
	MOV	AH,MEMALL
	INT	MSDOS		;AX:0000 -> allocated memory
	MOV	MEMADR,AX	;Save memory segment
	JNC	MEMOK		;Jump if allocate ok

	ADD	AL,'0'
	MOV	MEMERR2,AL
	MOV	DX,OFFSET MEMMSG2
	MOV	AH,OUTSTR
	INT	MSDOS		;Display message
	JMP	BYE		;And exit

;	Initialize EXEC parameter block

MEMOK:	MOV	P1_DTA+2,CS
	MOV	P1_FCB1+2,CS
	MOV	P1_FCB2+2,CS
 
;	Save stack registers

	MOV	SAVESS1,SS
	MOV	SAVESP1,SP

;	Set up local stack (for .EXE files)

	CLI			;Interrupts off
	MOV	AX,CS
	MOV	SS,AX
	MOV	SP,OFFSET STACK1
	STI			;Interrupts on

;	Execute COMMAND.COM as a child process

	MOV	DS,AX		;Set segment registers
	MOV	ES,AX
	MOV	DX,OFFSET CMDPATH ;DS:DX -> path name
	MOV	BX,OFFSET P1_BLK  ;ES:BX -> parm block
	MOV	AH,EXECP	;Exec function call
	XOR	AL,AL		;Load and execute program
	MOV	CS:CMDFLG,1	;Allow special key
	INT	MSDOS		;Error code returned in AX
	MOV	CS:CMDFLG,0	;Disallow special key

;	Restore original stack

	CLI			;Interrupts off
	MOV	SS,CS:SAVESS1
	MOV	SP,CS:SAVESP1
	STI			;Interrupts on

;	Restore data segment register

	MOV	BX,CS
	MOV	DS,BX

;	Check for error

	JNC	CMDOK		;Jump if no error

;	Print error message

	PUSH	AX		;Save error code
	MOV	DX,OFFSET ERRMSGC
	MOV	AH,OUTSTR
	INT	MSDOS
	POP	AX		;Restore error code

	CMP	AL,1
	JNZ	CHK2
	MOV	DX,OFFSET ERROR1
	JMP	SHORT ERRPRT

CHK2:	CMP	AL,2
	JNZ	CHK8
	MOV	DX,OFFSET ERROR2
	JMP	SHORT ERRPRT

CHK8:	CMP	AL,8
	JNZ	CHK10
	MOV	DX,OFFSET ERROR8
	JMP	SHORT ERRPRT

CHK10:	CMP	AL,10
	JNZ	CHK11
	MOV	DX,OFFSET ERROR10
	JMP	SHORT ERRPRT

CHK11:	CMP	AL,11
	JNZ	ERRUNK
	MOV	DX,OFFSET ERROR11
	JMP	SHORT ERRPRT

ERRUNK: MOV	DX,OFFSET ERRORUN

ERRPRT: MOV	AH,OUTSTR	;Print reason for error
	INT	MSDOS

CMDOK:	JMP	LOOP		;Loop for next command

;	Restore the User K.B. ISR address

BYE:	MOV	DS,WORD PTR CS:UKBJMP+3  ;DS:DX = User K.B. ISR address
	MOV	DX,WORD PTR CS:UKBJMP+1

	MOV	AH,SETINT
	MOV	AL,INTUKB
	INT	MSDOS		;Set new User K.B. ISR address

;	Restore the MS-DOS INT 23H ISR address

	MOV	DS,WORD PTR CS:CTCJMP+3  ;DS:DX = MS-DOS INT 23H ISR address
	MOV	DX,WORD PTR CS:CTCJMP+1

	MOV	AH,SETINT
	MOV	AL,INTCTC
	INT	MSDOS		;Set new MS-DOS INT 23H ISR address

;	Restore the MS-DOS INT 21H ISR address

	MOV	DS,WORD PTR CS:DOSJMP+3  ;DS:DX = MS-DOS INT 21H ISR address
	MOV	DX,WORD PTR CS:DOSJMP+1

	MOV	AH,SETINT
	MOV	AL,INTDOS
	INT	MSDOS		;Set new MS-DOS INT 21H ISR address

;	Print exiting message on console

	MOV	AX,CS
	MOV	DS,AX		;Restore DS register
	MOV	AH,OUTSTR
	MOV	DX,OFFSET EXITMSG
	INT	MSDOS		;Display message

;	Exit to MS-DOS

	XOR	AL,AL		;Exit code = 0
	MOV	AH,EXITP
	INT	MSDOS		;Terminate process

	IF	Z100
;	User Keyboard Interrupt Service Routine
;	called by the BIOS when a key is pressed

UKBISR: JMP	UKBCHK		;Jump past data

;	The following literal value is used to detect
;	whether or not the Command Shell ISR has been
;	installed, or not.  It is addressed by using
;	the pointer to the User Keyboard Interrupt
;	Service Routine located at 0000:0140H.

UKBLIT	DB	'SHELL' 	;Signature at UKBISR+3
KEYFLG	DB	0		;Special key flag
CMDFLG	DB	0		;Process key flag

;	Check for Special Key

UKBCHK: PUSHF			;Save flags
	CLI			;Interrupts off
	CMP	AH,0		;Key already processed?
	JNZ	UKBRET		;Exit, if so

	CMP	AL,SPECKEY	;Special key pressed?
	JNZ	UKBRET		;Jump if not

	CMP	CS:CMDFLG,1	;Process special key?
	JNZ	UKBRET		;Jump if not

	MOV	CS:KEYFLG,1	;Indicate special key seen
	MOV	AH,0FFH 	;Don't place in input queue

UKBRET: POPF			;Restore flags

;	Jump to the BIOS User K.B. ISR

UKBJMP: JMP	UKBLAB		;Modified at init time

	ELSE
;	Keyboard Interrupt Service Routine
;	called by the BIOS when a key is pressed

UKBISR: JMP	UKBCHK		;Jump past data

;	The following literal value is used to detect
;	whether or not the Command Shell ISR has been
;	installed, or not.  It is addressed by using
;	the pointer to the BIOS Keyboard Interrupt
;	Service Routine located at 0000:0024H.

UKBLIT	DB	'SHELL' 	;Signature at UKBISR+3
KEYFLG	DB	0		;Special key flag
CMDFLG	DB	0		;Process key flag

;	Check for Special Key

UKBCHK: PUSH	AX		;Save registers
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES

	PUSHF			;Push flags for K.B. ISR IRET

UKBJMP: CALL	UKBLAB		;Call the original keyboard ISR

	STI			;Interrupts on
	MOV	AH,1		;Character in buffer?
	INT	KEYBD		;Keyboard I/O interrupt
	JZ	UKBRET		;Jump if no char ready

	CMP	AX,SPECKEY	;Special key pressed?
	JNZ	UKBRET		;Jump if not

	CMP	CS:CMDFLG,1	;Process special key?
	JNZ	UKBRET		;Jump if not

	MOV	AH,0		;Get the character
	INT	KEYBD		;Keyboard I/O interrupt

	MOV	CS:KEYFLG,1	;Indicate special key seen

UKBRET: POP	ES		;Restore registers
	POP	DS
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	IRET			;Return to interrupted process
	ENDIF

;	MS-DOS Control-C/BREAK Interrupt Service Routine
;	called by MS-DOS when CTRL-C/BREAK is pressed

CTCISR: CLC			;Indicate continue execution
	IRET			;Just return to program

;	Save area for MS-DOS INT 23H ISR address

CTCJMP: JMP	CTCLAB		;Modified at init time

;	MS-DOS Interrupt 21H Interrupt Service Routine
;	Front and back-ends the MS-DOS INT 21H handler

DOSISR: CMP	CS:ACTFLG,1	;SHELL already active?
	JZ	DOSJMP		;Exit, if so
	CMP	CS:KEYFLG,1	;Special key pressed?
	JNZ	DOSJMP		;Jump if not

;	On entry to an interrupt service routine,
;	the top stack contents are as follows:
;	Instruction Pointer, Code Segment and Flags

	POP	CS:USERIP	;Store user's IP in JMP
	POP	CS:USERCS	;Store user's CS in JMP
	PUSH	CS		;Replace with Back-end address
	PUSH	CS:BACK

;	Jump to the MS-DOS INT 21H ISR

DOSJMP: JMP	DOSLAB		;Modified at init time

;	Back-end to INT 21H - the MS-DOS critical flag
;	isn't usually set, so we can issue interrupts

;	Note that the MS-DOS INT 21H ISR has already
;	performed an IRET instruction so we can exit
;	back to the interrupted program via a JMP

BACK	DW	OFFSET BAKEND
SAVEES	DW	?
SAVEBX	DW	?

BAKEND: PUSHF			;Save flags

;	Check if the MS-DOS Critical Flag is set

	CLI			;Interrupts off
	MOV	CS:SAVEES,ES	;Save registers
	MOV	CS:SAVEBX,BX
	LES	BX,CS:DWORD PTR CRTFLG ;Get address of flag
	CMP	ES:[BX],BYTE PTR 0     ;Check if it's set
	MOV	BX,CS:SAVEBX	;Restore registers
	MOV	ES,CS:SAVEES
	JNZ	RETURN		;Exit if it's set

;	Execute COMMAND.COM as a child process

	CALL	EXEC		;Go execute child process
	MOV	CS:KEYFLG,0	;Indicate special key processed
	MOV	CS:MEMFLG,1	;Indicate need to reallocate memory
				;when SHELL regains control

;	Return to the interrupted program

RETURN: POPF			;Restore flags
;	STI			;Interrupts on

	DB	JMPFAR		;Modified at execution time
USERIP	DW	?		;User's instruction pointer
USERCS	DW	?		;User's code segment

ACTFLG	DB	0		;SHELL activity flag
MEMFLG	DB	1		;Memory allocation flag
CRTFLG	DW	?		;DOS critical flag offset
	DW	?		;DOS critical flag segment

;	Execute COMMAND.COM as a child process
;	Enter and exit with interrupts disabled

EXEC	PROC	NEAR

	MOV	CS:ACTFLG,1	;Indicate we're active

;	Save caller's registers

	MOV	CS:SAVEAX,AX	;Save caller's AX reg
	MOV	CS:SAVESS2,SS	;Save caller's SS reg
	MOV	CS:SAVESP2,SP	;Save caller's SP reg

;	Create local stack

	MOV	AX,CS
	MOV	SS,AX
	MOV	SP,OFFSET CS:STACK2

;	Save the remaining registers

	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	DS
	PUSH	ES

;	Set up local segment registers

	MOV	DS,AX
	MOV	ES,AX
	STI			;Interrupts on

;	Clear the screen

	CALL	CLS

;	Release the allocated memory block

	PUSH	ES
	MOV	ES,CS:MEMADR	;ES = Segment to free
	MOV	AH,MEMFRE	;Free allocated memory block
	INT	MSDOS
	POP	ES
	JNC	RELOK		;Jump if release ok

	ADD	AL,'0'
	MOV	MEMERR1,AL
	MOV	DX,OFFSET MEMMSG1
	MOV	AH,OUTSTR
	INT	MSDOS		;Display message

;	Initialize EXEC parameter block

RELOK:	MOV	SI,PSPENV	;Parent process's
	MOV	AX,[SI] 	;environment segment
	MOV	P2_ENV,AX
	MOV	P2_DTA+2,CS
	MOV	P2_FCB1+2,CS
	MOV	P2_FCB2+2,CS
 
;	Save local SP register

	MOV	CS:SPSAVE,SP

;	Execute COMMAND.COM as a child process

	MOV	DX,OFFSET CMDPATH ;DS:DX -> path name
	MOV	BX,OFFSET P2_BLK  ;ES:BX -> parm block
	MOV	AH,EXECP	;Exec function call
	XOR	AL,AL		;Load and execute program
	INT	MSDOS		;Error code returned in AX

;	Restore local segment & stack registers

	CLI			;Interrupts off
	MOV	BX,AX		;Save return code
	MOV	AX,CS
	MOV	DS,AX
	MOV	ES,AX
	MOV	SS,AX
	MOV	SP,CS:SPSAVE
	STI			;Interrupts on

;	Check for error

	MOV	AX,BX		;Restore return code
	JNC	CLEAR		;Jump if no error

;	Print error message

	PUSH	AX		;Save error code
	MOV	DX,OFFSET ERRMSGC
	MOV	AH,OUTSTR
	INT	MSDOS
	POP	AX		;Restore error code

	CMP	AL,1
	JNZ	ERR2
	MOV	DX,OFFSET ERROR1
	JMP	SHORT ERRPR

ERR2:	CMP	AL,2
	JNZ	ERR8
	MOV	DX,OFFSET ERROR2
	JMP	SHORT ERRPR

ERR8:	CMP	AL,8
	JNZ	ERR10
	MOV	DX,OFFSET ERROR8
	JMP	SHORT ERRPR

ERR10:	CMP	AL,10
	JNZ	ERR11
	MOV	DX,OFFSET ERROR10
	JMP	SHORT ERRPR

ERR11:	CMP	AL,11
	JNZ	ERRUN
	MOV	DX,OFFSET ERROR11
	JMP	SHORT ERRPR

ERRUN:	MOV	DX,OFFSET ERRORUN

ERRPR:	MOV	AH,OUTSTR	;Print reason for error
	INT	MSDOS
	JMP	SKIP

;	Clear the screen

CLEAR:	CALL	CLS

;	Reallocate memory for later use

SKIP:	MOV	BX,MSIZE	;memory size in paragraphs
	MOV	AH,MEMALL
	INT	MSDOS		;AX:0000 -> allocated memory
	MOV	CS:MEMADR,AX	;Save memory segment
	JNC	ALLOK		;Jump if allocate ok

	ADD	AL,'0'
	MOV	MEMERR2,AL
	MOV	DX,OFFSET MEMMSG2
	MOV	AH,OUTSTR
	INT	MSDOS		;Display message

;	Restore caller's registers

ALLOK:	CLI			;Interrupts off
	POP	ES
	POP	DS
	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX

	MOV	SS,CS:SAVESS2	;Restore caller's SS reg
	MOV	SP,CS:SAVESP2	;Restore caller's SP reg
	MOV	AX,CS:SAVEAX	;Restore caller's AX reg
	MOV	CS:ACTFLG,0	;Indicate we're inactive
	RET			;Return to caller

EXEC	ENDP

;	Clear the screen & home the cursor

CLS	PROC	NEAR

	IF	Z100
	MOV	AH,OUTSTR
	MOV	DX,OFFSET CLSMSG
	INT	MSDOS

	ELSE
	MOV	AX,6*256+0		;Scroll entire screen upwards
	MOV	BH,07H			;Screen Attribute
	SUB	CX,CX			;Upper Left = Row 00 Col 00
	MOV	DX,24*256+79		;Lower Right = Row 24 Col 79
	INT	VIDEO			;ROM BIOS Video I/O

	MOV	AH,2			;Set Cursor Position
	XOR	BH,BH			;Page Number = 0
	XOR	DX,DX			;Row 00 Col 00
	INT	VIDEO			;ROM BIOS Video I/O
	ENDIF

	RET
CLS	ENDP

;	Data Areas
 
INSTMSG DB	'Command Shell Successfully Installed',CR,LF
	IF	Z100
	DB	'Press BREAK to Escape or EXIT to End'
	ELSE
	DB	'Press CTRL-RETURN to Escape or EXIT to End'
	ENDIF
CRLF	DB	CR,LF,EOS

ERRMSG	DB	'Error - Command Shell is already installed!'
	DB	BELL,CR,LF,EOS

EXITMSG DB	CR,LF
	DB	'Exiting from Command Shell'
	DB	CR,LF,EOS

PROMPT	DB	CR,LF
DRIVE	DB	'A'		;Current drive letter
	DB	'>',EOS

BUFFMAX DB	128		;Total buffer length
BUFFLEN DB	0		;Number of characters typed
BUFFER	DB	128 DUP (' ')	;Text of buffer

EXITU	DB	'EXIT'		;EXIT commands
EXITL	DB	'exit'

SAVESS1 DW	?		;Save area for SS register
SAVESP1 DW	?		;Save area for SP register

P1_BLK	EQU	$		;Parameter block for EXEC call
P1_ENV	DW	0		;WORD segment address of environment
				;zero passes parent's environment
P1_DTA	DW	OFFSET DTA1	;DWORD pointer to cmd line at DTA
	DW	?
P1_FCB1 DW	OFFSET FCB1	;DWORD pointer to 1st default FCB
	DW	?
P1_FCB2 DW	OFFSET FCB2	;DWORD pointer to 2nd default FCB
	DW	?

DTA1	EQU	$		;Default Disk Transfer Address
CMDLEN	DB	CMDBUFE-CMDBUFS ;Command line length
CMDBUFS DB	'/C'		;COMMAND.COM switch
CMDBUFF DB	128 DUP (' ')	;Text of command line
	DB	CR		;Command line delimiter
CMDBUFE EQU	$		;End of command line

	DW	256 DUP (?)	;Local stack
STACK1	EQU	$

MEMADR	DW	?		;Segment of allocated memory

	IF	Z100
CLSMSG	DB	ESC,'q' 	;Exit reverse video
	DB	ESC,'E' 	;Clear lines 1-24
	DB	ESC,'j' 	;Save cursor location
	DB	ESC,'x1'	;Enable line 25
	DB	ESC,'Y8 '	;Cursor to row 25 col 1
	DB	ESC,'K' 	;Erase to end of line
	DB	ESC,'k' 	;Restore cursor location
	DB	EOS		;End of string symbol
	ENDIF

MEMMSG1 DB	CR,LF,BELL
	DB	'Error - unable to release memory, return code = '
MEMERR1 DB	0,CR,LF,EOS

MEMMSG2 DB	CR,LF,BELL
	DB	'Error - unable to allocate memory, return code = '
MEMERR2 DB	0,CR,LF,EOS

ERRMSGC DB	CR,LF,BELL
	DB	'Error - unable to execute COMMAND.COM - ',EOS

ERROR1	DB	'invalid function',CR,LF,EOS
ERROR2	DB	'file not found',CR,LF,EOS
ERROR8	DB	'not enough memory',CR,LF,EOS
ERROR10 DB	'bad environment',CR,LF,EOS
ERROR11 DB	'bad format',CR,LF,EOS
ERRORUN DB	'reason unknown',CR,LF,EOS

;	It may be necessary to specify the drive letter
;	of the boot disk in the following path name

CMDPATH DB	'\COMMAND.COM',0 ;Path and file name

SAVEAX	DW	?		;Save area for caller's AX reg
SAVESS2 DW	?		;Save area for caller's SS reg
SAVESP2 DW	?		;Save area for caller's SP reg
SPSAVE	DW	?		;Save area for local	SP reg

P2_BLK	EQU	$		;Parameter block for EXEC call
P2_ENV	DW	0		;WORD segment address of environment
				;zero passes parent's environment
P2_DTA	DW	OFFSET DTA2	;DWORD pointer to cmd line at DTA
	DW	?
P2_FCB1 DW	OFFSET FCB1	;DWORD pointer to 1st default FCB
	DW	?
P2_FCB2 DW	OFFSET FCB2	;DWORD pointer to 2nd default FCB
	DW	?

DTA2	EQU	$		;Default Disk Transfer Address
;	DB	LEN,'/C...',CR	;Command line length & text
	DB	128 DUP (0)

FCB1	DB	32 DUP (0)	;1st default File Control Block
FCB2	DB	32 DUP (0)	;2nd default File Control Block
	 
	DW	256 DUP (?)
STACK2	LABEL	NEAR		;Local stack

;	Align on a paragraph (16 byte) boundary

	IF	($-SHELL) MOD 16
	ORG	($+16)-(($-SHELL) MOD 16)
	ENDIF

ENDSH	EQU	$		;End of memory area to keep

CODE	ENDS

	END	SHELL
