+ARCHIVE+ 8087sp.asm    7471 10/01/1984 13:00:14
;
;     8087sp.asm - basic 8087 support for C86 
; 
; 
;     LAST REVISED: 24-APR-1984 JSC
; 
;     CAUTION: THE FUNCTIONS IN THIS LIBRARY DO NOT FOLLOW OUR 
;	USUAL CALLING CONVENTIONS. TAKE A GOOD LOOK AT IT BEFORE 
;	MAKING MODIFICATIONS 
;
	INCLUDE	MODEL.H 		; @bigmodel 
	INCLUDE MACROS.H        	; 8087 macros 
	INCLUDE	PROLOGUE.H      	; need for C86 environment 
@code   ends

@DATAU  segment
_savecw	dw	?			; save current control word here
@DATAU	ends

@CODE   segment
_rndcw	dw	0fffh			; truncate control word

;	convert a double to int
;	leaving the int on the stack
;
;	truncation of the fractional part as per K&R p.42
;
	public	$87icvtd

IF	@BIGMODEL
$87iCVTD	PROC	FAR
ELSE
$87iCVTD	PROC	NEAR
ENDIF

	SUB	SP,2			;SPACE FOR RESULT
	push	bp
	mov	bp,sp

	PUSH	4[BP]
IF	@BIGMODEL
	PUSH	6[BP]
ENDIF

	fstcw	word ptr _savecw	; save previous control word
	fldcw	word ptr cs:_rndcw	; set up to truncate 
	fistp	word ptr @ab[bp]	; get the integer
	fldcw	word ptr _savecw	; restore previous control word
	fwait
IF	@BIGMODEL
	POP	4[BP]
ENDIF
	POP	2[BP]
	pop	bp
	ret			;all done
$87iCVTD	ENDP

;	convert a double to long
;	leaving the LONG on the stack
;
;	fractional part is truncated as per K&R
;
	public	$87lcvtd

IF	@BIGMODEL
$87LCVTD	PROC	FAR
ELSE
$87LCVTD	PROC	NEAR
ENDIF

	SUB	SP,4			;SPACE FOR RESULT
	push	bp
	mov	bp,sp
	PUSH	6[BP]                   ; save return offset 
IF	@BIGMODEL
	PUSH	8[BP]                   ; save return segment 
ENDIF
	fstcw	word ptr _savecw        ; save previous control word 
	fldcw	word ptr cs:_rndcw	; set up to round off
	fistp	dword ptr @AB[bp]       ; save long on stack 
	fldcw	word ptr _savecw	;restore previous control word
IF	@BIGMODEL
	POP	4[BP]   		; restore return segment 
ENDIF
	POP	2[BP]           	; restore return offset 
	pop	bp
	ret
$87LCVTD	ENDP

;	bulk push 8087 stuff to stack

	public	$87DBSAV

if	@bigmodel
$87dbsav	proc	far
	pop	si
	pop	es		;get the return address
	mov	cx,es:[si]	;get the count
	add	si,2		;save the return address
dbsloop:
	sub	sp,8
	mov	di,sp
	fstp	qword ptr ss:[di]	;store a value
	loop	dbsloop
	fwait
	push	es
	push	si
	ret
else
$87DBsav	proc	near
	pop	si
	mov	cx,cs:[si]		;get the count
	add	si,2			;save the return address
dbsloop:
	sub	sp,8
	mov	di,sp
	fstp	qword ptr [di]		;store a value
	loop	dbsloop
	fwait
	push	si
	ret
ENDIF
$87dbsav	endp

;	push double arg to the stack for calling

	public	$87DARG,$87DSAVE

IF	@BIGMODEL
$87DARG	PROC	FAR
ELSE
$87DARG	PROC	NEAR
ENDIF
$87DSAVE:

	SUB	SP,8		;MAKE ROOM FOR IT
	PUSH	BP
	MOV	BP,SP
	PUSH	10[BP]          ; save return address 
IF	@BIGMODEL
	PUSH	12[BP]
ENDIF
	FSTP	QWORD PTR @AB[BP]
	fwait
IF	@BIGMODEL
	POP	4[BP]           ; restore return address 
ENDIF
	POP	2[BP]
	POP	BP
	RET

$87DARG	ENDP

;	block restore the 8087 after calling

	public	$87DBRES

IF	@BIGMODEL
$87DBRES	proc	far

	pop	si		;get the return address
	pop	es
	mov	di,sp
	push	cx		;save cx
	mov	cx,es:[si]	;get the count
	add	si,2		;fix return address
drloop:
	fld	qword ptr ss:[di] ; push a double on 8087 stack 
	add	di,8
	loop	drloop
	fwait
	pop	cx
	mov	sp,di
	push	es
	push	si
	ret
else
$87DBRES	proc	near

	pop	si		;get the return address
	mov	di,sp
	push	cx		;save cx
	mov	cx,cs:[si]	;get the count
	add	si,2		;fix return address
drloop:
	fld	qword ptr [di]	; load double 
	add	di,8
	loop	drloop
	fwait
	pop	cx
	mov	sp,di
	push	si
	ret
ENDIF
$87dbres	endp

;	restore double to the 8087 after calling

	public	$87DRES

IF	@BIGMODEL
$87DRES	PROC	FAR
ELSE
$87DRES	PROC	NEAR
ENDIF

	PUSH	BP
	MOV	BP,SP
	PUSH	CX
	PUSH	BX
	PUSH	DX
	PUSH	AX
	FLD	QWORD PTR -8[BP]
	fwait
	MOV	SP,BP
	POP	BP
	RET

$87DRES	ENDP

;	more restore of 8087 stuff

	public	$87DREST

if	@bigmodel
$87DREST	proc	far
else 
$87DREST	proc	near 
endif 

	push	bp
	mov	bp,sp
	fld	qword ptr @ab[bp]
	fwait
	pop	bp
	ret	8
$87DREST	endp

;	place double into 8086 registers before returning

	public	$87DFVAL

IF	@BIGMODEL
$87DFVAL	PROC	FAR
ELSE
$87DFVAL	PROC	NEAR
ENDIF

	PUSH	BP
	MOV	BP,SP
	SUB	SP,8
	FSTP	QWORD PTR -8[BP]
	fwait
	POP	AX
	POP	DX
	POP	BX
	POP	CX
	MOV	SP,BP
	POP	BP
	RET

$87DFVAL	ENDP

;	convert signed long to double
;	entry	long on stack

	public	$87dcvtl

IF	@BIGMODEL
$87dcvtl	PROC	FAR
ELSE
$87DCVTL	PROC	NEAR
ENDIF

	push	bp
	mov	bp,sp
	fild	DWORD PTR @AB[BP]
	pop	bp
	fwait
	RET	4
$87DCVTL	ENDP

;	convert signed integer to double
;	entry	integer on stack

	public	$87dcvti

IF	@BIGMODEL
$87dcvti	PROC	FAR
ELSE
$87DCVTI	PROC	NEAR
ENDIF

	push	bp
	mov	bp,sp
	fild	word ptr @AB[bp]
	pop	bp
	fwait
	ret	2
$87DCVTI	ENDP

;	convert an unsigned long to double
;	entry	number on the stack

	public	$87dcvtul

IF	@BIGMODEL
$87dcvtul	PROC	FAR
ELSE
$87DCVTUL	PROC	NEAR
ENDIF

	PUSH	BP
	MOV	BP,SP
	PUSH	AX
	XOR	AX,AX
	PUSH	AX
	XCHG	AX,-2[BP]
	PUSH	@AB+2[BP]
	PUSH	@AB[BP]
	fild	dword ptr -8[bp] 
	fwait
	MOV	SP,BP
	pop	bp
	ret	4
$87DCVTUL	ENDP

;	convert unsigned integer to double
;	entry	integer on stack

	public	$87dcvtui

IF	@BIGMODEL
$87dcvtui	PROC	FAR
ELSE
$87DCVTUI	PROC	NEAR
ENDIF

	PUSH	BP
	MOV	BP,SP
	PUSH	AX
	XOR	AX,AX
	XCHG	AX,-2[BP]
	PUSH	@AB[BP]
	fild	word ptr -4[bp]
	fwait
	MOV	SP,BP
	pop	bp
	ret	2
$87DCVTUI	ENDP

;	double precision floating point comparison routines

	public	$87dceq,$87dcne,$87dcls,$87dcle,$87dcge,$87dcgr

IF	@BIGMODEL
$87dceq	PROC	FAR	;return true if equal
ELSE
$87DCEQ	PROC	NEAR
ENDIF

	PUSH	AX
	mov	Al,2
	jmp	short dcomp

$87dcne:			;return true if not equal
	PUSH	AX
	mov	Al,5
	jmp	short dcomp

$87dcls:			;return true if less
	PUSH	AX
	mov	Al,1
	jmp	short dcomp

$87dcle:			;return true if less or equal
	PUSH	AX
	mov	Al,3
	jmp	short dcomp

$87dcgr:			;return true if greater
	PUSH	AX
	mov	Al,4
	jmp	short dcomp

$87dcge:			;return true if greater or equal
	PUSH	AX
	mov	Al,6
;	jmp	short dcomp

;	actual routine to do comparison of two doubles on stack

dcomp:
	push	bp
	mov	bp,sp
	fcompp

	PUSH	2[BP]
	PUSH	4[BP]
	POP	2[BP]
IF	@BIGMODEL
	PUSH	6[BP]
	POP	4[BP]
ENDIF
	fstsw	word ptr @AB[bp]
	fwait
	mov	ah,@AB+1[bp]
	sahf
	jA	dcomp02
	je	dcomp01
	sar	Al,1
dcomp01:
	sar	Al,1
dcomp02:
	and	ax,1
	mov	@AB[bp],ax
	POP	AX
	pop	bp
	ret
$87DCEQ	ENDP


;	get 8087 status word  
;	13-APR-1984 JSC 
; 
;	getsw: return 8087 status word e.g. sw=_87getsw(); 

	public _87GETSW

if	@bigmodel
_87GETSW	proc	far
else
_87GETSW	proc	near
endif

	push	bp
	mov	bp,sp
	sub	sp,2
	fstsw	word ptr -2[bp]
	fwait
	mov	ax,-2[bp]
	mov	sp,bp
	pop	bp
	ret

_87GETSW	endp

;	get 8087 control word  
;	13-APR-1984 JSC 
; 
;	getcw: return 8087 control word e.g. cw=_87getcw(); 

	public _87GETCW

if	@bigmodel
_87GETCW	proc	far
else
_87GETCW	proc	near
endif

	push	bp
	mov	bp,sp
	sub	sp,2
	fstcw	word ptr -2[bp]
	fwait
	mov	ax,-2[bp]
	mov	sp,bp
	pop	bp
	ret

_87GETCW	endp

;	set 8087 control word  
;	13-APR-1984 JSC 
; 
; _87SETCW: set the 8087 control word  e.g. _87setcw(cw); 
	public _87SETCW 
if	@bigmodel 
_87SETCW	proc	far 
else 
_87SETCW	proc	near 
endif 

	push	bp 
	mov	bp,sp 
	fldcw	word ptr @ab[bp]	 
	fwait 
        pop	bp 
	ret 
_87SETCW	endp 

	INCLUDE	EPILOGUE.H
	end
+ARCHIVE+ 87sincos.asm  2669 10/01/1984 13:00:16
;	8087: 87SINCOS.ASM

EDOM		equ	33
ERANGE		equ	34

	include model.h
	include prologue.h
	include macros.h

	public	$87_sin_cos
@code	ends

@datab	segment

	extrn	errno:word	; Storage for error variable
	extrn	$87_pi_4:byte	; Pi / 4
pi_div_4	equ	qword ptr $87_pi_4
@datab	ends

@code	segment
if	@bigmodel
$87_sin_cos	proc	far
else
$87_sin_cos 	proc	near		; Common routine for Tangent,
endif 
					; Co-tangent, Cosine, and Sine.
					; Enter routine with radian
					; at top of 8087 stack.
	push	bp
	mov	bp,sp
	sub	sp,2
	fld	pi_div_4		; Push pi/4 onto stack as modulus.
	fld	st(1)			; Get copy of radian value to tos.
	fprem				; Set radian to zeroth octant.
	fstsw	word ptr -2[bp]		; Get the last three bits of quotient.
	fwait				; Wait till 8087 has stored status
	mov	ax,-2[bp]		; Must shift around some bits to get
	and	ah,43h			; an integer value result.
	ror	ah,1			; Move C0 to bit 7 position.
	shr	ax,1			; Get C1 out of AH.
	mov	cl,4
	shr	ah,cl			; Move C3 to bit 0 in AH.
	shr	ax,1			; Bump C3 out of AH.
	shr	ah,1			; Move C0 to bit 0 position.
	shl	ax,1			; Push C3 and C1 back into
	shl	ax,1			; AH.
	test	ah,1			; Odd octants get subtracted by 
					; PI/4.
	jz	normal_fptan		; If not then don't subtract from
					; Pi/4.
cos_to_sin:
	fsubr	pi_div_4		; Subtract stack top from Pi/4.
normal_fptan:
	ftst				; Must see if radian = 0.0
	fstsw	word ptr -2[bp]		;
	fwait
	test	byte ptr -1[bp],40h	; If bit is set, then zero.
	jz	compute_tangent
	fstp	st(0)			; Pop off stack
	fldz				; Load a zero (sine)
	fld1				; Load a one (cosine)
	jmp	short skip_fptan
compute_tangent:
	fptan				; Compute the tangent (sin/cos)
skip_fptan:
	cmp	ah,1			; Do the SINE and COSINE values
	je	switch_sine_cos		; require switching for correct
	cmp	ah,2			; trigonometric identities?
	je	switch_sine_cos		; Only Octants 1,2,5,and 6
	cmp	ah,5			; require this switch.
	je	switch_sine_cos
	cmp	ah,6
	jne	no_switch		; If no switch is required, then leave
switch_sine_cos:
	fxch				; Sine and cosine switch places
no_switch:
	cmp	ah,4			; Will the SINE value be negative?
	jb	no_change_sine_sign	; Yes, but the Cosine is not.
change_sine_sign:
	fld	st(1)			; Get a copy of the SINE.
	fchs				; Make this negative.
	fstp	st(2)			; Store back for the real SINE.
no_change_sine_sign:
	cmp	ah,2			; Is the cosine negative?
	jb	no_change_cosine_sign	; No.
	cmp	ah,5
	ja	no_change_cosine_sign	; No.
change_cosine_sign:
	fchs
no_change_cosine_sign:
	fwait 
	mov	sp,bp
	pop	bp
	ret				; Cosine is on top of stack, ST(0),
					; Sine is at ST(1).
$87_sin_cos	endp

	include epilogue.h
	end
+ARCHIVE+ 87yarc.asm    2816 10/01/1984 13:00:14
;	8087: 87_ARC.ASM

EDOM		equ	33
ERANGE		equ	34

	include model.h
	include macros.h
	include prologue.h
@code	ends
@datab	segment
	extrn	errno:word	; Storage for error variable
	extrn	$87_pi_2:byte	; Pi / 2
	extrn	$87_pi_4:byte	; Pi / 4

pi_div_2	equ	qword ptr $87_pi_2
pi_div_4	equ	qword ptr $87_pi_4
@datab	ends

@code	segment
	public	$87_arc_y_x

; Inverse Trigonometric functions

if	@bigmodel
$87_arc_y_x proc far
else
$87_arc_y_x proc near
endif
	push	bp
	mov	bp,sp
	sub	sp,2
	fld	st(1)			; Load Y
	ftst				; Compare Y to zero
	fstsw	word ptr -2[bp]		; Store result in status word
	fstp	st(0)			; Pop Y off of stack
	fwait 
	test	byte ptr -1[bp],1	; If zeroth bit set then
					; Y is negative
	jz	y_is_positive		; Y is positive

	fxch				; Load Y
	fchs				; -  Y
	fxch				; Load X
	fchs				; - X
	call	$87_arc2		; Test for Cosine troubles
	fldpi				; Load Pi
	faddp	st(1),st		; Add Pi to ARCTAN
	fwait 
	jmp	done_arc1
y_is_positive:
	call	$87_arc2		; Test for Cosine troubles
done_arc1:
	mov	sp,bp
	pop	bp
	ret
$87_arc_y_x	endp

$87_arc2 proc	near			; Cosine correction routine
	push	bp
	mov	bp,sp
	sub	sp,2
	ftst				; Is X < 0?
	fstsw	word ptr -2[bp]
	fwait
	test	byte ptr -1[bp],1	; If zero bit is set, then X < 0
	jz	x_is_pos		; X is positive
	fchs				; Force X positive
	call	$87_arc3			; Check for Y > X
	fldpi				; Load Pi
	fsubrp	st(1),st		; Pi - ARCTAN
	fwait 
	jmp	done_arc2
x_is_pos:
	call	$87_arc3		; Check for Y > X
done_arc2:
	mov	sp,bp
	pop	bp
	ret
$87_arc2 endp

$87_arc3 proc	near
	push	bp
	mov	bp,sp
	sub	sp,2
	fcom				; Compare X to Y
	fstsw	word ptr -2[bp]		; Store Flags
	fwait
	test	byte ptr -1[bp],1	; Is X < Y?
	jz	test_for_equal		; No, then check for X = Y
	fxch				; Switch X & Y
	call	$87_arc4		; Check for  (x=0) or (y=0)
	fsubr	pi_div_2		; Pi/2 - ARCTAN
	fwait 
	jmp 	done_arc3
test_for_equal:
	test	byte ptr -1[bp],040h	; Is X = Y?
	jnz	around			; yes
	call	$87_arc4		; No.
	jmp	done_arc3
around:
	fstp	st(0)			; Pop X off stack
	fstp	st(0)			; Pop Y off stack
	fld	pi_div_4		; Load Pi/4 on 8087 stack top
	fwait 
done_arc3:
	mov	sp,bp
	pop	bp
	ret
$87_arc3 endp

$87_arc4 proc	near			; X > Y 
	push	bp
	mov	bp,sp
	sub	sp,2
	fld	st(1)			; Get Y on top of stack
	ftst				; Compare Y with zero
	fstsw	word ptr -2[bp]		; Store flags in memory variable
	fstp	st(0)			; Pop Y off of stack
	fwait 
	test	byte ptr -1[bp],41h	; Is X > Y > 0?
	fwait 
	jz	not_a_zero		; Yes, then calc ARCTAN

	fstp	st(0)			; No, then pop X and Y
	fstp	st(0)			; off stack.
	fldz				; Push a proper Zero onto 8087 stack
	jmp	done_arc4
not_a_zero:
	fpatan				; Calculate ARCTAN (Y/X)
done_arc4:
	fwait 
	mov	sp,bp
	pop	bp
	ret

$87_arc4 endp
	include epilogue.h 
	end

+ARCHIVE+ 87ydata.asm   2274 10/01/1984 13:00:14
;	8087: 87_DATA.ASM

	include model.h
	include prologue.h
	include macros.h

@code	ends
@datab	segment

	public	$87_pi_2, $87_pi_4, $87_lrg_num, $87_max_rad
	public	$87_half, $87_sqrt_2
	public	$87_lrg_exp


;	The values for Pi/2 and Pi/4 are static for reasons of speed.
;	The necessity of dividing or scaling Pi to these useful values
;	was determined to take too long when the data space taken up was
;	miniscule.

$87_pi_2		label	qword		; Pi / 2
	db	018h,02dh,044h,054h,0fbh,021h,0f9h,03fh
$87_pi_4		label	qword		; Pi / 4
	db	018h,02dh,044h,054h,0fbh,021h,0e9h,03fh

;	$87_LRG_NUM is the largest number that can be stored in double
;	precision format for both negative and positive numbers.	
;									
;	$87_MAX_RAD is the largest radian value that can be reduced by	
;	FPREM to under Pi/4 with one pass. Thus it becomes the maximum  
;	radian value to pass to TAN, COTAN, SINe, and COSine.		

$87_lrg_num	label	qword		; 2**1022	- Very large number
	db	00h,00h,00h,00h,00h,00h,0e0h,07fh
$87_max_rad	label	qword		; 1.0e18	- Maximum Radian value
	db	00h,00h,00h,00h,065h,0cdh,0ddh,041h

; one plus and one minus epsilon are not used currently
;	$87_ONE_PLS is short for One-plus-epsilon. $87_ONE_MIN is short for 
;	One-minus-epsilon. Epsilon = 1 - (sqrt(2) / 2), or approximately
;	0.29. The log functions can be less than accurate when the	
;	argument is very close to one (1). By using FYL2XP1, the result 
;	is more accurate when the argument is between 0.71 and 1.29.	

;$87_one_pls	label	qword		; 1.29		- For log functions
;	db	0a2h,070h,03dh,0ah,0d7h,0a3h,0f4h,03fh
;$87_one_min	label	qword		; 0.71		- For log functions
;	db	0b8h,01eh,085h,0ebh,051h,0b8h,0e6h,03fh

;	$87_HALF and $87_SQRT_2 are used by the exponential functions for
;	calculating the limits of arguments for the 8087 instruction	 
;	F2MX1. $87_SQRT_2 is the 80 bit, temporary real representation	 
;	of the square root of two.					 

$87_half	label	qword		; 0.5		- For EXP and POW
	db	00h,00h,00h,00h,00h,00h,0e0h,03fh
$87_sqrt_2	label	tbyte		; SQRT(2)	- Temporary Real
	db	084h,064h,0deh,0f9h,033h
	db	0f3h,04h,0b5h,0ffh,03fh

$87_lrg_exp	dw	1023	; Largest possible exponent

@datab		ends
@code	segment
	include epilogue.h
	end

+ARCHIVE+ 87yend.asm    1392 10/01/1984 13:00:14
;	8087:87_END.ASM

	include model.h
	include prologue.h
	include macros.h

	public	$87_end
;
;	$87_END: Common routine to store values for return to C86.
;	
;	USE CAUTION if you intend to modify this code
;	MOST of the 8087 trig routines call this code to store
;	the returned value in the registers and restore the
;	base pointer (bp).

DEBUG_87 equ 0  			; DO AN 8087 STACK CHECK

if	DEBUG_87
@code ends
@datab segment
BADSTMSG	db '87_END',10,13,'$' 	; IF SP NON-ZERO
@datab ends
@code segment
endif

if	@bigmodel
$87_end	proc	far
else
$87_end	proc	near
endif

	sub	sp,8    		; make room for double 
	fstsw	word ptr -2[bp]
	fwait
	test	word ptr -2[bp],0010h	; check underflow flag 
	jnz	underflow 

ret_double: 
	fstp	qword ptr -8[bp]	; get the answer 
	fwait	 

if	DEBUG_87 
	sub	sp,2			 
	fstsw	word ptr -10[bp]        ; get the status word 
	fwait 
	test	byte ptr -9[bp],38h	; NDP stack ptr should be 0
	jz	st_okay	
	mov	ah,9    		; print BAD SP
	mov	dx,offset BADSTMSG
	int	21h
st_okay:
endif 

	mov	ax,word ptr -8[bp]
	mov	dx,word ptr -6[bp]
	mov	bx,word ptr -4[bp]
	mov	cx,word ptr -2[bp]
	mov	sp,bp 
	pop	bp
	ret

underflow:                      ; only get here if underflow
	fstp	st(0)
	fldz
	fclex			; clear exception flags in status word 
	jmp	ret_double	; return zero
$87_end	endp

	include epilogue.h
	end

+ARCHIVE+ 87yy2x.asm    3422 10/01/1984 13:00:16
;	8087: 87_Y2X.ASM

EDOM		equ	33
ERANGE		equ	34
	include model.h

	include prologue.h
	include macros.h

	public	$87_y2x
@code ends

@datab	segment
	extrn	errno:word		; Storage for error variable
	extrn	$87_lrg_num:byte	; 2**1022 - Very large number
	extrn	$87_half:byte		; 0.5	  - For EXP and POW
	extrn	$87_sqrt_2:byte		; SQRT(2) - Temporary Real
	extrn	$87_lrg_exp:word	; Largest possible exponent

large_num	equ	qword ptr $87_lrg_num
half		equ	qword ptr $87_half
sqrt_2		equ	tbyte ptr $87_sqrt_2
@datab	ends

@code	segment

if	@bigmodel
$87_y2x	proc	far
else
$87_y2x proc	near		; Y=st(0), X=st(1)
endif

	push	bp
	mov	bp,sp
	sub	sp,2

	fmulp	st(1),st	; Multiply X by log base 2 of Y
	ftst			; Check for x < 0
	fstsw	word ptr -2[bp]	; Store 8087 flags
	fwait
	test	byte ptr -1[bp],1 ; Is X negative?
	jz	x_not_neg	; No.

	fchs			; Yes, then make positive
	call	set_exp		; Calculate exponent
	fld1			; Load a one for inverting result
	fdivrp	st(1),st	; 1 / (y^x)
	jmp	done

x_not_neg:
	call	set_exp		; Calculate (y^x)
done:
	fwait 
	mov	sp,bp
	pop	bp
	ret

$87_y2x	endp

set_exp	proc	near

	push	bp
	mov	bp,sp
	sub	sp,2
	fld	st(0)		; Load working copy of exponent
	ficomp	$87_lrg_exp	; Compare exponent to maximum exponent
	fstsw	word ptr -2[bp] 
	fwait
	test	byte ptr -1[bp],1 ; Is ST < $87_lrg_exp?
	jnz	exp_is_ok	; Yes, then exponent is within range

	mov	errno,erange	; No, then set error word
	fstp	st(0)		; pop off 8087 stack
	fld	large_num	; Load in near Infinity
	jmp	done_set

exp_is_ok:
	call	two_2_the_x	; Final calculation
done_set:
	fwait 
	mov	sp,bp
	pop	bp
	ret
set_exp	endp

two_2_the_x	proc	near
	push	bp			; save stack frame pointer
	mov	bp,sp
	sub	sp,2
	fld	st(0)			; Push a Copy onto 8087 stack
	fstcw	word ptr -2[bp]		; store control word
	fwait
	mov	ax,-2[bp]
	or	byte ptr -1[bp],0ch	; force any rounding to chop
	fldcw	word ptr -2[bp]		; Load in modified control word
	frndint				; Chop off fraction
	mov	-2[bp],ax 
	fldcw	word ptr -2[bp]		; Load in original control word
	fsub	st(1),st		; Convert ST(1) to fraction only
	fxch				; Switch places with st(0)
	fld	half			; Load 0.5
	fcom	st(1)			; Compare with ST(1)
	fstsw	word ptr -2[bp]		; Save flags for perusal
	fwait
	test	byte ptr -1[bp],41h	; Is the fraction larger than 0.5?
	jz	dont_sub		; No.
	test	byte ptr -1[bp],40h	; Is the fraction equal to 0.5?
	jnz	exactly_sqrt_2		; Yes, then don't subtract 0.5
	fsub	st(1),st		; Else, subtract 0.5 from fraction
dont_sub:
	fstp	st(0)			; Pop off 0.5
	f2xm1				; Calc (2^X)-1
	fld1				; Add one to result
	faddp	st(1),st
	test	byte ptr -1[bp],1	; Was this originally > 0.5?
	jz	dont_mul		; No.
	fld	sqrt_2			; Yes, then multiply result by
	fmulp	st(1),st		; SQRT(2)
	jmp	short dont_mul		; Skip around special code for
					; exactly square root of 2
exactly_sqrt_2:
	fstp	st(0)			; Pop off 0.5
	fstp	st(0)			; Pop off fraction
	fld	sqrt_2			; Load square root of two as result

dont_mul:
	fxch				; Must check scale factor for a zero
	ftst
	fstsw	word ptr -2[bp]
	fxch				; Switch them back.
	fwait 
	test	byte ptr -1[bp],40h	; If scale factor equals zero,
	jnz	dont_scale
	fscale				; Scale fraction up to correct value

dont_scale:
	fstp	st(1)			; Pop off stack leaving result at top
	mov	sp,bp
	pop	bp
	ret

two_2_the_x	endp
	include epilogue.h
	end
+ARCHIVE+ acos.asm      1393 10/01/1984 13:00:16
;     8087: ACOS.ASM

EDOM		equ	33
ERANGE		equ	34
	
	include	model.h
	include prologue.h
	include macros.h

if	@bigmodel
	extrn	$87_end:far, $87_arc_y_x:far
else
	extrn	$87_end:near, $87_arc_y_x:near
endif
@code	ends

@datab	segment
	extrn	errno:word
@datab	ends

@code	segment
	public	acos

if	@bigmodel
acos	proc	far
else
acos	proc	near
endif

	push	bp			; Save BP on 8088 stack
	mov	bp,sp			; 
	fld	qword ptr @ab[bp]	; Load in cosine
	sub	sp,2
	fld	st(0)			; Push a copy onto 8087 stack
	ftst				; Compare with zero
	fstsw	word ptr -2[bp]
	fwait
	test	byte ptr -1[bp],1	; Is cosine negative?
	jz	cosine_is_positive	; No.
	fchs				; Change sign for X > 1 test
cosine_is_positive:
	fld1				; Load a one
	fcomp				; Is arg < 1.0?
	fstsw	word ptr -2[bp]		; Save 8087 flags
	fwait
	test	byte ptr -1[bp],1
	jz	ok_to_calc_arccos	; Yes.
	mov	errno,edom		; No, then set errno
	fstp	st(0)			; Pop stack
	fstp	st(0)
	fldz				; Load a zero
	jmp	$87_end			; Quit
ok_to_calc_arccos:
	fmul	st,st(0)		; Square cosine value
	fld1				; Load one for trig identity
	fsubrp	st(1),st(0)		; 1 - (cos^2) = sin^2
	fsqrt				; Sine at top of stack
	fxch				; Switch sine and cosine so that
					; cosine is at top of 8087 stack
	call	$87_arc_y_x		; Calculate ARCTAN(sin/cos)
	jmp	$87_end			; Store result and return

acos	endp
	include	epilogue.h
	end
+ARCHIVE+ asin.asm      1627 10/01/1984 13:00:18
;       8087: ASIN.ASM

EDOM		equ	33
ERANGE		equ	34

	include	model.h
	include prologue.h
	include macros.h
@code	ends
@datab	segment
	extrn	errno:word	; Storage for error variable
@datab	ends
@code	segment
	public	asin

if	@bigmodel
	extrn	$87_end:far, $87_arc_y_x:far
else
	extrn	$87_end:near, $87_arc_y_x:near
endif

if	@bigmodel
asin	proc	far
else
asin	proc	near
endif

	push	bp			; Save BP on 8088 stack
	mov	bp,sp			; Access the sine value on stack
	fld	qword ptr @ab[bp]	; Load sine
	sub	sp,2
	ftst				; Compare with zero
	fstsw	word ptr -2[bp]		; Save flags in 8088 memory
	fwait				
	test	byte ptr -1[bp],1	; Is Sine negative (< 0)?
	jz	sine_is_pos		; No.
	fchs				; Change to positive
	call	arc_sine		; Calculate Arc_sine
	fchs			; Convert result to negative
	jmp	$87_end		; Store and return
sine_is_pos:
	call	arc_sine	; Calculate Arc_sine
	jmp	$87_end		; Store and return
asin	endp

arc_sine proc	near
	push	bp
	mov	bp,sp
	sub	sp,2
	fld1				; Load a one for test
	fcomp				; Compare sine with one.
	fstsw	word ptr -2[bp]		; Save flags
	fwait
	test	byte ptr [bp],1		; Is arg > 1.0?
	jz	no_sine_err		; No.
	mov	errno,edom		; Yes, set error flag
	fstp	st(0)			; Pop arg off 8087 stack
	fldz				; Load a zero
	jmp	done_arc_sine

no_sine_err:
	fld	st(0)			; Duplicate arg	
	fmul	st,st(0)		; Square the sine
	fld1				; Load a one
	fsubrp	st(1),st(0)		; 1 - (sin^2) = cos^2
	fsqrt				; Cosine at top of 8087 stack
	call	$87_arc_y_x		; Calculate ARCTAN(sin/cos)
done_arc_sine:
	fwait
	mov	sp,bp
	pop	bp
	ret
arc_sine endp
	include epilogue.h 
	end
+ARCHIVE+ atan.asm      2715 10/01/1984 13:00:18
;	8087: ATAN, ATAN2
; 
;	atan2(y,x) returns as follows: 
; 
;       0.0 		if y==0.0 && x==0.0 
;       pi/2		if x==0.0 && y>0.0 
;       -pi.2		if x==0.0 && y<0.0 
;       arctan(y/x) 	else 
; 
; 
	include model.h
	include macros.h
	include prologue.h
@CODE 	ENDS

@DATAC	SEGMENT
	extrn	$87_pi_2:word

@DATAC	ENDS
@CODE	SEGMENT
if	@bigmodel
	extrn	$87_arc_y_x:far, $87_end:far 
else
	extrn	$87_arc_y_x:near, $87_end:near
endif

	public	atan, atan2

if	@bigmodel
atan	proc	far
else
atan	proc	near			; ATAN(arg)
endif

	push	bp			; Must access the 8088 stack
	mov	bp,sp			; BP now points to argument values
	fld	qword ptr @ab[bp]	; Load Double precision Tangent
	sub	sp,2
	ftst				; Compare with zero
	fstsw	word ptr -2[bp]		; Save Flags for use by 8088
	fwait
	test	byte ptr -1[bp],1	; Is Tangent > 0?
	jz	positive_tan		; Yes, then skip
	fchs				; No, then make positive
	fld1				; Load a one for cosine
	call	$87_arc_y_x		; Calculate ARCTAN (tan/1)
	fchs				; Convert to negative
	jmp	$87_end			; Store and return
positive_tan:
	fld1				; Load in a 1 for cosine value
	call	$87_arc_y_x		; Calculate ARCTAN(tan/1)
	jmp	$87_end			; Store and return
atan	endp

if	@bigmodel
atan2	proc	far     		; atan2(y/x) 
else
atan2	proc	near
endif

	push	bp 
	mov	bp,sp 
	sub	sp,4
	fld	qword ptr @ab[bp]       ; Load Y
	ftst
	fstsw	word ptr -2[bp]         ; status word for Y 
	fld	qword ptr @ab+8[bp]     ; Load X
	ftst
	fstsw	word ptr -4[bp] 	; status word for X 
	fwait 
	and	byte ptr -1[bp],41h	; isolate C3 and C0
	and	byte ptr -3[bp],41h     ; isolate C3 and C0

	cmp	byte ptr -3[bp],40h	; is X zero ?
	jnz	xnzero 
xzero: 
	cmp	byte ptr -1[bp],40h	; X is zero, is Y zero ?
	jnz	ynzero
yxzero: 
	fstp	st(0)           	; X and Y are zero 
	fstp	st(0)  			; atan2(0,0) = 0
	fldz
	jmp	$87_end
ynzero: 				; x is zero, y is not
	fstp	st(0)
	fstp	st(0)
	fld	qword ptr DGROUP:$87_pi_2 ; atan2(y,0) = pi/2
	test	byte ptr -1[bp],1 
	jz	pos_pi_2 
	fchs				; need to return -pi/2	 
pos_pi_2: 
	jmp	$87_end 
xnzero:
	test	byte ptr -1[bp],1       ; is y < 0 ? 
	jz	ypos 
	fxch				; atan2(y,x) = -atan2(-y/x) 
	fchs                        	; change sign of Y 
	fxch
	call	atan2a	 
	fchs 
	jmp	$87_end 
ypos: 
	call	atan2a 
	jmp	$87_end 
atan2	endp 

atan2a	proc	near
	push	bp 
	mov	bp,sp 
	sub	sp,2 
	ftst	 
	fstsw	word ptr -2[bp] 
	fwait 
	test	byte ptr -1[bp],1 
	jz	xpos    	       	; atan2(v/u) = pi - atan2(v/-u), u<0 
	fchs 
        call	$87_arc_y_x
	fldpi	 
	fsubrp	st(1),st(0) 
	mov	sp,bp 
	pop	bp 
	ret		 
xpos: 
	call	$87_arc_y_x
	mov	sp,bp 
	pop	bp 
	ret 
atan2a	endp 

	include epilogue.h 
	end
+ARCHIVE+ ceil.asm       750 10/01/1984 13:00:18
;      8087: CEIL.ASM

EDOM		equ	33
ERANGE		equ	34

	include model.h
	include prologue.h
	include macros.h

	public	ceil
if	@bigmodel
	extrn	$87_end:far
else
	extrn	$87_end:near
endif

if	@bigmodel
ceil	proc	far
else
ceil	proc	near
endif

	push	bp	
	mov	bp,sp
	fld	qword ptr @ab[bp]	; Load in argument
	sub	sp,2
	fstcw	word ptr -2[bp]		; store control word
	fwait
	mov	ax,-2[bp]		; store working copy
	or	byte ptr -1[bp],08h	; force rounding to next greatest int
	fldcw	word ptr -2[bp]		; Load in modified control word
	frndint				; Chop off fraction
	mov	-2[bp],ax 
	fldcw	word ptr -2[bp]		; Load in original control word
	jmp	$87_end			; Return integer value of argument

ceil	endp

	include epilogue.h
	end
+ARCHIVE+ cos.asm       1723 10/01/1984 13:00:18
;	8087: COS.ASM

EDOM		equ	33
ERANGE		equ	34

	include model.h
	include prologue.h
	include macros.h

if	@bigmodel
	extrn	$87_sin_cos:far, $87_end:far
else
	extrn	$87_sin_cos:near, $87_end:near
endif
@code	ends

@datab	segment
	extrn	errno:word		; Storage for error variable
	extrn	$87_max_rad:byte	; 1.0e18	- Maximum Radian value
max_rads equ	qword ptr $87_max_rad
@datab	ends

@code	segment
	public	cos

if	@bigmodel
cos	proc	far
else
cos	proc	near			; 8087 Co-Sine function.
endif

	push	bp			; Save BP
	mov	bp,sp			; Access the argument on 8086 stack.
	fld	qword ptr @ab[bp]	; Push radian onto 8087 stack.
	fabs				; cos(-x) = cos(x)
	call	co_sinner		; A radian of either positive
					; or negative value will produce
					; the same cosine.
	jmp	$87_end			; Finish storing the cosine and quit.
cos	endp

co_sinner proc	near
	push	bp
	mov	bp,sp
	sub	sp,2
	fcom	max_rads		; Is radian greater than Maximum
	fstsw	word ptr -2[bp]		; Check status word
	fwait
	test	byte ptr -1[bp],1h	; If bit 0 in AH is set,
	jnz	rad_cosine_ok		; then good radian on stack
	jmp	trig_error		; Else, set trig error

rad_cosine_ok:
	call	$87_sin_cos		; get y,x
	fxch				; exchange y,x
	fmul	st(0),st		; square x
	fld	st(1)			; get y
	fmul	st(0),st		; square y
	faddp	st(1),st		; sum squares
	fsqrt				; now we have hypotenuse
	fdivr	st,st(1)		; compute x/h
	fstp	st(3)			; clean up stack and
	fstp	st(0)			; leave x/h on tos
	fstp	st(0)
	mov	sp,bp
	pop	bp
	ret				; cos is tos

trig_error:
	mov	errno,edom		; Set error variable
	fstp	st(0)			;  pop stack
	fldz				; Load 8087 stack top with Zero
	mov	sp,bp
	pop	bp
	ret

co_sinner endp
	include epilogue.h 
	end
+ARCHIVE+ cotan.asm     2133 10/01/1984 13:00:20
;	8087: COTAN.ASM

EDOM		equ	33
ERANGE		equ	34

	include model.h
	include prologue.h
	include macros.h
if	@bigmodel
	extrn	$87_sin_cos:far, $87_end:far
else
	extrn	$87_sin_cos:near, $87_end:near
endif
@code	ends

@datab	segment
	extrn	errno:word		; Storage for error variable
	extrn	$87_lrg_num:byte	; 2**1022 - Very large number
	extrn	$87_max_rad:byte	; 1.0e18 - Largest allowable radian

large_num	equ	qword ptr $87_lrg_num
max_rads	equ	qword ptr $87_max_rad
@datab	ends

@code	segment


	public	cotan

if	@bigmodel
cotan	proc	far
else
cotan	proc	near			; Co-Tangent routine for 8087.
endif

	push	bp			; Save BP.
	mov	bp,sp			; For accessing the stack.
	fld	qword ptr @ab[bp]	; Get the radian value to convert.
	sub	sp,2 
	ftst				; Is this negative?
	fstsw	word ptr -2[bp]
	fwait
	test	byte ptr -1[bp],1	; the radian is negative.
	jz	pos_cotan		; Must be a positive.
	fchs				; Change sign for $87_sin_cos routine.
	call	co_tanner		; Find the co_tangent.
	fchs				; Change the sign of the result.
	jmp	$87_end			; Finish standard trig function.
pos_cotan:
	call	co_tanner	; Find normal co-tangent.
	jmp	$87_end		; Finish standard trig function.
cotan	endp

co_tanner proc	near
	fcom	max_rads		; Is radian greater than Maximum
	fstsw	word ptr -2[bp]		; Check status word
	fwait
	test	byte ptr -1[bp],1h	; If bit 0 in AH is not set,
	jz	trig_error		; then bad radian on stack
					; Else,
	call	$87_sin_cos		; Get the COSINE and SINE.
	fxch				; Switch Sine and cosine on stack
	ftst				; Check for a zero Sine value
	fstsw	word ptr -2[bp]
	fwait
	test	byte ptr -1[bp],40h	; Is this a zero?
	jz	good_cotan		; No, then don't set large_num
	fstp	st(0)			; Yes, then pop off stack
	fld	large_num		; Load extremely large number
	mov	errno,erange		; Set error variable
	fxch				; Switch large number with one
good_cotan:
	fdivp	st(1),st		; Divide the Cosine by the Sine.
	fstp	st(1)			; pop stack
	ret

trig_error:
	mov	errno,edom		; Set error variable
	fstp	st(0)
	fldz				; Load 8087 stack top with Zero
	ret
co_tanner endp
	include epilogue.h
	end
+ARCHIVE+ exp.asm        550 10/01/1984 13:00:20
; 8087: EXP.ASM

	include model.h
	include macros.h
	include prologue.h

if	@bigmodel
	extrn $87_y2x:far, $87_end:far
else
	extrn $87_y2x:near, $87_end:near
endif

	public	exp

if	@bigmodel
exp	proc	far
else
exp	proc	near
endif

	push	bp			; Save BP on 8088 stack
	mov	bp,sp			; BP now points to stack variables
	fld	qword ptr @ab[bp]	; Load argument into 8087
	fldl2e				; Load log base 2 of 'e'
	call	$87_y2x			; Calculate y^X
	jmp	$87_end			; return with result on 8087 stack top

exp	endp

	include epilogue.h
	end
+ARCHIVE+ exp10.asm      557 10/01/1984 13:00:20
; 8087: EXP10.ASM

	include model.h
	include macros.h
	include prologue.h

if	@bigmodel
	extrn $87_y2x:far, $87_end:far
else
	extrn $87_y2x:near, $87_end:near
endif

	public	exp10

if	@bigmodel
exp10	proc	far 
else
exp10	proc	near
endif

	push	bp			; Save BP on 8088 stack
	mov	bp,sp			; BP now points to stack variables
	fld	qword ptr @ab[bp]	; Load argument into 8087
	fldl2T				; Load log base 2 of 10
	call	$87_y2x			; Calculate y^X
	jmp	$87_end		; return with result on 8087 stack top

exp10	endp
	include epilogue.h
	end
+ARCHIVE+ floor.asm      762 10/01/1984 13:00:22
;      8087: FLOOR.ASM

EDOM		equ	33
ERANGE		equ	34

	include model.h
	include prologue.h
	include macros.h

if	@bigmodel
	extrn	$87_end:far
else
	extrn	$87_end:near
endif

	public	floor

if	@bigmodel
floor	proc	far
else
floor	proc	near
endif

	push	bp			; Save BP
	mov	bp,sp
	fld	qword ptr @ab[bp]	; Load in the argument
	sub	sp,2 
	fstcw	word ptr -2[bp]		; Store control word
	fwait 
	mov	ax,-2[bp]		; store working copy 
	or	byte ptr -1[bp],04h	; force rounding to next least int
	fldcw	word ptr -2[bp]		; Load in modified control word
	frndint				; Chop off fraction
	mov	-2[bp],ax 
	fldcw	word ptr -2[bp]		; Load in original control word
	jmp	$87_end			; Store integer result

floor	endp
	include epilogue.h
	end


+ARCHIVE+ frexp.asm      857 10/01/1984 13:00:22
;	8087: FREXP.ASM

EDOM		equ	33
ERANGE		equ	34

	include model.h
	include prologue.h
	include macros.h
@code	ends

@datab	segment
	extrn	errno:word		; Storage for error variable
@datab	ends

@code	segment

	public	frexp

if	@bigmodel
	extrn	$87_end:far
else
	extrn	$87_end:near
endif

if	@bigmodel
frexp	proc	far
	push	bp
	mov	bp,sp
	les	si,dword ptr @ab+8[bp]
	fld	qword ptr @ab[bp]
	fxtract
	fxch
	fistp	word ptr es:[si]
	fwait
	jmp	$87_end
else
frexp	proc	near
	push	bp
	mov	bp,sp			; BP accesses stack
	mov	bx,@ab+8[bp]		; BX points to integer variable
	fld	qword ptr @ab[bp]	; Load 8087 with argument
	fxtract				; Mantissa on top of stack
	fxch				; Exponent on top
	fistp	word ptr [bx]		; Store Integer exponent
	fwait
	jmp	$87_end		; return with mantissa
endif
frexp	endp

	include epilogue.h
	end
+ARCHIVE+ ldexp.asm     1633 10/01/1984 13:00:22
;	8087: LDEXP

EDOM		equ	33
ERANGE		equ	34

	include model.h
	include prologue.h
	include macros.h

@code	ends

@datab	segment
	extrn	errno:word		; Storage for error variable
	extrn	$87_lrg_num:byte	; 2**1022 - Very large number
	extrn	$87_lrg_exp:word	; Largest possible exponent

large_num	equ	qword ptr $87_lrg_num
@datab	ends

@code	segment
if	@bigmodel
	extrn	$87_end:far
else
	extrn	$87_end:near
endif

	
	public	ldexp

if	@bigmodel
ldexp	proc	far
else
ldexp	proc	near
endif

	push	bp			; Save BP on 8088 stack
	mov	bp,sp
	fld	qword ptr @ab[bp]	; Load mantissa into 8087
	sub	sp,2
	fxtract				; Convert to integer and significand
	fxch				; put integer on stack top
	fiadd	word ptr @ab+8[bp]	; Add integer exponential value
	fild	$87_lrg_exp		; Load in maximum exponent
	fchs				; Make it negative
	fcom	st(1)			; Test for exp < -1023
	fstsw	word ptr -2[bp]
	fwait
	test	byte ptr -1[bp],1h	; If zero, then underflow
	jz	under_flow		; Error, will set to zero
	fchs				; change max-exp to positive
	fcom	st(1)
	fstsw	word ptr -2[bp]		; Check now for overflow condtions
	fwait
	test	byte ptr -1[bp],1h	; If not zero, then overflow
	jnz	over_flow		; Exponent is too high
	fstp	st(0)			; pop off maximum exponent
	fxch				; Switch valid exponent with mantissa
	fscale				; Convert to a valid number
	fstp	st(1)			; Save on top of stack
	jmp	$87_end		; Return
under_flow:
	fldz				; Return with zero
	jmp	$87_end

over_flow:
	fld	large_num		; Load with near Infinity
	mov	errno,erange		; Set error word
	jmp	$87_end		; return
ldexp	endp
	include epilogue.h
	end
+ARCHIVE+ log.asm       2214 10/01/1984 13:00:22
;	8087: LOG.ASM  log and log10

EDOM		equ	33
ERANGE		equ	34

	include model.h
	include prologue.h
	include macros.h
@code	ends

@datab	segment
	extrn	errno:word
	extrn	$87_lrg_num:byte	; 2**1022	- Very large number
;	extrn	$87_one_pls:byte	; 1.29		- For xlog functions
;	extrn	$87_one_min:byte	; 0.71		- For xlog functions

large_num	equ	qword ptr $87_lrg_num
;one_plus	equ	qword ptr $87_one_pls
;one_minus	equ	qword ptr $87_one_min
@datab	ends

@code	segment

if	@bigmodel
	extrn	$87_end:far
else
	extrn	$87_end:near
endif

	public	log
	public	log10

if	@bigmodel
log	proc	far 
else
log	proc	near
endif
	fldln2				; log to base e
	jmp	$87_calc_log
log	endp

if	@bigmodel
log10	proc	far 
else
log10	proc	near
endif

	fldlg2				; log to base 10
	jmp 	$87_calc_log
log10	endp

$87_calc_log proc near
	push	bp
	mov	bp,sp			; Access to argument on 8088 stack
	fld	qword ptr @ab[bp]	; Argment now on top of 8087 stack
	sub	sp,2
	ftst				; Check for a negative argument
	fstsw	word ptr -2[bp]
	fwait
					; Only positive, non-zero arguments
					; are allowed.
	test	byte ptr -1[bp],41h	; Is this a positive argument?
	jz	arg_is_positive		; Yes, then check for close to one.
	mov	errno,edom		; No, then set error flag
	fstp	st(0)			; Pop arg off stack
	fstp	st(0)			; pop stack
	fld	large_num		; Load a large number on stack
	fchs				; Change to negative value
	jmp	$87_end			; Return with tail between legs
arg_is_positive:
;	fcom	one_plus		; Compare arg with 1.29
;	fstsw	word ptr -2[bp] 
;	fwait
;	test	byte ptr -1[bp],41h	; Is arg <= 1.29?
;	jz	use_reg_calc		; No, then use normal calculation
;	fcom	one_minus		; Compare arg with 0.71
;	fstsw	word ptr -2[bp]
;	fwait
;	test	byte ptr -1[bp],41h	; Is arg <= 0.71?
;	jz	use_special_calc	; No, then use special calculation
;use_reg_calc:
	fyl2x				; Calculate log value
	jmp	$87_end			; Store log value and return

;use_special_calc:
;	fld1				; Ready to subtract one from
;					; X value (argument)
;	fsubp	st(1),st(0)		; arg - 1
;	fyl2xp1				; stack top = Y * log base 2 (X)
;	jmp	$87_end			; Increased accuracy result returned
; 
$87_calc_log	endp
	include	epilogue.h
	end
+ARCHIVE+ model.h        167 10/01/1984 13:33:06
;	define big or small model for library assembly code

FALSE	equ	0	;for small model
TRUE	equ	1	;for big model

@bigmodel equ TRUE	;select this for model desired
+ARCHIVE+ modf.asm      1242 10/01/1984 13:00:24
; 8087: MODF.ASM

EDOM		equ	33
ERANGE		equ	34

	include model.h
	include prologue.h
	include macros.h
@code	ends
@datab	segment

	extrn	errno:word		; Storage for error variable
@datab	ends
@code	segment

if	@bigmodel
	extrn	$87_end:far
else
	extrn	$87_end:near
endif


	public	modf

if	@bigmodel
modf	proc	far 
else
modf	proc	near
endif

	push	bp
	mov	bp,sp			; BP points to variables in stack

if	@bigmodel
	les	si,dword ptr @ab+8[bp]
else
	mov	bx,@ab+8[bp]		; BX gets address of double variable
endif

	fld	qword ptr @ab[bp]	; Load 8087 with Source argument
	sub	sp,2
	fld	st(0)			; Copy and push onto 8087 stack
	fstcw	word ptr -2[bp]		; Store control word
	fwait
	mov	ax,-2[bp]		; store working copy
	or	byte ptr -1[bp],0ch
					; Force any rounding to chop
	fldcw	word ptr -2[bp]		; Load in modified control word
	frndint				; Chop off fraction
	mov	-2[bp],ax
	fldcw	word ptr -2[bp]		; Load in original control word
	fsub	st(1),st		; arg - int = fraction

if	@bigmodel
	fstp	qword ptr es:[si]
else
	fstp	qword ptr [bx]		; Store integer part
endif

	fabs				; Force fractional part to positive
	jmp	$87_end			; Store fraction and return
modf	endp

	include epilogue.h
	end
+ARCHIVE+ pow.asm       2685 10/01/1984 13:00:24

;	8087: POW.ASM  

EDOM		equ	33
ERANGE		equ	34

	include model.h
	include prologue.h
	include macros.h
@code	ends

@datab	segment
	extrn	errno:word
@datab	ends

@code	segment
if	@bigmodel
	extrn	$87_y2x:far, $87_end:far
else                    
	extrn	$87_y2x:near, $87_end:near
endif
	public	pow


if	@bigmodel
pow	proc	far
else
pow	proc	near
endif

	push	bp
	mov	bp,sp			; BP now points to variable area
	fld	qword ptr @ab+8[bp]	; Load X
	sub	sp,10			; keep room for flags and
					; one double
	ftst				; Test X for zero value
	fstsw	word ptr -2[bp]
	fwait
	test	byte ptr -1[bp],40h	; is x == zero ?
	jz	do_not_default		; No, then don't return a one
	fstp	st(0)			; Yes, then load a one at the
	fld1				; 8087 stack top, then return
	jmp	$87_end
do_not_default:
	fld	qword ptr @ab[bp]	; Load Y
	ftst				; Check for a negative Y value
	fstsw	word ptr -2[bp]
	fwait
	test	byte ptr -1[bp],41h	; If not zero then negative
	jz	base_is_pos		; Y is positive
	test	byte ptr -1[bp],01h	; Y is either zero or negative
	jnz	base_is_neg		; Y is negative
base_is_zero:
	fxch				; Test for X zero or negative
	ftst
	fstsw	word ptr -2[bp]
	fwait
	fstp	st(0)   		; get rid of X,Y 
	fstp	st(0) 
	fldz				; Answer is zero no matter what
	test	byte ptr -1[bp],41h	; If X is positive, then no ERROR
	jz	no_zero_error		; X is positive
	mov	errno,edom		; X is negative, forcing an error
no_zero_error:
	jmp	$87_end			; Return

base_is_pos:
	fld1				; Convert Y to log base 2
	fxch
	fyl2x				; Top of stack now has log base 2 of Y
	call	$87_y2x			; Calculate Y^x
	jmp	$87_end			; Return

base_is_neg:				; Special processing if Y is negative
	fld	st(1)
	fld	st(0)			; Load two copies of xponent
	frndint				; Change stack top to integer
	fcomp	st(1)			; Was X an integer value?
	fstsw	word ptr -2[bp]
	fistp	qword ptr -10[bp]	; Pop extra X off 8087 stack
					; While storing as integer X
	test	byte ptr -1[bp],40h	; Test for X = integer(X)
	jnz	x_is_integer		; X is an integer
	fstp	st(0)			; Pop another off stack
	fstp	st(0)			; and another 
	mov	errno,edom		; Set error variable
	fldz
	jmp	$87_end		; Return with zero
x_is_integer:
	fchs				; Change Y to positive
	fld1				; Load a one for log base 2 of Y
	fxch
	fyl2x
	test	byte ptr -10[bp],01h	; Check if exponent even
	jz	x_is_even		; Yes.
	call	$87_y2x			; Calculate correct y^X
	fchs				; Since X was odd and neg
					; Change sign of result to negative
	jmp	$87_end			; Return correct answer
x_is_even:
	call	$87_y2x		; Calculate Y^X for positive Y
	jmp	$87_end		; Even exponents have positive results

pow	endp
	include epilogue.h 
	end
+ARCHIVE+ sin.asm       1924 10/01/1984 13:00:24
; 8087: SIN.ASM

EDOM		equ	33
ERANGE		equ	34

	include model.h
	include prologue.h
	include macros.h
@code	ends

@datab	segment
	extrn	errno:word		; Storage for error variable
	extrn	$87_max_rad:byte	; 1.0e18 - Maximum Radian value

max_rads	equ	qword ptr $87_max_rad
@datab	ends

@code	segment
if	@bigmodel
	extrn	$87_sin_cos:far, $87_end:far
else
	extrn	$87_sin_cos:near, $87_end:near
endif


	public	sin
if	@bigmodel
sin	proc	far
else
sin	proc	near			; 8087 Sine routine.
endif

	push	bp			; Save BP.
	mov	bp,sp			; Use BP for accessing the stack.
	fld	qword ptr @ab[bp]	; Load radian onto 8087 stack.
	sub	sp,2
	ftst				; check for negative radian.
	fstsw	word ptr -2[bp]		; Store result in memory
	fwait
	test	byte ptr -1[bp],1	; is this negative ? 
	jz	pos_sin			; Not.
	fchs				; Is, then make positive for sin_cos.
	call	sinner			; Ask 8087 for Sine.
	fchs				; change the Sine's sign.
	jmp	$87_end			; Move result to 8086 registers.
pos_sin:
	call	sinner			; Do a normal radian.
	jmp	$87_end		; Save value in 8086 regs.
sin	endp

sinner	proc	near
	push	bp
	mov	bp,sp
	sub	sp,2
	fcom	max_rads		; Is radian greater than Maximum
	fstsw	word ptr -2[bp]		; Check status word
	fwait
	test	byte ptr -1[bp],1h	; If bit 0 is set,
	jnz	rad_sine_ok		; then good radian on stack
	jmp	trig_error		; Else, set trig error

rad_sine_ok:
	call	$87_sin_cos		; get y,x
	fmul	st(0),st		; square x
	fld	st(1)			; get y
	fmul	st(0),st		; square y
	faddp	st(1),st		; sum squares
	fsqrt				; now we have hypotenuse
	fdivr	st,st(1)		; compute y/h
	fstp	st(3)			; clean up stack and
	fstp	st(0)			; leave y/h on tos
	fstp	st(0)
done_sinner:
	mov	sp,bp
	pop	bp
	ret				; sin is tos

trig_error:
	mov	errno,edom		; Set error variable
	fstp	st(0)			;  pop stack
	fldz				; Load 8087 stack top with Zero
	jmp	done_sinner
sinner	endp

	include epilogue.h
	end
+ARCHIVE+ sqrt.asm      1026 10/01/1984 13:00:26
;	8087: SQRT.ASM

EDOM		equ	33
ERANGE		equ	34

	include model.h
	include prologue.h
	include macros.h
@code	ends
@datab	segment
	extrn	errno:word	; Storage for error variable
@datab	ends
@code	segment
if	@bigmodel
	extrn	$87_end:far
else
	extrn	$87_end:near
endif

	public	sqrt

if	@bigmodel
sqrt	proc	far
else
sqrt	proc	near			; 8087 Square root routine.
endif

	push	bp			; Standard procedure call.
	mov	bp,sp
	fld	qword ptr @ab[bp]	; Load in the argument.
	sub	sp,2
	ftst				; Is argument negative?
	fstsw	word ptr -2[bp]		; Check status word
	fwait
	test	byte ptr -1[bp],1h	; If bit 0 in AH is not set,
	jz	sqrt_arg_ok		; then good argument on stack
	jmp	trig_error		; Else, set trig error
sqrt_arg_ok:
	fsqrt				; 8087 xsquare root.
	jmp	$87_end			; Finish standard function return.
trig_error:
	mov	errno,edom		; Set error variable
	fstp	st(0)			; pop
	fldz				; Load 8087 stack top with Zero
	jmp	$87_end			; Return with error value.
sqrt	endp

	include epilogue.h
	end
+ARCHIVE+ square.asm     645 10/01/1984 13:00:26
;	8087: SQUARE.ASM

EDOM		equ	33
ERANGE		equ	34

	include model.h
	include prologue.h
	include macros.h
@code	ends

@datab	segment
	extrn	errno:word	; Storage for error variable
@datab	ends

@code	segment
if	@bigmodel
	extrn	$87_end:far
else
	extrn	$87_end:near
endif


	public	square

if	@bigmodel
square	proc	far
else
square	proc	near			; Quick 8087 squaring function.
endif

	push	bp			; Access the 8086 stack argument.
	mov	bp,sp
	fld	qword ptr @ab[bp]	; Load in the arg to square.
	fmul	st,st(0)		; Square the value.
	jmp	$87_end			; Store the result in 8086 regs.
square	endp
	include epilogue.h
	end
+ARCHIVE+ tan.asm       2216 10/01/1984 13:00:26
;	8087: TAN.ASM

EDOM		equ	33
ERANGE		equ	34

	include model.h
	include prologue.h
	include macros.h
@code	ends
@datab	segment
	extrn	errno:word		; Storage for error variable
	extrn	$87_lrg_num:byte	; 2**1022 - Very large number
	extrn	$87_max_rad:byte	; 1.0e18 - Largest allowable radian

large_num	equ	qword ptr $87_lrg_num
max_rads	equ	qword ptr $87_max_rad
@datab	ends

@code	segment

if	@bigmodel
	extrn	$87_sin_cos:far, $87_end:far
else
	extrn	$87_sin_cos:near, $87_end:near
endif


	public	tan

if	@bigmodel
tan	proc	far
else
tan	proc	near			; Double precision Tangent.
endif

	push	bp			; Save for later.
	mov	bp,sp			; Access the stack for variable.
	fld	qword ptr @ab[bp]      	; Get the radian off stack.
	sub	sp,2
	ftst				; Is it a negative?
	fstsw	word ptr -2[bp]		; Get the flags.
	fwait
	test	byte ptr -1[bp],1	; Not zero if negative.
	jz	pos_tan			; Must be positive.
	fchs				; Force positive, will reverse later.

	call	tanner			; Get tangent from 8087.
	fchs				; Must reverse sign change.
	jmp	$87_end			; Tangent is left on stack.
pos_tan:
	call	tanner			; Get a normal tangent.
	jmp	$87_end			; Store tangent and quit.
tan	endp

tanner	proc	near
	push	bp
	mov	bp,sp
	sub	sp,2
	fcom	max_rads		; Is radian greater than Maximum
	fstsw	word ptr -2[bp]		; Check status word
	fwait
	test	byte ptr -1[bp],1h	; If bit 0 in AH is not set,
	jz	trig_error		; then bad radian on stack
					; Else,
	call	$87_sin_cos		; Get Cosine and sine on 8087 stack.
	ftst				; Check for a zero cosine value
	fstsw	word ptr -2[bp]
	fwait
	test	byte ptr -1[bp],40h	; Is this a zero?
	jz	good_tan		; No, then don't set large_num
	fstp	st(0)			; Yes, then pop off stack
	fld	large_num		; Load extremely large number
	mov	errno,erange		; Set error variable
	fxch				; Switch large number with one
good_tan:
	fdivp	st(1),st		; Divide Sine by the Cosine.
	fstp	st(2)
	fstp	st(0)			; keep tos and pop
	mov	sp,bp
	pop	bp
	ret				; Return with tangent.

trig_error:
	mov	errno,edom		; Set error variable
	fstp	st(0)			;  pop stack
	fldz				; Load 8087 stack top with Zero
	mov	sp,bp
	pop	bp
	ret

tanner	endp
	include epilogue.h
	end
