;	CLOCK -- SCRNCLK CONTROL PROGRAM
;
;	ALLOWED USES OF THIS PROGRAM:
;
;	A>CLOCK			PRINT THE TIME
;	A>CLOCK P		PRINT TIME UNTIL CHAR
;	A>CLOCK D		DISABLE SCREEN CLOCK
;	A>CLOCK E		ENABLE SCREEN CLOCK
;	A>CLOCK HH:MM:SS	SET THE CLOCK
;	A>CLOCK U		UNLOAD SCRNCLK
;
;	BY P. SWAYNE, HUG  18-JUN-84

;	DEFINITIONS

TIMEINT	EQU	8		;TIME INTERRUPT VECTOR
BIOS	EQU	0
BDOS	EQU	5

	ORG	100H

;	TEST IF SCRNCLK IS LOADED

CLOCK:	LXI	H,0
	DAD	SP		;LOCATE STACK
	SHLD	OLDSP		;SAVE IT
	LXI	SP,STACK	;SET A NEW ONE
	LHLD	BIOS+1		;GET BIOS VECTOR
	INX	H		;SKIP JUMP
	MOV	E,M
	INX	H
	MOV	D,M		;DE = WARM BOOT
	MOV	A,E		;TEST IF EXTENSION IN
	SUB	L
	MOV	A,D
	SBB	H
	JNC	NTLDED		;NOTHING LOADED, EXIT
	LHLD	BDOS+1		;GET BDOS ADDRESS
	LXI	D,7
	DAD	D		;MOVE TO SIG.
	MOV	A,M		;GET FIRST CHARACTER
	CPI	'C'		;IS IT "P"?
	JNZ	NTLDED		;CLOCK NOT LOADED
	INX	H
	MOV	A,M		;GET SECOND CHARACTER
	CPI	'K'		;IS IT "S"?
	JZ	LDED		;YES, IT'S LOADED
NTLDED:	LXI	D,ITSOUT
	CALL	PMSG		;ELSE, SAY "IT'S OUT"
	JMP	EXIT		;RETURN TO CP/M

;	CHECK COMMAND LINE

LDED:	LDA	5DH		;GET FIRST FCB LETTER
	LHLD	TIMEINT+1	;GET CLOCK ADDRESS
	DCX	H		;BACK UP TO ENABLE BYTE
	MVI	B,1		;ASSUME ENABLE
	CPI	'E'		;ENABLE?
	JNZ	CHKD		;NO, CHECK DISABLE
EDCLK:	MOV	M,B		;SET CLOCK OFF/ON
	JMP	EXIT		;AND EXIT
CHKD:	MVI	B,0		;ASSUME DISABLE
	CPI	'D'		;CHECK IT
	JZ	EDCLK		;IT'S IT, DISABLE
	CPI	'U'		;DISABLE?
	JZ	UNLD		;YES, UNLOAD
	CPI	'P'		;CONTINUOUS?
	JZ	PCTIME		;YES
	CPI	' '		;NO ARG?
	JZ	PTIME		;YES, PRINT TIME ONCE

;	NONE OF ABOVE, MUST BE THE TIME

	LXI	H,80H		;POINT TO ARGUMENT
SOB:	INX	H
	MOV	A,M		;GET A CHAR
	CPI	' '		;SPACE?
	JZ	SOB		;IF SO, SKIP IT
	DCX	H		;BACK UP ONE
	MVI	M,'0'		;ALLOW LEADING ZERO
	INX	H
	INX	H		;MOVE TO SECOND CHAR.
	MOV	A,M		;GET CHAR.
	CPI	'0'		;LESS THAN ZERO?
	JC	NLZ		;IF SO, NO LEADING ZERO
	CPI	'9'+1		;GREATER THAN 9?
	JNC	NLZ
	INX	H		;REMOVE ONE BACKUP
NLZ:	DCX	H		;BACK UP TO START OF TIME
	DCX	H
	PUSH	H		;SAVE IT
	INX	H
	INX	H		;MOVE TO FIRST DELIMITER
	MVI	M,':'		;REPLACE WITH COLON
	INX	H
	INX	H
	INX	H		;MOVE TO SECOND DELIMITER
	MVI	M,':'		;REPLACE WITH COLON
	POP	H		;RESTORE STRING ADDRESS
	PUSH	H		;SAVE AGAIN

;	CHECK IF ENTRY IS GOOD

	MVI	C,8		;CHECK 8 CHARACTERS
CHLP	MOV	A,M
	CPI	'0'		;LESS THAN ZERO?
	JC	ERROR		;BAD ENTRY
	CPI	':'+1		;MORE THAN ":"?
	JNC	ERROR		;BAD ENTRY
	INX	H
	DCR	C		;DONE?
	JNZ	CHLP		;IF NOT, CONTINUE

;	SET TIME IN CLOCK

	LXI	D,HITMSG
	CALL	PMSG		;PRINT "HIT ANY CHAR"
	MVI	C,1
	CALL	BDOS		;GET ANY CHAR
	LXI	D,CRLF
	CALL	PMSG		;PRINT CRLF
	LHLD	TIMEINT+1	;GET CLOCK ADDRESS
	LXI	D,-14
	DAD	D		;BACK UP TO TIME STRING
	POP	D		;GET TIME ENTERED ADDRESS
	MVI	C,8		;MOVE 8 CHARACTERS
	DI			;DISABLE INTERRUPTS FOR MOVE
MOVLP	LDAX	D		;GET A CHARACTER
	MOV	M,A		;PUT IT IN MEMORY
	INX	D
	INX	H		;INCREMENT POINTERS
	DCR	C		;DONE?
	JNZ	MOVLP		;IF NOT, CONTINUE
	LHLD	TIMEINT+1
	DCX	H
	DCX	H		;POINT TO TICKER
	MVI	M,0		;ZERO IT (START AT EVEN SECOND)
	DCX	H
	MVI	M,0
	EI			;RESTORE INTERRUPTS
	CALL	PTIMES		;PRINT TIME
EXIT:	LHLD	OLDSP		;GET OLD STACK POINTER
	SPHL			;SET IT
	RET			;RETURN TO CP/M

ERROR:	LXI	D,ERRMSG
	CALL	PMSG		;PRINT ERROR MESSAGE
	JMP	EXIT

;	PRINT THE TIME

PCTIME:	CALL	PTIME1		;PRINT THE TIME
	MVI	C,11
	CALL	BDOS		;CHECK STATUS
	ORA	A		;ANY KEY?
	JNZ	PCEXIT		;IF SO, EXIT
	MVI	C,2
	MVI	E,13
	CALL	BDOS		;ELSE, PRINT CR
	JMP	PCTIME		;AND LOOP
PCEXIT:	MVI	C,1
	CALL	BDOS		;CLEAR CONSOLE
	JMP	EXIT		;AND EXIT

PTIME:	CALL	PTIME1		;PRINT THE TIME ONCE
	JMP	EXIT		;AND EXIT

PTIME1:	LHLD	TIMEINT+1
	LXI	D,-7
	DAD	D		;POINT TO SECONDS
	MOV	E,M		;GET THE CURRENT SECOND
WFSEC:	MOV	A,M		;GET IT AGAIN
	CMP	E		;COMPARE WITH OLD
	JZ	WFSEC		;STILL SAME, WAIT
PTIMES:	LHLD	TIMEINT+1	;GET CLOCK ADDRESS
	LXI	D,-14
	DAD	D		;POINT TO TIME STRING
	MVI	B,8		;SET A COUNTER
	MVI	C,2		;GET OUTPUT FUNCTION
PTIMLP:	MOV	E,M		;GET A CHARACTER
	PUSH	H		;SAVE POINTER
	PUSH	B		;SAVE COUNTER
	CALL	BDOS		;PRINT CHAR
	POP	B
	POP	H
	INX	H		;INCREMENT POINTER
	DCR	B		;DECREMENT COUNTER
	JNZ	PTIMLP
	RET

;	UNLOAD SCREEN CLOCK

UNLD:	LHLD	BDOS+1		;GET BDOS ADDRESS
	INX	H		;MOVE TO OLD BDOS ADDRESS
	MOV	E,M		;GET IT
	INX	H
	MOV	D,M
	XCHG
	SHLD	BDOS+1		;RESTORE IT
	XCHG
	INX	H		;MOVE TO OLD WARM BOOT ADDR
	MOV	E,M		;GET IT
	INX	H
	MOV	D,M
	PUSH	H		;SAVE THIS PLACE
	LHLD	BIOS+1		;GET BIOS ADDRESS
	INX	H		;SKIP JUMP
	MOV	M,E		;REPLACE WARM BOOT ADDRESS
	INX	H
	MOV	M,D
	POP	H		;GET PLACE IN SCRNCLK
	INX	H		;MOVE TO OLD CLOCK VECTOR
	MOV	E,M		;GET IT
	INX	H
	MOV	D,M
	XCHG
	DI
	SHLD	TIMEINT+1	;RESTORE OLD VECTOR
	EI
	LXI	D,OUTM
	CALL	PMSG		;REPORT SCR UNLOADED
	JMP	EXIT		;RETURN TO CP/M

;	PRINT MESSAGES

PMSG	MVI	C,9		;PRINT FUNCTION
	JMP	BDOS

;	DATA AREA

ITSOUT	DB	'ERROR -- SCRNCLK not loaded.$'
OUTM	DB	'SCRNCLK Unloaded.$'
HITMSG	DB	'Hit any key to set time...$'
ERRMSG	DB	'Invalid time entry.  Retry using',13,10,10
	DB	'  CLOCK HH:MM:SS$'
CRLF	DB	13,10,'$'
OLDSP	DS	2
STACK	EQU	$+100H

	END
'Invalid time entry.  Retry using',13,10,