;	UNSCR -- UNLOAD SCREEN DUMP PROGRAM
;
;	THIS PROGRAM UNLOADS THE HUG CP/M SCREEN DUMP PROGRAM
;	FROM MEMORY
;
;	BY P. SWAYNE, HUG  17-JUN-84

BIOS	EQU	0		;BIOS VECTOR
BDOS	EQU	5		;BDOS VECTOR
PRINTF	EQU	9		;PRINT FUNCTION

	ORG	100H

UNLOAD	LHLD	BIOS+1		;GET BIOS VECTOR
	INX	H		;SKIP JUMP
	MOV	E,M
	INX	H
	MOV	D,M		;DE = WARM BOOT
	CALL	CPHD		;TEST IF SCR ALREADY OUT
	JC	UNLOAD1		;SOMETHING'S IN, GO AHEAD
NUNLD	LXI	D,ITSOUT
	CALL	PMSG		;ELSE, SAY "IT'S OUT"
	JMP	BIOS		;RETURN TO CP/M
UNLOAD1	LHLD	BDOS+1		;GET BDOS ADDRESS
	PUSH	H		;SAVE IT
	LXI	D,5
	DAD	D		;MOVE TO SIGNATURE
	MOV	A,M		;GET FIRST CHARACTER
	CPI	'P'		;IS IT "P"?
	JNZ	NUNLD		;IF NOT, DO NOT UNLOAD
	INX	H
	MOV	A,M		;GET SECOND CHARACTER
	CPI	'S'		;IS IT "S"?
	JNZ	NUNLD		;IF NOT, DO NOT UNLOAD
	POP	H		;RESTORE BDOS ADDRESS
	PUSH	H		;SAVE AGAIN
	INX	H		;MOVE TO OLD BDOS ADDRESS
	MOV	E,M		;GET IT
	INX	H
	MOV	D,M
	XCHG
	SHLD	BDOS+1		;RESTORE IT
	XCHG
	INX	H		;MOVE TO ORIGINAL WARM BOOT ADDR
	MOV	E,M		;GET IT
	INX	H
	MOV	D,M
	XCHG
	SHLD	WBADR		;SAVE IT
	POP	H		;RESTORE BDOS ADDRESS
	LXI	D,8
	DAD	D		;LOCATE CONIN ADDRESS
	MOV	C,M		;GET IT
	INX	H
	MOV	B,M		;BC = CONIN ADDRESS
	LHLD	BIOS+1		;GET BIOS ADDRESS
	INX	H		;SKIP JUMP
	XCHG
	LHLD	WBADR		;GET WARM BOOT ADDRESS
	XCHG
	MOV	M,E		;REPLACE WARM BOOT ADDRESS
	INX	H
	MOV	M,D
	INX	H
	INX	H		;SKIP JUMP INST.
	INX	H		;SKIP CONST VECTOR
	INX	H
	INX	H
	MOV	M,C		;REPLACE CONIN
	INX	H
	MOV	M,B
	LXI	D,OUTM
	CALL	PMSG		;REPORT SCR UNLOADED
	JMP	BIOS		;RETURN TO CP/M

; COMPARE HL TO DE

CPHD	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	RET

;	PRINT MESSAGES

PMSG	MVI	C,PRINTF
	JMP	BDOS

;	DATA AREA

WBADR	DW	0		;WARM BOOT ADDRESS

ITSOUT	DB	13,10,'ERROR -- SCR not loaded.$'
OUTM	DB	13,10,'SCR Unloaded.$'

	END
