	PAGE	,132
	TITLE	FONTLD - Load alternate character font and interrupt handler (BFL.ASM)
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;



	INCLUDE	DEFMS.ASM
	INCLUDE	DEFMTR.ASM
	INCLUDE	DEFDOSI.ASM
	INCLUDE	DEFCONFG.ASM
	INCLUDE	DEFIPAGE.ASM

BIOS_SEG SEGMENT BYTE PUBLIC 'BIOSCODE'

	ORG	0
	ASSUME	CS:BIOS_SEG,DS:BIOS_SEG,ES:NOTHING,SS:BIOS_SEG

	PUBLIC	FONTLD
	PUBLIC	BIOS_INTFUNC

	EXTRN	ROM_VER:BYTE,MTR_DS_VAL:WORD,FNT_TAB:BYTE,BDRIVE:BYTE

;**	FONTLD - Load the file ALTCHAR.SYS on the default drive
;
;	FONTLD is called at init time to load the ALTCHAR.SYS file
;	from the boot (default) drive into memory
;
;

FONTLD	PROC	NEAR
	MOV	AL,BYTE PTR BDRIVE
	ADD	AL,'A'				; AL = drive letter
	MOV	BYTE PTR FNT_FCB,AL
	MOV	DX,OFFSET FNT_FCB
	MOV	AX,DOSF_OPENH*256+DOSFO_RED
	INT	21H				; Open the font file
	JNC	FONTLD1				; If opened ok
	RET
FONTLD1:
	MOV	BX,AX				; BX = font file handle
RD_KY1:
	MOV	DX,OFFSET FNT_BUF
	MOV	CX,2
	MOV	AH,DOSF_READH			; Read 2 bytes (keyboard map)
	INT	21H
	JC	FONT_EOF
	CMP	AX,2
	JNZ	FONT_EOF
RD_KY2:
	MOV	CX,WORD PTR FNT_BUF		; CX = keyboard code
	INC	CX
	JZ	RD_CHR				; If end of keyboard stuff
	MOV	AL,BYTE PTR FNT_BUF
	XOR	AH,AH
	MOV	SI,AX				; SI = index to old one
	CMP	BYTE PTR ROM_VER,2
	JNC	RD_KY3
	DEC	SI
	DEC	SI
RD_KY3:
	PUSH	DS
	MOV	AX,WORD PTR MTR_DS_VAL
	MOV	DS,AX				; DS points to it
	MOV	AL,CS:BYTE PTR FNT_BUF+1	; AL = new code
	MOV	DS:BYTE PTR [SI+MTR_KYB],AL	; Map it in
	POP	DS
	JMP	RD_KY1

;	Now do the character font stuff

RD_CHR:
	MOV	DX,OFFSET FNT_BUF
	MOV	CX,1				; Read the index byte
	MOV	AH,DOSF_READH
	INT	21H
	JC	FONT_EOF			; If error on read
	CMP	AX,1				; or not enough read
	JNZ	FONT_EOF

	MOV	AL,BYTE PTR FNT_BUF		; AL = character index
	CMP	AL,0FFH
	JZ	FNT_CHR				; If all done

	XOR	AH,AH
	MOV	DX,AX
	MOV	CL,3				; * 8 + 1
	SHL	DX,CL
	ADD	DX,AX				; Location for it
	CMP	DX,MTR_FNT_SIZE
	JNC	FONT_EOF			; If too big, file error
	ADD	DX,OFFSET FNT_TAB
	MOV	AH,DOSF_READH
	MOV	CX,9
	INT	21H				; Read it into place
	JC	FONT_EOF
	CMP	AX,9
	JNZ	FONT_EOF			; If did not work
	JMP	RD_CHR

;	Handle EOF on the font file

FONT_EOF:
	MOV	AH,DOSF_CLOSEH
	INT	21H				; Close the file
	RET

;	Now map the font value

FNT_CHR:
	MOV	DX,OFFSET FNT_BUF
	MOV	CX,2
	MOV	AH,DOSF_READH			; Read some
	INT	21H
	JC	FONT_EOF
	CMP	AX,2
	JNZ	FONT_EOF			; Did not get them all
RD_CH2:
	MOV	CX,WORD PTR FNT_BUF
	INC	CX
	JZ	FONT_EOF

	MOV	AL,BYTE PTR FNT_BUF
	XOR	AH,AH
	MOV	SI,AX
	CMP	BYTE PTR ROM_VER,2
	JNC	RD_CH3
	DEC	SI
	DEC	SI
RD_CH3:
	PUSH	DS
	MOV	AX,WORD PTR MTR_DS_VAL
	MOV	DS,AX
	MOV	AL,CS:BYTE PTR FNT_BUF+1
	MOV	DS:BYTE PTR [SI+MTR_CHR],AL
	POP	DS
	JMP	SHORT FNT_CHR

FNT_FCB	DB	'X:\ALTCHAR.SYS',0

FNT_BUF	DB	0,0

FONTLD	ENDP

;***	BIOS_INTFUNC - Handler interrupt request functions
;
;	BIOS_INTFUNC handles the requests from users to install or
;	remove them from the interrupt list
;
;	ENTRY:	AH	=	Function
;		AL	=	Interrupt number
;		ES:BX	=	Interrupt address
;
;	EXIT:	PSW.CY	=	Error processing function
;		AX	=	DOSE_INVFUNC if invalid function
;				DOSE_NOFILE  if interrupt not found
;				DOSE_TMFILES if no room for it in tables
;

	PUBLIC	BIOS_INTFUNC

BIOS_INTFUNC	PROC	FAR			; Far procedure
	CMP	AH,BIF_MAXINT			; AL too large?
	JNC	BIF_INVFUNC			; Yes, invalid function
	PUSH	SI
	PUSH	DI
	PUSH	AX
	SUB	AL,BIOSAI			; Bias it down
	JC	BIF_NOHNDL			; Invalid interrupt
	CMP	AL,INT_UMAX-BIOSAI		; Too large?
	JNC	BIF_NOHNDL
	CMP	AL,INT_EVNA-BIOSAI		; Event interrupt?
	JZ	BIF_NOHNDL			; Yes, can't set it
	CMP	AL,INT_NETA-BIOSAI		; Or network?
	JZ	BIF_NOHNDL
	PUSH	AX
	MOV	AL,AH
	XOR	AH,AH				; Function in AX
	SHL	AX,1
	MOV	SI,AX				; SI = word offset
	POP	AX
	XOR	AH,AH
	SHL	AX,1
	MOV	DI,AX				; DI = interrupt number
	MOV	DI,CS:WORD PTR BIF_IDT[DI]
	JMP	CS:WORD PTR BIF_DIS[SI]		; Dispatch the function

MI_NOP	EQU	090H				; 8086 nop instruction
MI_CALL	EQU	09AH				; Call far
MI_RET	EQU	0C3H				; Near return

IDTS	EQU	5				; 5 bytes / entry
IDTN	EQU	8				; 8 entries / interrupt

;	Error - Invalid function in AH

BIF_INVFUNC:
	MOV	AX,DOSE_INVFUNC
	STC
	RET

;	Error - No room in tables for BIF_SETINT

BIF_NOROOM:
	POP	AX
	POP	DI
	POP	SI
	MOV	AX,DOSE_TMFILES
	STC
	RET

;	Error - interrupt not found

BIF_NOFILE:
	POP	AX
	POP	DI
	POP	SI
	MOV	AX,DOSE_NOFILE
	STC
	RET

;	Error - Invalid interrupt

BIF_NOHNDL:
	POP	AX
	POP	DI
	POP	SI
	MOV	AX,DOSE_NOHNDL			; Error - unknown handle
	STC
	RET

;	Processors for the interrupt routines. DI = table pointer

BIF_SET:
	CMP	CS:BYTE PTR [DI],MI_NOP		; Clear entry?
	JZ	BIF_SET1
	CMP	CS:BYTE PTR [DI],MI_RET		; End of table?
	JZ	BIF_NOROOM			; Yep, too bad
	ADD	DI,IDTS
	JMP	BIF_SET
BIF_SET1:
	PUSHF
	CLI
	MOV	CS:BYTE PTR [DI],MI_CALL
	MOV	CS:WORD PTR [DI+1],BX
	MOV	CS:WORD PTR [DI+3],ES		; Set it in
	POPF
	POP	AX
	POP	DI
	POP	SI
	CLC
	RET

BIF_CLR:
	MOV	SI,ES
BIF_CLR0:
	CMP	CS:BYTE PTR [DI],MI_RET
	JZ	BIF_NOFILE			; Cant find it
	CMP	CS:BYTE PTR [DI],MI_CALL
	JNZ	BIF_CLR1			; Try next
	CMP	CS:WORD PTR [DI+1],BX
	JNZ	BIF_CLR1			; Not right address
	CMP	CS:WORD PTR [DI+3],SI
	JNZ	BIF_CLR1			; Or segment
	PUSHF
	CLI
	MOV	CS:BYTE PTR [DI],MI_NOP
	MOV	CS:WORD PTR [DI+1],(MI_NOP SHL 8) OR MI_NOP
	MOV	CS:WORD PTR [DI+3],(MI_NOP SHL 8) OR MI_NOP
	POPF
	POP	AX
	POP	DI
	POP	SI
	CLC
	RET
BIF_CLR1:
	ADD	DI,IDTS
	JMP	BIF_CLR0

;	Function dispatcher

BIF_DIS	LABEL	WORD				; Dispatch table
	DW	OFFSET BIF_SET			; Set it
	DW	OFFSET BIF_CLR			; Clear it

;	Interrupt vector list

BIF_IDT	LABEL	WORD
	DW	OFFSET KYB_IDT			; Keyboard dispatcher
	DW	OFFSET TIM_IDT			; Clock dispatcher
	DW	OFFSET SAI_IDT			; Serial A input
	DW	OFFSET SBI_IDT			; Serial B input
	DW	OFFSET LP_IDT			; Light pen hit
	DW	OFFSET CRT_IDT			; CRT output
	DW	OFFSET SAO_IDT			; Serial A output
	DW	OFFSET SBO_IDT			; Serial B output
	DW	OFFSET NOP_IDT			; Do nothing here
	DW	OFFSET NET_IDT			; Network interrupt
	DW	OFFSET VSY_IDT			; Vsync interrupt
	DW	OFFSET LPS_IDT			; Light pen special

;	The interrupt dispatch tables
;
;	Each entry in the table is a machine instruction. Interrupt
;	routines CALL NEAR the first byte of the table, and the
;	table consists of NOPs for unused entries, and CALL FARS
;	for used entries. The table is terminated with a near RET

	PUBLIC	KYB_IDT,TIM_IDT,SAI_IDT,SBI_IDT,LP_IDT
	PUBLIC	CRT_IDT,SAO_IDT,SBO_IDT,NET_IDT,VSY_IDT
	PUBLIC	LPS_IDT

KYB_IDT	DB	IDTS*IDTN DUP (MI_NOP),MI_RET
TIM_IDT	DB	IDTS*IDTN DUP (MI_NOP),MI_RET
SAI_IDT	DB	IDTS*IDTN DUP (MI_NOP),MI_RET
SBI_IDT	DB	IDTS*IDTN DUP (MI_NOP),MI_RET
LP_IDT	DB	IDTS*IDTN DUP (MI_NOP),MI_RET
CRT_IDT	DB	IDTS*IDTN DUP (MI_NOP),MI_RET
SAO_IDT	DB	IDTS*IDTN DUP (MI_NOP),MI_RET
SBO_IDT	DB	IDTS*IDTN DUP (MI_NOP),MI_RET
NOP_IDT	DB	MI_RET
NET_IDT	DB	MI_RET
VSY_IDT	DB	IDTS*IDTN DUP (MI_NOP),MI_RET
LPS_IDT	DB	IDTS*IDTN DUP (MI_NOP),MI_RET
BIOS_INTFUNC	ENDP

BIOS_SEG	ENDS

	END
              