;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
; Definitions for the Monitor ROM
;

; Entry points to ROM monitor

MTR_SEG	SEGMENT	AT 0FE01H	; Segment addr for Monitor ROM calls
	ORG	000H
  MTR_RES	LABEL	FAR	; Reset function
	ORG	005H
  MTR_MON	LABEL	FAR	; Monitor call
	ORG	00AH
  MTR_SWIM	LABEL	FAR	; Trace/breakpoint handler
	ORG	00FH
  MTR_DCRT	LABEL	FAR	; Dumb display output
	ORG	014H
  MTR_DKBD	LABEL	FAR	; Dumb keyboard handler
	ORG	019H
  MTR_SCRT	LABEL	FAR	; Smart display output
	ORG	01EH
  MTR_SKBD	LABEL	FAR	; Smart keyboard input
	ORG	023H
  MTR_TTY_INTR	LABEL	FAR	; Vertical retrace interrupt handler
MTR_SEG	ENDS


MTR_D_SEG SEGMENT AT 0		; Monitor data segment(not really at 0)
	ORG	000H

; Monitor Parameters

  MTR_WIP	LABEL	FAR	; Far jump to wild interrupt handler
		DB 5 DUP(?)	; the far jump
  MTR_VER	DB ?		; BCD version of ROM monitor
    MTR_CVER	  EQU 01H	  ; Lowest version BIOS can run on
  MTR_DS_SIZE	DW ?		; Size of the ROM monitor data segment


; Boot parameters

  MTR_BINDX	DB ?		; Boot device index
  MTR_BPORT	DB ?		; Boot device base port number
  MTR_BSTRING	DB 80 DUP(?)	; Boot string
  MTR_BUNIT	DB ?		; Boot unit number


; Pointers to All sorts of things

  MTR_DCI	DD ?		; Addr of Display Character Initialization
  MTR_DFC	DD ?		; Addr of Display Font Character Routine
  MTR_DXMTC	DD ?		; Addr of Dumb Keyboard Transmit Character
  MTR_EDC	DD ?		; Addr of Erase Display Character Routine
  MTR_EMEC	DD ?		; Addr of Escape Character Handler Routine
  MTR_FONT	DD ?		; Addr of Character Font table
    MTR_FNT_SIZE  EQU 9*(256-' ') ; Size of reserved font table
				  ;  number of bytes copied from rom font
				  ;  area if version = 1)
  MTR_MDC	DD ?		; Addr of Move Display Characters Routine
  MTR_MDL	DD ?		; Addr of Move Display Line Routine
  MTR_PROMPT	DD ?		; Addr of Display ROM Monitor Prompt Routine
  MTR_RDC	DD ?		; Addr of Read Displayed Character Routine
  MTR_SXMTC	DD ?		; Addr of Smart Keyboard Transmit Character
  MTR_UIES	DD ?		; Addr of Unimplemented Escape Sequence
  MTR_XCA	DD ?		; Addr of Transmit Character Attributes

; If version = 1, next word is not present, and all references must have
;	-2 added to them for labels beyond this point

  MTR_FNTSIZ	DW ?		; Size of FONT in bytes (If version > 1)
  MTR_KYB	DB 256 DUP (?)	; Keyboard map table
  MTR_CHR	DB 256 DUP (?)	; Display map table
  MTR_HORP	DB ?		; Horizontal position of cursor (column)
  MTR_VERP	DB ?		; Vertical position of cursor (row)
  MTR_MIB	DB ?		; Base interrupt number for master
  MTR_SIB	DB ?		; Base interrupt number for slave
  MTR_RESF	DB ?		; Reset flag to re-enter monitor
MTR_D_SEG ENDS


IPAGE_SEG SEGMENT AT 0		; The interrupt area page
	ORG	03FEH
  MTR_DS	LABEL WORD	; Location that contains monitor DS value

IPAGE_SEG ENDS
