;
; THIS IS AN EXAMPLE OF HOW TO INCLUDE 16-BIT OBJECT CODE IN
; AN 8-BIT .COM PROGRAM.  ALTHOUGH THIS IS A TRIVIAL EXAMPLE,
; EXAMPLES OF ANY DESIRED COMPLEXITY MAY ACTUALLY BE USED.  
; WHERE IT IS APPROPRIATE TO DO SO, CHANGES IN TECHNIQUE WHICH
; MAY BE DESIRABLE FOR MORE COMPLEX EXAMPLES ARE NOTED.
;
; THE OPERATING SYSTEM SUPPORTS "CONFIGURATION" FUNCTIONS VIA
; THE JUMP VECTOR AT BIOS+5AH.  THE SPECIFIC CONFIGURATION 
; FUNCTION CORRESPONDING TO 16-BIT CODE EXECUTION IS FUNCTION
; NUMBER 6.  REGISTER H,L POINTS TO A DATA BLOCK WHICH IS
; UNIQUE FOR EVERY USE OF THE 16-BIT CODE EXECUTION FEATURE,
; BUT WHICH CONTAINS ALL PARAMETERS PASSED BETWEEN THE 8 AND
; 16-BIT MODULES AND WHOSE 1ST TWO BYTES CONTAIN THE OFFSET
; (WITHIN THE 8-BIT CPU's ADDRESS SPACE) AT WHICH THE 16-BIT
; CODE IS LOCATED AND ORGed (THIS WILL BE THE IP AT RUN TIME,
; WHILE THE CS: WILL BE 1000H, CORRESPONDING TO THE 8085'S
; 64K OF MEMORY).  THE 16-BIT CODE IS ENTERED VIA A FAR CALL
; AND EXITED VIA A FAR RETURN.  NO ASSUMPTIONS MAY BE MADE
; ABOUT THE CONTENTS OF ANY REGISTERS (INCLUDING SEG REGS) ON
; ENTRY, AND NO REGISTERS (INCLUDING SEG REGISTERS) NEED BE
; PRESERVED.
;
; ALTHOUGH IT IS NOT THE PREFERRED TECHNIQUE, PARAMETERS MAY
; BE PASSED TO THE 16-BIT CODE MODULE IN REG B,C AND D,E,
; AND A RETURN CODE MAY BE RETURNED IN REG A.  THE CONTENTS
; OF THE 8-BIT REGISTERS ARE AVAILABLE TO THE 16-BIT CODE
; VIA THE REGAF, REGBC, REGDE AND REGHL VARIABLES IN
; BNKBIOS3 (SEE THE BNKBIOS3.ASM SOURCE CODE).  REGHL
; MUST POINT TO A DW CONTAINING THE ADDRESS OF THE 16-BIT
; CODE AND MUST NOT CONTAIN THE 16-BIT CODE ADDRESS ITSELF.
;
; WARNING: MESS WITH DEVICE INITIALIZATIONS AND INTERRUPTS AT
; YOUR OWN RISK.  THE WATZMAN CP/M+ IMPLEMENTATION IS A COMPLEX
; SYSTEM AND CAN EASILY BE DESTROYED IF YOU START TINKERING AND
; DO NOT KNOW WHAT YOU ARE DOING !
;
BOOT	EQU	0
BDOS	EQU	5
BIOSLOC	EQU	0FB00H
;
MTRSEG	EQU	0FE01H
MTRSCRT	EQU	0019H
;
	ORG	100H
;
EXAMPLE:MVI	C,0CH		;INSURE THIS IS CP/M+
	CALL	BDOS
	MOV	A,H
	ORA	A
	JNZ	WRNGVER		;NOT CP/M
	MOV	A,L
	CPI	31H		;VERSION 3.1 ?
	JNZ	WRNGVER		;NO, ERROR
	LHLD	BOOT+1		;GET BIOS ADDRESS
	LXI	D,57H		;OFFSET TO CONFIG ENTRY PT.
	DAD	D
	SHLD	CFGENT+1	;SAVE CONFIG ENTRY PT ADDR
	MOV	A,M
	CPI	0C3H		;MUST BE A JUMP INSTRUCTION
	JNZ	WRNGVER		;IT'S NOT, ERROR
	MVI	C,0		;SEE WHAT CONFIG VERSION IS
	CALL	CFGENT
	CPI	11H		;AT LEAST VERSION 1.1
	JNC	KEEPON		;NO ERROR
;
; OS IS THE WRONG VERSION
;
WRNGVER:LXI	D,WVMSG		;WRONG VERSION MESSAGE
	MVI	C,9		;PRINT STRING FUNCTION
	CALL	BDOS		;TELL USER WRONG VERSION
	MVI	C,0		;TERMINATE FUNCTION
	JMP	BDOS		;TERMINATE
;
KEEPON:	LXI	H,CODE16	;WHERE THE 16-BIT CODE IS
	SHLD	CB16		;SAVE IN 16-BIT CNTL BLOCK
	LXI	H,MSG16		;POINT TO MESSAGE TO BE PRINTED
	SHLD	CB16+2
	MVI	C,6		;FUNCTION # FOR 16-BIT CODE EXECUTION
	LXI	H,CB16		;WHERE THE 16-BIT CNTL BLOCK IS
	CALL	CFGENT		;RUN THE 16-BIT CODE
	MVI	C,0
	JMP	BDOS
;
; JUMP TO THE CONFIGURATION ENTRY POINT
;
CFGENT	DB	0C3H,0,0	;ADDR FILLED IN AT RUN TIME
;
; 16-BIT CODE CONTROL BLOCK
;
; THIS CONTROL BLOCK CAN BE AS LONG AS DESIRED AND ALL CONTENTS
; AFTER THE FIRST TWO BYTES ARE AT THE APPLICATIONS DISCRETION.
;
CB16	DW	0		;MUST BE OFFSET OF 16-BIT CODE
	DW	0		;MSG ADDR (THIS EXAMPLE ONLY)
;
; THE 16-BIT CODE GOES HERE
;
; IN A NON-TRIVIAL CASE, THIS WOULD PROBABLY BE AS FOLLOWS:
;
;CODE16:DS	n
;
; WITH THE 16 BIT CODE WRITTEN AND ASSEMBLED SEPARATELY:
;
; A>ASM86 CODE16
; A>GENCMD CODE16 8080 NHEAD
;
; THEN THE BINARY CODE FROM GENCMD (NHEAD IS AN UNDOCUMENTED OPTION
; THAT CAUSES GENCMD TO SKIP GENERATING THE .CMD HEADER RECORD) WOULD
; BE INSERTED INTO THE ABOVE DS WITH DDT OR SID USING THE "R" COMMAND.
;
; IT IS RECOMMENDED THAT THIS AREA BEGIN ON A PARAGRAPH OR PAGE
; BOUNDRY, ALTHOUGH THIS IS NOT ACTUALLY REQUIRED.
;
	ORG	16*(($+15)/16)		;FORCE PARAGRAPH BOUNDRY
;
CODE16:	DB	8CH,0C8H		;MOV	AX,CS
	DB	8EH,0D8H		;MOV	DS,AX
	DB	8BH,1EH			;MOV	BX,REGHL
	DW	REGHL
	DB	8BH,77H,02H		;MOV	SI,2[BX]
CODEA:	DB	0ACH			;LODSB
	DB	50H			;PUSH	AX
	DB	56H			;PUSH	SI
	DB	9AH			;  FAR CALL
	DW	MTRSCRT			;  TO CHAR OUT ROUTINE
	DW	MTRSEG			;  IN MTR-100 ROM
	DB	5EH			;POP	SI
	DB	58H			;POP	AX
	DB	0AH,0C0H		;OR	AL,AL
	DB	75H,0F2H		;JNZ	CODEA
	DB	0CBH			;RETF
;
; END OF 16-BIT CODE, RETURNING TO THE 8-BIT WORLD.
;
WVMSG	DB	0DH,0AH,'Wrong Operating System Version.',0DH,0AH,'$'
;
MSG16	DB	0DH,0AH,'This Message Printed By 16-Bit Code'
	DB	0DH,0AH,'Within An 8-bit .COM Program.',0DH,0AH,0
;
; THE FOLLOWING EQUATES SHOULD APPEAR IN THE MODULE CONTAINING
; THE 16-BIT CODE.  IF THE 16-BIT CODE IS PREPARED AND ASSEMBLED
; SEPARATELY, THIS SHOULD BE DEFINED AS A DATA SEGMENT.
;
; NOTE THAT THE DS's HERE WOULD BE RS's, RB's OR RW's IF THIS
; WERE A SEPARATE MODULE BEING ASSEMBLED WITH ASM86.
;
;	DSEG			;NOT APPLICABLE HERE
	ORG	BIOSLOC+63H	;SEE THE BNKBIOS3.ASM LISTING
;
	DS	50		;SCB VARIABLE ADDRESSES, NOT USED HERE
;
CACPU	DS	1
MEMBNK	DS	1
;
FUNCT	DS	1
REGAF	DS	2
REGBC	DS	2
REGDE	DS	2
REGHL	DS	2		;THIS IS THE ONE WE REALLY WANT
;
; YOU MAY DEFINE THE REMAINING DATA SEGMENT IN THE 8-BIT BIOS IF
; YOU WILL NEED ACCESS TO ANY OF IT IN YOUR 16-BIT MODULE.
;
	END
