	PAGE	,132
TITLE	DIRECTORY TREE PROGRAM
;	THIS PROGRAM SHOWS ALL OF THE DIRECTORIES IN A SPECIFIED
;	DRIVE AND/OR DIRECTORY IN A GRAPHIC TREE FORMAT.
;	BASED ON TREED BY R A FLAVIN

;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  04-FEB-88  23-JAN-89

;
LF	EQU	0AH
CR	EQU	0DH
;

BIOS	SEGMENT AT 40H
	ORG	0
JTBL	LABEL	BYTE		;ESTABLISH BIOS JUMP TABLE LOCATION
	ORG	9
BOUT	LABEL	FAR		;BIOS OUTPUT ROUTINE
BIOS	ENDS

CODE	SEGMENT
	ASSUME DS:CODE, SS:CODE ,CS:CODE ,ES:CODE
	ORG	5DH
FCBN	LABEL	WORD
	ORG	100H

START:	MOV	AX,DS
	CLI
	MOV	SS,AX
	MOV	SP,OFFSET START		;SET STACK
	STI
	CMP	FCBN,' ?'		;CHECK FOR HELP WANTED
	JNZ	START1			;NOT WANTED
	MOV	DX,OFFSET EXPMSG
	MOV	AH,9
	INT	21H			;ELSE, SHOW HELP
	INT	20H
START1:	PUSH	DS
	MOV	AX,40H
	MOV	DS,AX
	ASSUME	DS:BIOS
	CMP	JTBL,0E9H		;CHECK FOR JUMP TABLE
	POP	DS			;FIX DS
	ASSUME	DS:CODE
	JNZ	GOTPC			;IT'S A PC
	MOV	BYTE PTR PCFLG,0	;ELSE, FLAG Z-100
	MOV	BYTE PTR NLINES-1,23	;FIX LINE COUNT
GOTPC:	MOV	SI,80H			;POINT TO USER'S ARGUMENT
	MOV	CL,[SI]			;GET COUNT
	INC	SI
SOS:	CMP	BYTE PTR [SI],' '	;SPACE?
	JNZ	CPYARG
	MOV	BYTE PTR [SI],'!'	;REPLACE SPACE WITH "!"
	DEC	CX
	INC	SI
	JMP	SHORT	SOS

;	COPY THE USER ARGUMENT TO THE SEACH PATH AND DISPLAY LINE.

CPYARG:	MOV	AX,CS
	MOV	ES,AX
	MOV	DI,OFFSET PATH		;POINT TO SEARCH PATH
	MOV	BX,OFFSET DLINE		;POINT TO DISPLAY LINE
	OR	CL,CL			;ANY ARGUMENT?
	JNZ	MVARG			;YES, MOVE IT
	MOV	BYTE PTR [SI],'\'	;ELSE, INSERT "\" CHARACTER
	MOV	CL,1
MVARG:	LODSB				;GET CHARACTER FROM ARGUMENT
	STOSB				;PUT IT IN SEARCH PATH
	MOV	[BX],AL			;ALSO IN DISPLAY LINE
	INC	BX
	DEC	CL
	JNZ	MVARG

;	SKIP OVER SPACES AND BACK SLASHES AT END OF ARGUMENT.

SOSSL:	DEC	SI
	MOV	AL,[SI]
	CMP	AL,' '			;SPACE?
	JZ	SOSS1			;YES, SKIP IT
	CMP	AL,'\'			;BACK SLASH?
	JNZ	STREE			;NO, INSERT STARTING TREE CHARACTERS
SOSS1:	DEC	BX			;BACK UP OVER CHARACTER
	DEC	DI
	JMP	SHORT	SOSSL

;	START TREE BY PUTTING IN SOME GRAPHIC CHARACTERS

STREE:	MOV	AX,CS
	MOV	DS,AX
	MOV	PATHE,DI
	MOV	WORD PTR [BX],0C2C4H	;STORE GRAPHIC CHARACTERS
	MOV	BYTE PTR [BX+2],0C4H	;TO MAKE TREE SHAPE
	MOV	WORD PTR [BX+3],0DC4H
	MOV	WORD PTR [BX+5],240AH
	SUB	BX,8
	MOV	DLPTR,BX		;SET DISPLAY LINE POINTER
	MOV	DX,OFFSET MYDTA	
	MOV	AH,1AH			;SET DTA
	INT	21H
	MOV	SI,OFFSET DIRLST	;PUT DIRECTORY LIST HERE
	CALL	MAIN			;CALL RECURSIVE MAIN ROUTINE
	INT	20H			;EXIT

;	THIS IS THE MAIN ROUTINE OF THE PROGRAM.  IT IS CALLED
;	RECURSIVELY AS THE DIRECTORY TREE IS SEARCHED.

MAIN:	PUSH	DIRPTR			;SAVE DIR. LIST POINTER
	PUSH	PATHE			;AND PATH END
	PUSH	SI			;AND NEW LIST POINTER
	MOV	DIRPTR,SI		;UPDATE DIRECTORY LIST POINTER
	MOV	BX,DLPTR		;GET DISPLAY LINE POINTER
	MOV	DI,PATHE		;AND END OF PATH
	MOV	CL,12			;SIZE OF AN ENTRY
	MOV	AL,[SI]			;GET A CHARACTER
	OR	AL,AL			;ANYTHING IN LIST?
	JZ	PPSRCH

;	COPY CURRENT NAME IN DIRECTORY LIST TO THE SEARCH PATH
;	AND TO THE DISPLAY LINE.

FNEND:	LODSB				;GET A CHARACTER
	OR	AL,AL			;END?
	JZ	GOTEND			;YES
	STOSB				;ELSE, STORE IT IN PATH
	MOV	[BX],AL			;AND DISPLAY LINE
	INC	BX
	DEC	CL			;UNTIL DONE
	JNZ	FNEND
GOTEND:	AND	BYTE PTR FLAG,0FFH-40H	;ASSUME NO EXTENSION
	CMP	CL,3
	JNB	NOEXT
	OR	BYTE PTR FLAG,40H	;FLAG AN EXTENSION
NOEXT:	CMP	BX,OFFSET DLINE+63	;DISPLAY LINE GETTING TOO LONG?
	JB	TRMLIN			;NO
	MOV	WORD PTR [BX],'..'	;ELSE, SHOW ..., INDICATE MORE
	MOV	WORD PTR [BX+2],0D2EH	;.,CR
	MOV	WORD PTR [BX+4],240AH	;LF,'$'
	JMP	PLINE			;AND GO PRINT LINE
TRMLIN:	MOV	WORD PTR [BX],0A0DH	;TERMINATE LINE WITH CR,LF
	MOV	BYTE PTR [BX+2],'$'	;INSERT TERMINATOR

;	PREPARE TO SEARCH PATH

PPSRCH:	MOV	AL,'\'
	STOSB
	MOV	PATHE,DI		;UPDATE PATH END
	MOV	AL,'*'			;WE WANT EVERYTHING
	STOSB
	MOV	AL,'.'
	STOSB
	MOV	AL,'*'
	STOSB
	MOV	AL,0
	STOSB

;	SEARCH THE PATH

	MOV	SI,DIRPTR		;GET DIR. LIST POINTER
	MOV	DX,OFFSET PATH		;POINT TO SEARCH PATH
	MOV	CX,10H			;LOOK FOR DIRECTORY NAMES
	MOV	AH,4EH
	INT	21H			;SEARCH FOR FIRST ONE
	JNB	CHKNAM			;FOUND SOMETHING, CHECK IT
NDF:	MOV	DX,OFFSET NFMSG
	MOV	AH,9
	INT	21H			;NOTHING FOUND, SAY SO
	MOV	BX,PATHE
	MOV	BYTE PTR [BX],'$'	;TERMINATE PATH
	MOV	DX,OFFSET PATH
	MOV	AH,9			;PRINT PATH
	INT	21H
	MOV	DX,OFFSET NDMSG
	MOV	AH,9			;PRINT REST OF MSG
	INT	21H
	OR	BYTE PTR FLAG,10H	;FLAG NOTHING FOUND
	JMP	MAINX			;EXIT MAIN ROUTINE

;	A DIRECTORY ENTRY WAS FOUND.  SEE IF IT'S A DIRECTORY NAME.

CHKNAM:	CMP	WORD PTR DIRNAM,'.'	;CURRENT DIRECTORY INDICATOR?
	JNZ	CHKNM1			;NO
FNDNXT:	MOV	CX,10H
	MOV	AH,4FH
	INT	21H			;SEARCH FOR ANOTHER DIRECTORY NAME
	JB	TREE			;NO MORE, PROCESS THIS LOAD
	CMP	WORD PTR DIRNAM,'.'	;CURRENT DIRECTORY INDICATOR?
	JZ	FNDNXT			;IF SO, SKIP IT
	CMP	WORD PTR DIRNAM,'..'	;PARENT DIRECTORY?
	JNZ	CHKNM1
	CMP	BYTE PTR DIRNAM+2,0
	JZ	FNDNXT			;SKIP PARENT DIRECTORY INDICATOR
CHKNM1:	TEST	BYTE PTR ATTRIB,10H	;ENSURE THAT THIS IS A DIRECTORY NAME
	JZ	FNDNXT			;SKIP IF NOT

;	DIRECTORY NAME FOUND, MOVE IT TO TABLE

MVNAM:	OR	BYTE PTR FLAG,20H	;MARK DIRECTORY FOUND
	MOV	CX,6
	MOV	DI,SI			;LIST POINTER TO DI
	MOV	SI,OFFSET DIRNAM	;NAME IS HERE
	REPZ	MOVSW
	MOV	SI,DI			;UPDATE LIST POINTER
	JMP	SHORT FNDNXT		;FIND NEXT ENTRY

;	ALL OF THE SUB-DIRECTORIES IN A DIRECTORY HAVE BEEN FOUND.
;	TIME TO FORM A TREE GRAPHIC AND DISPLAY THEM.

TREE:	CMP	SI,DIRPTR		;ANY NAMES IN DIR. LIST
	JZ	PLINE			;IF NOT, PRINT LINE NOW
	CALL	SORT			;ELSE, SORT ENTRIES
	MOV	BX,DLPTR		;GET DISPLAY LINE POINTER

;	FIND END OF DISPLAY LINE

TREE1:	INC	BX
	MOV	AL,[BX]
	CMP	AL,CR			;CR?
	JNZ	TREE1

;	HERE THE TREE IS FORMED BY INSERTING GRAPHIC CHARACTERS
;	INTO THE DISPLAY LINE.  THE DIRECTORY LIST IS PROCESSED
;	BACKWARDS TO DETERMINE WHAT CHARACTERS TO USE.

	PUSH	DLPTR			;SAVE DISPLAY LINE POINTER
	MOV	AX,11			;SIZE ALLOWED FOR NAME
	TEST	BYTE PTR FLAG,40H	;EXTENSION?
	JZ	TREE2
	ADD	AX,4			;ALLOW SPACE FOR IT
TREE2:	ADD	DLPTR,AX		;UPDATE DISPLAY LINE POINTER
	MOV	AL,0C4H			;GET HORIZONTAL BAR
TREE3:	MOV	[BX],AL			;INSERT ONE
	INC	BX			;MOVE POINTER
	CMP	BX,DLPTR		;AT END OF BARS?
	JB	TREE3			;IF NOT, INSERT MORE BARS
	MOV	BYTE PTR [BX-2],0C2H	;INSERT DOWNWARD BRANCH 
	SUB	SI,12			;BACK UP ONE ENTRY
	CMP	SI,DIRPTR		;ALL ENTRIES DONE?
	JNZ	LKMOR			;NO, LOOK FOR SUBS IN THIS DIR.
	MOV	BX,DLPTR		;ELSE, GET END OF DISPLAY LINE
	MOV	BYTE PTR [BX-2],0C4H	;INSERT HORIZONTAL BAR
	JMP	SHORT LKLST1		;LOOK FOR SUBS IN LAST DIRECTORY
TREE4:	SUB	SI,12			;BACK UP ONE ENTRY
	CMP	SI,DIRPTR		;ALL ENTRIES DONE?
	JZ	LKLST			;YES, PROCESS LAST ENTRY

;	LOOK FOR DIRECTORIES IN CURRENT DIRECTORY

LKMOR:	CALL	MAIN			;LOOK FOR SUBS IN THIS DIRECTORY
	MOV	BX,DLPTR		;GET DISPLAY LINE POINTER
	MOV	WORD PTR [BX-2],0C4C3H	;INSERT RT. BRANCH AND BAR
	TEST	BYTE PTR FLAG,10H	;NO FILE FLAG SET?
	JZ	TREE4			;NO
	JMP	SHORT MAINX		;ELSE, EXIT

;	LOOK FOR DIRECTORIES IN LAST DIRECTORY IN LIST.

LKLST:	MOV	BX,DLPTR
	MOV	WORD PTR [BX-2],0C4C0H	;INSERT CORNER AND BAR
LKLST1:	CALL	MAIN
	POP	AX
	MOV	DLPTR,AX		;SET DISPLAY LINE POINTER
	JMP	SHORT MAINX		;AND EXIT

;	PRINT A LINE OF THE DIRECTORY TREE

PLINE:	TEST	BYTE PTR FLAG,20H	;TEST FOR DIRECTORY FOUND
	JNZ	PLINE1			;ONE WAS FOUND
	JMP	NDF			;ELSE, SAY NONE FOUND
PLINE1:	MOV	DX,OFFSET DLINE		;POINT TO DISPLAY LINE
	CALL	OUTLN			;SHOW IT
	INC	BYTE PTR LINCNT		;INCREMENT LINE COUNTER
	CMP	BYTE PTR LINCNT,23	;DONE 23 LINES?
NLINES	LABEL	BYTE
	JNZ	PPLINE			;NO, PREPARE LINE
	MOV	BYTE PTR LINCNT,0	;ZERO LINE COUNT
	MOV	AH,8
	INT	21H			;WAIT FOR KEY

;	PREPARE THE DISPLAY LINE FOR THE NEXT PRINTING BY
;	PUTTING IN PROPER GRAPHIC CHARACTERS.

PPLINE:	MOV	DI,OFFSET DLINE		;POINT TO DISPLAY LINE
	MOV	CX,DLPTR		;GET POINTER TO END OF LAST LINE
	SUB	CX,DI			;GET COUNT OF CHARACTERS
TREE5:	MOV	AL,[DI]			;GET A CHARACTER
	CMP	AL,0B3H			;VERTICAL LINE?
	JZ	TREE6
	CMP	AL,0C2H			;DOWN BRANCH?
	JZ	TREE6
	CMP	AL,0C3H			;RIGHT BANCH?
	JNZ	TREE9
TREE6:	ADD	DI,2			;SKIP CHARACTER
	CMP	DI,DLPTR		;AT END?
	JNZ	TREE7
	MOV	AL,0C3H			;INSERT RIGHT BRANCH
	MOV	CL,1			;FIX COUNTER SO WE'ER DONE
	JMP	SHORT TREE8
TREE7:	MOV	AL,0B3H			;INSERT VERTICAL LINE
TREE8:	SUB	DI,2			;BACK UP TWO CHARACTERS
	JMP	SHORT TREE10
TREE9:	MOV	AL,' '			;GET A SPACE
TREE10:	STOSB				;STORE CHARACTER
	DEC	CL			;COUNT IT
	JNZ	TREE5			;UNTIL LINE FILLED
MAINX:	POP	SI			;RESTORE POINTERS
	POP	PATHE
	POP	DIRPTR
	RET

;	SORT ROUTINE -- ARANGES NAMES IN ALPHABETICAL ORDER.
;	NAMES ARE SORTED BACKWARDS, AND THEN LIST IS PROCESSED BACKWARDS.

SORT:	PUSH	SI			;SAVE DIRECTORY LIST POINTER
	SUB	SI,12			;BACK UP ONE ENTRY
	CMP	SI,DIRPTR		;AT BEGINNING?
	JZ	SORTX			;NOTHING TO SORT
	MOV	TMPTR,SI		;SAVE POINTER
SORT1:	AND	BYTE PTR FLAG,0FFH-80H	;CLEAR SWAP FLAG
	MOV	SI,DIRPTR		;GET LIST POINTER
SORT2:	MOV	BX,SI			;POINTER IN BX
	ADD	BX,12			;MOVE TO NEXT ENTRY
	MOV	DI,BX			;IN DI
	MOV	CL,12			;SIZE OF ENTRY
SORT3:	CMPSB				;COMPARE CHARACTERS
	JNZ	SORT4			;NOT EQUAL
	DEC	CL			;ELSE COUNT THEM
	JNZ	SORT3			;UNTIL ALL CHARACTERS CHECKED
SORT4:	MOV	SI,BX			;RESTORE POINTER
	JNB	SORT6			;ALREADY IN ORDER
	OR	BYTE PTR FLAG,80H	;ELSE, MARK SWAP NEEDED
	MOV	DI,BX			;PREPARE TO DO SWAP
	SUB	SI,12
	MOV	CL,6
SORT5:	MOV	AX,[DI]			;DO SWAP HERE
	MOVSW
	MOV	[SI-2],AX
	DEC	CL
	JNZ	SORT5
SORT6:	CMP	SI,TMPTR		;BACK TO STARTING POINT?
	JNZ	SORT2			;IF NOT, MORE TO COMPARE
	TEST	BYTE PTR FLAG,80H	;SWAP DONE?
	JNZ	SORT1			;IF SO, CHECK MORE
SORTX:	POP	SI			;RESTORE POINTER
	RET

;	OUTPUT LINE WITH GRAPHIC CHARACTERS

OUTLN:	CMP	PCFLG,1			;IS THIS A PC?
	JNZ	OUTLN1			;NO
	MOV	AH,9
	INT	21H			;ELSE, USE DOS TO PRINT
	RET
OUTLN1:	PUSH	SI			;SAVE SI
	MOV	SI,DX			;POINT TO MSG
	CLD
OUTLP:	LODSB				;GET A CHARACTER
	CMP	AL,'$'			;END?
	JZ	OUTLX
	TEST	AL,80H			;TEST FOR GRAPHIC
	JZ	OUTL2			;IT'S NOT
	MOV	AH,AL			;SAVE CHARACTER
	MOV	AL,1BH
	CALL	BOUT
	MOV	AL,'F'
	CALL	BOUT			;TURN GRAPHICS ON
	MOV	AL,AH
	CMP	AL,0B3H			;TEST FOR VERTICAL BAR
	JNZ	OUTL1			;IT'S NOT
	MOV	AL,'`'			;GET Z-100 VERTICAL BAR
	JMP	SHORT OUTL1A		;PRINT IT
OUTL1:	PUSH	BX
	MOV	BX,OFFSET GRTBL		;POINT TO GRAPHIC TABLE
	SUB	AL,0C0H			;MAKE CHARACTER ZERO BASED
	XLAT				;TRANSLATE CHARACTER
	POP	BX
OUTL1A:	CALL	BOUT
	MOV	AL,1BH
	CALL	BOUT
	MOV	AL,'G'			;TURN OFF GRAPHICS
	CALL	BOUT
	JMP	OUTLP
OUTL2:	CALL	BOUT			;OUTPUT CHARACTER
	JMP	OUTLP			;LOOP UNTIL DONE
OUTLX:	POP	SI
	RET

EXPMSG	DB	13,10,'Directory Tree Display v. 1.0',13,10,10
	DB	'To use this program, enter',13,10,10
	DB	'  DT <pathname>',13,10,10
	DB	'where <pathname> is an optional path name.'
	DB	13,10,'$'
NFMSG	DB	13,10,'No directory names found in path "$'
NDMSG	DB	'".',CR,LF,'$'

GRTBL	DB	'eusva'			;GRAPHIC CHAR. TRANSLATION TABLE
PCFLG	DB	1			;PC-COMPATIBLE FLAG
FLAG	DB	0			;OPERATION FLAG
LINCNT	DB	0			;LINE COUNTER
TMPTR	DW	0			;TEMPORARY POINTER
PATHE	DW	0			;POINTER TO END OF PATH
PATH	DB	8 DUP(3FH),60 DUP(0)	;SEARCH PATH
	DB	CR,LF
	DB	'$'
MYDTA	DB	21 DUP(0)		;RESERVED AREA OF SEARCH DATABLOCK
ATTRIB	DB	9 DUP(0)		;ATTRIBUTE BYTE IN SEARCH DATA
DIRNAM	DB	'        .    $'	;NAME AREA
DLPTR	DW	0			;DISPLAY LINE POINTER
DLINE	DB	80 DUP (20H)		;DISPLAY LINE
DIRPTR	DW	OFFSET DIRLST		;DIRECTORY LIST POINTER
DIRLST	DB	0			;LIST OF DIRECTORY NAMES STARTS HERE
	CODE	ENDS
;
END	START
