	PAGE	,132
TITLE	F -- FIND
;	THIS PROGRAM CAN FIND ANY FILE OR FILES SPECIFIED
;	ON THE SPECIFIED DISK DRIVE.  IT SEARCHES ALL DIRECTORIES
;	AND LISTS ALL MATCHING FILES.
;
;	BASED ON A PUBLIC DOMAIN "WHEREIS" UTILITY.
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  05-FEB-88

CODE	SEGMENT
	ASSUME DS:CODE, SS:CODE ,CS:CODE ,ES:CODE
	ORG	100H

START:	MOV	SI,80H			;POINT TO USER ARGUMENT
	LODSB				;GET COUNT
	OR	AL,AL			;TEST IT
	JNZ	SOS			;ARGUMENT SPECIFIED
	INT	20H			;ELSE, EXIT
SOS:	CMP	BYTE PTR [SI],' '	;SPACE?
	JNZ	FNDARG			;NO
	INC	SI			;SKIP SPACE
	JMP	SOS
FNDARG:	CMP	BYTE PTR 1[SI],':'	;DRIVE SPECIFIED?
	JNZ	NODRV			;NO
	LODSW				;ELSE, GET DRIVE SPEC.
	MOV	WORD PTR PATH,AX	;PUT IT HERE
	MOV	BYTE PTR PATH+2,'\'	;AND INSERT "\"
NODRV:	MOV	DI,OFFSET BUFFER	;PUT ARGUMENT HERE
MOVARG:	LODSB				;GET A CHARACTER
	CMP	AL,0DH			;END OF ARGUMENT?
	JZ	ENDARG			;YES
	STOSB				;ELSE, STORE CHARACTER
	JMP	MOVARG			;GET MORE
ENDARG:	XOR	AL,AL
	STOSB				;ZERO END OF ARGUMENT
	MOV	DI,OFFSET PATH		;POINT TO PATH
	XOR	AL,AL
	CLD
	MOV	CX,64			;SIZE OF PATH
	REPNZ	SCASB			;LOOK FOR ZERO
	MOV	BX,DI
	DEC	BX			;BX = LOCATION OF ZERO (END OF PATH)
	MOV	DX,0			;INDICATE START OF SEARCH
	CALL	MAIN			;CALL MAIN RECURSIVE ROUTINE
	INT	20H

;	MAIN RECURSIVE SEARCH ROUTINE

MAIN:	PUSH	SI
	PUSH	DX
	CALL	CPYARG			;COPY SEARCH ARGUMENT TO PATH
	CALL	FIND			;LOOK FOR FILE
	JB	NOTFND			;NOT FOUND
	CALL	PLINE			;ELSE, SHOW IT
FNDLP:	CALL	FNDNXT			;LOOK FOR ANOTHER ONE
	JB	NOTFND			;NOT FOUND
	CALL	PLINE			;ELSE, SHOW IT
	JMP	SHORT FNDLP		;LOOP UNTIL ALL SHOWN

NOTFND:	POP	DX
	PUSH	DX
	CALL	MVWILD			;COPY WILD CARD TO PATH
	CALL	FIND			;LOOK FOR ANYTHING
	JB	NODIR			;NOTHING FOUND
	MOV	SI,DX
	TEST	BYTE PTR 21[SI],10H	;IS THIS A DIRECTORY NAME?
	JNZ	GOTDIR			;YES
LDLP:	CALL	FNDNXT			;ELSE, LOOK AGAIN
	JB	NODIR
	TEST	BYTE PTR 21[SI],10H	;IS THIS A DIRECTORY NAME?
	JZ	LDLP			;KEEP LOOKING UNTIL ONE FOUND
GOTDIR:	CMP	BYTE PTR 30[SI],'.'	;IS THIS A . OR .. DIRECTORY?
	JZ	LDLP			;CAN'T USE IT
	CALL	SCHPTH			;LOOK FOR OUR FILE
	PUSH	AX
	MOV	AH,1AH
	INT	21H			;MOVE DTA AREA
	POP	AX
	JMP	SHORT	LDLP
NODIR:	POP	DX
	POP	SI
	RET

;	A DIRECTORY HAS BEEN FOUND, SEARCH IT FOR OUR FILE(S)

SCHPTH:	PUSH	DI
	PUSH	SI
	PUSH	AX
	PUSH	BX
	CLD
	MOV	SI,DX			;GET DTA POINTER
	ADD	SI,30			;ADD SIZE OF ONE ENTRY
	MOV	DI,BX			;POINT TO END OF PATH
CLPTH:	LODSB
	STOSB				;MOVE LATEST DIR. NAME HERE
	OR	AL,AL			;UNTIL DONE
	JNZ	CLPTH
	MOV	BX,DI			;SAVE NEW END OF PATH
	STD				;GOING BACKWARDS
	STOSB				;ZERO AT END
	MOV	AL,5CH	;'\'
	STOSB				;AND "\" BEFORE
	CALL	MAIN			;LOOK DOWN NEW PATH
	POP	BX
	MOV	BYTE PTR [BX],0		;RESTORE OLD PATH
	POP	AX
	POP	SI
	POP	DI
	RET

;	PRINT LINE SHOWING PATH AND FILE FOUND

PLINE:	PUSH	AX
	PUSH	DX
	MOV	DX,OFFSET PATH		;POINT TO PATH
	MOV	AL,[BX]			;GET FIRST CHARACTER OF ARGUMENT
	MOV	BYTE PTR [BX],0		;REPLACE WITH ZERO
	MOV	BYTE PTR CHRCNT,0	;CLEAR CHARACTER COUNT
	CALL	PSTRG			;PRINT PATH (EXCLUDING ARGUMENT)
	MOV	[BX],AL			;REPLACE FIRST CHARACTER OF ARG.
	POP	DX
	PUSH	DX
	ADD	DX,30			;SKIP TO FILE NAME IN SEARCH RESULT
	CALL	PSTRG			;PRINT FILE NAME
	MOV	DL,' '			;GET A SPACE
	MOV	AH,2
	INT	21H			;SPACE AFTER NAME
	MOV	AL,CHRCNT		;GET CHARACTER COUNT
	CMP	AL,53			;HOW FAR ON LINE ARE WE
	JAE	PSIZE			;FAR ENOUGH, PRINT SIZE
	MOV	DL,'.'			;ELSE, GET A PERIOD
	MOV	AH,2
	MOV	CL,AL
PSPLP:	INT	21H			;PRINT PERIOD
	INC	CL			;COUNT IT
	CMP	CL,53			;GONE FAR ENOUGH?
	JNZ	PSPLP			;IF NOT, LOOP
PSIZE:	POP	DX			;RESTORE FOUND ENTRY POINTER
	PUSH	DX
	PUSH	SI			;SAVE SI
	MOV	SI,DX			;POINT TO FOUND ENTRY
	TEST	BYTE PTR 21[SI],10H	;IS THIS A DIRECTORY ENTRY?
	JZ	PSIZE1			;NO
	MOV	BYTE PTR NUMBUF,'.'
	MOV	WORD PTR NUMBUF+1,'< '	;ELSE, PUT <DIR> IN NUMBER BUFFER
	MOV	WORD PTR NUMBUF+3,'ID'
	MOV	WORD PTR NUMBUF+5,'>R'
	JMP	SHORT PSIZE2
PSIZE1:	MOV	AX,26[SI]		;GET SIZE LOW
	MOV	DX,28[SI]		;AND SIZE HIGH
	CALL	DDECOUT			;CONVERT TO ASCII
PSIZE2:	MOV	DX,OFFSET NUMBUF
	CALL	PSTRG			;PRINT SIZE
	CALL	P2SP			;PRINT 2 SPACES
	MOV	AX,24[SI]		;GET DATE
	MOV	CL,5
	SHR	AX,CL			;MOVE MONTH DOWN
	AND	AL,0FH			;ISOLATE MONTH
	CBW				;MAKE IT A WORD
	CWD				;MAKE IT A DOUBLE WORD
	CALL	DDECOUT			;CONVERT TO ASCII
	MOV	DX,OFFSET NUMBUF+5
	CALL	PSTRG			;PRINT MONTH
	MOV	DL,'-'
	MOV	AH,2
	INT	21H			;PRINT "-"
	MOV	AL,24[SI]		;GET DAY
	AND	AL,1FH			;ISOLATE IT
	CBW				;MAKE IT A WORD
	CWD				;AND A DOUBLE WORD
	CALL	DDECOUT			;CONVERT TO ASCII
	PUSH	SI
	MOV	SI,OFFSET NUMBUF+5	;POINT TO CONVERTED MONTH
	CMP	BYTE PTR [SI],' '	;FIRST CHARACTER SPACE?
	JNZ	PMONTH			;NO
	MOV	BYTE PTR [SI],'0'	;ELSE, REPLACE WITH ZERO
PMONTH:	MOV	DX,SI			;POINTER TO DX
	POP	SI
	CALL	PSTRG			;PRINT MONTH
	MOV	DL,'-'
	MOV	AH,2
	INT	21H			;PRINT "-"
	MOV	AL,25[SI]		;GET YEAR
	SHR	AL,1			;MOVE IT DOWN
	ADD	AL,80			;MAKE IT 80-BASED
	CBW				;MAKE IT A WORD
	CWD				;AND A DOUBLE WORD
	CALL	DDECOUT			;CONVERT TO ASCII
	MOV	DX,OFFSET NUMBUF+5
	CALL	PSTRG			;PRINT YEAR
	CALL	P2SP			;PRINT 2 SPACES
	MOV	AL,23[SI]		;GET HOUR
	MOV	CL,3
	SHR	AL,CL			;MOVE IT DOWN
	CMP	AL,12			;12 OR LATER?
	JB	MORN			;NO, MORNING
	MOV	CH,'p'			;MARK PM
	CMP	AL,13			;1 OR LATER?
	JB	PHOUR			;NO
	SUB	AL,12			;ELSE, SUBTRACT 12 HOURS
	JMP	SHORT PHOUR
MORN:	MOV	CH,'a'			;MARK AM
	OR	AL,AL			;12 AM?
	JNZ	PHOUR			;NO
	MOV	AL,12			;ELSE, MAKE IT SAY IT
PHOUR:	CBW				;MAKE HOUR A WORD
	CWD				;AND A DOUBLE WORD
	CALL	DDECOUT			;CONVERT TO ASCII
	MOV	DX,OFFSET NUMBUF+5
	CALL	PSTRG			;PRINT HOUR
	MOV	DL,':'
	MOV	AH,2
	INT	21H			;PRINT ":"
	MOV	AX,22[SI]		;GET TIME
	MOV	CL,5
	SHR	AX,CL			;MOVE MINUTES DOWN
	AND	AL,3FH			;ISOLATE MINUTES
	CBW				;MAKE MINUTES WORD
	CWD				;AND A DOUBLE WORD
	CALL	DDECOUT			;CONVERT TO ASCII
	PUSH	SI
	MOV	SI,OFFSET NUMBUF+5	;POINT TO CONVERTED MINUTE
	CMP	BYTE PTR [SI],' '	;FIRST CHARACTER SPACE?
	JNZ	PMIN			;NO
	MOV	BYTE PTR [SI],'0'	;ELSE, REPLACE WITH ZERO
PMIN:	MOV	DX,SI			;POINTER TO DX
	POP	SI
	CALL	PSTRG			;PRINT MINUTE
	MOV	DL,CH			;GET AM/PM INDICATOR
	MOV	AH,2
	INT	21H			;PRINT IT
	POP	SI
	POP	DX
	CALL	PCRLF			;AND CR, LF
	POP	AX
	RET

;	COPY USER'S SEARCH ARGUMENT TO PATH

CPYARG:	PUSH	SI
	MOV	SI,OFFSET BUFFER
	CALL	MOVE
	POP	SI
	RET

;	MOVE WILD CARD DESIGNATION INTO PATH

MVWILD:	PUSH	SI
	MOV	SI,OFFSET WILD
	CALL	MOVE
	POP	SI
	RET

;	MOVE CHARACTERS FROM (SI) TO (BX) UNTIL ZERO FOUND

MOVE:	PUSH	AX
	PUSH	DI
	MOV	DI,BX			;DESTINATION TO DI
	CLD
MOVE1:	LODSB				;GET A CHARACTER
	STOSB				;STORE IT
	OR	AL,AL			;DONE?
	JNZ	MOVE1			;IF NOT, LOOP
	POP	DI
	POP	AX
	RET

FIND:	PUSH	CX
	CMP	DX,0
	JA	FIND1
	MOV	DX,(OFFSET BUFFER)-30	;PROVIDE DTA ADDR IF STARTING OUT
FIND1:	ADD	DX,43			;ADD SIZE OF A SEARCH ENTRY
	MOV	CX,10H			;INCLUDE DIR NAMES IN SEARCH
	MOV	AH,1AH			;SET DTA FOR SEARCH
	INT	21H
	PUSH	DX
	MOV	DX,OFFSET PATH
	MOV	AH,4EH
	INT	21H			;SEARCH THE PATH
	POP	DX
	POP	CX
	RET

FNDNXT:	PUSH	CX
	PUSH	DX
	MOV	DX,OFFSET PATH
	MOV	CX,10H
	MOV	AH,4FH
	INT	21H
	POP	DX
	POP	CX
	RET

;	PRINT 2 SPACES

P2SP:	MOV	AH,2
	MOV	DL,' '
	INT	21H
	INT	21H
	RET

;	PRINT CR, LF

PCRLF:	PUSH	AX
	PUSH	DX
	MOV	AH,2
	MOV	DL,0AH
	INT	21H
	MOV	DL,0DH
	INT	21H
	POP	DX
	POP	AX
	RET

;	PRINT CHARACTERS UNTIL ZERO FOUND

PSTRG:	PUSH	AX
	PUSH	DX
	PUSH	SI
	CLD
	MOV	SI,DX			;STRING POINTER TO SI
	MOV	AH,2			;USE DOS FUNCTION 2
	LODSB				;GET A CHARACTER
PSTLP:	MOV	DL,AL			;IN DL
	INT	21H			;PRINT IT
	INC	BYTE PTR CHRCNT		;COUNT IT
	LODSB				;GET NEXT CHARACTER
	OR	AL,AL			;END OF STRING?
	JNZ	PSTLP			;LOOP UNTIL END
	POP	SI
	POP	DX
	POP	AX
	RET

;	DDECOUT - PRINT 32 BIT NO. IN DX,AX IN DECIMAL
;	(DX) = HIGH WORD, (AX) = LOW WORD
;	ASCII NUMBER PLACED IN (NUMBUF)

DDECOUT:PUSH	AX			;SAVE REGISTERS
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	XOR	SI,SI			;CLEAR ZERO SUPPRESS FLAG
	MOV	DI,OFFSET TNBUF		;OUTPUT POINTER TO DI
	CLD				;CLEAR DIR FLAG
	MOV	CX,3B9AH
	MOV	BX,0CA00H		;CX,BX = 1,000,000,000
	CALL	DIVPR			;DIVIDE AND PRINT
	MOV	CX,5F5H
	MOV	BX,0E100H		;CX,BX = 100,000,000
	CALL	DIVPR
	MOV	CX,98H
	MOV	BX,9680H		;CX,BX = 10,000,000
	CALL	DIVPR
	MOV	CX,0FH
	MOV	BX,4240H		;CX,BX = 1,000,000
	CALL	DIVPR
	MOV	CX,1
	MOV	BX,86A0H		;CX,BX = 100,000
	CALL	DIVPR
	MOV	CX,0
	MOV	BX,10000		;CX,BX = 10000
	CALL	DIVPR
	MOV	CX,0
	MOV	BX,1000			;CX,BX = 1000
	CALL	DIVPR
	MOV	CX,0
	MOV	BX,100			;CX,BX = 100
	CALL	DIVPR
	MOV	CX,0
	MOV	BX,10			;CX,BX = 10
	CALL	DIVPR
	ADD	AL,'0'			;ADD ASCII TO ONE'S DIGIT
	STOSB				;STORE IT
	DEC	DI			;POINT TO LAST DIGIT
	MOV	SI,DI			;POINTER TO SI
	MOV	DI,OFFSET NUMBUF+6	;POINT TO END OF NUMBER BUFFEF
	STD				;GO BACKWARDS
	MOV	CX,7			;7 DIGITS MAX
MOVNUM:	LODSB				;GET A DIGIT
	OR	AL,AL			;NUMBER DONE?
	JZ	NUMSPC			;YES, DO SPACES
	STOSB				;ELSE, STORE DIGIT
	LOOP	MOVNUM
NUMSPC:	OR	CX,CX			;ANY SPACES TO DO
	JZ	NOSPC			;NO
NUMSPC1:CMP	CL,1			;ONLY 1?
	JZ	NUMPER			;PUT IN A PERIOD
	MOV	AL,' '
	STOSB				;ELSE, PUT IN A SPACE
	LOOP	NUMSPC1
NUMPER:	MOV	AL,'.'
	STOSB
NOSPC:	CLD				;FIX DIR FLAG
	POP	BP			;RESTORE REGISTERS
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET				;AND RETURN
DIVPR:	MOV	BP,-1			;SET A COUNTER
DIVPR1:	INC	BP			;INCREMENT COUNTER
	SUB	AX,BX			;SUBTRACT DIVISOR
	SBB	DX,CX
	JNB	DIVPR1			;REPEAT UNTIL OVERFLOW
	ADD	AX,BX			;ADD DIVISOR BACK IN ONCE
	ADC	DX,CX
	PUSH	AX			;SAVE AX
	MOV	AX,BP			;GET COUNTER (WHICH IS DIGIT)
	ADD	AL,'0'			;ADD ASCII OFFSET
	TEST	SI,2			;CKECK ZERO FLAG
	JNZ	DIVPR2			;PASSED LEADING ZEROS, PRINT NO.
	CMP	AL,'0'			;IS NO. ZERO?
	JZ	DIVPR3			;IF SO, EXIT
	OR	SI,2			;ELSE, FLAG ZEROS PASSED
DIVPR2:	STOSB				;STORE NO.
DIVPR3:	POP	AX			;RESTORE AX
	RET

CHRCNT	DB	0			;CHARACTER COUNT
	DB	0			;ZERO BEFORE TEMP. NUMBER BUFFER
TNBUF	DB	7 DUP (0)		;TEMP. NUMBER BUFFER
NUMBUF	DB	'       '		;NUMBER OUTPUT BUFFER
	DB	0			;ZERO AFTER NUMBER BUFFER
WILD	DB	'*.*',0
PATH	DB	'\'
	DB	64 DUP(0)

;	THIS BUFFER HOLDS THE USER ARGUMENT AND THE RESULT
;	OF DIRECTORY SEARCHES.

BUFFER	DB	0
	CODE	ENDS

END	START
