;	FTEST -- FAST DISK FORMATTED TEST
;	THIS PROGRAM TESTS IF A DISK IS FORMATTED.
;	TO USE THIS PROGRAM, ENTER
;
;	FTEST [d:]
;
;	WHERE d: IS THE DRIVE TO TEST.  IF THE DRIVE
;	IS NOT SPECIFIED, THE DEFAULT DRIVE IS USED.
;	INSPIRED BY Z-100 IS.COM BY PAUL F. HERMAN.
;	PC VERSION BY P. SWAYNE, HUG SOFTWARE ENGINEER.
;	THE Z-100 PORTION OF THIS CODE WAS ORIGINALLY
;	WRITTEN BY PAUL F. HERMAN.  USED HERE BY PERMISSION.

BIOS	SEGMENT AT 40H
	ORG	0
JMPTBL	LABEL	BYTE		;Z-100 JUMP TABLE IS HERE
	ORG	48H
DSK_F	LABEL	FAR		;DEFIND BIOS DSK_FUNC
BIOS	ENDS

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	5CH
FCB	LABEL	BYTE		;DEFINE DEFAULT FCB
	ORG	100H

;	GET DRIVE SPECIFIED

START:	MOV	AL,FCB		;GET SPECIFIED DRIVE
	DEC	AL		;ANY SPECIFIED?
	JNS	GOTDRV		;YES
	MOV	AH,19H
	INT	21H		;ELSE, GET DEFAULT DRIVE
GOTDRV:	MOV	BX,BIOS
	MOV	DS,BX
	ASSUME	DS:BIOS
	CMP	JMPTBL,0E9H	;IS THIS A Z-100?
	PUSH	CS
	POP	DS		;FIX DS
	ASSUME	DS:CODE
	JZ	Z100		;IT'S A Z-100

;	COMPUTER IS A PC, DO PC TEST.

	MOV	DL,AL		;DRIVE TO DL
	PUSH	DX		;SAVE DRIVE
	MOV	AH,0
	INT	13H		;RESET DRIVES
	POP	DX
	MOV	BL,2		;SET RETRY COUNT
RETRY:	MOV	AX,401H		;FUNCTION 4, 1 SECTOR
	XOR	DH,DH		;HEAD 0
	MOV	CX,1		;TRACK 0, SECTOR 1
	PUSH	BX
	PUSH	DX
	INT	13H		;TEST THE DISK
	POP	DX
	POP	BX
	OR	AH,AH		;TEST RESULT
	JZ	DSKGD		;DISK IS GOOD
	DEC	BL		;TRY AGAIN?
	JNZ	RETRY		;YES
DSKNG:	MOV	DX,OFFSET NFMSG
	JMP	PMSG		;ELSE, SAY "NOT FORMATTED"
DSKGD:	MOV	DX,OFFSET FMSG
PMSG:	MOV	AH,9
	INT	21H
	INT	20H		;EXIT

;	COMPUTER IS A Z-100, DO Z-100 TEST

Z100:	MOV	DRIVE,AL	;SAVE DRIVE CODE
	CMP	AL,7		;TEST DRIVE CODE
	JBE	DRVOK		;IT'S OK
	MOV	DX,OFFSET BADDRV
	JMP	PMSG		;ELSE, SAY IT'S NOT
DRVOK:	MOV	AL,8
	CALL	DSK_F		;GET DRIVE PARAMETER VECTOR TABLE
	MOV	AL,DRIVE	;GET DRIVE
	XOR	AH,AH		;AX = DRIVE
	SHL	AX,1
	ADD	BX,AX		;FIND VECTOR FOR THIS DRIVE
	MOV	BX,ES:[BX]	;GET START OF DISK INFO BLOCK
	PUSH	ES:16[BX]	;SAVE ORIGINAL RETRY COUNT
	MOV	BYTE PTR ES:16[BX],0	;SET NO RETRIES
	PUSH	ES		;SAVE BLOCK START
	PUSH	BX
	PUSH	DS
	POP	ES		;PUT ES HERE
	MOV	BX,OFFSET DSKPR	;POINT TO OUR TABLE
	MOV	AL,4		;VERIFY FUNCTION
	CALL	DSK_F		;VERIFY SECTOR 1 ON DISK
	POP	BX		;RESTORE BLOCK START
	POP	ES
	POP	ES:16[BX]	;REPLACE OLD RETRY COUNT
	JC	DSKNG		;DISK NO GOOD
	JMP	DSKGD

DSKPR	LABEL	NEAR		;LOCAL DISK PARAMETER TABLE
DRIVE	DB	?		;DRIVE CODE
SECTOR	DW	1		;SECTOR 1
COUNT	DW	1		;ONLY ONE SECTOR
DTAOFF	DW	?		;BUFFER ADDRESS DOESN'T MATTER
DTASEG	DW	?
LEN	DW	9		;LENGTH OF TABLE

BADDRV	DB	'Bad drive specified.$'
NFMSG	DB	'This disk is not formatted.$'
FMSG	DB	'This disk is formatted.$'

CODE	ENDS
	END	START
