	PAGE	,132
;	CROSS-HATCH GENERATOR PROGRAM FOR THE Z-449 CARD
;	AND ZCM-1490 OR ZCM-1390 MONITOR.
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  04-NOV-88

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	5DH
ARG1	LABEL	WORD			;DEFINE ARGUMENT 1
	ORG	6DH
ARG2	LABEL	BYTE			;DEFINE ARGUMENT 2
	ORG	100H

START:	MOV	AX,ARG1			;GET ARGUMENT 1
	CMP	AL,' '			;ANYTHING THERE?
	JNZ	GOTARG			;YES
NOARG:	MOV	DX,OFFSET EXPL
	MOV	AH,9
	INT	21H			;SHOW EXPLANATION MSG
	INT	20H			;AND EXIT
GOTARG:	CALL	CONBIN			;CONVERT TO BINARY
	MOV	BL,AL			;FOREGROUND TO BH
	MOV	AX,10
	INT	10H			;SET VIDEO MODE 10
	MOV	CX,34			;SET A COUNTER
	MOV	BH,0			;USE PAGE 0
	MOV	DX,0			;SET STARTING CURSOR POSITION
	CMP	ARG2,'C'		;SET COURSE HATCH?
	JZ	SHOWC			;YES
DISPLP:	MOV	SI,OFFSET HATCH
	CALL	SHOLINE			;SHOW A LINE
	LOOP	DISPLP			;DO ENTIRE SCREEN
EXIT:	MOV	AH,8
	INT	21H			;WAIT FOR KEY
	MOV	AX,3
	INT	10H			;RESTORE MODE 3
	INT	20H			;EXIT
SHOWC:	SHR	CX,1			;CUT COUNT IN HALF
DISPLP2:MOV	SI,OFFSET HATCH2
	CALL	SHOLINE			;SHOW FIRST TYPE OF LINE
	MOV	SI,OFFSET HATCH3
	CALL	SHOLINE			;SHOW OTHER TYPE
	LOOP	DISPLP2
	JMP	EXIT

CONBIN:	CMP	AH,' '			;SINGLE DIGIT?
	JNZ	GOT2D			;NO
	SUB	AL,'0'			;ELSE, REMOVE ASCII
	RET				;AND RETURN
GOT2D:	SUB	AH,'0'			;FIX LOW DIGIT
	MOV	AL,10			;ASSUME NOT > 19
	ADD	AL,AH			;ADD LOW DIGIT
	AND	AL,0FH			;ENSURE <= 15
	RET

;	SHOW A LINE ON THE SCREEN

SHOLINE:CLD
	PUSH	CX			;SAVE LINE COUNTER
	MOV	CX,80			;GET COLUMN COUNT
LINELP:	MOV	AH,2
	INT	10H			;POSITION CURSOR
	INC	DL			;MOVE TO NEXT COLUMN
	LODSB				;GET A CHARACTER
	PUSH	CX			;SAVE COUNT
	MOV	CX,1
	MOV	AH,9
	INT	10H			;WRITE CHARACTER
	POP	CX
	LOOP	LINELP			;DO ONE LINE
	XOR	DL,DL			;MOVE TO COLUMN 0
	INC	DH			;MOVE TO NEXT LINE
	POP	CX
	RET

HATCH:
	REPT	40
	DB	0C5H,0C4H
	ENDM
	DB	0
HATCH2:
	REPT	20
	DB	0C4H,0C5H,0C4H,0C4H
	ENDM
	DB	0
HATCH3:
	REPT	20
	DB	' ',0B3H,'  '
	ENDM
	DB	0

EXPL	DB	13,10,'This program draws a cross-hatch pattern on your'
	DB	13,10,'screen in the 640x480 mode in your selected color.'
	DB	13,10,'To use this program, enter'
	DB	13,10,10,'  HATCH n[,C]'
	DB	13,10,10,'where n is the number of the color you want to'
	DB	13,10,'be used for the cross-hatch pattern.  Add C after'
	DB	13,10,'the number for a course pattern (fewer lines).'
	DB	13,10,10,'Available colors are:',13,10,10
PCCOL	DB	'0  black     4  red       8  dk gray   12  br red',13,10
	DB	'1  blue      5  magenta   9  br blue   13  br magenta',13,10
	DB	'2  green     6  brown    10  br green  14  yellow',13,10
	DB	'3  cyan      7  gray     11  br cyan   15  white',13,10,'$'

CODE	ENDS
	END	START
