	PAGE	,132
;	THIS PROGRAM PRINTS THE CODE OF ANY KEY PRESSED
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  26-AUG-88

TRUE	EQU	0FFFFH			;DEFINE TRUE
FALSE	EQU	NOT TRUE		;AND FALSE
BIOSCOD	EQU	TRUE			;SHOW BIOS KEY CODES

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGN-ON
	MOV	AX,3509H
	INT	21H			;GET INT 9 VECTOR
	MOV	INT09V,BX		;SAVE IT
	MOV	INT09V+2,ES
	MOV	AX,2509H
	MOV	DX,OFFSET INT09
	INT	21H			;VECTOR KEYBOARD TO HERE
	MOV	AX,40H
	MOV	ES,AX			;POINT TO BIOS RAM
	MOV	SI,6CH			;POINT TO TIMER
	MOV	AL,ES:[SI]		;GET TIC COUNT
	ADD	AL,18			;ADD 1 SECOND
WAIT1S:	CMP	AL,ES:[SI]		;1 SECOND UP?
	JNZ	WAIT1S			;IF NOT, WAIT
	MOV	TICCNT,AL		;STORE TIC COUNT
	MOV	BX,OFFSET KEYBUF
	MOV	TPTR,BX			;FIX TAIL POINTER
	MOV	HPTR,BX			;AND HEAD POINTER
	MOV	DX,OFFSET BEGIN
	MOV	AH,9
	INT	21H			;SAY "BEGIN"
	CLD
WLOOP:	CMP	BYTE PTR CRLFFLG,1	;CRLF ALREADY SENT?
	JZ	TICSAM			;YES
	MOV	AL,ES:[SI]		;GET TIC COUNT
	CMP	AL,TICCNT		;COMPARE WITH SAVED COUNT
	JZ	TICSAM			;SAME
	MOV	TICCNT,AL		;ELSE, UPDATE COUNT
	MOV	AL,MYTIC		;GET MY COUNT
	INC	AL			;ADD ONE
	MOV	MYTIC,AL		;SAVE IT
	CMP	AL,18			;ONE SECOND GONE?
	JNZ	TICSAM			;NO
	MOV	DX,OFFSET CRLF
	CALL	PMSG			;ELSE, PRINT CRLF
	MOV	BYTE PTR CRLFFLG,1	;MARK CRLF SENT
RESCNT:	MOV	BYTE PTR MYTIC,0	;RESET MY COUNT
TICSAM:	MOV	BX,TPTR			;GET TAIL POINTER
	CMP	BX,HPTR			;SAME PLACE AS HEAD POINTER?
	JZ	WLOOP			;IF SO, WAIT FOR KEY
	MOV	AL,[BX]			;GET KEY
	INC	BX			;INCREMENT POINTER
	CMP	BX,OFFSET KEYBUF+10	;AT END?
	JNZ	TNEND			;NO
	MOV	BX,OFFSET KEYBUF	;ELSE, RESET POINTER
TNEND:	MOV	TPTR,BX			;UPDATE TAIL POINTER
	MOV	BYTE PTR KEYCODE,AL	;SAVE KEY CODE
	MOV	BL,AL			;KEY TO BL
	MOV	DX,OFFSET KEYMSG
	CALL	PMSG			;SAY "THE KEY IS"
	MOV	AL,BL
	CALL	HEXOUT			;PRINT KEY IN HEX
	MOV	DX,OFFSET DECMSG
	CALL	PMSG			;PRINT "IN DECIMAL"
	XOR	BH,BH
	CALL	DECOUT			;PRINT KEY IN DECIMAL
	IF	BIOSCOD
	CMP	BL,0E0H			;EXTENDED KEY?
	JZ	NOABS			;IF SO, DON'T PRINT BIOS CODE NOW
	MOV	AH,1
	INT	16H			;SEE IF ABSORPTION NEEDED
	JZ	NOABS			;NOT NEEDED
	MOV	AH,0
	INT	16H			;ELSE, ABSORB KEY
	MOV	BX,AX			;SAVE BIOS CODE
	MOV	DX,OFFSET BIOSMSG
	CALL	PMSG			;PRINT BIOS MESSAGE
	MOV	AL,BH			;GET BIOS CODE HIGH
	CALL	HEXOUT			;PRINT IT
	MOV	AL,BL			;GET BIOS CODE LOW
	CALL	HEXOUT			;PRINT IT
NOABS:
	ENDIF
	MOV	BYTE PTR MYTIC,0	;START COUNTER
	MOV	BYTE PTR CRLFFLG,0	;ALLOW CRLF
	CMP	BYTE PTR KEYCODE,81H	;ESCAPE KEY
	JZ	QUIT			;IF SO, QUIT
	JMP	WLOOP
QUIT:
	IF	BIOSCOD
	MOV	AH,1
	INT	16H			;ANY KEY TO ABSORB?
	JZ	QUIT1			;NO
	MOV	AH,0
	INT	16H			;ELSE, ABSORB IT
	JMP	QUIT			;TEST AGAIN
	ENDIF
QUIT1:	MOV	DX,INT09V		;GET OLD KEY VECTOR
	MOV	DS,INT09V+2
	MOV	AX,2509H
	INT	21H			;FIX KEYBOARD VECTOR
	INT	20H

;	KEYBOARD INTERRUPT PROCESSOR

INT09:	PUSH	AX			;SAVE AX
	PUSH	BX			;AND BX
	IN	AL,60H			;READ KEY
	MOV	BX,CS:HPTR		;GET HEAD POINTER
	MOV	CS:[BX],AL		;SAVE KEY
	INC	BX			;INCREMENT POINTER
	CMP	BX,OFFSET KEYBUF+10	;AT END OF BUFFER?
	JNZ	HNEND			;NO
	MOV	BX,OFFSET KEYBUF
HNEND:	MOV	CS:HPTR,BX		;SAVE HEAD POINTER
	POP	BX
	IF	BIOSCOD
	POP	AX
	JMP	CS:DWORD PTR INT09V	;TO TO OTHER PROCESSORS
	ELSE
	IN	AL,61H			;PREPARE TO ABSORB KEY
	OR	AL,80H
	OUT	61H,AL			;ABSORB KEY
	AND	AL,7FH
	OUT	61H,AL
	MOV	AL,20H
	OUT	20H,AL			;RESET INT. CONTROLLER
	POP	AX
	IRET
	ENDIF

;	PRINT AL IN HEX

HEXOUT:	PUSH	AX
	AND	AL,0F0H
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1			;MOVE HIGH NIBBLE DOWN
	CALL	CVTNIB			;PRINT IT
	POP	AX
	AND	AL,0FH
CVTNIB:	ADD	AL,90H			;CONVERT TO HEX ASCII
	DAA
	ADC	AL,40H
	DAA
	CALL	OUTCH
	RET

;	DECOUT - PRINT BX IN DECIMAL
;	THIS IS A TRICKY ROUTINE THAT MAKES USE OF THE
;	STACK TO STORE DECODED DIGITS.

DECOUT:	PUSH	CX
	PUSH	DX
	PUSH	BX			;SAVE REGISTERS
	MOV	CX,10			;RADIX FOR CONVERSION
	MOV	DX,0
	MOV	AX,BX
	DIV	CX			;DIVIDE BY 10
	MOV	BX,AX			;ANSWER TO BX (DX [REMAINDER] = DIGIT)
	CMP	BX,0			;DONE?
	JZ	DEC1	
	CALL	DECOUT			;CALL RECURSIVELY UNTIL DONE
DEC1:	ADD	DL,'0'			;ADD ASCII BIAS
	MOV	AL,DL
	CALL	OUTCH			;PRINT DIGIT
	POP	BX			;RESTORE REGISTERS
	POP	DX
	POP	CX
	RET

;	PRINT MESSAGE WITHOUT USING DOS

PMSG:	PUSH	SI
	MOV	SI,DX			;POINT TO STRING
	CLD
PMSGLP:	LODSB				;GET A CHARACTER
	CMP	AL,'$'			;END OF STRING?
	JZ	PMSGX			;YES
	CALL	OUTCH			;ELSE, PRINT CHARACTER
	JMP	PMSGLP
PMSGX:	POP	SI
	RET

;	OUTPUT CHARACTER

OUTCH:	PUSH	DX
	PUSH	SI
	MOV	AH,14
	INT	10H			;PRINT CHARACTER
	POP	SI
	POP	DX
	RET

;	DATA AREA

KEYBUF	DB	10 DUP (0)
TPTR	DW	OFFSET KEYBUF
HPTR	DW	OFFSET KEYBUF
KEYCODE	DB	0			;CURRENT KEY CODE
TICCNT	DB	0			;STORE TIC COUNT HERE
MYTIC	DB	0			;MY TIC COUNT
CRLFFLG	DB	1			;CRLF FLAG
INT09V	DW	0,0			;INT 9 VECTOR

SIGNON	DB	13,10,'HUG Keyboard Code Reporter, v. 1.0',13,10,10
	DB	'Wait one second... $'
BEGIN	DB	'Begin testing.',13,10,10,'$'
KEYMSG	DB	13,10,'Hardware interrupt code: $'
DECMSG	DB	', in decimal: $'
BIOSMSG	DB	13,10,'BIOS keyboard code returned: $'
CRLF	DB	13,10,'$'

CODE	ENDS
	END	START
