	PAGE	,132
;	THIS PROGRAM IS A SHELL THAT RUNS A PROGRAM AT A
;	MUCH SLOWER SPEED THAN NORMAL, BY HAVING THE TRAP
;	INTERRPT ACTIVE WHILE THE PROGRAM IS RUNNING.
;
;	TO USE THIS PROGRAM, ENTER
;
;	RUNPROG <PROGRAM> [<ARGUMENTS>]
;
;	WHERE <PROGRAM> IS THE COMPLETE PATH NAME DESCRIBING 
;	THE PROGRAM YOU WANT TO RUN, AND <ARGUMENTS> ARE ANY
;	ARGUMENTS REQUIRED BY THE PROGRAM.
;
;	COPYRIGHT (C) HEATH/ZENITH USERS' GROUP 1988.  ALL RIGHTS RESERVED.
;
;	BY PATRICK SWAYNE, HUG SOFTWARE ENGINEER  11-AUG-88

TFMASK	EQU	100H			;TRAP FLAG MASK

RETF	MACRO	DISP			;DEFINE FAR RET W/DISP.
	LOCAL	DUMMY
DUMMY	PROC	FAR
	RET	DISP
DUMMY	ENDP
	ENDM

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	0
ZERO	LABEL	NEAR
	ORG	2CH
ENVSEG	LABEL	WORD			;ENVIRONMENT SEGMENT
	ORG	5CH
FCB1	LABEL	BYTE			;FIRST FCB
	ORG	6CH
FCB2	LABEL	BYTE			;SECOND FCB
	ORG	80H
ARG	LABEL	BYTE			;ARGUMENT AREA
	ORG	100H

;	SET UP FOR EXECUTION OF PROGRAM

START:	MOV	DX,OFFSET SIGNON
	CALL	PMSG			;PRINT SIGN-ON
	MOV	AH,30H
	INT	21H			;GET DOS VERSION
	CMP	AL,2			;TEST IT
	JNB	VERSOK			;VERSION OK
	MOV	DX,OFFSET BADVER
	CALL	PMSG			;SAY "BAD VERSION"
	INT	20H
VERSOK:	MOV	FCB1,0			;ZERO FCB1 DRIVE
	MOV	FCB2,0			;AND FCB2 DRIVE
	CLD
	MOV	DI,OFFSET FCB1+1
	MOV	AL,' '
	MOV	CX,11
	REP	STOSB			;CLEAR FCB1
	MOV	DI,OFFSET FCB2+1
	MOV	CX,11
	REP	STOSB			;CLEAR FCB2
	MOV	SI,OFFSET ARG		;POINT TO USER ARGUMENT
	MOV	DI,OFFSET ENDADR	;POINT TO FREE SPACE
	MOV	CX,80H/2
	REP	MOVSW			;COPY ARGUMENT THERE
	MOV	SI,OFFSET ENDADR	;NOW, POINT TO IT HERE
	LODSB				;GET COUNT
	OR	AL,AL			;ANY COUNT?
	JNZ	GOTINP			;YES, WE HAVE USER INPUT
NOINP:	MOV	DX,OFFSET NPMSG
	CALL	PMSG			;ELSE, SAY "NO PROGRAM"
	INT	20H

;	GET THE PROGRAM NAME

GOTINP:	XOR	AH,AH			;MAKE COUNT A WORD
	MOV	CX,AX			;COUNT TO CX
	CALL	SOS			;SKIP SPACES
	JZ	NOINP			;NO USER INPUT
	MOV	DI,OFFSET PRGNAM	;PUT PROGRAM NAME HERE
MOVPGM:	LODSB				;GET A CHARACTER
	CMP	AL,' '			;END OF PROGRAM NAME?
	JZ	GOTSW			;YES
	CMP	AL,13			;COULD END IN CR
	JZ	GOTEND
	CMP	AL,'/'			;COULD END IN SWITCH
	JZ	GOTSW
	STOSB				;STORE IT
	LOOP	MOVPGM			;ELSE, LOOP
	JMP	NOARG			;RAN OUT OF CHARACTERS, NO ARGUMENT
GOTSW:	DEC	SI			;BACK UP TO SWITCH
	INC	CX			;CANCEL NEXT DEC
GOTEND:	DEC	CX			;COUNT THE SEPARATOR
	MOV	BYTE PTR [DI],0		;NULL END OF PROGRAM NAME
	JZ	NOARG			;NO ARGUMENT SPECIFIED

;	SET UP THE COMMAND ARGUMENT AND THE FCB'S

	PUSH	CX			;SAVE COUNT
	PUSH	SI			;AND LOCATION
	MOV	ARG,CL			;SAVE ARGUMENT LENGTH
	MOV	DI,OFFSET ARG+1		;PUT PROGRAM ARGUMENT HERE
	REP	MOVSB			;MOVE ARGUMENT
	POP	SI			;RESTORE POINTER
	POP	CX			;AND COUNT
	CALL	SOS			;SKIP SPACES
	JZ	NOARG
	MOV	DI,OFFSET FCB1		;POINT TO FIRST FCB
	MOV	AX,2900H
	PUSH	SI			;SAVE POINTER
	INT	21H			;PARSE FIRST NAME
	POP	SI
FNDTRM:	MOV	AL,[SI]			;GET NEXT CHARACTER
	CMP	AL,' '			;SPACE?
	JZ	GOTTRM
	CMP	AL,','			;COMMA?
	JZ	GOTTRM
	CMP	AL,';'			;SEMI?
	JZ	GOTTRM
	CMP	AL,'='
	JZ	GOTTRM
	INC	SI
	LOOP	FNDTRM			;LOOK FOR TERMINATOR
	JMP	SHORT GOTARG		;NONE FOUND, NO 2ND ARG
GOTTRM:	INC	SI			;PASS OVER TERMINATOR
	DEC	CX			;COUNT IT
	JZ	NOARG			;THAT WAS THE END
	CALL	SOS			;SKIP ANY SPACES
	JZ	NOARG			;ONLY SPACES LEFT
	MOV	DI,OFFSET FCB2		;POINT TO SECOND FCB
	MOV	AX,2900H
	INT	21H			;PARSE SECOND NAME
	JMP	SHORT GOTARG
NOARG:	MOV	WORD PTR ARG,0D00H	;INSERT NULL COUNT, CR
GOTARG:	CLI
	MOV	SP,OFFSET ENDADR	;PUT STACK HERE
	STI

;	PROCESS PROGRAM NAME

	MOV	DX,OFFSET FNDBUF
	MOV	AH,1AH
	INT	21H			;SET DTA TO FIND BUFFER
	XOR	BP,BP			;CLEAR EXTENSION FLAG
	MOV	DI,OFFSET PRGNAM	;POINT TO PROGRAM NAME
	MOV	AL,'.'
	MOV	CX,80
	REPNZ	SCASB			;LOOK FOR "."
	JNZ	NOEXT			;NO EXTENSION SPECIFIED
	CMP	WORD PTR [DI],'OC'	;LOOK FOR "COM"
	JNZ	NOTCOM			;NOT "COM"
	CMP	BYTE PTR 2[DI],'M'
	JZ	LOOK2			;WE HAVE COM
NOINPJ:	JMP	NOINP			;EXPLAIN PROGRAM
NOTCOM:	CMP	WORD PTR [DI],'XE'	;LOOK FOR "EXE"
	JNZ	NOINPJ			;NOT "EXE"
	CMP	BYTE PTR 2[DI],'E'
	JZ	LOOK2			;EXTENSION SPECIFIED, LOOK FOR FILE
	JMP	NOINPJ
NOEXT:	INC	BP			;FLAG EXTENSION SUPPLIED
	MOV	DI,OFFSET PRGNAM
	XOR	AL,AL
	MOV	CX,80
	REPNZ	SCASB			;ELSE, LOOK FOR END
	DEC	DI			;POINT TO IT
	MOV	WORD PTR [DI],'C.'	;MOVE IN .COM
	MOV	WORD PTR 2[DI],'MO'
	MOV	DX,OFFSET PRGNAM
	MOV	CX,0
	MOV	AH,4EH
	INT	21H			;LOOK FOR PROGRAM
	JNC	GOTPRG			;GOT IT
	MOV	BYTE PTR 1[DI],'E'	;ELSE, MAKE PROGRAM .EXE
	MOV	WORD PTR 2[DI],'EX'
LOOK2:	MOV	CX,0
	MOV	AH,4EH
	MOV	DX,OFFSET PRGNAM
	INT	21H			;LOOK FOR PROGRAM
	JNC	GOTPRG			;GOT IT
	MOV	DX,OFFSET NOFIND
	CALL	PMSG			;ELSE, SAY "CAN'T FIND"
	OR	BP,BP			;EXTENSION SUPPLIED?
	JZ	NOEXS			;NO
	MOV	WORD PTR [DI],0A0DH	;ELSE, INSERT CR,LF
	MOV	BYTE PTR 2[DI],'$'
NOEXS:	MOV	DX,OFFSET PRGNAM
	CALL	PMSG			;PRINT FILE NAME
	INT	20H
GOTPRG:

;	PREPARE TO RUN THE PROGRAM

PRPRUN:	MOV	AX,0
	MOV	DS,AX			;POINT TO INT SEGMENT
	MOV	SI,4			;POINT TO TRAP VECTOR
	MOV	DI,OFFSET INT01V	;PUT VECTOR HERE
	PUSH	SI
	CLD
	MOVSW				;COPY VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET MYTRAP	;VECTOR TO HERE
	MOV	2[SI],CS
	MOV	SI,16H*4		;POINT TO KEYBOARD VECTOR
	MOV	DI,OFFSET INT16V	;PUT VECTOR HERE
	PUSH	SI
	MOVSW				;COPY VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET MYKEY	;VECTOR TO HERE
	MOV	2[SI],CS
	MOV	SI,21H*4		;POINT TO SYSTEM VECTOR
	MOV	DI,OFFSET INT21V	;PUT VECTOR HERE
	PUSH	SI
	MOVSW				;COPY VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET MYSYS	;VECTOR TO HERE
	MOV	2[SI],CS
	PUSH	CS
	POP	DS			;FIX DS
	MOV	BX,(ENDADR-ZERO+15) SHR 4	;POINT TO END PARA.
	MOV	AH,4AH
	INT	21H			;FREE UP MEMORY FOR PROGRAM TO RUN
	JC	CNTEX			;SOMETHING'S WRONG
	MOV	AX,ENVSEG
	MOV	PBENV,AX		;SET UP ENV. SEGMENT ADDRESS
	MOV	PBCMD+2,CS		;SET UP SEGMENT FOR CMD LINE
	MOV	PBFCB1+2,CS		;SET UP FCB1 SEGMENT
	MOV	PBFCB2+2,CS		;SET UP FCB2 SEGMENT

;	RUN THE PROGRAM

	MOV	DX,OFFSET PRGNAM	;POINT TO PROGRAM NAME
	MOV	BX,OFFSET PBLOCK	;AND TO PARAMETER BLOCK
	MOV	AX,4B00H		;PROGRAM EXEC FUNCTION
	PUSHF
	POP	AX			;GET FLAG BITS
	OR	AX,TFMASK		;SET TRAP FLAG
	PUSH	AX			;PUT IT ON THE STACK
	PUSH	CS
	CALL	SETTF			;SET TRAP FLAG
	NOP				;ALLOW TRAP TIME TO WORK
	MOV	AX,4B00H		;PROGRAM EXEC FUNCTION

;	WE HAVE TO EXECUTE THE SYSTEM INTERRUPT WITHOUT KILLING
;	THE TRAP FLAG, SO WE'LL FAKE IT.

	PUSHF				;PREPARE TO FAKE INT 21
	CALL	CS:DWORD PTR INT21V	;TRY TO EXECUTE PROGRAM
	JNC	EXECOK			;IT WAS OK
CNTEX:	MOV	DX,OFFSET NOEXEC
	MOV	AH,9
	INT	21H
EXECOK:
DONE:	CLI
	PUSHF
	POP	AX			;GET FLAG BITS
	AND	AX,-1-TFMASK		;CLEAR TRAP FLAG
	PUSH	AX			;PUT IT ON THE STACK
	PUSH	CS
	CALL	SETTF			;CLEAR TRAP FLAG
	MOV	AX,0
	MOV	ES,AX			;POINT TO INT PAGE
	MOV	AX,CS
	MOV	DS,AX			;AND TO HERE
	MOV	DI,4			;WHERE VECTOR GOES
	MOV	SI,OFFSET INT01V	;WHERE IT IS
	CLD
	MOVSW				;RESTORE VECTOR
	MOVSW
	MOV	SI,OFFSET INT16V	;POINT TO KEYBOARD VECTOR
	MOV	DI,16H*4		;WHERE IT GOES
	MOVSW				;RESTORE VECTOR
	MOVSW
	MOV	SI,OFFSET INT21V	;POINT TO SYSTEM VECTOR
	MOV	DI,21H*4		;WHERE IT GOES
	MOVSW				;RESTORE VECTOR
	MOVSW
	MOV	AX,CS
	MOV	SS,AX			;FIX SS
	MOV	SP,OFFSET START		;FIX STACK
	STI				;ENABLE INTERRUPTS
	INT	20H			;AND EXIT

;	SUBROUTINES
;	SKIP OVER SPACES

SOS:	CMP	BYTE PTR [SI],' '	;SPACE?
	JNZ	NOTSP			;NO
	INC	SI			;ELSE, SKIP IT
	LOOP	SOS
NOTSP:	OR	CX,CX			;SET FLAG ON COUNT
	RET

;	PRINT MESSAGES, SKIPPING ZEROS

PMSG:	PUSH	SI
	MOV	SI,DX			;POINT TO MESSAGE
	CLD
PMSGLP:	LODSB				;GET A CHARACTER
	OR	AL,AL			;ZERO
	JZ	PMSGLP			;SKIP IT
	CMP	AL,'$'			;END?
	JZ	PMSGX
	MOV	DL,AL
	MOV	AH,2
	INT	21H			;PRINT CHARACTER
	JMP	PMSGLP
PMSGX:	POP	SI
	RET

;	TRAP INTERRUPT PROCESSOR
;	(PUT IN THE COMMENTED-OUT CODE TO MAKE THIS THING
;	RUN EVEN SLOWER!)

MYTRAP:
;	PUSH	CX
;	MOV	CX,1000H
;SLOLP:	LOOP	SLOLP
;	POP	CX
	IRET

;	SOFTWARE INTERRUPT PROCESSORS.  THESE ARE REQUIRED
;	BECAUSE THE TRAP FLAG IS KILLED BY THE INT INSTRUCTION,
;	AND PROCESSES THAT RETURN USING THE FLAGS AS INDICATORS
;	WILL LEAVE THE TRAP FLAG KILLED.

;	KEYBOARD INTERRUPT PROCESSOR

MYKEY:	PUSHF
	CALL	CS:DWORD PTR INT16V	;EXECUTE KEYBOARD FUNCTION
FIXTF:	PUSH	AX			;PREPARE TO FIX TRAP FLAG
	PUSHF
	POP	AX			;GET FLAG BITS
	OR	AX,TFMASK		;SET TRAP FLAG BIT
	PUSH	AX			;PUT FLAGS ON THE STACK
	PUSH	CS
	CALL	SETTF			;SET TRAP FLAG
	POP	AX
	NOP				;ALLOW TRAP TIME TO WORK
	STI				;ENABLE OTHER INTERRUPTS
	RETF	2			;RETURN, FLAGS INTACT

;	SYSTEM INTERRUPT PROCESSOR

MYSYS:	PUSHF
	CALL	CS:DWORD PTR INT21V	;CALL SYSTEM
	JMP	FIXTF			;FIX TRAP FLAG

;	SUBROUTINE TO SET TRAP FLAG PLACED ON STACK

SETTF:	IRET				;THIS WILL SET TRAP FLAG!

;	DATA AREA

;	PARAMETER BLOCK USED TO EXECUTE PROGRAM

PBLOCK	LABEL	NEAR
PBENV	DW	0			;ENVIRONMENT SEGMENT
PBCMD	DW	80H,0			;COMMAND LINE ADDRESS
PBFCB1	DW	5CH,0			;FCB1 ADDRESS
PBFCB2	DW	6CH,0			;FCB2 ADDRESS

;	INTERRUPT VECTORS

INT01V	DW	0,0			;INT 01 VECTOR
INT16V	DW	0,0			;INT 16 VECTOR
INT21V	DW	0,0			;INT 21 VECTOR

;	OTHER STUFF

FNDBUF	DB	43 DUP (0)		;FIND BUFFER

BADVER	DB	13,10,7,'This program requires MS-DOS version 2 or '
	DB	'above.',13,10,'$'
NOFIND	DB	13,10,"Can't find $"
NOEXEC	DB	13,10,"Can't execute "
PRGNAM	DB	80 DUP (0)		;NAME OF PROGRAM TO RUN
	DB	13,10,'$'

SIGNON	DB	13,10,'RunSLow Version 1.0.',13,10
	DB	"Copyright (C) Heath/Zenith Users' Group 1987.  "
	DB	'All Rights Reserved.',13,10,'$'
NPMSG	DB	13,10,'This program runs another program as a child,',13,10
	DB	'at a much slower speed than normal.',13,10,10
	DB	'To use this program, enter',13,10,10
	DB	'  RSL <program> [<arguments>]',13,10,10
	DB	'Where <program> is the program you want to',13,10
	DB	'run, and <arguments> are any command line arg-',13,10
	DB	'uments required by the program.',13,10,'$'

ENDADR	EQU	$+256			;END OF THIS PROGRAM

CODE	ENDS
	END	START
