	PAGE	,132
;	PROCESSOR SPEED REPORTER
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER.

PCSTD	EQU	465		;PC SPEED CONSTANT

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	6CH
TICCNT	LABEL	BYTE		;DEFINE TIC COUNT LOCATION
	ORG	100H

START:	MOV	DX,OFFSET MSG0
	MOV	AH,9
	INT	21H		;PRINT SIGN-ON
	MOV	AH,2CH
	INT	21H		;GET DOS TIME
	INC	DH		;INCREMENT SECOND
	CMP	DH,60		;ON MINUTE BOUNDARY?
	JNZ	SAVSEC		;NO
	MOV	DH,0		;ELSE, NEXT SECOND WILL BE ZERO
SAVSEC:	MOV	BYTE PTR TIME,DH	;SAVE NEXT SECOND
WFSEC:	MOV	AH,2CH
	INT	21H		;GET DOS TIME
	CMP	DH,BYTE PTR TIME	;ON A NEW SECOND?
	JNZ	WFSEC		;WAIT FOR ONE
	MOV	TIME,DX		;SAVE START TIME
	MOV	CX,10		;SET A COUNTER
TESTLP:	PUSH	CX		;SAVE COUNT
	CALL	PRIMES		;DO PRIME NUMBER CALCULATION
	POP	CX
	LOOP	TESTLP
	MOV	AH,2CH
	INT	21H		;GET DOS TIME
	MOV	CX,TIME		;GET STARTING TIME
	CMP	DH,CH		;DID MINUTE ROLL OVER?
	JAE	TIMEOK		;NO, TIME IS OK
	ADD	DH,60		;ELSE, CORRECT SECONDS
TIMEOK:	MOV	AL,DH		;CONVERT NEW TIME TO HUNDREDTHS
	MOV	BL,100
	MUL	BL
	XOR	DH,DH
	ADD	DX,AX		;DX = NEW TIME IN HUNDREDTHS
	MOV	AL,CH		;CONVERT OLD TIME TO HUNDREDTHS
	MUL	BL
	XOR	CH,CH
	ADD	CX,AX		;CX = OLD TIME IN HUNDREDTHS
	SUB	DX,CX		;GET ELAPSED TIME
	MOV	BX,DX		;IN BX
	MOV	AX,PCSTD*100	;GET PC STANDARD * 100
	XOR	DX,DX		;IN DX:AX
	DIV	BX		;CALCULATE SPEED INDEX

	MOV	BX,AX
	MOV	DX,OFFSET MSG1
	MOV	AH,9
	INT	21H		;PRINT MESSAGE 1
	CALL	DECOUT		;PRINT SPEED INDEX
	MOV	DX,OFFSET MSG2
	MOV	AH,9
	INT	21H		;PRINT MESSAGE 2
	INT	20H

;	DECOUT - PRINT BX IN DECIMAL
;	THIS IS A TRICKY ROUTINE THAT MAKES USE OF THE
;	STACK TO STORE DECODED DIGITS.

DECOUT:	PUSH	CX
	PUSH	DX
	PUSH	BX			;SAVE REGISTERS
	MOV	CX,10			;RADIX FOR CONVERSION
	MOV	DX,0
	MOV	AX,BX
	DIV	CX			;DIVIDE BY 10
	MOV	BX,AX			;ANSWER TO BX (DX [REMAINDER] = DIGIT)
	CMP	BX,0			;DONE?
	JZ	DEC1	
	CALL	DECOUT			;CALL RECURSIVELY UNTIL DONE
DEC1:	ADD	DL,'0'			;ADD ASCII BIAS
	MOV	AH,2
	INT	21H			;PRINT DIGIT
	POP	BX			;RESTORE REGISTERS
	POP	DX
	POP	CX
	RET

;	SUBROUTINE TO FIND ALL PRIME NUMBERS BETWEEN 0 AND 8190
;	IN THIS SUBROUTINE,
;	BX = I
;	SI = K
;	DX = PRIME
;	AX = COUNT

PRIMES	PROC	NEAR
	MOV	CX,8190			;SET A COUNT
	MOV	DI,OFFSET FLAGS		;POINT TO FLAGS ARRAY
	MOV	AL,1
	CLD
	REP	STOSB			;FILL FLAGS WITH 1'S
	MOV	BX,0			;SET BASE POINTER
	MOV	AX,0			;SET PRIME COUNTER
PRIMLP:	CMP	BYTE PTR FLAGS[BX],0	;IS FLAG HERE 0?
	JZ	NOTPRM			;NOT A PRIME
	MOV	DX,BX			;GET BASE COUNT 
	ADD	DX,BX			;DOUBLE IT
	ADD	DX,3			;PRIME = I + I + 3
	MOV	SI,BX			;BASE COUNT TO SI
	ADD	SI,DX			;K = I + PRIME
TESTK:	CMP	SI,8190			;IS SI MORE THAN 8190?
	JA	GOTPRM			;GOT A PRIME, COUNT IT
	MOV	BYTE PTR FLAGS[SI],0	;FLAG A NON-PRIME
	ADD	SI,DX			;K = K + PRIME
	JMP	TESTK			;ADD AND LOOP
GOTPRM:	INC	AX			;COUNT THIS PRIME
NOTPRM:	INC	BX
	CMP	BX,8191
	JNZ	PRIMLP			;LOOP UNTIL DONE
	RET
PRIMES	ENDP

MSG0	DB	13,10,'The HUG Computer Speed Test, v. 1.0',13,10,'$'
MSG1	DB	13,10,'The relative speed index of this computer '
	DB	'(IBM PC = 100) is $'
MSG2	DB	'.',13,10,'$'

	EVEN
TIME	DW	0
COUNT	DW	0			;COUNT ITERATIONS HERE
FLAGS	LABEL	BYTE			;STORE FLAGS HERE

CODE	ENDS
	END	START
