	TITLE Terminal Program
	PAGE 	,132
	.LFCOND
	.TFCOND
FALSE	EQU	0
TRUE	EQU	NOT FALSE
LISTT	EQU	TRUE		; List key correspondence table
LISTM	EQU	TRUE		; List messages

	IF1
		%OUT	*Pass 1 Started*
		IF NOT LISTT
			%OUT	*Suppressing Table Listing*
		ENDIF
		IF NOT LISTM
			%OUT	*Suppressing Message Listing*
		ENDIF
	ENDIF
	IF2
		%OUT	*Pass 2 Started*
	ENDIF

	PAGE
;
;	Terminal Program for Z-100 under Z-DOS
;
;
;		Z-100 Native Mode Terminal Version
;
;
;	Author: R. A. Metz		Date: 1/25/83
;
;
;	This program turns a Z-100 into a terminal of choice
;	for use in access to other computer systems.  Keyboard
;	expansion is disabled and all key entries are converted
;	to a desired character or character sequence (e.g. the
;	up-arrow key is usually converted to ESC,A in most
;	ASCII terminals).  In this manner, the keyboard may be
;	made to emulate most any terminal on the market by 
;	providing the proper entries in the keyboard conversion
;	table.  Incomming data from the modem port also passes
;	through a filter such that the emulated brand X terminal's
;	control and escape sequences are translated to those 
;	recognized by the Z-100.
;	Once activated, the program is in its on-line mode which
;	means that any characters typed on the keyboard are
;	sent to the AUX port.  Any characters received from the 
;	AUX port are converted if necessary and displayed
;	directly on the CRT.  Also, characters both sent and received
;	to/from the AUX port are stored in memory for later
;	retrieval if desired.  
;	Certain capabilities are also available to provide some
;	local services within the terminal program.
;	Three keys are monitored for entry on the keyboard and are
;	not passed on to the AUX port.  They are:
;
;	  	Ctl/P (010H) - Causes the current contents of the
;			CRT screen to be saved in memory and then
;			printed on the PRN device.  Note: as soon
;			as the cursor returns, the keyboard/display
;			is free for further use while the printer is
;			busy printing (transparent print).
;
;		S(BREAK) - A form-feed is saved in the memory buffer and
;			a special character is displayed.  Nothing is
;			transferred to the AUX port.  This is to allow
;			for placement of page breaks in the saved 
;			record of a terminal session for later display
;			on a printer.  Also, if transparent print is
;			active, a page break is sent to the printer
;			directly.
;
;		HELP  -  The contents of the CRT screen are saved and a
;			a menu of options is displayed.  While the 
;			HELP menu is being displayed, only the 
;			following keys on the keyboard are active and
;			they have the following meaning:
;
;----------------------------------------------------------------------
;
;		F1 - Return On-Line  -  The saved screen is re-
;			displayed at the point at which the HELP
;			key was pressed and the program is again
;			in its on-line mode as described above.
;
;		F2 - Option Toggles  -  The user is prompted for 
;			one of 3 options which may be toggled on/off:
;			1 - 25th line status on/off.  The 25th line will
;			contain (when enabled) an event timer and
;			a memory utilization percentage.  These
;			data are useful when using this program
;			for connection to a data-base service or 
;			other timed connection.  When using this 
;			program with systems which themselves make
;			use of the 25th line (eg protocol converters)
;			the local use of the status line must be
;			turned off.  The default state of the status
;			line is off.
;			2 - Character echo on/off.  Characters typed
;			on the keyboard when in on-line mode are
;			echoed to the CRT with th echo flag on (it
;			is off when the program is entered).  This
;			flag should be on when communicating with
;			systems which do not echo received characters
;			(e.g. another Z-100 system).  It should be
;			off when communicating with  a system in FDX
;			mode (eg a protocol converter or a data base
;			service).
;			3 - Transparent print on/off  -  When this flag
;			is on (it is off on program entry) all
;			characters received are also transferred to the
;			printer as well as to the CRT and memory buffer.
;			This is to allow for simultaneous hard copy
;			output of a conversation.
;		F3 - Change Current File  -  The user is prompted
;			for a new active file name (note: the current
;			active file is displayed at the bottom of
;			the HELP menu screen).  Upon entry, that new
;			file name is opened and becomes the new active
;			file.  A null entry (CR only) will cause
;			retention of the old active file.
;			This file is used in the F5,F6, and F7 options
;			below.
;
;		F4 - Clear counters  -  The user is prompted to
;			clear (1) the memory buffer which contains
;			an ongoing record of all communications
;			activity or (2) the event timer which is a 
;			record of connect time.
;
;		F5 - Save Memory Buffer  -  The current contents of
;			the memory buffer are written to the 
;			currently active file.
;
;		F6 - Transmit Current File  -  See note 1.  The user
;			is prompted for the type of file transfer
;			desired:
;			1 - ASCII file to Z-100 TERM
;			2 - Binary file to Z-100 TERM
;			3 - Direct ASCII file transfer (no protocol)
;
;		F7 - Receive Current File  -  This is an error
;			checked reception only (see note 1).  To
;			receive direct transfers (see F6 option 3
;			above), use the memory save option F5.
;
;		F8 - Change AUX port baud rate  -  The user is 
;			prompted to change the baud rate to:
;				1 - 300 bps
;				2 - 1200 bps
;				3 - 2400 bps
;				4 - 4800 bps
;				5 - 9600 bps
;			The AUX port should be set through CONFIGUR
;			to the proper parity, etc. desired.  Note:  for
;			file transfer between Z-100 systems, the parity
;			on both systems must match.  It is reccommended
;			that the AUX port be setup with 7-bit
;			characters, even parity, 1 stop bit.
;			The 9600 bps option should only be used with
;			systems supporting XON/XOFF.  The input buffer
;			for the AUX port is fixed at 120 characters
;			in current versions of Z-DOS and the XON/XOFF
;			protocol is used to prevent buffer overflow
;			which would otherwise occur as the Z-100 
;			cannot process data at the full 9600 bps
;			rate.
;
;		F9 - Save program image  -  This option will save the
;			current program image on the default drive
;			in the file 'TERMZ100.COM'.  This will make 
;			permanent any set baud rate, active file, and
;			programmed function key strings.
;
;		F10 - Set programmed function keys  -  The current
;			values for the 8 programmed function keys are
;			displayed and the user is prompted for the key
;			to be modified (1-8).  The user is then asked
;			to enter the character string to be associated
;			with that key (63 characters max) terminated
;			by ctl Z (01AH).  Current key values are then
;			re-displayed.  To exit this mode - type any
;			character other than 1-8.  Note: in on-line 
;			mode the programmed function keys are expanded
;			to their stored value and sent to the AUX port.
;			Unprogrammed keys will cause transfer of the 
;			escape sequence normally associated with that
;			particular function key.
;			To de-program a key, enter a null string
;			(Ctl/Z only).
;
;		F11 - Print Memory Buffer  -  The contents of the
;			memory buffer are sent to the PRN device.
;			The print may be aborted at any time by
;			pressing any key on the keyboard.
;
;		F12 - Exit terminal program and return to Z-DOS.
;
;
;	Note 1:  The file transfer facility in options F6 and F7
;	allow for error corrected file transfer between two Z-100
;	computers, each of which is running this program, or for
;	direct transfer without error correcting protocol.  The
;	transfer protocol is as follows:
;
;	When started by an operator, the transmitting computer
;	will sent either an SOH for binary file transfer or an
;	STX for ASCII file transfer and will await an ACK response
;	from the receiver.  The transmitter will send the SOH/STX
;	request every 3 seconds for 30 seconds waiting for the 
;	receiver's response before giving up.  The receiver, when
;	started by an operator, will wait for 30 seconds for an
;	SOH/STX transmit request from a transmitting computer 
;	before it will give up.  
;	When the receiver gets the SOH/STX request, an ACK response 
;	is sent.  The transmitter will then send data in 256-byte
;	blocks.  Blocks are terminated with ETB/LRC for inter-
;	mediate blocks and with ETX/LRC for the final or only
;	block.  The receiver will verify the received block and
;	respond with ACK or NAK.  The transmitter will re-transmit
;	NAKked blocks for a maximum of 10 times before aborting the
;	transmission.
;	Transmission may be terminated by either end by sending
;	an EOT character.  An operator can force a transmission
;	abort from either end by typing Ctl/A (01H) on the keyboard.
;	All other keys will be ignored during file transmission.
;	The difference between binary and ASCII file
;	transmission is that for binary files a 2 for 1 character
;	expansion is performed by the transmitter prior to block
;	transmission and a 1 for 2 character compression is 
;	performed by the receiver after reception of a block.
;	This is to prevent control characters in the data from
;	screwing up the communications protocol.  In ASCII file
;	transfer, the contents of the ASCII file are transmitted
;	on an "as is" basis.  Only the least significant 7 bits
;	of the 8 bit byte are transferred.  Any control characters
;	(SOH,STX,ETX,EOT,ETB) which may be in the data file will
;	consequently cause communications errors.  Files which
;	may be transferred in ASCII form are print and source 
;	files.  Files which may not be transferred in ASCII form
;	are COM files, Multiplan work files, BASIC programs stored
;	in non-ASCII form, etc.  
;
;
	SUBTTL	DEFINITIONS
	PAGE
TERM	SEGMENT
	ASSUME 	DS:TERM,CS:TERM,SS:TERM,ES:TERM
	ORG 	80H
DBUF:
	ORG	100H
START:
	JMP	DISP_HDR	; Skip around data
;
CHR_READ	EQU	1	; Read command to AUX routines
CHR_WRITE	EQU	0	; Write command to AUX routines
CHR_STATUS	EQU	2	; Status command to AUX routines
CHR_CONTROL	EQU	3	; Control command to AUX routines
CHR_SFGC	EQU	1	; Get configuration info subfunction
CHR_CFSU	EQU	0	; Set new configuration subfunction
CHR_SFGS	EQU	0	; Get status subfunction
OUTSTR		EQU	9	; String output function
PRINTCHR	EQU	5	; Print character function
INCHR		EQU	8	; Kbd input w/o echo function
INLINE		EQU	10	; Line input function
KBDTST		EQU	11	; Keyboard test function
CRTOUT		EQU	2	; CRT Output function
KBDIN		EQU	1	; Keyboard input function
OPEN		EQU 	15	; File open function
CLOSE		EQU	16	; File close function
SEQRED		EQU	20	; Sequential file read function
SEQWRT		EQU	21	; Sequential file write function
CREATE		EQU	22	; Create file function
CURDSK		EQU	25	; Get current drve ID function
DTA		EQU	26	; Set data transfer area
PARSE		EQU	41	; Parse file name function
GETTIME		EQU	44	; Get current time function
SETTIME		EQU	45	; Set time function
AUXIN		EQU	3	; Aux port input
AUXOUT		EQU	4	; Aux port output
;
SOH		EQU	1	; SOH
STX		EQU	2	; STX
ETX		EQU	3	; ETX
EOT		EQU	4	; EOT
ACK		EQU	6	; ACK
LF		EQU	0AH	; LF
FF		EQU	0CH	; FF
CR		EQU	0DH	; CR
DLE		EQU	10H	; DLE
XON		EQU	11H	; XON
XOFF		EQU	13H	; XOFF
NAK		EQU	15H	; NAK
ETB		EQU	17H	; ETB
EOF		EQU	1AH	; EOF
ESC		EQU	1BH	; ESC
ASC0		EQU	30H	; '0'
ASC1		EQU	31H	; '1'
ASC2		EQU	32H	; '2'
ASC3		EQU	33H	; '3'
ASC5		EQU	35H	; '5'
ASC8		EQU	38H	; '8'
ASC9		EQU	39H	; '9'
TILDA		EQU	7EH	; '~'
;
FADRE	EQU	2
FCURI	EQU	4		; FIFO definition
FCURO	EQU	6
;
BUFEND	EQU	0FC00H		; End of BIGBUF (Leave 1K Stack)
;
BIOS_CONFUNC	DW	051H,040H
BIOS_AUXFUNC	DW	04EH,040H
BIOS_PRNFUNC	DW	04BH,040H
;
BUFPTR	DW	OFFSET BIGBUF	; Memory buffer pointer
INITB:
PRTPTR	DW	0		; Print buffer pointer
STENB	DB	0		; Status line enable flag
STATFL  DB	0		; Status line display flag
CRTON	DB	0		; CRT xfer enable flag (0=on)
PRTON	DB	0		; PRT xfer enable flag (0=off)
LINC	DB	0		; Print line counter
CHRC	DB	0		; Print character counter
EOLF	DB	0		; Print end of line flag
COLC	DB	0		; CRT Repaint chr counter
AFLG	DB	0		; Type flag for xmission
BUFTRM	DB	0		; Xmission buffer terminator
BLKCNT	DB	0		; Comm block counter
PRTREQ	DB	0		; Print request flag
XONFLG	DB	0		; XON required flag
FSAV	DW	0		; Saved PFK - new PFK processing
ECOFLG	DB	0		; Echo flag (default is off)
ROWC	DB	0		; CRT repaint - line counter
ADR1	DB	0		; Saved cursor address byte 1
ADR2	DB	0		; Saved cursor address byte 2
INITE:
SHFTFLG	DB	0		; Keyboard shift mode flag
CURBD	DW	2		; Current AUX baud rate (1200 default)
;
PFESC	DB	'STUVWPQR'	; Default ESC codes for F1-F8
FTAB:
F1B	DB	2,1BH,'S'	; F1 
	DB	61 DUP (0)
F2B	DB	2,1BH,'T'	; F2
	DB	61 DUP (0)
F3B	DB	2,1BH,'U'	; F3
	DB	61 DUP (0)
F4B	DB	2,1BH,'V'	; F4
	DB	61 DUP (0)
F5B	DB	2,1BH,'W'	; F5
	DB	61 DUP (0)
F6B	DB	2,1BH,'P'	; F6
	DB	61 DUP (0)
F7B	DB	2,1BH,'Q'	; F7
	DB	61 DUP (0)
F8B	DB	2,1BH,'R'	; F8
	DB	61 DUP (0)
;
BDTBL	DB	0,6,8,11,12,13	; Configuration baud rate table
CFGBUF	DB	32 DUP (0)	; Get configuration buffer
;
FCB	DB	0		; File control block
	DB	'TERM    TXT'	; Default file name
	DB	30 DUP (0)
PFCB	DB	0
	DB	'TERMZ100COM'
	DB	30 DUP (0)
;
LININP	DB	128		; Line buffer size
LINBUF	DB	128 DUP (?)	; Input line buffer
IOBUF	DB	256 DUP (?)	; Comm I/O buffer
IOBEND:
;
	IF	NOT LISTM
		.XLIST
	ENDIF

HDR	DB	1BH,45H		; Clear screen
	DB	1BH,6DH,34H,30H ; Green/black
	DB	1BH,78H,31H	; Enable 25th line
	DB	1BH,79H,35H	; Enable cursor
	DB	1BH,'y?'	; Disable key expansion
	DB	1BH,77H		; Disable cursor wrap
	DB	'Z-100 Terminal Program Active'
	DB	0DH,0AH,0AH,'$'
GETSCR	DB	1BH,'x5'	; Turn off cursor
	DB	1BH,'x?'	; Enable key expansion
	DB	1BH,'n'		; Request cursor position
	DB	1BH,'#$'	; Xmit page
;
CLS	DB	1BH,45H,'$'	; Clear screen
;
ENCUR	DB	1BH,'y?'	; Disable key expansion
     	DB	1BH,'y5$'	; Enable cursor msg
RESCUR	DB	1BH,'y5'	; Re-enable cursor
	DB	1BH,'m40'	; Green/black
	DB	1BH,'y?'	; Disable key expansion
      	DB	1BH,'Y$'	; Restore cursor
STCLR	DB	1BH,59H,32H,30H
	DB	1BH,'l'
	DB	1BH,59H,33H,30H
	DB	1BH,'l$'
;
HELP_MENU	DB	1BH,45H
		DB	1BH,59H,21H,2AH
		DB	1BH,'p'
		DB	'TERMINAL:  AUXILLIARY FUNCTION MENU'
		DB	1BH,'q'
		DB	1BH,59H,25H,30H
		DB	'F1 = Return on-line'
		DB	1BH,59H,26H,30H
		DB	'F2 = Option Toggle'
		DB	1BH,59H,27H,30H
		DB	'F3 = Change current file'
		DB	1BH,59H,28H,30H
		DB	'F4 = Clear'
		DB	1BH,59H,29H,30H
		DB	'F5 = Save memory buffer in current file'
		DB	1BH,59H,2AH,30H
		DB	'F6 = Transmit current file'
		DB	1BH,59H,2BH,30H
		DB	'F7 = Receive current file'
		DB	1BH,59H,2CH,30H
		DB	'F8 = Change AUX baud rate'
		DB	1BH,59H,2DH,30H
		DB	'F9 = Save program image'
		DB	1BH,59H,2EH,30H
		DB	'F10 = Set programmed function key'
		DB	1BH,59H,2FH,30H
		DB	'F11 = Print memory buffer'
		DB	1BH,59H,30H,30H
		DB	'F12 = Exit terminal program'
		DB	1BH,'y5'
		DB	'$'
;
CURFIL	DB	1BH,59H,37H,39H
	DB	'Current file is: $'
;
PROMPT	DB	1BH,59H,32H,28H
	DB	1BH,'l'
      	DB	'New file is? $'
;
FILERR	DB	1BH,59H,33H,30H
	DB	1BH,'l'
	DB	'FILE OPEN ERROR$'
;
DSCERR	DB	1BH,59H,33H,30H
	DB	1BH,'l'
	DB	'DISC I/O ERROR$'
;
TIMDES	DB	1BH,'x?'	; Enable kbd expansion
      	DB	1BH,59H,20H,20H
      	DB	1BH,45H
	DB	'SYSTEM TIME DESTROYED'
	DB	0DH,0AH
	DB	'RESET IF DESIRED.'
FINMSG	DB	0DH,0AH
	DB	1BH,'m70$'	; Reset to white/black
NORCVR	DB	1BH,59H,33H,30H
	DB	1BH,'l'
	DB	'Comm error - no receiver$'
ABTMSG	DB	1BH,59H,33H,30H
	DB	1BH,'l'
	DB	'Comm error - transmission aborted$'
XCMPLT	DB	1BH,59H,33H,30H
	DB	1BH,'l'
	DB	'Transmission complete$'
BGNXMT	DB	1BH,'l'
      	DB	1BH,59H,32H,30H
	DB	1BH,'l'
	DB	'Begin transmission Block # $'
STATMS  DB	1BH,59H,32H,4BH,'$'
NOXMTR	DB	1BH,59H,33H,30H
	DB	1BH,'l'
	DB	'Comm error - no transmitter$'
RCVMSG	DB	1BH,59H,33H,30H
	DB	1BH,'l'
	DB	'File reception complete$'
BGNRCV	DB	1BH,'l'
      	DB	1BH,59H,32H,30H
	DB	1BH,'l'
	DB	'Begin reception - block # $'
WATXMT	DB	1BH,59H,33H,30H
	DB	1BH,'l'
	DB	'Awaiting transmitter--$'
WATRCV  DB	1BH,59H,33H,30H
	DB	1BH,'l'
	DB	'Awaiting receiver--$'
RCVABT	DB	1BH,59H,33H,30H
	DB	1BH,'l'
	DB	'Comm error - reception aborted$'
DERMS	DB	1BH,59H,33H,30H
	DB	1BH,'l'
	DB	'Receive file overflow - reception aborted.$'
TGLMES	DB	1BH,59H,32H,30H
	DB	1BH,'l'
	DB	'1=Status line,2=echo,3=print: $'
PRTINP	DB	1BH,59H,33H,30H
	DB	1BH,'l'
	DB	1BH,'p'
	DB	'...Printing...'
	DB	1BH,'q$'
PRTC	DB	1BH,59H,33H,30H
	DB	1BH,'l'
	DB	'Print complete$'
NEWRAT	DB	1BH,59H,32H,30H
	DB	1BH,'l'
	DB	'Enter new rate: 1=300,2=1200,3=2400,4=4800,5=9600: $'
BRKMSG	DB	1BH,46H,7EH,1BH,47H,24H
XMTTYP	DB	1BH,59H,32H,25H
	DB	1BH,'l'
	DB	'1=Binary to Z100,2=ASCII to Z100,3=ASCII direct '
	DB	'(no protocol): $'
NEWPFK	DB	0DH,0AH
	DB	'Enter key# (1-8), CR to return to menu: $'
GETPFK	DB	0DH,0AH
	DB	'New value (ctl/Z terminates string): $'
SAVMSG	DB	1BH,59H,33H,30H
	DB	1BH,'l'
	DB	'Disc save complete$'
B300	DB	1BH,59H,36H,48H
	DB	'Baud = 300$'
B1200	DB	1BH,59H,36H,48H
	DB	'Baud = 1200$'
B2400	DB	1BH,59H,36H,48H
	DB	'Baud = 2400$'
B4800	DB	1BH,59H,36H,48H
	DB	'Baud = 4800$'
B9600	DB	1BH,59H,36H,48H
	DB	'Baud = 9600$'
ECOF	DB	1BH,59H,36H,39H
	DB	'Echo OFF$'
ECON	DB	1BH,59H,36H,39H
	DB	'Echo ON$'
TPRTON	DB	1BH,59H,36H,56H
	DB	'Print ON$'
TPRTOF	DB	1BH,59H,36H,56H
	DB	'Print OFF$'
PFDSPLY DB	1BH,45H
	DB	1BH,59H,21H,30H
	DB	'Current Values for PF Keys are as Follows:'
	DB	0DH,0AH,0AH,'$'
PFMSG	DB	0DH,0AH
	DB	'  PF'
PFNO	DB	'1 = $'
ESCMSG	DB	'<esc>$'
CRMSG	DB	'<cr>$'
LFMSG	DB	'<lf>$'
CLRTYP	DB	1BH,59H,32H,30H
	DB	1BH,'l'
	DB	'1=Clear memory buffer, 2=Clear event timer: $'
STLCLR	DB	1BH,59H,38H,20H
	DB	80 DUP (20H)
	DB	'$'
STLSET	DB	1BH,59H,38H,20H
	DB	1BH,'p'
	DB	'  Event timer: 00:00     Memory buffer 00% free'
	DB	30 DUP (20H)
	DB	1BH,'q'
	DB	'$'
TADR	DB	1BH,'j'
	DB	1BH,59H,38H,2FH,'$'
PADR	DB	1BH,59H,38H,47H,'$'
RCUR	DB	1BH,'k$'
	.LIST
	SUBTTL	TERMINAL CODE
;
	PAGE
DISP_HDR:
	CLD
	MOV	CX,0
	MOV	DX,0		; Clear event timer
	MOV	AH,SETTIME
	INT	21H
	MOV	AH,OUTSTR	; Display header
	MOV	DX,OFFSET HDR
	INT	21H
	CALL	CHGB		; Set AUX baud rate
	MOV	BUFPTR,OFFSET BIGBUF
	MOV	BX,OFFSET INITB
INITLP:				; Init variables
	CMP	BX,OFFSET INITE
	JE	BEGIN
	MOV	BYTE PTR [BX],0
	INC	BX
	JMP	INITLP
	MOV	PFCB,0		; Program file to default disc
	MOV	BX,OFFSET PRTFIF
	MOV	AX,[BX]		; Init printer fifo
	MOV	FCURI[BX],AX
	MOV	FCURO[BX],AX
;
BEGIN:
	CALL	STATLN		; Update status line if necessary
	CMP	PRTPTR,0	;    screen print active?
	JNE	PRNT_SCREEN	;     Yes
	JMP	CKTSP		;     No - check for tsp prt data
PRNT_SCREEN:
	CMP	EOLF,0		;    Yes - eol processing?
	JE	LINCHK
	MOV	DL,0AH		;      Yes - send LF
	MOV	EOLF,0
	JMP	PUTIT
LINCHK:
	INC	CHRC		; Check for end of line
	CMP	CHRC,81
	JL	NXTCHR
	MOV	CHRC,0		; End of line - check for end of page
	INC	LINC
	CMP	LINC,25
	JE	PRTFIN
	MOV	EOLF,1		; Set eol flag and send CR
	MOV 	DL,CR
	JMP	PUTIT
NXTCHR:
	MOV	BX,PRTPTR	; Get next chr from buffer
	MOV	DL,[BX]
	INC	PRTPTR
	CMP	DL,CR		; CR Terminates page
	JE	PRTFIN
	CMP	DL,ESC		; Ignore esc sequences
	JNE	PUTIT
	MOV 	BX,PRTPTR
	MOV	DL,[BX]
	INC	PRTPTR
	CMP	DL,'m'		; Color spec is 4-bytes
	JNE	NXTCHR
	INC	PRTPTR
	INC	PRTPTR
	JMP	NXTCHR
PUTIT:
	MOV	AH,PRINTCHR
	INT	21H
TSTAUXJ:
	JMP	TSTAUX
PRTFIN:
	MOV	PRTPTR,0
	MOV	LINC,0
	MOV	CHRC,0		; Finish - clear counters
	MOV	EOLF,0
	MOV	AL,FF
	JMP	PUTIT
CKTSP:				; Check for data in tsp print fifo
	CALL	GTFIFO
	JC	PUTIT		; Print all chrs in fifo
;
TSTAUX:
	CMP	CURBD,4		; XON/XOFF processing for >=4800 bps
	JL 	REDAUX
	MOV	AH,CHR_STATUS	; Check AUX buffer
	MOV	AL,CHR_SFGS
	CALL	DWORD PTR BIOS_AUXFUNC
	CMP	BL,20		; <20 chr in buffer?
	JG	CKXOFF		;  No - see if XOFF threshold reached
	CMP	XONFLG,0	;  Yes - need to send XON?
	JNE	REDAUX
	MOV	XONFLG,1	;   Yes - send XON to AUX
	MOV	AH,AUXOUT
	MOV	DL,XON
	INT	21H
	JMP	REDAUX
CKXOFF:
	CMP	BL,90		; >90 chrs in buffer?
	JLE	REDAUX		;  No - 
	CMP	XONFLG,0	;  Yes - must send XOFF if not sent
	JE	REDAUX
	CALL	SXOFF		; Send XOFF
REDAUX:
	MOV	AH,CHR_READ
	CALL 	DWORD PTR BIOS_AUXFUNC	; Check modem port
	JC	TSTCON
	CALL	CVTRCV		; Process received character
TSTCON:
	MOV	AH,CHR_READ	; Check console keyboard
	CALL	DWORD PTR BIOS_CONFUNC
	JC	BEGINJ
	CALL	CVTKBD		; Process KBD character
BEGINJ:
	JMP	BEGIN
;
	SUBTTL	Special character code processing
	PAGE
PRINTS:				; Print screen
	MOV	PRTREQ,1	; Set print request flag
	JMP	HELP_KEY	; Go read screen contents
;
PF1:
	MOV	BX,OFFSET F1B
	JMP	FEXP
PF2:
	MOV	BX,OFFSET F2B
	JMP	FEXP
PF3:
	MOV	BX,OFFSET F3B
	JMP	FEXP
PF4:
	MOV	BX,OFFSET F4B
	JMP	FEXP
PF5:
	MOV	BX,OFFSET F5B
	JMP	FEXP
PF6:
	MOV	BX,OFFSET F6B
	JMP	FEXP
PF7:
	MOV	BX,OFFSET F7B
	JMP	FEXP
PF8:
	MOV	BX,OFFSET F8B
FEXP:
	MOV	CL,[BX]		; Character count
	MOV	CH,0
	INC	BX
FEXPLP:
	MOV	DL,[BX]
	INC	BX
	MOV	AH,AUXOUT
	INT	21H
	CMP	ECOFLG,0		; Echo?
	JE	FLP			;  No
	MOV	AH,CRTOUT		;  Yes - to CRT also
	INT	21H
	MOV	AL,DL
	CALL	PUTBUF
FLP:
	LOOP	FEXPLP
	JMP	BEGIN
;
BREAK:			; Set break in memory
	MOV	AL,FF
	CALL	PUTBUF
	MOV	AH,OUTSTR
	MOV	DX,OFFSET BRKMSG	; Special chr to screen
	INT	21H
	JMP	BEGIN
	SUBTTL	HELP SCREEN PROCESSING
	PAGE
;
HELP_KEY:
	CALL	SXOFF			; Send XOFF if 9600 rate
	MOV	DX,OFFSET GETSCR	; Request screen contents
	MOV	AH,OUTSTR
	INT	21H
	MOV	BX,OFFSET SCRBUF
	MOV	CX,2400			; Max buffer size
INLUP:
	CALL 	GETCHAR			; Read and store a char
	CMP	AL,CR			; CR terminates buffer
	JE	ALLIN
	CMP	AL,ESC			; Look for cursor report
	JNE 	INLUP1
	CALL	GETCHAR			; Get esc control
	CMP	AL,'Y'			; 'Y' is cursor control
	JNE	INLUP1
	DEC	BX
	DEC	BX			; Reprot here - remove from
	CALL	GETCHAR			;  memory and read addr chrs
	DEC	BX
	MOV	ADR1,AL
	CALL	GETCHAR
	DEC	BX
	MOV	ADR2,AL
INLUP1:
	LOOP	INLUP
ALLIN:
	CMP	PRTREQ,0		; Print request (ctl/P)
	JE	MENU			;  No
	JMP	PRINT			;  Yes - go directly to print
GETCHAR	PROC	NEAR
	MOV	AH,INCHR		; Read character routine
	INT	21H
	MOV	[BX],AL
	INC	BX
	RET
GETCHAR	ENDP
MENU:
	MOV	DX,OFFSET HELP_MENU	; Display menu
	MOV	AH,OUTSTR
	INT	21H
	MOV	DX,OFFSET ECOF
	CMP	ECOFLG,0		; Display ECOFLG value
	JE	DSPECO
	MOV	DX,OFFSET ECON
DSPECO:
	MOV	AH,OUTSTR
	INT	21H
	MOV	DX,OFFSET B300
	CMP	CURBD,1			; Display CURBD value
	JE	DSPBD
	MOV	DX,OFFSET B1200
	CMP	CURBD,2
	JE	DSPBD
	MOV	DX,OFFSET B2400
	CMP	CURBD,3
	JE	DSPBD
	MOV	DX,OFFSET B4800
	CMP	CURBD,4
	JE	DSPBD
	MOV	DX,OFFSET B9600
DSPBD:
	MOV	AH,OUTSTR
	INT	21H
	MOV	DX,OFFSET TPRTOF
	CMP	PRTON,0
	JE	DSPTPR
	MOV	DX,OFFSET TPRTON
DSPTPR:					; Transparent print ON/OFF
	MOV	AH,OUTSTR
	INT	21H
	MOV	DX,OFFSET CURFIL	; Display current active file
	MOV	AH,OUTSTR
	INT	21H
	MOV	DL,FCB
	CMP	DL,0			; Default drive?
	JNE	MAKE_ASC		;  No
	MOV	AH,CURDSK		;  Yes - find default id
	INT	21H
	MOV	DL,AL
	INC	DL
MAKE_ASC:
	ADD	DL,40H			; Convert to alphabetic
	MOV	AH,CRTOUT
	INT	21H	
	MOV	AH,CRTOUT
	MOV	DL,':'			; :
	INT	21H
	MOV	BX,OFFSET FCB+1		; File name
	MOV	CX,11
DSPFIL:
	MOV	AH,CRTOUT
	MOV	DL,[BX]
	INC	BX
	INT	21H
	LOOP	DSPFIL
ESCWAIT:
	CALL	STATLN			; Update status line if rqd
	MOV	AH,KBDTST		; Character here?
	INT	21H
	CMP	AL,0
	JE	ESCWAIT			;  No - keep looking
	MOV	AH,INCHR		;  Yes - read it
	INT	21H
	CMP	AL,ESC
	JNE	ESCWAIT			; Ignore if not ESC
	MOV	AH,INCHR
	INT	21H			; Read control code
	MOV	BX,OFFSET CTLTBL
CHKLUP:
	CMP	BX,OFFSET ENDTBL	; Table look-up
	JE	ESCWAIT
	CMP	AL,[BX]	
	JE	GOTVAL			; Good entry
	ADD	BX,3
	JMP	CHKLUP
GOTVAL:
	INC	BX
	MOV	BX,[BX]
	MOV	AH,OUTSTR
	MOV	DX,OFFSET STCLR
	INT	21H
	JMP	BX			; Goto processor
CHKNXT2:
	MOV	AH,INCHR	; F9-F12 are 3-chr sequences
	INT	21H
	MOV	BX,OFFSET CTL2
CKLP2:
	CMP	BX,OFFSET END2
	JE	ESCWAIT
	CMP	AL,[BX]
	JE	GOTVAL
	ADD	BX,3
	JMP	CKLP2
;
CTLTBL:
	DB	'S'		; F1
	DW	OFFSET RETRN
	DB	'T'		; F2
	DW	OFFSET TOGGLE
	DB	'U'		; F3
	DW	OFFSET CHANGE
	DB	'V'		; F4
	DW	OFFSET CLEAR
	DB	'W'		; F5
	DW	OFFSET SAVE
	DB	'P'		; F6
	DW	OFFSET XMIT
	DB	'Q'		; F7
	DW	OFFSET RCV
	DB	'R'		; F8
	DW	OFFSET CBAUD
	DB	'0'		; F9-F12
	DW	OFFSET CHKNXT2
ENDTBL:
CTL2:
	DB	'I'		; F9
	DW	OFFSET PSAVE
	DB	'J'		; F10
	DW	OFFSET CPFK
	DB	'K'		; F11
	DW	OFFSET PRNTBF
	DB	'L'		; F12
	DW	OFFSET EXIT
END2:
;
;
	SUBTTL	HELP FUNCTION PROCESSORS
	PAGE
TOGGLE:				; Toggle flags
	MOV	DX,OFFSET TGLMES
	MOV	AH,OUTSTR	; Request flag to toggle
	INT	21H
	MOV	AH,KBDIN	; Read reply
	INT	21H
	CMP	AL,ASC1		; 1=stat line
	JE	STAT
	CMP	AL,ASC2		; 2=echo
	JE	ECOTGL
	CMP	AL,ASC3		; 3=transparent print
	JE	PRTTGL
	JMP	MENU
PRTTGL:				; Toggle transparent print flag
	CMP	PRTON,0
	JE	SETPRTF
	MOV	PRTON,0
	JMP	MENU
SETPRTF:
	MOV	PRTON,1
	JMP	MENU
;
PRNTBF:				; Print memory buffer
	MOV	DX,OFFSET PRTINP
	MOV	AH,OUTSTR	; Print in progress msg
	INT	21H
	MOV	BX,OFFSET BIGBUF
PRNTLUP:
	CMP	BX,BUFPTR
	JE	PRNT_DONE
	MOV	AH,KBDTST	; Keyboard entry aborts print
	INT	21H
	CMP	AL,0
	JNE	PRNT_DONE
	MOV	DL,[BX]
	INC	BX
	MOV	AH,PRINTCHR
	INT	21H
	JMP	PRNTLUP
PRNT_DONE:
	MOV	DX,OFFSET PRTC
	MOV	AH,OUTSTR	; Print complete msg
	INT	21H
	JMP	ESCWAIT
;
STAT:				; Toggle status line enable
	CMP	STENB,0
	JE	SETST
	MOV	STENB,0
	MOV	DX,OFFSET STLCLR
STATEX:
	MOV	AH,OUTSTR
	INT	21H
	MOV	AH,OUTSTR
	MOV	DX,OFFSET STCLR
	INT	21H
	JMP	MENU
SETST:
	MOV	STENB,1
	MOV	DX,OFFSET STLSET
	JMP	STATEX
;
ECOTGL:				; Toggle echo flag
	CMP	ECOFLG,0
	JE	SETECO
	MOV	ECOFLG,0
	JMP	MENU
SETECO:
	MOV	ECOFLG,1
	JMP	MENU
;
PSAVE:				; Save program image
	MOV	DX,OFFSET PFCB
	CALL	OPNFIL
	CMP	AL,0		
	JE	PSV_OK
	JMP	OPNERR
PSV_OK:
	MOV	SI,OFFSET START
PSVLP:
	CMP	SI,OFFSET ENDCOD
	JG	PSV_CLS
	MOV	CX,128
	MOV	DI,OFFSET DBUF
	REP	MOVSB
	MOV	AH,SEQWRT
	MOV	DX,OFFSET PFCB
	INT	21H
	CMP	AL,0		; Check for write error
	JE	PSVLP
	MOV	DX,OFFSET DSCERR
	MOV	AH,OUTSTR	; Error - inform user
	INT	21H
	MOV	DX,OFFSET PFCB
	MOV	AH,CLOSE	; Close program file
	INT	21H
	JMP	ESCWAIT
PSV_CLS:
	MOV	DX,OFFSET PFCB
	MOV	AH,CLOSE
	INT	21H
	MOV	DX,OFFSET SAVMSG
	MOV	AH,OUTSTR
	INT	21H
	JMP	ESCWAIT
;
CBAUD:				; Change AUX baud rate
	MOV	DX,OFFSET NEWRAT
	MOV	AH,OUTSTR
	INT	21H		; Request new rate
	MOV	AH,KBDIN
	INT	21H		; Read reply
	CMP	AL,ASC1		; 1-5 ALLOWED
	JL 	MENUJ
	CMP	AL,ASC5
	JG	MENUJ
	AND	AL,15
	MOV	AH,0
	MOV	CURBD,AX	;  Set new default rate
	CALL	CHGB		;  Change it
MENUJ:
	JMP	MENU
;
CPFK:				; Display and change PFK strings
	MOV	DX,OFFSET PFDSPLY
	MOV	AH,OUTSTR
	INT	21H		; Display current values
	MOV	BX,0
	MOV	PFNO,ASC1
	MOV	CX,8
DSPPFLP:
	PUSH	BX
	PUSH	CX
	MOV	DX,OFFSET PFMSG
	MOV	AH,OUTSTR
	INT	21H
	INC	PFNO
	MOV	CL,BYTE PTR FTAB[BX]
	MOV	CH,0
	INC	BX
DSPLP:
	MOV	DL,BYTE PTR FTAB[BX]
	INC	BX
	CMP	DL,CR		; Expand CR,LF,ESC
	JNE	DSPLFT
	MOV	DX,OFFSET CRMSG
DSPSTR:
	MOV	AH,OUTSTR
	INT	21H
	JMP	DSPLUP
DSPLFT:
	CMP	DL,LF
	JNE	DSPESCT
	MOV	DX,OFFSET LFMSG
	JMP	DSPSTR
DSPESCT:
	CMP	DL,ESC
	JNE	DSPOUT
	MOV	DX,OFFSET ESCMSG
	JMP	DSPSTR
DSPOUT:
	MOV	AH,CRTOUT
	INT	21H
DSPLUP:
	LOOP	DSPLP
	POP	CX
	POP	BX
	ADD	BX,64
	LOOP	DSPPFLP
	MOV	DX,OFFSET NEWPFK
	MOV	AH,OUTSTR
	INT	21H		; Request new PFK
	MOV	AH,KBDIN
	INT	21H
	CMP	AL,ASC1		; '1'?
	JL	MENUJ
	CMP	AL,ASC8		; '8'?
	JG	MENUJ
	AND	AL,15		; Range OK - cvt to offset
	DEC	AL
	MOV	AH,0	
	MOV	FSAV,AX
	MOV	CL,6		; Mult by 64
	SHL	AX,CL
	MOV	BX,AX
	MOV	BYTE PTR FTAB[BX],0	; Clear count
	MOV	SI,BX
	INC	BX
	MOV	DX,OFFSET GETPFK
	MOV	AH,OUTSTR
	INT	21H		; Request new value
	MOV	CX,63		; 63 chrs max
KLP:
	MOV	AH,KBDIN
	INT	21H		; Read a chr
	CMP	AL,EOF
	JE	SETPFK		; Ctl/Z terminates
	MOV	BYTE PTR FTAB[BX],AL
	INC	BX
	INC	BYTE PTR FTAB[SI]
	LOOP	KLP
SETPFK:
	CMP	CX,63		; Check for 0 chrs entered
	JE	CLRPFK		; Set to default if so
	JMP	CPFK		; Else re-display values
CLRPFK:
	MOV	AL,ESC
	MOV	BYTE PTR FTAB[BX],AL
	INC	BX
	MOV	BYTE PTR FTAB[SI],2
	MOV	DI,BX
	MOV	BX,FSAV		; Get PFK id
	MOV	AL,PFESC[BX]	; Get ESC control byte
	MOV	BYTE PTR FTAB[DI],AL
	JMP	CPFK
;
EXIT:
	MOV	DX,OFFSET STLCLR	; Clear status line
	MOV	AH,OUTSTR
	INT	21H
	MOV	DX,OFFSET TIMDES ; user must reset clock
	MOV	AH,OUTSTR
	INT	21H
	INT	20H		; Exit to Z-DOS
;
CLEAR:
	MOV	AH,OUTSTR
	MOV	DX,OFFSET CLRTYP	; Request type of clear
	INT	21H
	MOV	AH,KBDIN
	INT	21H
	CMP	AL,ASC1			; 1=Clear buffer
	JE	CLRB
	CMP	AL,ASC2			; 2=Clear timer
	JNE	JMENU
	MOV	CX,0
	MOV	DX,0
	MOV	AH,SETTIME
	INT	21H
JMENU:
	JMP	MENU
CLRB:
	MOV	BUFPTR,OFFSET BIGBUF	; Reset buffer pointer
	JMP	MENU
;
PRINT:
	MOV	LINC,0
	MOV	CHRC,0		; Clear counters
	MOV	EOLF,0
	MOV	PRTPTR,OFFSET SCRBUF	; Flag to print screen
	MOV	PRTREQ,0		
	MOV	AH,OUTSTR
	MOV	DX,OFFSET ENCUR		; Re-enable cursor
	INT	21H
	JMP	BEGIN
RETRN:
	MOV	DX,OFFSET CLS		; Clear screen
	MOV	AH,OUTSTR
	INT	21H
	MOV	BX,OFFSET SCRBUF	; Repaint screen
	MOV	COLC,0
	MOV	ROWC,0
OUTLUP:
	MOV	AH,CRTOUT		
	MOV	DL,[BX]
	INC	BX
	CMP	DL,ESC		; ESC?
	JNE	CKCR		;  No 
	INT	21H		;  Yes - send sequence w/o counting
	MOV	DL,[BX]
	INC	BX
	MOV	AH,CRTOUT
	INT	21H
	CMP	DL,'m'		; If color spec - 2 more chrs
	JNE	OUTLUP
	MOV	DL,[BX]
	INC	BX
	MOV	AH,CRTOUT
	INT	21H
	MOV	DL,[BX]
	INC	BX
	MOV	AH,CRTOUT
	INT	21H
	JMP	OUTLUP
CKCR:
	CMP	DL,CR
	JE	RESTORE
	INC	COLC
	INT	21H
	CMP	COLC,80		; Full line displayed?
	JNE	OUTLUP		;  No
	MOV	COLC,0		;  Yes - do CRLF
	INC	ROWC
	CMP	ROWC,24
	JE	RESTORE
	MOV	AH,CRTOUT
	MOV	DL,CR
	INT	21H
	MOV	AH,CRTOUT
	MOV	DL,LF
	INT	21H
	JMP	OUTLUP
RESTORE:
	MOV	DX,OFFSET RESCUR	; Restore cursor
	MOV	AH,OUTSTR
	INT	21H
	MOV	AH,CRTOUT
	MOV	DL,ADR1
	INT	21H
	MOV	AH,CRTOUT
	MOV	DL,ADR2
	INT	21H
	JMP	BEGIN
;
CHANGE:
	MOV	DX,OFFSET PROMPT	; Request new name
	MOV	AH,OUTSTR
	INT	21H
	MOV	AH,INLINE		; Read reply
	MOV	DX,OFFSET LININP
	INT	21H
	CMP	LINBUF,0		; If no chrs entered -
	JE	OPENFIL			; Then open current file
	MOV	AH,PARSE
	MOV	DI,OFFSET FCB
	MOV	SI,OFFSET LINBUF+1	; Parse to FCB
	INT	21H
OPENFIL:
	MOV	DX,OFFSET FCB
	CALL	OPNFIL			; Open file
	CMP	AL,0			; Check for error
	JNE	OPNERR
	JMP	MENU
OPNERR:
	MOV	DX,OFFSET FILERR
	MOV	AH,OUTSTR
	INT	21H
	JMP	ESCWAIT
;
SAVE:
	MOV	DX,OFFSET FCB
	CALL	OPNFIL			; Open file
	CMP	AL,0
	JNE	OPNERR			; Open error
	MOV	SI,OFFSET BIGBUF
RECLUP:
	MOV	DI,OFFSET DBUF
BLDLUP:
	CMP	SI,BUFPTR
	JE	DONE
	LODSB
	STOSB
	CMP	DI,OFFSET START
	JNE	BLDLUP
	MOV	DX,OFFSET FCB
	MOV	AH,SEQWRT
	INT	21H
	CMP	AL,0
	JE	RECLUP
DERR:
	MOV	DX,OFFSET DSCERR
	MOV	AH,OUTSTR
	INT	21H
	MOV	AH,CLOSE
	MOV	DX,OFFSET FCB
	INT	21H
	JMP	ESCWAIT
;
DONE:
	MOV	AL,EOF		; End of file marker
	STOSB
	MOV	AH,SEQWRT
	MOV	DX,OFFSET FCB	; Write final record
	INT	21H
	CMP	AL,0
	JNE	DERR
	MOV	AH,CLOSE
	MOV	DX,OFFSET FCB
	INT	21H
	MOV	DX,OFFSET SAVMSG
	MOV	AH,OUTSTR
	INT	21H
	MOV	BUFPTR,OFFSET BIGBUF	; Automatic buffer clear
	JMP	ESCWAIT
;
	SUBTTL	FILE TRANSFER COMMUNICATIONS
	PAGE
XMIT:
	MOV	DX,OFFSET XMTTYP
	MOV	AH,OUTSTR
	INT	21H		; Request xmission type
	MOV	AH,KBDIN
	INT	21H
	CMP	AL,ASC1		; 1=Bin
	JE	SETAFLG
	CMP	AL,ASC2		; 2=ASCII
	JE	SETAFLG
	CMP	AL,ASC3		; 3=Direct
	JE	SETAFLG
	JMP	MENU
SETAFLG:
	AND	AL,3
	MOV	AFLG,AL
	MOV	DX,OFFSET FCB
	CALL	OPNFIL		; Open current file
	CMP	AL,0
	JE	XMIT_OK	
	JMP	OPNERR		; Open error - print error
XMIT_OK:
	MOV	AH,OUTSTR
	MOV	DX,OFFSET WATRCV	
	INT	21H		; Waiting for rcvr msg
	MOV 	BLKCNT,ASC0	; Inin comm block counter
	CMP	AFLG,3		; Direct?
	JE	STRTO		;  Yes - no need to connect
	MOV	CX,10		; Try 10 times for connection
GET_RCVR:
	PUSH	CX
	MOV	CX,0
	MOV	DX,0		; Clear timer
	MOV	AH,SETTIME
	INT	21H
	MOV	AH,AUXOUT
	MOV	DL,AFLG		; Request receiver acknowledge
	INT	21H
XMIT_RWAIT:
	CALL	ABTCHK		; Check for operator abort
	JC	XMIT_NOABT
	JMP	ABORTOUT
XMIT_NOABT:
	MOV	AH,GETTIME
	INT	21H
	CMP	DH,3		; 3-second timer
	JE	TRYAGAIN
	MOV	AH,CHR_READ
	CALL	DWORD PTR BIOS_AUXFUNC
	JC	XMIT_RWAIT	; Wait for response
	CMP	AL,ACK		; ACK?
	JE	XMT_STRT	;  Yes
TRYAGAIN:
	POP	CX
	LOOP	GET_RCVR
	MOV	DX,OFFSET NORCVR
	MOV	AH,OUTSTR	; No receiver error
	INT	21H	
	JMP	IOCMPLT
XMT_STRT:
	POP	CX
STRTO:
	MOV	DX,OFFSET BGNXMT
	MOV	AH,OUTSTR	; Begin xmission msg
	INT	21H
XMIT_NXT:
	MOV	AH,DTA
	MOV	DX,OFFSET IOBUF	; Set up for disc read
	INT	21H
	MOV	IOBUF,EOF
	MOV	AH,SEQRED
	MOV	DX,OFFSET FCB	; Read a record from disc
	INT	21H
	MOV	BUFTRM,ETB	; Assume ETB
	CMP	AL,0		; Check for end of file
	JE 	GETNXTBUF
	MOV	BUFTRM,ETX	; ETX on last buffer
GETNXTBUF:
	CMP	AFLG,SOH	; ASCII or bin?
	JE 	EXPND		;  Bin - must expand
	MOV	BYTE PTR IOBUF+128,EOF
	CMP	BUFTRM,ETX	;  ASCII - All done?
	JE	DOOUT		;   Yes
	MOV	AH,DTA		;   No   - need another rec
	MOV	DX,OFFSET IOBUF+128
	INT	21H
	MOV	AH,SEQRED
	MOV	DX,OFFSET FCB	; Read a record from disc
	INT	21H
	CMP	AL,0		; Check for end of file
	JE	DOOUT
	MOV	BUFTRM,ETX	; ETX on last rec in file
	JMP	DOOUT
EXPND:
	MOV	SI,OFFSET IOBUF+127
	MOV	DI,OFFSET IOBUF+255
	STD
	MOV	CX,128
EXPLP:
	LODSB
	MOV	AH,AL
	AND	AL,15
	ADD	AL,ASC0
	CMP	AL,ASC9
	JLE	ST1
	ADD	AL,7
ST1:
	STOSB
	ROR	AH,1
	ROR	AH,1
	ROR	AH,1
	ROR	AH,1
	MOV	AL,AH
	AND	AL,15
	ADD	AL,ASC0
	CMP	AL,ASC9
	JLE	ST2
	ADD	AL,7
ST2:
	STOSB
	LOOP	EXPLP
	CLD
DOOUT:
	CMP	AFLG,3		; Direct?
	JNE	DOERCHK		;  No
	MOV	BX,OFFSET IOBUF ;  Yes - send block
	MOV	CX,256
SNDLP:
	MOV	AH,AUXOUT
	MOV	DL,[BX]
	INC	BX
	INT	21H
	CMP	DL,EOF
	JE	NXTBJ
	LOOP	SNDLP
NXTBJ:
	PUSH	CX
	JMP	NXTBLK
DOERCHK:
	MOV	CX,10		; Init retry counter
SNDAGN:
	PUSH	CX
	MOV	BX,OFFSET IOBUF
	MOV	AH,AUXOUT
	MOV	DL,AFLG		; Buffer header
	INT	21H
	MOV	CX,256		; Max buffer size
	MOV	DH,0		; Clear LRC
XMTLP:
	MOV	AH,AUXOUT
	MOV	DL,[BX]
	INC	BX
	XOR	DH,DL		; Add to LRC
	INT	21H
	CMP	DL,EOF		; End of file?
	JE	XMTEND
LOOPJ:
	LOOP	XMTLP
XMTEND:
	MOV	AH,AUXOUT
	MOV	DL,BUFTRM	; ETB/ETX
	XOR	DH,DL
	INT	21H
	MOV	AH,AUXOUT
	MOV	DL,DH		; LRC
	INT	21H
	MOV	CX,0
	MOV	DX,0		; Clear timer
	MOV	AH,SETTIME
	INT	21H
XMIT_RPL:
	CALL	ABTCHK		; Check for user abort
	JNC	ABORTOUT
	MOV	AH,GETTIME
	INT	21H
	CMP	DH,5		; 5-second timer
	JE	RE_XMIT
	MOV	AH,CHR_READ
	CALL	DWORD PTR BIOS_AUXFUNC
	JC	XMIT_RPL
	CMP	AL,ACK		; ACK?
	JE	NXTBLK		;  Yes - next block
	CMP	AL,NAK		; NAK?
	JNE	ABORTOUT	;  No - EOT assumed
RE_XMIT:
	POP	CX		;  Yes - re-transmit block
	LOOP	SNDAGN
	PUSH	CX
ABORTOUT:
	POP	CX
	MOV	AH,AUXOUT
	MOV	DL,EOT		; Abort w/ EOT
	INT	21H
	MOV	DX,OFFSET ABTMSG	; Inform user
	MOV	AH,OUTSTR
	INT	21H
IOCMPLT:
	MOV	AH,DTA		; Restore disc I/O address
	MOV	DX,OFFSET DBUF
	INT	21H
	MOV	DX,OFFSET FCB
	MOV	AH,CLOSE		; Close file
	INT	21H
	MOV	CX,0
	MOV	DX,0			; Clear timer
	MOV	AH,SETTIME
	INT	21H
	JMP	ESCWAIT
NXTBLK:
	POP	CX
	MOV	DX,OFFSET STATMS	; Display BLKCNT
	MOV	AH,OUTSTR
	INT	21H
	INC	BLKCNT
	CMP	BLKCNT,TILDA
	JL	PRTCNT
	MOV	BLKCNT,ASC0
PRTCNT:
	MOV	DL,BLKCNT
	MOV	AH,CRTOUT
	INT	21H
	CMP	BUFTRM,ETX		; ETX?
	JE	XMTDON			;  Yes - xmit complete
	JMP	XMIT_NXT		;  No - get nxt blk
XMTDON:
	MOV	DX,OFFSET XCMPLT
	MOV	AH,OUTSTR		
	INT	21H
	JMP	IOCMPLT
RCV:
	MOV	DX,OFFSET FCB
	CALL	OPNFIL		; Open active file
	CMP	AL,0
	JE	RCV_OK
	JMP	OPNERR		; On open error display msg
RCV_OK:
	MOV	BLKCNT,ASC0
	MOV	AH,OUTSTR
	MOV	DX,OFFSET WATXMT
	INT	21H		; Waiting for xmittr msg
	MOV	CX,0
	MOV	DX,0		; Clear timer
	MOV	AH,SETTIME
	INT	21H
RCV_WAIT:
	CALL	ABTCHK		; Check for user abort
	JC	RCV_NOABT
	JMP	ABORTIN
RCV_NOABT:
	MOV	AH,GETTIME
	INT	21H
	CMP	DH,30		; 30-second timer
	JE	NOXMITR
	MOV	AH,CHR_READ
	CALL	DWORD PTR BIOS_AUXFUNC
	JC	RCV_WAIT	; Wait for transmitter
	CMP	AL,SOH		; Only allow SOH/STX
	JE	SETF
	CMP	AL,STX
	JE	SETF		
ABORTINJ:
	JMP	ABORTIN		; If none - assume EOT
SETF:
	MOV	AFLG,AL
	MOV	DX,OFFSET BGNRCV
	MOV	AH,OUTSTR	; Begin reception message
	INT	21H
	MOV	AH,AUXOUT
	MOV	DL,ACK		; Acknowledge transmit request
	INT	21H
	JMP	RCV_LP
NOXMITR:
	MOV	DX,OFFSET NOXMTR
	MOV	AH,OUTSTR	; No transmitter message
	INT	21H
	JMP	IOCMPLT
RCV_LP:
	MOV	CX,0
	MOV	DX,0		; Clear timer
	MOV	AH,SETTIME
	INT	21H
	MOV	BX,OFFSET IOBUF
	MOV	BUFTRM,0
	MOV	DH,0		; Clear LRC Accumulator
RCV_NEXCHR1:
	PUSH	BX
RCV_NEXCHR2:
	PUSH	DX
RCV_CWAIT:
	CALL	ABTCHK		; Check for user abort
	JNC	RCV_ABT
	MOV	AH,GETTIME
	INT	21H
	CMP	DH,15		; 15 secont timer
	JE	RCV_ABT
	MOV	AH,CHR_READ
	CALL	DWORD PTR BIOS_AUXFUNC
	JC	RCV_CWAIT	; Wait for character
	POP	DX
	CMP	BUFTRM,0	; LRC next?
	JNE	RCV_LRC
	CMP	AL,ETX		; STX/SOH?
	JGE	RCV_ALRC	;  No
	POP	BX
	JMP	RCV_LP		;  Yes - restart 
RCV_ALRC:
	POP	BX
	CMP	AL,EOT		; EOT?
	JE	ABORTINJ	;  Yes - abort input
	XOR	DH,AL		; Add to LRC
	CMP	AL,ETX		; ETX?
	JE	RCV_SETEND
	CMP	AL,ETB		; ETB?
	JNE	RCV_STORCHR
RCV_SETEND:
	MOV	BUFTRM,AL
	JMP	RCV_NEXCHR1
RCV_ABT:
	POP	DX
	POP	BX
	JMP	ABORTIN
RCV_STORCHR:
	AND	AL,7FH
	CMP	BX,OFFSET IOBEND	; Ensure no buf ovflo
	JE	RCV_NEXCHR1
	MOV	[BX],AL
	INC	BX
	JMP	RCV_NEXCHR1
RCV_LRC:
	POP	BX
	CMP	DH,AL		; LRCs match?
	JE	RCV_ACKIT	;  Yes
	MOV	DL,NAK		;  No - return NAK
	MOV	AH,AUXOUT
	INT	21H
	JMP	RCV_LP
RCV_ACKIT:
	CMP	AFLG,STX	; ASCII?
	JE	RCV_ASC		;  Yes
	MOV	SI,OFFSET IOBUF	;  No bin - compress
	MOV	DI,OFFSET IOBUF
	MOV	CX,128
CMPRLP:
	LODSB
	MOV	AH,AL
	LODSB			; Get 2 bytes
	CMP	AH,ASC9
	JLE	CMP1		; Check for A-F
	SUB	AH,7		;  Adjust
CMP1:
	AND	AH,15
	SHL	AH,1
	SHL	AH,1
	SHL	AH,1
	SHL	AH,1
	CMP	AL,ASC9
	JLE	CMP2		; Check for A-F (LS nibble)
	SUB	AL,7
CMP2:
	AND	AL,15
	OR	AL,AH
	STOSB			; Store compressed byte
	LOOP	CMPRLP
	MOV	AH,DTA
	MOV	DX,OFFSET IOBUF	; Change DTA
	INT	21H
	MOV	AH,SEQWRT	; Write to disc
	MOV	DX,OFFSET FCB
	INT	21H
	CMP	AL,0		; Check for disc error
	JE	RCV_ACK
RCV_DERR:
	MOV	DX,OFFSET DERMS
RCV_EX:
	MOV	AH,OUTSTR
	INT	21H		; Display disc error msg
	MOV	AH,AUXOUT
	MOV	DL,EOT		; EOT To transmitter
	INT	21H
	JMP	IOCMPLT
RCV_ASC:			; ASCII file reception
	MOV	DX,OFFSET IOBUF
	MOV	AH,DTA		; Change DTA
	INT	21H
	MOV	AH,SEQWRT	; Write to disc
	MOV	DX,OFFSET FCB
	INT	21H
	CMP	AL,0
	JNE	RCV_DERR
	MOV	DX,OFFSET IOBUF+128
	MOV	AH,DTA		; New DTA
	INT	21H
	MOV	DX,OFFSET FCB
	MOV	AH,SEQWRT	; Write 2nd record
	INT	21H
	CMP	AL,0
	JNE	RCV_DERR
RCV_ACK:
	MOV	DX,OFFSET STATMS
	MOV	AH,OUTSTR	; Display current block count
	INT	21H
	INC	BLKCNT
	CMP	BLKCNT,TILDA
	JL	DSPCNT
	MOV	BLKCNT,ASC0
DSPCNT:
	MOV	DL,BLKCNT
	MOV	AH,CRTOUT
	INT	21H
	MOV	AH,AUXOUT
	MOV	DL,ACK		; Return ACK
	INT	21H
	CMP	BUFTRM,ETX	; Last buffer in file?
	JE	RCV_DONE	;  Yes - finished
	JMP	RCV_LP		;  No - get next block
RCV_DONE:
	MOV	DX,OFFSET RCVMSG	
	JMP	RCV_EX
ABORTIN:
	MOV	DX,OFFSET RCVABT
	JMP	RCV_EX
;
	SUBTTL	SUBROUTINES
	PAGE
;
;	Subroutines
;
PUTBUF	PROC	NEAR
	AND	AL,7FH
	CMP	PRTON,0		; Xfr to prt if tsp prt on
	JE	PUTBUF_CKEOF
	CALL	PTFIFO
PUTBUF_CKEOF:
	CMP	AL,EOF		; Do not store eof's
	JE	PUTRTN
	CMP	BUFPTR,BUFEND	; Do nothing at end of buffer
	JE	PUTRTN
	PUSH	BX
	MOV	BX,BUFPTR
	MOV	[BX],AL
	INC	BUFPTR
	POP	BX
PUTRTN:
	RET
PUTBUF	ENDP
;
;
ABTCHK	PROC	NEAR
	MOV	AH,CHR_READ	; Check kbd for ctl/A
	CALL	DWORD PTR BIOS_CONFUNC
	JC	ABTRTN
	CMP	AL,1		; Only ctl/A
	JNE	ABTIGNR		;  Ignore all else
	CLC			;  Indicate got ctl/A
	RET
ABTIGNR:
	STC
ABTRTN:
	RET
ABTCHK	ENDP
;
;
OPNFIL	PROC	NEAR		; Open file subroutine
	PUSH	CX
	PUSH	BX
	MOV	CX,24
	MOV	BX,DX
CLRLP:
	MOV	BYTE PTR 12[BX],0 ; Clear FCB
	INC	BX
	LOOP	CLRLP
	MOV	AH,OPEN		; Open file
	INT	21H
	CMP	AL,0		; Does it exist?
	JE	OPNRTN		;  Yes
	MOV	AH,CREATE	;  No - make one
	INT	21H
OPNRTN:
	POP	BX
	POP	CX
	RET
OPNFIL	ENDP
;
;
CHGB	PROC	NEAR		; Change AUX baud rate
	PUSH	DX
	MOV	AH,CHR_STATUS
	MOV	AL,CHR_SFGC	; Get configuration
	MOV	BX,OFFSET CFGBUF
	CALL	DWORD PTR BIOS_AUXFUNC
	MOV	BX,CURBD
	MOV	AL,BDTBL[BX]	; Get current baud rate
	MOV	BX,OFFSET CFGBUF
	MOV	4[BX],AL	; Set in configuration buffer
	MOV	AH,CHR_CONTROL
	MOV	AL,CHR_CFSU	; Now reset configuration
	CALL	DWORD PTR BIOS_AUXFUNC
	POP	DX
	RET
CHGB	ENDP
;
;
STATLN	PROC	NEAR		; Status line display
;
;	Status line updated every 2 seconds when enabled
;
	CMP	STENB,0		; Enabled?
	JNE	STAT_DOIT	;  Yes
	RET			;  No - return
STAT_DOIT:
	MOV	AH,GETTIME	; Get current time
	INT	21H
	TEST 	DH,1		; Even/odd second?
	JE	STAT_EVEN
	MOV	STATFL,0
	RET
STAT_EVEN:
	CMP	STATFL,0	; Displayed this time?
	JE	STAT_NOW
	RET			;  Yes - wait til nxt even sec
STAT_NOW:
	MOV	STATFL,1	; Indicate processed this sec
	MOV	CH,DH		; Save seconds
	MOV	DX,OFFSET TADR	; Address timer field
	MOV	AH,OUTSTR
	INT	21H
	MOV	AL,CL
	MOV	AH,0		; Minutes
	MOV	DH,CH		; Save seconds
	CALL	DECOUT		; Display decimal mins
	MOV	AH,CRTOUT
	MOV	DL,':'
	INT	21H
	MOV	AL,DH
	MOV	AH,0
	CALL	DECOUT		; Display decimal secs
	MOV	AH,OUTSTR
	MOV	DX,OFFSET PADR	; Address percent field
	INT	21H
	MOV	AX,OFFSET BUFEND
	SUB	AX,BUFPTR
	MOV	CX,100		; # free bytes * 100
	MUL 	CX
	MOV	BX,OFFSET BUFEND
	SUB 	BX,OFFSET BIGBUF ; # Bytes in buffer
	DIV 	BX		; Free bytes*100/total bytes
	CMP	AX,99		; Insure 2-digit percent
	JLE	DISPER
	MOV	AX,99
DISPER:
	CALL	DECOUT		; Display percent free
	MOV	AH,OUTSTR
	MOV	DX,OFFSET RCUR	; Restore cursor
	INT	21H
	RET
STATLN	ENDP
;
;
DECOUT	PROC	NEAR		; Display dec ascii # in AX
	MOV	CL,10
	IDIV	CL
	ADD	AX,3030H
	MOV	BX,AX
	MOV	AH,CRTOUT
	MOV	DL,BL
	INT	21H
	MOV	AH,CRTOUT
	MOV	DL,BH
	INT	21H
	RET
DECOUT	ENDP
;
;
SXOFF	PROC	NEAR		; Send XOFF if 9600 bps rate
	CMP	CURBD,3
	JNE	NOXOFF
	MOV	XONFLG,0	; Set XON required flag
	MOV	AH,AUXOUT
	MOV	DL,XOFF
	INT	21H
NOXOFF:
	RET
SXOFF	ENDP
;
;
CVTKBD	PROC	NEAR		; Convert keyboard entries
	MOV	AH,0
	MOV	BX,AX
	SAL	BX,1
	SAL	BX,1
	MOV	CX,4
CVTKLP:
	MOV	AH,AUXOUT	
	MOV	DL,OFFSET TABLE [BX]	; Get table entry
	INC	BX
	CMP	DL,0			; 0=end of entry
	JE	CVTKFIN
	CMP	DL,0FFH			; -1=special processor flag
	JE	CVTKSPEC
	INT	21H			; None - pass to AUX
	CMP	ECOFLG,0		; Echo to CRT?
	JE	CVTKLUP			;  No
	MOV	AH,CRTOUT		;  Yes - send to CRT
	INT	21H
	MOV	AL,DL
	CALL	PUTBUF			; Put in mem too
CVTKLUP:
	LOOP	CVTKLP
CVTKFIN:
	RET
CVTKSPEC:
	INC	BX
	MOV	BX,WORD PTR TABLE [BX]
	POP	AX			; Pop rtn addr
	JMP	BX			; Goto special processor
CVTKBD	ENDP
;
	INCLUDE	KTBL.ASM	; Keyboard conversion table
;
CVTRCV	PROC	NEAR		; Process received characters
	CMP	AL,20H		; Control?
	JL	CVTCTL		;  Yes - special handling
CVTRCV_XFR:
	CALL	XFRCHR		;  No - transfer to CRT
CVTRCV_RTN:
	RET
;
XFRCHR	PROC	NEAR		; Transfer char subroutine
	CALL	PUTBUF		; Put in mem buffer
	CMP	CRTON,0		; Xfr to CRT allowed?
	JNE	XFRCHR_RTN	;  No
	MOV	DL,AL		;  Yes - send to CRT
	MOV	AH,CRTOUT
	INT	21H
XFRCHR_RTN:
	RET
XFRCHR	ENDP
;
;
CVTCTL:
	MOV	BX,OFFSET CVTTBL	; Control table
CVTCTL_LP:
	CMP	BX,OFFSET CVTTBLEND
	JE	CVTRCV_XFR	; If not in table - xfr direct
	CMP	AL,[BX]
	JE	CVTCTL_GOTONE
	ADD	BX,4
	JMP	CVTCTL_LP
CVTCTL_GOTONE:
	MOV	AX,2[BX]	; Processor address
	JMP	AX
;
;	Native mode Z100 conversion table
;
;	This is essentially a skeleton table as no conversion
;	need take place.  The table for other brand X terminals
;	would most likely need some of their control and escape
;	sequences to be converted to those recognizable by the 
;	Z100.  Some example code processors are included.
;
;	Table format:  4-byte entries:
;
;		byte 0 - control character needing conversion
;		byte 1 - character to convert to (not always used)
;		byte 2-3 - address of processor routine
;
CVTTBL:
	DB	ESC,0		; ESC
	DW	OFFSET GOTESC	; Processor address
	DB	16H,0		; SYN
	DW	OFFSET CVTRCV_RTN	; Example ignore routine
	DB	0AH,0AH		; LF
	DW	OFFSET CTLSUBS	; Example substitution routine
CVTTBLEND:
;
CTLSUBS:			; Ctl substitution routine
	MOV	AL,1[BX]	; Get chr to substitute
	JMP	CVTRCV_XFR
;
GOTESC:				; ESC processor
	MOV	AH,AUXIN
	INT	21H		; Read control chr
	MOV	BX,OFFSET ESCTBL
GOTESC_LP:
	CMP	BX,OFFSET ESCTBLEND
	JE	CVTRCV_RTN	; Ignore sequences not in table
	CMP	AL,[BX]
	JE	GOTESC_CVT
	ADD	BX,4
	JMP	GOTESC_LP
GOTESC_CVT:
	MOV	AX,2[BX]	; Processor address
	JMP	AX
;
;	Native mode Z100 esc sequence conversion table
;	
;	All Z100 sequences are present.
;	No conversion is required, however, examples of
;	certain processors are present.
;
;	Table format - 4-byte entries:
;
;		byte 0 - escape command byte
;		byte 1 - substitution command (no always used)
;		byte 2-3 - address of processor
;
;	note: for best performance - the table should be ordered
;	with the most used sequences first
;
ESCTBL:
	DB	'AA'	; Cusror up
	DW	OFFSET SUBSESC	; Example substitution
	DB	'Y '	; Cursor address
	DW	OFFSET XFRESCP2	; Transfer 4-byte sequence
	DB	'm '	; Color select
	DW	OFFSET XFRESCP2
	DB	'x '	; Set modes
	DW	OFFSET XFRSPEC 	; Special check for illegal seqs
	DB	'y '	; Reset modes
	DW	OFFSET XFRSPEC
	DB	'i '	; Zenith identify
	DW	OFFSET XFRESCP1
	DB	'B '	; Cursor down
	DW	OFFSET XFRESC	; Transfer sequence directly
	DB	'C '	; Cursor right
	DW	OFFSET XFRESC
	DB	'D '	; Cursor left
	DW	OFFSET XFRESC
	DB	'E '	; Clear screen
	DW	OFFSET XFRESC
	DB	'H '	; Cursor home
	DW	OFFSET XFRESC
	DB	'I '	; Reverse index
	DW	OFFSET XFRESC
	DB	'j '	; Save cursor
	DW	OFFSET XFRESC
	DB	'n '	; Cursor position report
	DW	OFFSET XFRESC
	DB	'k '	; Restore cursor
	DW	OFFSET XFRESC
	DB	'J '	; Erase end of screen
	DW	OFFSET XFRESC
	DB	'K '	; Erase end of line
	DW	OFFSET XFRESC
	DB	'L '	; Insert line
	DW	OFFSET XFRESC
	DB	'M '	; Delete line
	DW	OFFSET XFRESC
	DB	'N '	; Delete char
	DW	OFFSET XFRESC
	DB	'O '	; Exit insert char
	DW	OFFSET XFRESC
	DB	'@ '	; Enter insert char
	DW	OFFSET XFRESC
	DB	'b '	; Erase to beginning
	DW	OFFSET XFRESC
	DB	'l '	; Erase line
	DW	OFFSET XFRESC
	DB	'o '	; Erase to beginning of line
	DW	OFFSET XFRESC
	DB	'F '	; Enter graphichs mode
	DW	OFFSET XFRESC
	DB	'G '	; Exit graphics mode
	DW	OFFSET XFRESC
	DB	'p '	; Enter rev video
	DW	OFFSET XFRESC
	DB	'q '	; Exit rev video
	DW	OFFSET XFRESC
	DB	'Z '	; Identify
	DW	OFFSET XFRESC
	DB	'# '	; Xmit page
	DW	OFFSET XFRESC
	DB	'] '	; Xmit 25th line
	DW	OFFSET XFRESC
	DB	'^ '	; Xmit line
	DW	OFFSET XFRESC
	DB	'_ '	; Xmit char at cursor
	DW	OFFSET XFRESC
	DB	'{ '	; Kbd enable
	DW	OFFSET XFRESC
	DB	'} '	; Kbd disable
	DW	OFFSET XFRESC
	DB	'v '	; Wrap at eol
	DW	OFFSET XFRESC
	DB	'w '	; Discard at eol
	DW	OFFSET XFRESC
	DB	'= '	; Enter alt kpd mode
	DW	OFFSET ALTKPD
	DB	'> '	; Exit alt kpd mode
	DW	OFFSET XALTKPD
	DB	't '	; Enter kpd shft mode
	DW	OFFSET SHFTKPD
	DB	'u '	; Exit kpd shft mode
	DW	OFFSET XSHFTKPD
ESCTBLEND:
;
XFRESC:				; Direct xfr of esc sequence
	MOV	AL,ESC
	CALL	XFRCHR
	MOV	AL,[BX]
	CALL	XFRCHR
	RET
;
SUBSESC:			; Substitute xfr of esc sequence
	MOV	AL,ESC
	CALL	XFRCHR
	MOV	AL,1[BX]
	CALL	XFRCHR
	RET
;
XFRESCP1:			; Xfr 3-byte sequence
	MOV	AL,ESC
	CALL	XFRCHR
	MOV	AL,[BX]
	CALL	XFRCHR
	JMP	PLUS1
;
XFRESCP2:			; Xfr 4-byte sequence
	MOV	AL,ESC
	CALL	XFRCHR
	MOV	AL,[BX]
	CALL	XFRCHR
PLUS2:
	MOV	AH,AUXIN	; Read 3rd chr of sequence
	INT	21H
	CALL	XFRCHR
PLUS1:				; Read 4th chr of sequence
	MOV	AH,AUXIN
	INT	21H
	CALL	XFRCHR
	RET
;
XFRSPEC:			; Special filter for Z100 terms
	MOV	AH,AUXIN
	INT	21H		; Read 3rd chr of sequence
	CMP	AL,'?'		; Disallow kbd expansion chgs
	JE	XFRSPEC_RTN
	CMP	AL,'6'		; keypad shft mode
	JE	XFRSPEC_SHFT
	CMP	AL,'7'		; alt keypad mode
	JE	XFRSPEC_ALT
	CMP	AL,'@'		; Disallow event key mode
	JE	XFRSPEC_RTN
	MOV	CL,AL		; Save 3rd chr
	MOV	AL,ESC
	CALL	XFRCHR
	MOV	AL,[BX]
	CALL	XFRCHR
	MOV	AL,CL
	CALL	XFRCHR
XFRSPEC_RTN:
	RET
;
XFRSPEC_SHFT:
	MOV	AL,[BX]
	CMP	AL,'x'
	JE	SHFTKPD
	JMP	XSHFTKPD
;
XFRSPEC_ALT:
	MOV	AL,[BX]
	CMP	AL,'x'
	JE	ALTKPD
	JMP	XALTKPD
;
SHFTKPD:
	MOV	SHFTFLG,1	; Indicate keypad shifted
	MOV	SI,OFFSET SHFT1
	MOV	DI,OFFSET TABLE+(4*0ADH)
	MOV	CX,13*4		; (Unshifted values)
	REP	MOVSB		; Alter keyboard table
	MOV	SI,OFFSET SHFT2
CHGXIT:
	MOV	DI,OFFSET TABLE+(4*0EDH)
	MOV	CX,13*4		; (Shifted values)
	REP	MOVSB
	RET
XSHFTKPD:
	MOV	SHFTFLG,0	; Indicate keypad not shifted now
	MOV	SI,OFFSET SHFT2
	MOV	DI,OFFSET TABLE+(4*0ADH)
	MOV	CX,13*4
	REP	MOVSB
	MOV	SI,OFFSET SHFT1
	JMP	CHGXIT
;
ALTKPD:
	MOV	SI,OFFSET ALT1
	MOV	DI,OFFSET SHFT2
	MOV	CX,13*4
	REP	MOVSB
	CMP	SHFTFLG,0
	JE	XSHFTKPD
	JMP	SHFTKPD
XALTKPD:
	MOV	SI,OFFSET ALT2
	MOV	DI,OFFSET SHFT2
	MOV	CX,13*4
	REP	MOVSB
	CMP	SHFTFLG,0
	JE	XSHFTKPD
	JMP	SHFTKPD
;
SHFT1:
	DB	2DH,0,0,0
	DB	2EH,0,0,0
	DB	0,0,0,0
	DB	30H,0,0,0
	DB	1BH,'L',0,0
	DB	1BH,'B',0,0
	DB	1BH,'M',0,0
	DB	1BH,'D',0,0
	DB	1BH,'H',0,0
	DB	1BH,'C',0,0
	DB	1BH,'@',0,0
	DB	1BH,'A',0,0
	DB	1BH,'N',0,0
;
SHFT2:
	DB	2DH,0,0,0
	DB	2EH,0,0,0
	DB	0,0,0,0
	DB	30H,0,0,0
	DB	31H,0,0,0
	DB	32H,0,0,0
	DB	33H,0,0,0
	DB	34H,0,0,0
	DB	35H,0,0,0
	DB	36H,0,0,0
	DB	37H,0,0,0
	DB	38H,0,0,0
	DB	39H,0,0,0
;
ALT2:
	DB	2DH,0,0,0
	DB	2EH,0,0,0
	DB	0,0,0,0
	DB	30H,0,0,0
	DB	31H,0,0,0
	DB	32H,0,0,0
	DB	33H,0,0,0
	DB	34H,0,0,0
	DB	35H,0,0,0
	DB	36H,0,0,0
	DB	37H,0,0,0
	DB	38H,0,0,0
	DB	39H,0,0,0
;
ALT1:
	DB	1BH,'?m',0
	DB	1BH,'?n',0
	DB	0,0,0,0
	DB	1BH,'?p',0
	DB	1BH,'?q',0
	DB	1BH,'?r',0
	DB	1BH,'?s',0
	DB	1BH,'?t',0
	DB	1BH,'?u',0
	DB	1BH,'?v',0
	DB	1BH,'?w',0
	DB	1BH,'?x',0
	DB	1BH,'?y',0
;
CVTRCV	ENDP
;
;
GTFIFO	PROC	NEAR
	PUSH	BX
	PUSH	SI
	MOV	BX,OFFSET PRTFIF
	MOV	SI,FCURO[BX]
	CMP	SI,FCURI[BX]
	JE	GTF_EMPTY
	MOV	AL,[SI]
	INC	SI
	CMP	SI,FADRE[BX]
	JLE	GTF_NOWRP
	MOV	SI,[BX]
GTF_NOWRP:
	MOV	WORD PTR FCURO[BX],SI
	STC
GTF_RTN:
	POP	SI
	POP	BX
	RET
GTF_EMPTY:
	CLC
	JMP	GTF_RTN
GTFIFO	ENDP
;
;
PTFIFO	PROC	NEAR
	PUSH	BX
	PUSH	SI
	MOV	BX,OFFSET PRTFIF
	MOV	SI,FCURI[BX]
	MOV	[SI],AL
	INC	SI
	CMP	SI,FADRE[BX]
	JLE	PTF_NOWRP
	MOV	SI,[BX]
PTF_NOWRP:
	CMP	SI,FCURO[BX]
	JE	PTF_FULL
	MOV	FCURI[BX],SI
	CLC
PTF_RTN:
	POP	SI
	POP	BX
	RET
PTF_FULL:
	STC
	JMP	PTF_RTN
PTFIFO	ENDP
;
PRTFIF	DW	OFFSET FIFBUF	; Transparent print fifo buffer
	DW	OFFSET SCRBUF-2
	DW	OFFSET FIFBUF
	DW	OFFSET FIFBUF
ENDCOD:
FIFBUF:
	ORG	OFFSET FIFBUF+1000	; 1000 byte fifo
SCRBUF:
	ORG	OFFSET SCRBUF+2400	; 2400 byte screen buffer
BIGBUF:
TERM	ENDS
	END	START
