	PAGE    60,128
	TITLE   SPOOLER.ASM V1.0
	COMMENT *
	
	PROGRAM:        SPOOLER.ASM  Version 1.1 for the H/Z 100 under ZDOS
	AUTHOR:         Mike Nice, HUG MEtro  [73565,565]
	DATE:           April 27,1983






			MODULE DESCRIPTION
			------------------
 
		     This  program sets  up an environment in which 
		any output for the printer is buffered before being
		printed. After the output is placed into the buffer
		control is passed back to the caller. The output is
		then printed.   The  print routine is given control
		at each tick of  the system timer, at which time it
		sends the  buffered output to the  printer of up to 
		twenty characters, unless the printer is busy. This
		allows a maximum print  speed of 200 characters per
		second (10 ms timer).
		     Using  this method, the program printing  does 
		not have to wait for the printed output to complete
		before  continuing, therefore  making better use of 
		the CPU and allows  the user to run other  programs
		as the printer is still printing.
			The command format is:  SPOOLER  N
		where N specifies the  buffer size in K bytes  from
		1-63.   If N is not specified, a default size of 16
		K is used.  Once the program is invoked, the buffer
		size cannot be  changed and the program will remain
		resident. It can only be removed by rebooting ZDOS.
		The contents of the buffer can be  deleted and out-
		put halted by printing the sequence ESC DEL.
			LPRINT CHR$(27)+CHR$(127);      

		    Disk operation will be slowed while the program
		is spooling output. If you have a parallel printer,
		or are  operating at a speed  other than 9600 baud,
		change WAIT_TIME higher or lower to accomodate your
		printer and/or optimize disk response.

		TO USE:  MASM SPOOLER;
			 LINK SPOOLER;
			 EXE2BIN SPOOLER.EXE.COM

		NOTE:  This  program flags 2 errors during assembly
		and one  during the link  process, but the  correct
		code is produced.


						Mike Nice
			
		*
		PAGE
; 
INT_SEG         SEGMENT AT 00H          ; interrupt segment
		ORG     4*42H
TIMER           LABEL   FAR             ; timer interrupt
DUMMY_TIMER     LABEL   FAR             ; dummy label
INT_SEG         ENDS
; 
BIOS_SEG        SEGMENT AT 40H
		ORG     25*3
PRINTER_CALL    LABEL   FAR     ; to be changed at run time
DUMMY_PRNFUNC   LABEL   FAR     ; dummy label
BIOS_SEG        ENDS
; 
; 
CSEG            SEGMENT 
		ASSUME  CS:CSEG,DS:CSEG,ES:CSEG,SS:CSEG
		ORG     100H
SPOOLER:        JMP     START                   ; br. around program
; 
ESCAPE_CHR	EQU	10H			; escape character detected
BF_ACTIVE	EQU	20H			; buffer operation active
BF_FULL         EQU     80H                     ; buffer full
BF_EMPTY        EQU     40H                     ; buffer empty
NO_ESCAPE	EQU	0EFH			; no escape character
NOT_FULL	EQU	07FH			; buffer not full
NOT_EMPTY	EQU	0BFH			; buffer not empty
BF_NOT_ACTIVE	EQU	0DFH			; buffer not active
MEMSIZE		EQU	DS:2			; last paragraph of memory plus 1
FCB             EQU     05DH                  	; file control block
DEFAULT_BUFSIZE EQU     16                      ; default buffer size: 16 k
CR              EQU     0DH			; carriage return
LF              EQU     0AH			; line feed
ESC		EQU	1BH			; ASCII escape
DEL		EQU	7FH			; ASCII delete
WRITE_FUNC	EQU	00H			; write to printer
WAIT_TIME	EQU	7			; number of times to loop
						;  while waiting for printer
; Set WAIT_TIME to 56 for 1200 baud operation
; 
; 
FLAGS		LABEL BYTE			; flags byte
		DB	0
FIRST_CHAR:     DW      0                       ; first char. pointer
LAST_CHAR:      DW      0                       ; last char. pointer
END_OF_BUFFER:  DW      0                       ; end of buffer
BUFFER_SEGMENT: DW	0			; storage for ES
PRINTER_HOOK:	DB	0E9H  ; "JMP"		 storage for jumps which
 		DB	2 DUP (?)		; point to our local
;                					print routine
		PAGE
; 
; 
; ==>After the spooler has installed itself, the ZDOS  BIOS_PRNFUNC is 
;    modified so that all calls are directed to this routine, where the
;    function is examined.  If it is a character to be printed, it is 
;    placed in the buffer and the buffer pointers updated.  All other
;    PRN_FUNC calls are passed to the BIOS_PRNFUNC routine.  
;NOTE:  This routine is entered with the code segment pointing to the BIOS
;	segment.
;
;
PRINTER_OUT     PROC    FAR
		PUSH	DS			; save segments
		PUSH	ES
		PUSH	BX
DS_ADDR:	MOV	BX,0			; to be determined at run time
		MOV	DS,BX			; make sure we point to data
		MOV	ES,BUFFER_SEGMENT	; point to buffer
		CMP     AH,WRITE_FUNC           ; see if write function
		JZ	WRITE_CHARACTER
		CALL	EXCHANGE		; restore PRNFUNC header
		POP	BX			; restore caller's BX
		POP	ES			; and ES
     		CALL    PRNFUNC                 ; otherwise handle as usual
		PUSH	ES
		PUSH	BX
		PUSHF				; save flags
		CALL	EXCHANGE		; set jump addresses again
		POPF				; restore flags
		JMP     PRINTER_OUT_RET
WRITE_CHARACTER:
		TEST	FLAGS,ESCAPE_CHR	; was the last char an ESC?
		JZ	CHECK_ESCAPE
		CMP	AL,DEL			; does this complete ESC-DEL?
		JNZ	CHECK_ESCAPE		; no
		MOV	AX,OFFSET BUFFER_AREA	; reset buffer
		MOV	FIRST_CHAR,AX		;   and character
		MOV	LAST_CHAR,AX		;   pointers	
		OR	FLAGS,BF_EMPTY		; show buffer empty
		JMP	PRINTER_OUT_RET		; and return
;
CHECK_ESCAPE:	AND	FLAGS,NO_ESCAPE		; reset flag
		CMP	AL,ESC			; escape character?
		JNZ	SEE_IF_FULL
		OR	FLAGS,ESCAPE_CHR	; show that last char was escape
SEE_IF_FULL:	TEST	FLAGS,BF_FULL		; buffer full?
		JZ	ADD_CHARACTER			
		STC				; buffer full; show not ready
		JMP	PRINTER_OUT_RET		; and return
ADD_CHARACTER:	OR	FLAGS,BF_ACTIVE		; show buffer operation taking place
		MOV	BX,LAST_CHAR		; get pointer
		MOV	BYTE PTR ES:[BX],AL	; store character
		AND	FLAGS,NOT_EMPTY		; show buffer has something
		CMP	END_OF_BUFFER,BX	; end of buffer?
		JNZ	CHECK_FOR_FULL	
		MOV	BX,OFFSET BUFFER_AREA	; point to start of buffer
		DEC	BX			;  minus one
CHECK_FOR_FULL:	INC	BX			; point to next character
		MOV	LAST_CHAR,BX		; store it
		CMP	WORD PTR FIRST_CHAR,BX  ; buffer full?
		CLC				; no error
		JNZ	PRINTER_OUT_RET
		OR	FLAGS,BF_FULL		; show full
		CLC				; no error
PRINTER_OUT_RET:
		PUSHF				; save flags
		AND	FLAGS,BF_NOT_ACTIVE	; show buffer operation done
		POPF				; restore flags
		POP	BX
		POP	ES
		POP	DS			; restore segments
		RET				; long return to caller
PRINTER_OUT     ENDP
; 
; 
; 
; 
PRNFUNC         PROC    NEAR
PRN_ADDR:       CALL    DUMMY_PRNFUNC		; to be determined at run time
		RET				; jump to BIOS_PRNFUNC
PRNFUNC         ENDP
		PAGE
; 
; 
;==>	This routine is called during every tick of the system timer (10 ms).
;	During this time up to 20 characters are sent to the printer, depend-
;	ing upon whether or not the printer is ready and if there are 20
;	characters in the buffer.
; 
; 
TIMER_INT       PROC    NEAR
		PUSH	AX			; save regs
		PUSH	BX
		PUSH	DX
		PUSH	DS
		PUSH	ES
		PUSH	DI
		PUSH	SI
		MOV	BX,CS			; set up DS
		MOV	DS,BX
		TEST	FLAGS,BF_ACTIVE		; buffer operation taking place?
		JNZ	TIMER_RET		;   then don't disturb
		CALL	EXCHANGE
		MOV	DL,20			; 20 chars max
NEXT_CHAR:	MOV	DH,WAIT_TIME		; maximum time to loop
		TEST	FLAGS,BF_EMPTY		; nothing to print?
		JNZ	TIMER_RET0
WAIT_NOT_BUSY:	MOV	ES,BUFFER_SEGMENT	; get segment
		MOV	BX,FIRST_CHAR		; point to character
		MOV	AL,BYTE PTR ES:[BX]	; get character
		MOV	AH,WRITE_FUNC		; write it
		PUSH	DX			; save counters
		PUSH	BX
		CALL	PRNFUNC
		POP	BX
		POP	DX			; restore counters
		JNC	PRINTED			; was the character printed?
		DEC	DH			; check time
		JNZ	WAIT_NOT_BUSY		; try again
		JMP	TIMER_RET0		; printer busy; exit
PRINTED:	CMP	BX,END_OF_BUFFER 	; end of buffer?
		JNZ	CHECK_FOR_EMPTY
		MOV	BX,OFFSET BUFFER_AREA	; point to start of buffer
		DEC	BX			; 	  minus one
CHECK_FOR_EMPTY: INC	BX			; point to next character
		MOV	FIRST_CHAR,BX		; save pointer
		AND	FLAGS,NOT_FULL		; buffer not full
		CMP	BX,LAST_CHAR 		; buffer empty?
		JNZ	WAS_NOT_EMPTY
		OR	FLAGS,BF_EMPTY
WAS_NOT_EMPTY:	DEC	DL			; 20 chars printed yet?
		JNZ	NEXT_CHAR		; try another
TIMER_RET0:	CALL	EXCHANGE		; restore jump
TIMER_RET:	POP	SI			; restore regs
		POP	DI	
		POP	ES
		POP	DS
		POP	DX
		POP	BX
		POP	AX
TIMER_JMP:	JMP     DUMMY_TIMER	        ; to be determined at run time.
TIMER_INT       ENDP				; actual timer routine takes
;						  over from here.
;
;
; 
EXCHANGE	PROC	NEAR
;
;==>	This routine exchanges the jump hook to the local "PRNFUNC" with the
; 	program header bytes which were there when the spooler installed itself
;
		PUSH	AX
		PUSH	BX
		MOV	BX,SEG BIOS_SEG		; get segment
		MOV	ES,BX			; point to buffer
		MOV	AX,PRINTER_HOOK		; get first two bytes from storage
		MOV	SI,PRN_ADDR+1		; point to PRNFUNC
		MOV	BX,ES:[SI]		; get first two bytes from PRNFUNC
		MOV	ES:[SI],AX		; store first two bytes
		MOV	PRINTER_HOOK,BX		; save for later use
		MOV	AL,BYTE PTR PRINTER_HOOK+2  ; get next byte
		INC	SI
		INC	SI
		MOV	BL,BYTE PTR ES:[SI]	; get next byte
		MOV	BYTE PTR PRINTER_HOOK+2,BL	; save...
		MOV	BYTE PTR ES:[SI],AL	; set up complete
		POP	BX
		POP	AX
		RET
EXCHANGE	ENDP
; 
		PAGE
; 
; 
; 
BUFSEG		SEGMENT PARA COMMON 'INIT'
		ASSUME	CS:NOTHING,ES:BUFSEG,DS:NOTHING,SS:NOTHING
; 					 buffer will overlay initialization
BUFFER_AREA 	EQU THIS FAR		; routine after program has installed
BUFSEG		ENDS			; itself
; 
; 
; 
		ASSUME CS:CSEG,ES:CSEG,DS:CSEG,SS:CSEG
INIT_ROUTINE	PROC	NEAR

						; ensure that buffer segment
	IF ($ - SPOOLER) MOD 16			; will start on a paragraph
		ORG $ + 16 - (($-SPOOLER) MOD 16) ; boundary
	ENDIF
; 
; 
;==>	This routine checks the specified buffer size and initializes all
;	special locations:  PRINTER_HOOK, DS_ADDR, PRN_ADDR, TIMER_JMP,
;	the BIOS_PRNFUNC header, and the timer interrupt location.
;
;
START:
;	First, let's make sure the program is not already installed
;
		MOV	BX,SEG	INT_SEG		; get interrupt segment
		MOV	ES,BX			; in ES
		MOV	BX,OFFSET TIMER
		MOV	SI,ES:[BX]		; get address of timer code
		MOV	ES,ES:[BX+2]		; get timer code segment
		MOV	DI,OFFSET TIMER_INT	; get address of local timer
		MOV	BX,32			; compare first 16 words
COMPARE:	MOV	CX,ES:[BX+SI]		; get the timer code
		CMP	[BX+DI],CX		; make the comparison
		JNZ	NOT_INSTALLED		; no match
		DEC	BX			; keep count
		DEC	BX
		JNZ	COMPARE
		MOV	DX,OFFSET ALREADY	; match; print message
		MOV	AH,9			; print string
		INT	21H			; invoke DOS
		JMP	EXIT			; and abort
;
NOT_INSTALLED:  MOV     SI,OFFSET FCB           ; point to memory size
		MOV	AL,[SI]			; get first char
		CMP     AL,' '                  ; any specified?
		JNZ     SPECIFIED               ; get buffer size
		MOV     DX,DEFAULT_BUFSIZE      ; default if none given
		JMP     SET_BUFFER
SPECIFIED:      MOV	DL,[SI+2]		; make sure valid size
		CMP	DL,' '			; space?
		JZ      SIZE_OK                 ; less than 3 characters
		JMP     NOT_VALID               ; too long
SIZE_OK:	MOV	DL,[SI+1]
		CMP     DL,' '                  ; two digits typed?
		JNZ	TWO_DIGITS		; yes
		MOV	DL,AL			; move digit to one's place
		MOV	AL,0			; make sure it is correct
		JMP	ONE_DIGIT
TWO_DIGITS:	CMP     AL,'9'
		JA      NO_GOOD
		CMP     AL,'0'
		JB      NO_GOOD
		JMP     GOOD
NO_GOOD:        JMP     NOT_VALID
GOOD:           AND     AL,0FH                  ; strip off ascii
		MOV	AH,10
		IMUL    AH			; multiply by ten
ONE_DIGIT:      CMP     DL,'0'                  ; check for validity
		JB	NOT_OK			; less than 0
		CMP     DL,'9'
		JA	NOT_OK			; greater than 9
		JMP     OK
NOT_OK:         JMP     NOT_VALID
OK:             AND     DL,0FH                  ; strip off ascii
		ADD     DL,AL                   ; get size in K
		CMP	DL,0			; rule out 0 K
		JZ	NOT_OK
		CMP	DL,63			; rule out > 63 K
		JA	NOT_OK
;
SET_BUFFER:	XOR	BX,BX			; get a zero
		MOV     AX,1024                 ; 1 K		
SET:		ADD     BX,AX                   ; add one K
		DEC     DL                      ; done?
		JNZ     SET			; need some more
		DEC     BX                      ; correct count
;
		MOV     AX,OFFSET BUFFER_AREA   ; locate start of buffer
		ADD     AX,BX			; locate end of buffer
		MOV     DX,OFFSET BUFFER_AREA   ; locate buffer area
		MOV     FIRST_CHAR,DX           ; and set up the first
		MOV     LAST_CHAR,DX            ; and last char pointers
		MOV     END_OF_BUFFER,AX	; set end of buffer
		OR      FLAGS,BF_EMPTY          ; set buffer empty
		AND	FLAGS,NOT_FULL
; 
		MOV	AX,CS			; get current code segment
		MOV	DS_ADDR+1,AX		; set up for data segment
		ADD	AX,OFFSET START/16	; compute buffer segment
		MOV	BUFFER_SEGMENT,AX	; store for later use
;
		MOV	DX,END_OF_BUFFER	; get last part of pgm
		MOV	CL,4			; convert to paragraph
		ROR	DX,CL
		AND	DX,0FFFH		; mask out carry
		ADD	AX,DX			; to ensure that there
		CMP	AX,MEMSIZE		; is enough memory
		JB	ENOUGH_MEMORY
		MOV	DX,OFFSET NOT_ENOUGH	; wasn't enough--print
		MOV	AH,9			; error message and
		INT	21H			; abort...
		JMP	EXIT
;
ENOUGH_MEMORY:	MOV	AX,SEG BIOS_SEG		; point to BIOS segment
		MOV	ES,AX
		MOV	BX,OFFSET PRINTER_CALL+1   ; point to routine
		MOV	AX,ES:[BX]		; get address of printer function
		ADD	AX,04EH			; compute actual address
		MOV	PRN_ADDR+1,AX		; set up for function call
		ADD	AX,403H			; compute absolute address
; 
		MOV	BX,OFFSET PRINTER_OUT	; get address of local "prnfunc"
		MOV	DX,CS			; get current segment
		MOV	CL,4			; shift by 4
		RCL	DX,CL			; to get absolute address
		AND	DX,0FFF0H		; strip carry, if any
		ADD	BX,DX			; current code
		SUB	BX,AX			; compute displacement
		MOV	PRINTER_HOOK+1,BX	; set jump address
		CALL	EXCHANGE		; initialize address
; 
		MOV	BX,SEG INT_SEG		; point to interrupt segment
		MOV	ES,BX			; to set up the local timer
		MOV	BX,OFFSET TIMER		; point to timer interrupt
		MOV	AX,ES:[BX]              ; get program address
		MOV	TIMER_JMP+1,AX		; put in jump location
		INC	BX
		INC	BX			; point to code segment
		MOV	AX,ES:[BX]		; get code segment
		MOV	TIMER_JMP+3,AX		; set jump location
; 
		MOV     DX,OFFSET TIMER_INT     ; get timerint routine
		MOV     AX,CS                   ; get seg ptr.
		MOV     DS,AX                   ; set int "42" cseg
		MOV     AH,25H                  ; dos call - set int.
		MOV     AL,42H                  ; replace int "42"
		INT     21H                     ; call dos
; 
		MOV     DX,OFFSET SIGNON        ; print signon message
		MOV     AH,9                    ; print string
		INT     21H
; 
		MOV     DX,END_OF_BUFFER        ; locate end of pgm.
		INC	DX			; plus one
		ADD	DX,OFFSET START		; allow for program
		INT	27H			; end but remain resident
;
;
NOT_VALID:      MOV     DX,OFFSET ERMSG         ; invalid memory size
		MOV     AH,9                    ; print string
		INT     21H                     ; invoke dos
EXIT:           INT     20H                     ; terminate program
; 
ERMSG:          DB      7,LF,'Invalid buffer size: must be 1-63 K',CR,LF,'$'
SIGNON:         DB      LF,'Spooler installed and ready',cr,lf,'$'
ALREADY:        DB      7,LF,'Spooler already installed',cr,lf,'$'
NOT_ENOUGH:	DB	7,LF,'Not enough memory for that buffer size',cr,lf,'$'
; 
INIT_ROUTINE    ENDP
CSEG		ENDS
		END	SPOOLER
; End of spooler program !
nough memory for that buf