;****************************************
;*					*
;*		ERRORS			*
;*		======			*
;*					*
;*   PRINTS # OF SOFT DISK ERRORS      	*
;*        SINCE LAST COLD BOOT		*
;*					*
;*   RUNS ON H89, H8 (USES 8080 CODE),	*
;*   32K MEMORY, REQUIRES CPM 2.2.	*
;*				     	*
;*      WRITTEN BY  R L GAZLAY	     	*
;*				     	*
;*            17 JULY 1981	     	*
;*				     	*
;****************************************
;		
;	MODIFIED BY P. SWAYNE, HUG  6-APR-82
;
;
;	MISC EQUATES
;
CR	EQU	0DH
LF	EQU	0AH
;
CONOUT	EQU	2
PSTRING EQU	9
;
BASE	EQU 	0
BDOS	EQU	BASE+5
	ORG	BASE+100H
;
MAIN:	LXI	H,0
	DAD	SP		;FIND CP/M STACK
	LXI	SP,STACK	;SET NEW STACK
	PUSH	H		;SAVE OLD STACK
	LXI	D,CRLF
	MVI	C,PSTRING
	CALL	BDOS		;PRINT CR, LF
	LHLD	BASE+1		;BET BIOS ADDRESS
	LXI	D,33H-3		;OFFSET TO VERSION NO. (.03)
	DAD	D
	MOV	A,M		;GET VERSION NUMBER
	STA	VERS		;SAVE IT
	LHLD	BASE+1		;GET BIOS ADDRESS
	LXI	D,49H-3		;OFFSET TO H17 ERROR COUNT (.03)
	CPI	3		;VERSION .03?
	JZ	VERS3		;YES
	LXI	D,4CH-3		;OFFSET TO ERROR COUNT (.02)
VERS3:	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M		;(DE) = H17 ERROR COUNT
PHERR:	XCHG
	CALL	DECOUT		;PRINT ERRORS
	LXI	D,MSG1		;POINT TO MESSAGE
	MVI	C,PSTRING	;READY TO PRINT STRING
	CALL	BDOS		;PRINT H17 ERRORS
	LDA	VERS		;GET VERSION NUMBER
	CPI	3		;VERSION 3?
	JNZ	EXIT		;IF NOT, FINISHED
	LHLD	BASE+1		;ELSE, GET BIOS ADDRESS
	LXI	D,4BH-3		;OFFSET TO H37 ERROR COUNT
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M		;(DE) = H37 ERROR COUNT
	XCHG
	CALL	DECOUT		;PRINT H37 ERRORS
	LXI	D,MSG2
	MVI	C,PSTRING
	CALL	BDOS		;PRINT SOFT ERROR MESSAGE
EXIT:	LXI	D,LBMSG		;GET "LAST BOOT" MESSAGE
	MVI	C,PSTRING
	CALL	BDOS		;PRINT IT
	POP	H		;GET OLD STACK
	SPHL			;SET IT
	RET
;
;	PRINT NUMBER IN (HL) IN DECIMAL
;
DECOUT:	PUSH	B
	PUSH	D
	PUSH	H		;SAVE REGISTERS
	LXI	B,-10		;RADIX FOR CONVERSION
	LXI	D,-1		;SUBTRACTION COUNTER
DX:	DAD	B		;SUBTRACT 10
	INX	D		;INCREMENT COUNTER
	JC	DX		;REPEAT UNTIL OVERFLOW
	LXI	B,10
	DAD	B		;ADD RADIX BACK IN ONCE
	XCHG			;(DE) = DIGIT, (HL) = NUMBER/10
	MOV	A,H
	ORA	L		;DONE?
	CNZ	DECOUT		;CALL RECURSIVELY UNTIL DONE
	MOV	A,E		;GET CHARACTER TO PRINT
	ADI	'0'		;ADD ASCII BIAS
	MOV	E,A		;PUT RESULT IN E
	MVI	C,CONOUT
	CALL	BDOS		;PRINT DIGIT
	POP	H
	POP	D
	POP	B		;RESTORE REGISTERS
	RET
;
VERS	DB	0		;SAVE VERSION NO. HERE
;
MSG1:	DB	' H17 SOFT DISK ERRORS',CR,LF,'$'
MSG2:	DB	' H37 SOFT DISK ERRORS',CR,LF,'$'
LBMSG:	DB	'SINCE LAST COLD BOOT.'
CRLF:	DB	CR,LF,'$'
;
	DS	64		;STACK SPACE
STACK	DS	0
;
	END	MAIN
K ERRORS