;	TITLE	'ALPHABETICAL SORTER FOR ASCII FILES - VER 14'
;	STL	'   WILLIAM W. MOSS - 29 JULY, 1979'
;
; SORTS ASCII FILES ALPHABETICALLY USING SHELL-METZNER SORT ROUTINE
;
;	CP/M VERSION BY PATRICK SWAYNE  25-NOV-80  15-DEC-80
;
;
; CP/M BDOS ADDRESSES
;
BOOT	EQU	0		;RE-BOOT CP/M
BDOS	EQU	BOOT+5		;BDOS ENTRY JUMP
HIGH	EQU	BOOT+6		;ADDRESS OF HIGH MEMORY
FCB1	EQU	BOOT+5CH	;FIRST FILE NAME
FCB2	EQU	BOOT+6CH	;SECOND FILE NAME
INBUF	EQU	BOOT+80H	;DEFAULT DMA ADDRESS
;
; CP/M BDOS FUNCTIONS
;
READF	EQU	1		;READ CONSOLE INTO A
TYPEF	EQU	2		;WRITE CONSOLE FROM E
PRINTF	EQU	9		;PRINT FUNCTION
OPEN	EQU	15		;OPEN FILE
CLOSE	EQU	16		;CLOSE FILE
FIND	EQU	17		;FIND FILE IN DIRECTORY
DELETE	EQU	19		;DELETE FILE
READ	EQU	20		;READ FILE
WRITE	EQU	21		;WRITE FILE
MAKE	EQU	22		;MAKE FILE DIRECTORY ENTRY
;
; OTHER DEFFINITIONS
;
CR	EQU	0DH		;CARRIAGE RETURN
LF	EQU	0AH		;LINE FEED
;
; START HERE
;
	ORG	BOOT+100H
START:	LXI	SP,STAK
	LXI	D,HEADER
	CALL	TYPTX		;PRINT SIGN-ON
	LDA	FCB1+1
	CPI	' '		;CHECK IF INPUT FILE ENTERED
	JZ	TPINST		;PRINT INSTRUCTIONS IF NOT
	LDA	FCB2+1
	CPI	' '		;CHECK IF OUTPUT FILE ENTERED
	JNZ	START0		;SKIP IF IT IS
TPINST:	LXI	D,INST
	CALL	TYPTX		;PRINT INSTRUCTIONS
	JMP	BOOT		;EXIT
START0:	MVI	C,16		;MOVE 2ND FILE NAME TO DFCB
	LXI	D,FCB2		;POINT TO FILE NAME
	LXI	H,DFCB		;WHERE TO MOVE IT
MFCB:	LDAX	D
	INX	D
	MOV	M,A
	INX	H
	DCR	C
	JNZ	MFCB
	XRA	A
	STA	DFCB+32		;CLEAR CURRENT RECORD
;
; OPEN FILES
;
	LXI	D,FCB1
	MVI	C,OPEN
	CALL	BDOS		;OPEN SOURCE FILE
	INR	A		;GOOD OPENING?
	JNZ	OPENS
	LXI	D,NOSORC
	CALL	TYPTX		;PRINT "NO SOURCE FILE"
	JMP	BOOT		;EXIT
OPENS:	LXI	D,DFCB
	MVI	C,FIND
	CALL	BDOS		;LOOK FOR SOURCE FILE
	INR	A		;DOES FILE ALREADY EXIST?
	JZ	OPENS0		;NO, CONTINUE
	LXI	D,FEXIST
	CALL	TYPTX		;PRINT "FILE ALREADY EXISTS"
	CALL	SCIN		;GET RESPONSE
	ANI	5FH		;CONVERT LOWER CASE TO UPPER
	CPI	'Y'		;WANT TO DELETE?
	JNZ	BOOT		;EXIT
	LXI	D,CRLF
	CALL	TYPTX		;PRINT CRLF
	LXI	D,DFCB
	MVI	C,DELETE
	CALL	BDOS		;DELETE THE FILE
OPENS0:	LXI	D,DFCB
	MVI	C,MAKE
	CALL	BDOS		;OPEN SOURCE FILE
	INR	A
	JNZ	OPEN0		;OPENING OK
	LXI	D,NODIR
	CALL	TYPTX
	JMP	BOOT		;NO DIRECTORY SPACE, EXIT
OPEN0:	LXI	H,INBUF+128	;HL = LWA+1 OF FILE BUFFER
	SHLD	BUFADD		;FLAGS 'GETC' TO READ FIRST RECORD
	JMP	PROGRM		;JUMP TO MAIN PROGRAM
;
; CONSOLE I/O THROUGH BDOS
;
SCIN:	PUSH	H		;SINGLE CHARACTER INPUT
	PUSH	D
	PUSH	B
	MVI	C,READF
	CALL	BDOS
	POP	B
	POP	D
	POP	H
	RET

TYPTX:	PUSH	H		;TYPE TEXT AT (DE)
	PUSH	B
	MVI	C,PRINTF
	CALL	BDOS
	POP	B
	POP	H
	RET
;
; FILE I/O ROUTINES
;
GETC:	PUSH	H
	LHLD	BUFADD
	MVI	A,((INBUF+128) SHL 8)/256
	CMP	L		;IS FILE BUFFER EMPTY?
	CZ	NEWREC		;IF YES
	MOV	A,M
	CPI	1AH		;END OF FILE MARKER
	JZ	GEXIT		;FIRST ^Z BYTE MARKS EOF
	INX	H
	SHLD	BUFADD
GEXIT:	POP	H
	RET
NEWREC:	LXI	H,INBUF		;HL = FWA OF FILE BUFFER
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,FCB1
	MVI	C,READ
	CALL	BDOS		;READ ONE RECORD
	POP	H
	POP	D
	POP	B
	ORA	A		;END OF FILE?
	JZ	NOEND
	LXI	H,DEOF		;POINT TO DUMMY EOF
NOEND:	RET
DEOF:	DB	1AH		;DUMMY END OF FILE
WRITEC:	PUSH	H
	LHLD	BUFADD
	MOV	M,A
	INX	H
	MVI	A,((INBUF+128) SHL 8)/256
	CMP	L
	CZ	NEWRIT
	SHLD	BUFADD
	POP	H
	RET
NEWRIT:	LXI	H,INBUF
	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW
	LXI	D,DFCB
	MVI	C,WRITE
	CALL	BDOS		;WRITE ONE RECORD
	ORA	A		;WRITE OK?
	JZ	WEXIT
	LXI	D,OUTSP
	CALL	TYPTX		;PRINT "OUT OF DISK SPACE"
	JMP	BOOT
WEXIT:	POP	PSW
	POP	B
	POP	D
	POP	H
	RET
QUIT:	LXI	D,DFCB
	MVI	C,CLOSE
	CALL	BDOS		;CLOSE OUTPUT FILE
	INR	A		;ALL OK?
	JNZ	BOOT
	LXI	D,WPRO
	CALL	TYPTX		;PRINT "CHECK WRITE PROTECT"
	JMP	BOOT
;
; MAIN PROGRAM
;
PROGRM:	LXI	H,STRTAB
	LXI	D,0
NXTSTR:	PUSH	H
	MVI	C,0
	INX	H
NXTCHR:	CALL	GETC
	JZ	POINT
	CPI	CR
	JZ	EOS		;IF END OF STRING
	CALL	MEMCHK  	;EXCEEDED UPPER RAM LIMIT?
	INR	C		;COUNT CHARACTERS IN STRING
	JZ	TOOLNG  	;IF > 255 CHARACTERS
	MOV	M,A
	INX	H
	JMP	NXTCHR
TOOLNG:	CALL	GETC		;SKIP TO
	CPI	CR		;END
	JNZ	TOOLNG  	;OF STRING
	DCR	C		;C = 255
EOS:	MOV	A,C
	ANA	A
	JZ	NULSTR
	XTHL			;GET ADDR OF STRING START-1
	MOV	M,C		;INSERT SIZE OF STRING
	INX	D		;DE = COUNT OF STRINGS IN TABLE
NULSTR:	POP	H
	CALL	GETC		;GET LF FROM END OF LINE
	JMP	NXTSTR
; CHECK FOR EXCEEDING LIMIT OF USER RAM
;	ENTRY:	HL = ADDRESS TO BE CHECKED
;	EXIT:	RETURNS TO PROGRAM IF IN BOUNDS.
;		ABORTS IF OUT OF BOUNDS.
;	USES:	F
MEMCHK:	PUSH	D
	PUSH	PSW
	XCHG
	LHLD	HIGH		;HL = UPPER BOUND OF USER MEMORY
	CALL	DEMHL
	XCHG
	POP	D
	MOV	A,D
	POP	D
	RC
	LXI	D,MSGE
	CALL	TYPTX
	JMP	BOOT
; CONSTRUCT A POINTER TABLE FOR THE STRING DATA TABLE.
; STRUCTURE AS FOLLOWS:
;	BEGIN AT ('POINTA').
;	EACH TWO BYTE DATA ITEM IS THE ADDRESS OF THE START OF DATA
;	FOR EACH STRING IN THE STRING DATA TABLE.
POINT:	XCHG
	SHLD	VARN		;= NUMBER OF STRINGS TO SORT
	DAD	H		;HL = SPACE REQUIRED FOR POINTER TABLE
	POP	D		;DE = END OF STRING TABLE
	DAD	D		;HL = END OF REQUIRED DATA SPACE
	CALL	MEMCHK
	XCHG
	MVI	M,0		;MARK END OF STRTAB WITH 0 
	INX	H
	SHLD	POINTA
	XCHG
	LXI	H,STRTAB
NXTLBL:	MOV	A,M
	ANA	A		;END OF STRTAB?
	JZ	SMSORT
	MOV	A,L
	STAX	D
	INX	D
	MOV	A,H
	STAX	D
	INX	D
	MOV	A,M
	INR	A		;A = LENGTH OF STRING + 1
	ADD	L
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A		;HL = HL + A
	JMP	NXTLBL
; SHELL-METZNER STRING SORTING ROUTINE
;	ENTRY:  'VARN' = NUMBER OF STRINGS TO BE SORTED
;		('POINTA') = START OF POINTER TABLE
;		   POINTER TABLE MADE UP OF A SERIES OF 16 BIT ADDRESSES
;		   POINTING TO THE POSITION IN THE DATA TABLE FOR EACH
;		   OF THE ITEMS TO BE SORTED.
;		DATA TABLE STRUCTURE:
;		   FIRST BYTE = LENGTH OF STRING
;		   FOLLOWING BYTES = STRING CHARACTERS
;		   BYTES BEYOND SPECIFIED LENGTH ARE IGNORED
;	EXIT:	POINTER TABLE REARRANGED TO POINT TO STRINGS IN ALPHABETICAL ORDER.
;		STRING DATA TABLE IS UNCHANGED.
;		'VARN' = NUMBER OF STRINGS SORTED. (UNCHANGED)
;		'VARM' = 0.
SMSORT:	LHLD	VARN
	SHLD	VARM
SETM:	LHLD	VARM
	MOV	A,H
	ANA	A		;CLEAR CARRY
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	SHLD	VARM		;VARM = VARM / 2 
	ORA	H
	JZ	PRINT		;IF END OF SORT
	LXI	H,1
	SHLD	VARJ		;VARJ = 1
	LHLD	VARN
	XCHG
	LHLD	VARM
	CALL	DEMHL
	SHLD	VARK		;VARK = VARN - VARM
SETI:	LHLD	VARJ
	SHLD	VARI		;VARI = VARJ
SETL:	LHLD	VARI
	XCHG
	LHLD	VARM
	DAD	D
	SHLD	VARL		;VARL = VARI + VARM
	CALL	SYMVAL		;HL = START OF DATA POINTED BY VARL
	PUSH	H
	LHLD	VARI
	CALL	SYMVAL
	POP	D
	LDAX	D		;A = CHAR COUNT FOR STRING [VARL]
	MOV	C,M		;C = CHAR COUNT FOR STRING [VARI]
	CMP	C
	PUSH	PSW		;'C' SET IF LENSTRING [VARI] > LENSTRING [VARL]
	JNC	COMP
	MOV	C,A
COMP:	INX	H		;C = LENGTH OF SHORTER STRING
	INX	D		;HL & DE POINT TO START OF LABEL STRINGS
	LDAX	D
	CMP	M		;COMPARE STRINGS
	JNZ	NOMACH		;IF NO MATCH
	DCR	C
	JNZ	COMP
	POP	PSW		;CHARACTERS THE SAME; SEE IF ONE STRING LONGER?
	JMP	NOMACH+1
NOMACH:	POP	H		;CLEAR STACK
	JNC	SETJ		;IF NO REARRANGEMENT REQUIRED
; SWITCH THE POINTER ADDRESS AT (VARI) WITH THAT AT (VARL)
	LHLD	VARI
	CALL	TABADD
	PUSH	H		;STACK = POINTER DATA FOR (VARI)
	LHLD	VARL
	CALL	TABADD		;HL = POINTER DATA FOR (VARL)
	POP	D
	LDAX	D
	MOV	B,A
	MOV	A,M
	STAX	D
	MOV	M,B
	INX	D
	INX	H
	LDAX	D
	MOV	B,A
	MOV	A,M
	STAX	D
	MOV	M,B
; SWITCH COMPLETED
	LHLD	VARI
	XCHG
	LHLD	VARM
	CALL	DEMHL
	SHLD	VARI		;VARI = VARI - VARM
	DCX	H
	MOV	A,H
	ANA	A
	JP	SETL		;IF VARI >= 1
SETJ:	LHLD	VARJ
	INX	H
	SHLD	VARJ		;VARJ = VARJ + 1
	XCHG
	LHLD	VARK
	XCHG
	CALL	DEMHL
	JC	SETM		;IF VARJ > VARK
	JMP	SETI
; DEMHL -- HL = DE - HL
;	ENTRY:	HL & DE = 16 BIT INTEGERS (UNSIGNED)
;	EXIT:	HL = DE - HL
;		DE = UNCHANGED
;		'C' SET IF HL > DE
;	USES:	A,F,H,L
DEMHL:	ORA	A		;CLEAR FLAGS
	MOV	A,E
	SUB	L
	MOV	L,A
	MOV	A,D
	SBB	H
	MOV	H,A
	RET
; TABADD -- FIND LOCATION OF DATA POINTER IN TABLE
;	ENTRY: HL = INTEGER VALUE ( 1 -> N )
;	EXIT:  HL = ADDR OF TWO BYTE DATA POINTER ( FOR INPUT VALUE )
;	USES:  D,E,H,L,F
TABADD:	DCX	H
	DAD	H		;HL = [(ORIGINAL HL) - 1] ; 2
	XCHG
	LHLD	POINTA
	DAD	D
	RET
; SYMVAL -- FIND DATA RELATED TO INPUT INTEGER VALUE IN ARRAY
;	ENTRY: HL = INTEGER VALUE ( 1 -> N ) POINTING TO DATA ARRAY
;	EXIT:  HL = FWA STRING DATA FOR THAT VALUE
;	USES:  A,D,E,H,L,F
SYMVAL:	CALL	TABADD
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
	RET
; SORTING COMPLETED - WRITE OUT RESULT
PRINT:	LHLD	VARN
	XCHG
	CALL	DECOUT		;PRINT NUMBER OF STRINGS SORTED ON CONSOLE
	LXI	D,MSGF
	CALL	TYPTX
	LXI	H,INBUF
	SHLD	BUFADD
PR1:	LHLD	VARN
	XCHG			;DE = NUMBER OF STRINGS SORTED
	LHLD	VARM		;VARM = 0 ON EXIT FROM SMSORT
	INX	H
	SHLD	VARM		;CURRENT POINTER ARRAY POSITION
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JC	OUTDON		;IF ALL STRINGS HAVE BEEN WRITTEN
	CALL	SYMVAL
	MOV	C,M
PR2:	INX	H
	MOV	A,M
	CALL	WRITEC
	DCR	C
	JNZ	PR2
	MVI	A,CR
	CALL	WRITEC
	MVI	A,0AH		;LINE FEED
	CALL	WRITEC
	JMP	PR1
OUTDON:	MVI	A,1AH
	CALL	WRITEC		;WRITE END OF FILE
OUTDO0:	LDA	BUFADD
	CPI	(INBUF SHL 8)/256
	JZ	QUIT
	MVI	A,1AH		;FILL WITH EOF'S
	CALL	WRITEC
	JMP	OUTDO0
; DECOUT -- PRINT DECIMAL INTEGER ON CONSOLE
;	ENTRY:	DE = 16-BIT VALUE
;	EXIT:	DECIMAL VALUE PRINTED ON CONSOLE WITH A TRAILING SPACE.
;	USES:	NONE
DECOUT:	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW
	MOV	B,D
	MOV	C,E
	MVI	A,5
	LXI	H,DECBUF
	PUSH	H
	CALL	UDD
	MVI	M,'$'		;MARK END OF STRING
	POP	H
	DCX	H
	MVI	C,5
DO1:	INX	H
	DCR	C
	JZ	DO2
	MOV	A,M
	CPI	'0'
	JZ	DO1		;IF LEADING ZEROS PRESENT
DO2:	XCHG
	CALL	TYPTX
	POP	PSW
	POP	B
	POP	D
	POP	H
	RET
;CONVERT BINARY TO DECIMAL STRING (UNPACK DECIMAL DIGITS)
UDD:	CALL	UDDX
	PUSH	H
UDD0:	PUSH	PSW
	PUSH	H
	LXI	D,12Q
	CALL	UDDY
	PUSH	H
	POP	B
	POP	H
	MVI	A,60Q
	ADD	E
	DCX	H
	MOV	M,A
	POP	PSW
	DCR	A
	JNZ	UDD0
	POP	H
	RET
UDDX:	PUSH	D
	MOV	E,A
	MVI	D,0
	DAD	D
	POP	D
	RET
UDDY:	MOV	A,D
	CMA
	MOV	D,A
	MOV	A,E
	CMA
	MOV	E,A
	INX	D
	MOV	A,D
	ORA	E
	JZ	UDDY4
	XRA	A
UDDY0:	MOV	H,D
	MOV	L,E
	DAD	B
	JNC	UDDY1
	INR	A
	MOV	H,D
	MOV	L,E
	DAD	H
	XCHG
	JC	UDDY0
	XCHG
	DCR	A
UDDY1:	MOV	H,B
	MOV	L,C
	LXI	B,0
UDDY2:	PUSH	PSW
	DAD	D
	JC	UDDY3
	MOV	A,L
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
UDDY3:	MOV	A,C
	RAL
	MOV	C,A
	MOV	A,B
	RAL
	MOV	B,A
	STC
	MOV	A,D
	RAR
	MOV	D,A
	MOV	A,E
	RAR
	MOV	E,A
	POP	PSW
	DCR	A
	JP	UDDY2
UDDY4:	XCHG
	MOV	H,B
	MOV	L,C
	RET
; DATA SPACE:
BUFADD:	DS	2		;FILE BUFFER POINTER
CRLF:	DB	CR,LF,'$'
INST:	DB	CR,LF,'INPUT SYNTAX ERROR.  THE CORRECT SYNTAX IS:'
	DB	CR,LF,CR,LF,'(X:)SORT X:FNAME1.EXT X:FNAME2.EXT',CR,LF
	DB	CR,LF,'WHERE  X = DEVICE (DRIVE) NAME (A - E)'
	DB	CR,LF,'       FNAME1.EXT = INPUT FILE NAME'
	DB	CR,LF,'       FNAME2.EXT = OUTPUT FILE NAME',CR,LF,'$'
NOSORC:	DB	CR,LF,'INPUT FILE DOES NOT EXIST',CR,LF,'$'
FEXIST:	DB	CR,LF,'OUTPUT FILE ALREADY EXISTS.  '
	DB	'WANT TO DELETE IT? (Y OR N) $'
NODIR:	DB	CR,LF,'NO DIRECTORY SPACE',CR,LF,'$'
OUTSP:	DB	CR,LF,'OUT OF DISK SPACE',CR,LF,'$'
WPRO:	DB	CR,LF,'UNABLE TO CLOSE OUTPUT FILE.  '
	DB	'CHECK WRITE PROTECT.',CR,LF,'$'
MSGE:	DB	CR,LF,7,'OUT OF RAM',CR,LF,'$'
MSGF:	DB	' STRINGS SORTED.  '
	DB	'WRITING RESULT TO FILE.',CR,LF,'$'
HEADER:	DB	CR,LF
	DB	'		HUG SORTER',CR,LF,CR,LF
	DB	'SHELL - METZNER  SORT PROGRAM  (WWM-PWS)',CR,LF,CR,LF,'$'
	DS	128
STAK	EQU	$
DFCB:	DS	33	;DESTINATION FILE NAME
DECBUF:	DS	6
	DB	'$'
POINTA:	DS	2
VARI:	DS	2
VARJ:	DS	2
VARK:	DS	2
VARL:	DS	2
VARM:	DS	2
VARN:	DS	2
STRTAB	EQU	$	;MUST BE LAST LABEL IN LIST
	END	START
