;usrpatch.asm
;
;this file contains an 8080 assembly language listing of the
;user patchable area of SMARTKEY V3.2.  it may be used to patch
;the program for changes outside the scope of SMKPATCH
;
;the patch procedure is as follows:
;	edit the patch listing as required - do not add or delete
;	any fields or change their order
;	assemble it using:	A>ASM USRPATCH
;	install it using:	A>DDT SMARTKEY.COM
;				-IUSRPATCH.HEX
;				-R
;				-G0
;				A>SAVE 13 SMARTKEY.COM
;
;	u s e r   p a t c h   a r e a
;
;the following variables are located here for ease of mod-
;ification.  they are moved into the resident data area by
;setup during initialization.  default values shown are for
;televideo terminals except that lead in char must be 01h (^A)
;
	org 0180h

usrpat:
	db 1bh		;default escape character (<ESC>)
	db 0ffh		;value to return for console status
			;  when expanding a multi-character
			;  definition.  normally 0ffh but
			;  dBase II and possibly some other
			;  programs require 0
	db 0		;lead in character for terminal
			;  function key sequences. zero to
			;  disable checking.
	db 1		;length of function key string pre-
			;  amble including leadin.
	db 1		;length of post-amble.
	db 80h		;mask character to xor with
			;  significant char of string to
			;  produce a single unique character.
			;  80H sets bit 7 but more exotic
			;  manipulations are possible
	dw 0300h	;delay constant for string
			;  recognition.  may need to be altered but only
			;  for extremes of processor and terminal speed.
	db 0		;set to 0ffh to require SMARTKEY to trap warm
			;  boot requests and prevent system reloads
			;  must be set to 0ffh for Osborne I and Superbrain
			;  which reload BIOS on warm boots (naughty!) and
			;  for some versions of North Star which overwrite
			;  the top of the TPA on warm boots (very naughty!)
	db 0		;flag non-zero to require
			;  the routine patched in below to be used for
			;  console input in lieu of the bios routine
inpt:	db 0,0,0,0,0	;these 16 bytes may be used for a console input 
	db 0,0,0,0,0	;  routine which returns 8 bit wide key codes
	db 0,0,0,0,0	;  this routine will only be called when the
	ret		;  console is ready and should not check status
			;  no addresses local to smartkey may be referenced
			;  as the routine will be relocated before use.
;
;	e n d   o f   p a t c h   a r e a
;
