;	PROGRAM TO SET H25 PRINTER CHARACTER AND LINE WIDTH

;	ENTER PSET n  (n = 10, 12, 13 (13.2), or 16 (16.5))
;	TO SET CHARACTERS PER INCH.
;
;	ENTER PSET n (n = 6 or 8)
;	TO SET LINES PER INCH.

TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE

HRUN	EQU	FALSE		;ASSEMBLE FOR HRUN

;	TO ASSEMBLE FOR HRUN, LOAD THE HEX FILE WITH DDT
;	THEN ENTER
;	-M2278,2400,100
;	-G0
;	A>SAVE 2 PSET25.ABS


	IF	HRUN
	ORG	2278H
	DB	0FFH,0
	DW	START
	DW	LEND-START
	DW	START
	ENDIF
	IF	NOT HRUN
	ORG	100H
	ENDIF
START	LXI	H,0
	DAD	SP		;FIND STACK
	IF	HRUN
	MOV	A,L
	CPI	80H		;CHECK STACK POSITION
	JNZ	GETARG		;THERE'S AN ARGUMENT
	DCX	H		;CANCEL INX IN GETARG
	ENDIF
	IF	NOT HRUN
	LXI	SP,STACK	;SET NEW STACK
	PUSH	H		;SAVE OLD ONE
	LXI	H,80H		;POINT TO ARGUMENT
	MOV	A,M		;GET COUNT
	ORA	A		;ANY ARGUMENT?
	JNZ	GETARG		;YES
	ENDIF
	LXI	D,INST
	MVI	C,9
	CALL	5		;PRINT INSTRUCTIONS
	JMP	EXIT
GETARG	INX	H		;MOVE TO HEXT CHAR
	MOV	A,M		;GET IT
	CPI	' '		;SPACE?
	JZ	GETARG		;SKIP SPACES
	CPI	'1'		;ONE?
	JZ	SETCHR		;YES, SET CHARACTER WIDTH
	CPI	'6'		;SIX?
	MVI	B,'0'		;ASSUME IT IS
	JZ	SETLN		;YES, SET LINE HEIGHT
	CPI	'8'		;EIGHT?
	MVI	B,'2'		;ASSUME IT IS
	JNZ	EXIT		;BAD ENTRY
SETLN	MOV	A,B		;GET LINE SET PARAMETER
	STA	LNVAL		;PUT IT IN LINE STRING
	LXI	H,LSTRING	;POINT TO LINE STRING
	JMP	PLOOP		;PRINT IT
SETCHR	INX	H
	MOV	A,M		;GET NEXT CHARACTER
	MVI	B,'1'		;ASSUME 10 CPI
	CPI	'0'		;IS IT 10?
	JZ	PSET		;YES, SET PRINTER
	MVI	B,'2'		;ASSUME 12 CPI
	CPI	'2'		;IS IT 12?
	JZ	PSET		;YES
	MVI	B,'3'		;ASSUME 13.2 CPI
	CPI	'3'		;IS IT 13?
	JZ	PSET		;YES
	MVI	B,'4'		;ASSUME 16.5 CPI
	CPI	'6'		;IS IT 16?
	JZ	PSET		;YES
EXIT
	IF	NOT HRUN
	POP	H		;GET OLD STACK VALUE
	SPHL			;SET IT
	RET			;RETURN TO CP/M
	ENDIF
	IF	HRUN
	XRA	A
	DB	0FFH,0		;SCALL .EXIT TO HRUN
	ENDIF
PSET	MOV	A,B
	STA	SETVAL		;SET UP PRINTER SETUP STRING
	LXI	H,PSTRING	;GET SETUP STRING
PLOOP	MOV	A,M		;GET CHARACTER
	ORA	A		;END OF STRING?
	JZ	EXIT		;IF SO, EXIT
	MOV	E,A		;PUT CHAR IN E
	MVI	C,5		;PRINT FUNCTION
	PUSH	H		;SAVE POINTER
	CALL	5		;CALL BDOS TO PRINT
	POP	H		;RESTORE POINTER
	INX	H		;INCREMENT IT
	JMP	PLOOP		;CONTINUE PRINTING

INST	DB	0DH,0AH
	DB	'PSET for the H/Z25.',0DH,0AH,0DH,0AH
	DB	'Enter PSET [arg], where [arg] =',0DH,0AH,0DH,0AH
	DB	'10 -- set 10 Characters Per Inch.',0DH,0AH
	DB	'12 -- set 12 CPI.',0DH,0AH
	DB	'13 -- set 13.2 CPI.',0DH,0AH
	DB	'16 -- set 16.5 CPI.',0DH,0AH
	DB	'6  -- set 6 Lines Per Inch.',0DH,0AH
	DB	'8  -- set 8 LPI.',0DH,0AH,'$'
PSTRING	DB	1BH,'['
SETVAL	DB	'0w',0DH,0
LSTRING	DB	1BH,'['
LNVAL	DB	'0x',0DH,0
LEND	EQU	$
STACK	EQU	$+100H		;PUT STACK HERE

	END	START
