;	PROGRAM TO SET MX80 PRINTER OPTIONS
;
;	ENTER
;
;	A>PSET x
;
;	WHERE x IS ONE OF THE FOLLOWING
;
;	C	SET COMPRESSED PRINTING
;	E	SET EMPHASIZED PRINTING
;	D	SET DOUBLE STRIKE
;	N	SET NORMAL PRINTING (CANCEL ABOVE SETTINGS)
;	6	SET 6 LINES/INCH
;	7	SET 7/72" LINE SPACING
;	8	SET 8 LINES/INCH

TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE

HRUN	EQU	FALSE		;ASSEMBLE FOR HRUN

;	TO ASSEMBLE FOR HRUN, LOAD THE HEX FILE WITH DDT
;	THEN ENTER
;	-M2278,2400,100
;	-G0
;	A>SAVE 2 PSETMX.ABS

	IF	HRUN
	ORG	2278H
	DB	0FFH,0
	DW	START
	DW	LEND-START
	DW	START
	ENDIF
	IF	NOT HRUN
	ORG	100H
	ENDIF
START	LXI	H,0
	DAD	SP		;FIND STACK
	IF	HRUN
	MOV	A,L
	CPI	80H		;CHECK STACK POSITION
	JNZ	GETARG		;THERE'S AN ARGUMENT
	DCX	H		;CANCEL INX IN GETARG
	ENDIF
	IF	NOT HRUN
	LXI	SP,STACK	;SET NEW STACK
	PUSH	H		;SAVE OLD ONE
	LXI	H,80H		;POINT TO ARGUMENT
	MOV	A,M		;GET COUNT
	ORA	A		;ANY ARGUMENT?
	JNZ	GETARG		;YES
	ENDIF
	LXI	D,INST
	MVI	C,9
	CALL	5		;PRINT INSTRUCTIONS
	JMP	EXIT
GETARG	INX	H		;MOVE TO HEXT CHAR
	MOV	A,M		;GET IT
	CPI	' '		;SPACE?
	JZ	GETARG		;SKIP SPACES
	LXI	H,STRING	;POINT TO SETUP STRING
	CPI	'8'		;8?
	MVI	B,'0'		;ASSUME YES
	JZ	PSET
	INR	B
	CPI	'7'
	JZ	PSET
	INR	B
	CPI	'6'
	JZ	PSET
	CPI	'E'		;EMPHASIZED?
	MOV	B,A		;ASSUME YES
	JZ	PSET
	CPI	'D'		;DOUBLE?
	MVI	B,'G'
	JZ	PSET
	INX	H		;SKIP ESCAPE
	CPI	'C'		;COMPRESSED?
	MVI	B,15
	JZ	PSET
	LXI	H,NORMAL	;ONLY NORMAL IS LEFT
	CPI	'N'		;TEST FOR IT
	JZ	PLOOP
EXIT
	IF	NOT HRUN
	POP	H		;GET OLD STACK VALUE
	SPHL			;SET IT
	RET			;RETURN TO CP/M
	ENDIF
	IF	HRUN
	XRA	A
	DB	0FFH,0		;SCALL .EXIT TO HRUN
	ENDIF
PSET	MOV	A,B
	STA	ARG		;SET UP PRINTER SETUP STRING
PLOOP	MOV	A,M		;GET CHARACTER
	ORA	A		;END OF STRING?
	JZ	EXIT		;IF SO, EXIT
	MOV	E,A		;PUT CHAR IN E
	MVI	C,5		;PRINT FUNCTION
	PUSH	H		;SAVE POINTER
	CALL	5		;CALL BDOS TO PRINT
	POP	H		;RESTORE POINTER
	INX	H		;INCREMENT IT
	JMP	PLOOP		;CONTINUE PRINTING

INST	DB	0DH,0AH
	DB	'PSET for the MX80.',0DH,0AH,0DH,0AH
	DB	'Enter PSET [arg], where [arg] ='
	DB	0DH,0AH,0DH,0AH
	DB	'C -- set Compressed printing.',0DH,0AH
	DB	'D -- set Double strike.',0DH,0AH
	DB	'E -- set Emphasized printing.',0DH,0AH
	DB	'N -- set Normal printing (cancel the above).',0DH,0AH
	DB	'6 -- set 6 Lines Per Inch.',0DH,0AH
	DB	'7 -- set 7/72" line spacing.',0DH,0AH
	DB	'8 -- set 8 LPI.',0DH,0AH,'$'
STRING	DB	1BH
ARG	DB	' ',0
NORMAL	DB	18,27,'F',27,'H',0
LEND	EQU	$
STACK	EQU	$+100H		;PUT STACK HERE

	END	START
H,'$'
STRING	DB	1BH
ARG	DB	