;	PWHEEL -- PRINT ALL CHARACTERS
;	ON A PRINT WHEEL

	ORG	100H

START	LXI	H,0
	DAD	SP		;FIND STACK
	LXI	SP,STACK	;SET NEW ONE
	PUSH	H		;SAVE OLD ONE
	CALL	PTEXT
	DB	0DH,0AH,'        COMPLETE CHARACTER SET',0DH,8AH
	LXI	H,80H
	MOV	A,M
	ORA	A		;ANY ARGUMENT?
	JZ	NOARG
	CALL	PTEXT
	DB	'        ON PRINTWHEEL',' '+80H
	MOV	B,M		;GET CHARACTER COUNT
TLOOP	INX	H		;MOVE TO NEXT CHARACTER
	MOV	A,M		;GET IT
	CALL	PCHAR		;PRINT
	DCR	B		;DONE?
	JNZ	TLOOP		;LOOP UNTIL DONE
NOARG	CALL	PTEXT
	DB	0DH,0AH,0DH,8AH
	MVI	B,32		;INITIALIZE COUNTER
PLOOP	CALL	PTEXT
	DB	'       ',' '+80H
	MOV	L,B
	MVI	H,0
	CALL	DECOUT		;PRINT ASCII CHAR NUMBER
	MVI	A,' '
	CALL	PCHAR		;PRINT A SPACE
	MOV	A,B		;GET COUNT
	CALL	PCHAR		;PRINT ITS VALUE
	CALL	PTEXT
	DB	'                       ',' '+80H
	MOV	A,B		;GET COUNT
	ADI	49		;ADD COLUMN OFFSET
	CPI	128		;CHARACTER 128?
	JNZ	NOT128		;NO
	CALL	PTEXT
	DB	'ESC Y ',27,'Y'+80H
	JMP	ENDLP
NOT128	CPI	129		;CHARACTER 129?
	JNZ	NOT129
	CALL	PTEXT
	DB	'ESC Z ',27,'Z'+80H
	JMP	ENDLP
NOT129	CPI	100		;100 OR MORE
	MOV	C,A		;SAVE CHARACTER
	JNC	NOSPC		;IF SO, NO EXTRA SPACE
	MVI	A,' '
	CALL	PCHAR		;PRINT EXTRA SPACE
NOSPC	CALL	PTEXT
	DB	' ',' '+80H	;PRINT TWO SPACES
	MOV	L,C
	MVI	H,0
	CALL	DECOUT		;PRINT CHAR NO.
	MVI	A,' '
	CALL	PCHAR		;PRINT FOLLOWING SPACE
	MOV	A,C
	CALL	PCHAR		;PRINT CHARACTER
ENDLP	CALL	PTEXT
	DB	0DH,8AH		;PRINT CRLF
	INR	B		;INCREMENT COUNTER
	MOV	A,B
	CPI	81		;DONE?
	JNZ	PLOOP		;IF NOT, CONTINUE
	POP	H		;GET OLD STACK
	SPHL			;SET IT
	RET			;TO CP/M

PCHAR	PUSH	B
	PUSH	D
	PUSH	H
	MOV	E,A
	MVI	C,5
	CALL	5		;PRINT CHARACTER
	POP	H
	POP	D
	POP	B
	RET

PTEXT	XTHL
PTLP	MOV	A,M		;GET A CHARACTER
	ANI	177Q		;STRIP PARITY
	PUSH	PSW
	CALL	PCHAR		;PRINT IT
	POP	PSW
	CMP	M		;END OF TEXT?
	INX	H
	JZ	PTLP		;IF NOT, CONTINUE
	XTHL			;FIX RET ADDR
	RET

DECOUT	PUSH	B
	PUSH	D
	PUSH	H
	LXI	B,-10
	LXI	D,-1
DX	DAD	B
	INX	D
	JC	DX
	LXI	B,10
	DAD	B
	XCHG
	MOV	A,H
	ORA	L
	CNZ	DECOUT
	MOV	A,E
	ADI	'0'
	CALL	PCHAR
	POP	H
	POP	D
	POP	B
	RET

STACK	EQU	$+64

	END	START

	MOV	A,H
	ORA	L
	CNZ	DECOUT
	MOV	A,E
	ADI	'0'
	C