;	ROTATE -- TEST DRIVE ROTATION SPEED
;
;	THIS PROGRAM ALLOWS THE CP/M USER TO CHECK
;	AND ADJUST HIS DRIVE ROTATION SPEED ON
;	ANY HEATH/ZENITH COMPUTER WITH 5.25 INCH
;	DRIVES.
;
;	THIS CAPABILITY WAS FORMALLY ONLY AVAILABLE
;	TO THE HDOS USER.
;
;	TO USE THIS PROGRAM, ENTER
;
;	A>ROTATE d:
;
;	WHERE d: IS A VALID DRIVE DESIGNATION.
;
;	BY P. SWAYNE, HUG  21-OCT-82
;	COPYRIGHT (C) 1982 BY HEATH USERS' GROUP

;	CP/M AND HARDWARE DEFINITIONS

TICCNT	EQU	0BH		;TIC COUNTER ADDRESS
BDOS	EQU	5		;BDOS VECTOR
CONIN	EQU	1		;CONSOLE INPUT
DCIO	EQU	6		;DIRECT CONSOLE I/O
PRINT	EQU	9		;PRINT STRING
CONSTAT	EQU	11		;GET CONSOLE STATUS
BIOS	EQU	1		;BIOS ADDRESS
SELDSK	EQU	1BH-3		;SELECT DISK FUNCTION
SETSEC	EQU	21H-3		;SET SECTOR
SETTRK	EQU	1EH-3		;SET TRACK
DREAD	EQU	27H-3		;READ DISK SECTOR
DFMO	EQU	10H		;H17 MOTOR ON COMMAND
DPDC	EQU	7FH		;H17 CONTROL PORT
FD$INT	EQU	79H		;H37 INT. PORT
CONMO	EQU	9		;H37 MOTOR ON
FDCFI	EQU	0D0H		;H37 TYPE 1 STATUS
FD$CON	EQU	78H		;H37 CONTROL PORT
FD$CMD	EQU	7AH		;H37 COMMAND PORT
DLYMO37	EQU	23H		;H37 DELAYS
H37CTL	EQU	25H		;H37 CONTROL BYTE
FDCON7	EQU	0B4H		;H207 CONTROL PORT
FDCMD7	EQU	0B0H		;H207 COMMAND PORT
CONDSEN	EQU	8		;H207 DRIVE SELECT

;	GET USER ENTRY (IF ANY)

	ORG	100H

START	LXI	SP,STACK	;SET NEW STACK
	LXI	H,80H		;POINT TO ARGUMENT BUFFER
	MOV	A,M		;GET COUNT
	ORA	A		;ANY ARGUMENT?
	JNZ	GETARG		;YES, GET IT
	MVI	A,'A'		;NO ARGUMENT, ASSUME DRIVE A:
	JMP	TEST		;START TESTING DISK
GETARG	INX	H		;SKIP OVER COUNT
	MOV	A,M		;GET A CHARACTER
	CPI	' '		;SPACE?
	JZ	GETARG		;SKIP SPACES
TEST	CPI	'A'		;LESS THAN A?
	JC	BADARG		;IF SO, BAD ENTRY
	CPI	'P'+1		;MORE THAN P?
	JC	GOODARG		;IF NOT, GOOD ENTRY
BADARG	LXI	D,ILLDRV
	MVI	C,PRINT
	CALL	BDOS		;PRINT "ILLEGAL DRIVE"
	JMP	0		;RETURN TO CP/M
GOODARG	STA	ADRIVE		;SAVE ASCII DRIVE NAME
	SUI	'A'		;REMOVE ASCII BIAS
	PUSH	PSW		;SAVE RESULT

;	PROMPT FOR DISK INSERTION

	LXI	D,INSERT
	MVI	C,PRINT
	CALL	BDOS		;PRINT "INSERT DISK"
WAICR	MVI	E,0FFH
	MVI	C,DCIO
	CALL	BDOS		;WAIT FOR CR
	ORA	A
	JZ	WAICR
	CPI	3		;CONTROL-C?
	JZ	0		;IF SO, EXIT
	CPI	0DH
	JNZ	WAICR
	MOV	E,A
	MVI	C,DCIO
	CALL	BDOS		;ECHO CR

;	SELECT DRIVE TO USE

	POP	PSW		;RESTORE DRIVE ENTERED
	MOV	C,A		;RESULT IN C
	LHLD	BIOS		;GET BIOS ADDRESS
	LXI	D,SELDSK	;AND SELECT OFFSET
	DAD	D
	MVI	E,1		;FORCE NOT FIRST SELECTION
	CALL	JBIOS		;SELECT DRIVE TO USE
	MOV	A,H
	ORA	L		;LEGAL DRIVE?
	JZ	BADARG		;IF NOT, EXIT
	LXI	D,16		;GET OFFSET TO DRIVE TYPE
	DAD	D
	MOV	A,M		;GET DRIVE TYPE
	ANI	11100000B	;ISOLATE IT
	ORA	A		;ANY DRIVE THERE?
	JZ	BADARG		;IMAGINARY DRIVE
	CPI	01000000B	;H17 TYPE?
	JZ	STTYPE		;YES, GOOD DRIVE
	CPI	01100000B	;H37 TYPE?
	JZ	STTYPE		;YES, GOOD DRIVE
	CPI	00100000B	;H207 TYPE?
	JNZ	BADARG		;NO, BAD DRIVE TYPE
STTYPE	STA	DTYPE		;SAVE IT
	INX	H		;MOVE TO UNIT CODE
	MOV	A,M		;GET IT
	STA	UNIT		;SAVE IT
	LDA	DTYPE		;GET DISK TYPE
	CPI	01000000B	;H17 DISK?
	JNZ	H37		;NO, H37
	LHLD	10Q+1		;GET RESTART 1 VECTOR
	DCX	H		;CLEAR H17 DELAYS
	XRA	A
	MOV	M,A
	DCX	H
	MOV	M,A
	DCX	H
	MOV	M,A
	LDA	UNIT		;GET UNIT NO.
	ORI	DFMO
	OUT	DPDC		;TURN MOTOR ON.
	JMP	WAIMOT		;WAIT FOR MOTOR
H37	CPI	00100000B	;H207 DISK?
	JZ	H207		;IF SO, PROCESS IT
	LXI	H,0
	SHLD	DLYMO37		;CLEAR H37 DELAYS
	XRA	A
	STA	H37CTL		;AND CONTROL BYTE
	XRA	A		;ACCESS C/D REGISTERS
	OUT	FD$INT
	LDA	UNIT		;GET UNIT NO.
	ORI	CONMO
	OUT	FD$CON		;TURN MOTOR ON
	MVI	A,FDCFI
	OUT	FD$CMD		;FORCE TYPE 1 STATUS
	JMP	WAIMOT		;WAIT FOR MOTOR
H207	LDA	UNIT		;GET UNIT NO.
	ORI	CONDSEN
	OUT	FDCON7		;TURN MOTOR ON
	MVI	A,0		;RESTORE HEAD
	OUT	FDCMD7		;FORCE TYPE 1 STATUS
	MVI	A,500 AND 0FFH
	OUT	0E4H		;SWITCH REAL TIME CLOCK
	MVI	A,500 SHR 8
	OUT	0E4H		;TO 2 MS
WAIMOT	LXI	H,TICCNT+1	;WAIT FOR MOTOR
	MOV	A,M
	ADI	3
WAIMOT0	CMP	M
	JNZ	WAIMOT0
	LXI	D,ADJUST
	MVI	C,PRINT
	CALL	BDOS		;PRINT "ADJUST DRIVE"

;	TIME 5 OR 10 ROTATIONS OF DISK

TLOOP	LXI	H,0
	SHLD	TICCNT		;ZERO TIC COUNTER
	CALL	WAIND		;WAIT FOR INDEX HOLE
	MVI	B,5		;SET ROTATION COUNTER
TLOOP0	LXI	H,0
	SHLD	TICCNT		;CLEAR TIC COUNTER
LOOP	CALL	WAIND		;WAIT FOR INDEX HOLE
	DCR	B		;DECREMENT IT
	JNZ	LOOP		;LOOP UNTIL DONE

;	PRINT COUNT IN TIC COUNTER

	LHLD	TICCNT		;GET TIC COUNTER
	DAD	H		;DOUBLE IT
	CALL	DECOUT		;PRINT VALUE THERE
	LXI	D,CRLF
	MVI	C,PRINT
	CALL	BDOS		;PRINT CRLF
	MVI	C,CONSTAT
	CALL	BDOS		;GET CONSOLE STATUS
	ORA	A		;ANY ENTRY?
	JZ	TLOOP		;IF NOT CONTINUE
	MVI	C,CONIN
	CALL	BDOS		;GET THE CHARACTER
	CPI	3		;CONTROL-C?
	JNZ	TLOOP		;IF NOT, KEEP GOING
	XRA	A		;ELSE, TURN OFF DRIVE
	OUT	DPDC
	OUT	FD$CON
	LXI	D,CTLC
	MVI	C,PRINT
	CALL	BDOS		;PRINT "^C"
	LDA	DTYPE		;GET DRIVE TYPE
	CPI	00100000B	;H207 DRIVE?
	JNZ	0		;IF NOT, EXIT
	MVI	A,2500 AND 0FFH	;ELSE, SET CLOCK
	OUT	0E4H		;BACK TO 10 MS
	MVI	A,2500 SHR 8
	OUT	0E4H
	JMP	0		;AND EXIT

;	WAIT FOR INDEX HOLE

WAIND	LDA	DTYPE		;GET DISK TYPE
	CPI	01000000B	;H17 DISK?
	JNZ	CHK37		;NO, TRY H37
WAI17	CALL	WHD		;WAIT FOR A HOLE
WAI170	CALL	CGT		;FIND LONG GAP
	CPI	6
	JC	WAI170
WAI171	CALL	CGT		;FIND SHORT GAP
	CPI	6
	JNC	WAI171
	RET
CHK37	CPI	01100000B	;H37 DISK?
	JNZ	WAI207		;NO, H207
WAI37	CALL	CTIME		;CHECK TIME
	IN	FD$CMD		;GET HOLE STATUS
	ORA	A		;GOT A HOLE?
	JZ	WAI37		;IF NOT, WAIT FOR IT
WAI370	CALL	CTIME		;CHECK TIME
	IN	FD$CMD		;CHECK HOLE STATUS
	ORA	A		;HAS IT PASSED?
	JNZ	WAI370		;IF NOT, WAIT
	RET
WAI207	CALL	CTIME		;CHECK TIME
	IN	FDCMD7		;GET HOLE STATUS
	ANI	10B		;GOT A HOLE?
	JZ	WAI207		;IF NOT, WAIT FOR IT
WAI2070	CALL	CTIME		;CHECK TIME
	IN	FDCMD7		;CHECK HOLE STATUS
	ANI	10B		;HAS IT PASSED?
	JNZ	WAI2070		;IF NOT, WAIT
	RET

;	COMPUTE GAP TIMING BETWEEN HARD SECTOR HOLES

CGT	LHLD	TICCNT		;GET TIC COUNTER
	CALL	WNH		;WAIT FOR NO HOLE
	CALL	WHD		;WAIT FOR HOLE
	LDA	TICCNT
	SUB	L		;GET ELAPSED TIME
	RET

;	WAIT FOR HOLE IN H17 DISK

WHD	CALL	CTIME		;CHECK TIME
	IN	DPDC		;CHECK HOLE STATUS
	RAR
	JNC	WHD		;WAIT FOR HOLE
	RET

;	WAIT FOR NO HOLE IN H17 DISK

WNH	CALL	CTIME		;CHECK TIME
	IN	DPDC		;CHECK HOLE STATUS
	RAR
	JC	WNH		;WAIT FOR NO HOLE
	RET

;	CHECK ELAPSED TIME.  EXIT IF TOO MUCH

CTIME	LDA	TICCNT+1	;GET TIC COUNTER HIGH
	CPI	4		;BEEN TOO LONG?
	RNZ			;IF NOT, RETURN
	LXI	D,BADDSK
	MVI	C,PRINT
	CALL	BDOS		;ELSE, PRINT "BAD DISK"
	LXI	SP,STACK	;RESET STACK
	LDA	ADRIVE		;GET USER'S DRIVE CODE
	JMP	TEST		;RESTART TEST

;	PRINT (HL) IN DECIMAL

DECOUT	PUSH	B
	PUSH	D
	PUSH	H		;SAVE REGISTERS
	LXI	B,-10		;GET RADIX
	LXI	D,-1		;SUBTRACTION COUNTER
DX	DAD	B		;DIVIDE BY 10
	INX	D
	JC	DX
	LXI	B,10
	DAD	B
	XCHG			;(DE) = DIGIT, (HL) = NUMBER/10
	MOV	A,H
	ORA	L		;DONE?
	CNZ	DECOUT		;CALL RECURSIVELY UNTIL DONE
	MOV	A,E		;GET CHARACTER TO PRINT
	ADI	'0'		;ADD ASCII BIAS
	MOV	E,A		;IN E
	MVI	C,DCIO
	CALL	BDOS		;PRINT NUMBER
	POP	H
	POP	D
	POP	B		;RESTORE REGISTERS
	RET

;	JUMP TO BIOS

JBIOS	PCHL

;	MESSAGES AND STORAGE

DTYPE	DB	0		;DRIVE TYPE
UNIT	DB	0		;UNIT NO.
INSERT	DB	0DH,0AH,'Insert a disk in drive '
ADRIVE	DB	'A:, and hit RETURN.$'
ADJUST	DB	0DH,0AH,'Adjust drive speed for 1000.  '
AFTNUM	DB	'Type Control-C to stop test.',0DH,0AH
CRLF	DB	0DH,0AH,'$'
ILLDRV	DB	0DH,0AH,'Illegal drive designation.'
	DB	0DH,0AH,'$'
BADDSK	DB	0DH,0AH,'Bad disk, or disk inserted '
	DB	'improperly.',0DH,0AH,'$'
CTLC	DB	'^C$'

	DS	64		;STACK SPACE
STACK	EQU	$

	END	START
Bad disk, or disk inserted '
	DB	'improperly.',0DH,0AH,'$'
CTLC	DB	'^C$'

	DS	64		;STACK SPACE
STACK	EQU	$
