;	WSCON
;
;	THIS PROGRAM CONVERTS ASCII TEXT FILES
;	TO THE FORMAT USED BY WORDSTAR FOR
;	DOCUMENT FILES
;
;	REPLACES CR'S WITH PHANTOM CR'S EXCEPT
;	AT PARAGRAPH BREAKS SEPARATED WITH AT
;	LEAST ONE BLANK LINE.  REPLACES MULTIPLE
;	SPACES WITH PHANTOM SPACES EXCEPT FOR THE
;	FIRST SPACE.  TWO SPACES ARE ALLOWED
;	AFTER A PERIOD.

;
;	BY P. SWAYNE, HUG  3-FEB-82
;
	ORG	100H

;	CONSTANTS

CONIN	EQU	1		;BDOS CONSOLE INPUT
CONOUT	EQU	2		;OUTPUT
PRINT	EQU	9		;PRINT FUNCTION
READ	EQU	10		;READ CONSOLE BUFFER
OPEN	EQU	15		;OPEN FILE
CLOSE	EQU	16		;CLOSE FILE
DELETE	EQU	19		;DELETE FILE
DREAD	EQU	20		;DISK READ
DWRITE	EQU	21		;DISK WRITE
MAKE	EQU	22		;MAKE FILE
SETDMA	EQU	26		;SET DMA ADDR
FLAGS	EQU	30		;SET FILE ATTRIBUTES
BDOS	EQU	5		;CALL BDOS HERE
FCB1	EQU	5CH		;DEFAULT FCB LOCATION

;	MAIN PROGRAM

WSCON:	LXI	SP,STACK	;SET NEW STACK
	LHLD	6		;GET BDOS ADDRESS
	LXI	D,-100H		;SUBTRACT ONE PAGE
	DAD	D
	SHLD	MEMTOP		;STORE AS MEMORY TOP
	LDA	80H
	ORA	A		;ANY FILE ENTERED?
	JNZ	GOTFIL		;YES
	LXI	D,NOFILE
	MVI	C,PRINT
	CALL	BDOS		;PRINT "NO FILE"
	JMP	0
GOTFIL:	LXI	H,FCB1
	LXI	D,FCB2		;PREPARE SECOND FCB
	MVI	B,9		;MOVE 9 CHARACTERS
MOVE:	MOV	A,M		;GET A CHARACTER
	STAX	D		;MOVE IT
	INX	H
	INX	D		;INCREMENT POINTERS
	DCR	B		;DONE?
	JNZ	MOVE		;IF NOT, LOOP
	LXI	D,FCB1
	MVI	C,OPEN
	CALL	BDOS		;TRY TO OPEN SOURCE FILE
	INR	A
	JNZ	OPENED		;OPENED OK
	LXI	D,NOOPEN
	MVI	C,PRINT
	CALL	BDOS		;PRINT "CAN'T OPEN"
	JMP	0
OPENED:	LXI	D,FCB2
	MVI	C,DELETE
	CALL	BDOS		;DELETE OLD OUTPUT IF THERE
	LXI	D,FCB2
	MVI	C,MAKE
	CALL	BDOS		;OPEN OUTPUT FILE
	LXI	D,WORKING
	MVI	C,PRINT
	CALL	BDOS		;PRINT "WORKING"
LOOP:	LXI	H,BUFFER
	SHLD	CURDMA		;SET UP INPUT DMA
	XCHG
	MVI	C,SETDMA
	CALL	BDOS		;SET DMA ADDRESS
	LXI	H,0
	SHLD	SECCNT		;CLEAR SECTOR COUNTER
RLOOP:	LXI	D,FCB1
	MVI	C,DREAD
	CALL	BDOS		;READ A SECTOR
	ORA	A		;READ ALL?
	STA	EOFFLG		;MARK END OF FILE CONDITION
	JNZ	RDONE		;LEAVE IF SO
	LHLD	CURDMA
	LXI	D,80H
	DAD	D		;UPDATE DMA ADDRESS
	SHLD	CURDMA
	XCHG			;SAVE DMA ADDR IN DE
	MVI	C,SETDMA
	CALL	BDOS
	LHLD	SECCNT
	INX	H		;UPDATE SECTOR COUNT
	SHLD	SECCNT
	LHLD	CURDMA		;GET DMA ADDRESS
	XCHG			;IN DE
	LHLD	MEMTOP		;GET TOP OF MEMORY
	MOV	A,L
	SUB	E		;SUBTRACT DMA FROM MEMTOP
	MOV	A,H		;TO SEE IF MEMORY USED UP
	SBB	D
	JNC	RLOOP		;READ ANOTHER SECTOR
RDONE:	LHLD	CURDMA
	MVI	M,1AH		;MARK END
	LXI	H,BUFFER	;FILE IS HERE
CONLP:	MOV	A,M		;GET A CHARACTER
	CPI	1AH		;DONE?
	JZ	DONE		;IF SO, EXIT
	CPI	0DH		;CR?
	JNZ	NOTCR		;IF NOT, KEEP LOOKING
	PUSH	H		;SAVE POINTER
	INX	H
	INX	H		;MOVE OVER TWO CHARACTERS
	MOV	B,M		;GET CHARACTER
	POP	H		;RESTORE POINTER
	CMP	B		;TWO CR'S?
	JNZ	FIXCR		;NO, FIX CR
	INX	H
	INX	H		;LEAVE TWO CR'S ALONE
	JMP	NOTSP		;TRY ANOTHER CHARACTER
FIXCR:	MVI	M,8DH		;REPLACE CR WITH CR + 80H
	JMP	NOTSP		;CHECK NEXT CHARACTER
NOTCR:	CPI	' '		;SPACE
	JNZ	NOTSP		;NO
	PUSH	H		;SAVE POINTER
	DCX	H		;CHECK LAST CHARACTER
	MOV	A,M
	CPI	'.'		;PERIOD?
	POP	H		;RESTORE POINTER
	JZ	NOTSP		;ALLOW TWO SPACES AFTER PERIOD
	PUSH	H		;SAVE POINTER
SPCON:	INX	H		;MOVE TO NEXT CHARACTER
	MOV	A,M		;GET IT
	CPI	' '		;ANOTHER SPACE?
	JNZ	SPDONE		;NO, DONE
	MVI	M,' '+80H	;REPLACE SPACE WITH SPACE + 80H
	JMP	SPCON		;TRY NEXT CHARACTER
SPDONE:	POP	H		;RESTORE POINTER
NOTSP:	INX	H		;MOVE TO NEXT CHARACTER
	JMP	CONLP		;CHECK IT
DONE:	LXI	H,BUFFER
	SHLD	CURDMA		;RESET DMA ADDRESS
	XCHG
WRLOOP:	MVI	C,SETDMA
	CALL	BDOS		;SET CP/M DMA
	MVI	C,DWRITE
	LXI	D,FCB2
	CALL	BDOS		;WRITE A SECTOR
	ORA	A		;GOOD WRITE
	JZ	GOODW		;YES
	LXI	D,WRERR
	MVI	C,PRINT
	CALL	BDOS		;PRINT "WRITE ERROR"
	JMP	0		;EXIT
GOODW:	LHLD	CURDMA
	LXI	D,80H
	DAD	D		;UPDATE DMA
	SHLD	CURDMA
	XCHG			;DMA ADDR TO DE
	LHLD	SECCNT
	DCX	H		;DECREMENT SECTOR COUNT
	SHLD	SECCNT
	MOV	A,H
	ORA	L		;TEST
	JNZ	WRLOOP		;WRITE UNTIL DONE
	LDA	EOFFLG		;END OF FILE?
	ORA	A
	JZ	LOOP		;IF NOT, LOOP
	LXI	D,FCB1
	MVI	C,CLOSE
	CALL	BDOS		;CLOSE INPUT FILE
	LXI	D,FCB2
	MVI	C,CLOSE
	CALL	BDOS		;CLOSE OUTPUT FILE
	LXI	D,DIDIT
	MVI	C,PRINT
	CALL	BDOS		;PRINT "DONE"
	JMP	0		;RETURN TO CP/M

;	MESSAGES

NOFILE	DB	0DH,0AH,'THE CORRECT USE OF THIS PROGRAM IS'
	DB	0DH,0AH,0DH,0AH
	DB	'd>WSCON d:FILENAME.TYP',0DH,0AH,0DH,0AH
	DB	'WHERE d IS A DRIVE NAME (A - F), AND',0DH,0AH
	DB	'FILENAME.TYP IS THE FILE TO BE CONVERTED',0DH,0AH,'$'
NOOPEN	DB	0DH,0AH,'CAN''T OPEN SOURCE FILE',0DH,0AH,'$'
WORKING	DB	0DH,0AH,'WORKING...',0DH,0AH,'$'
WRERR:	DB	0DH,0AH,'WRITE ERROR',0DH,0AH,'$'
DIDIT:	DB	0DH,0AH,'CONVERSION COMPLETE.',0DH,0AH,'$'

;	STORAGE

CURDMA	DW	BUFFER		;DMA ADDRESS
MEMTOP	DW	0		;MEMORY TOP
SECCNT	DW	0		;SECTOR COUNT
EOFFLG	DB	0		;END OF FILE FLAG
FCB2	DB	0,'        WS ',0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
STACK	EQU	$+40H
BUFFER	EQU	STACK

	END
FLAG
FC