	PAGE	,132
;	DEMO PROGRAM FOR ZPC VERSION 2
;
;	ANSISYS MUST BE LOADED AND ON

;	BY P. SWAYNE, HUG SOFTWARE ENGINEER

ROM	SEGMENT AT 0FE01H		;MONITOR ROM SEGMENT
	ORG	19H
ROMOUT	LABEL	FAR			;ROM CHAR OUTPUT
ROM	ENDS

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	XOR	AX,AX
	MOV	DS,AX			;PUT DS AT INT. SEGMENT
	MOV	SI,10H*4		;INT 10H VECTOR
	LES	DI,DWORD PTR [SI]	;GET INT 10 ADDRESS
	CMP	ES:WORD PTR -4[DI],'NA'	;ANSISYS IN?
	PUSH	CS
	POP	DS			;FIX DS
	JZ	ANSIN			;ANSISYS IN
	MOV	DX,OFFSET NOANSI
	MOV	AH,9
	INT	21H			;SAY "NO ANSISYS"
	INT	20H			;EXIT
ANSIN:	MOV	AX,0C00H
	INT	21H			;CLEAR CONSOLE
	MOV	DX,OFFSET TSTMSG
	MOV	AH,9
	INT	21H			;TEST FOR Z-100 MODE
	MOV	AH,6
	MOV	DL,0FFH
	INT	21H			;LOOK FOR INPUT
	JZ	IBMM			;NONE, IBM MODE
	MOV	AX,0C00H
	INT	21H			;ABSORB EXTRA CHARS
	MOV	DX,OFFSET NOIBM
	MOV	AH,9
	INT	21H			;SAY "NOT IBM MODE"
	INT	20H
IBMM:	MOV	AX,0F401H
	INT	21H			;TURN ANSI ON
	INT	12H			;TEST MEMORY
	CMP	AX,280H			;640 K?
	JB	SMMEM			;SMALL MEMORY
	MOV	BYTE PTR MEMFLG,1	;ELSE, MARK LARGE MEMORY
SMMEM:	MOV	DX,OFFSET MSG1
	MOV	AH,9
	INT	21H			;PRINT MESSAGE 1
	CALL	WFKEY			;WAIT FOR KEY
	MOV	DX,OFFSET MSG2
	MOV	AH,9
	INT	21H			;SET 80 COLUMNS
	MOV	CX,9			;SET A COUNTER
COLLP1:	MOV	DX,OFFSET MSG3
	MOV	AH,9
	INT	21H			;PRINT COLOR BARS
	LOOP	COLLP1			;PRINT 9 LINES OF BARS
	MOV	DX,OFFSET MSG4
	MOV	AH,9
	INT	21H			;PRINT COLOR NAMES
	MOV	CX,9
COLLP2:	MOV	DX,OFFSET MSG3
	MOV	AH,9
	INT	21H			;PRINT COLOR BARS
	LOOP	COLLP2			;PRINT 9 LINES OF BARS
	MOV	DX,OFFSET MSG5
	MOV	AH,9
	INT	21H			;PRINT COLOR NAMES
	CALL	WFKEY
	MOV	DX,OFFSET MSG6
	MOV	AH,9
	INT	21H			;PRINT MSG 6
	CMP	BYTE PTR MEMFLG,0	;TEST MEMORY SIZE
	JNZ	BIGMEM			;BIG MEMORY
	MOV	DX,OFFSET MSG6A
	MOV	AH,9
	INT	21H			;ELSE, PRINT MSG 6A
	JMP	SHORT SMMEM1
BIGMEM:	CALL	WFKEY
	MOV	DX,OFFSET MSG7
	MOV	AH,9
	INT	21H			;SET GRAPHIC MODE
	MOV	BX,0100H
	MOV	AH,11
	INT	10H			;SET PALETTE 0
	MOV	BX,1
	MOV	AH,11
	INT	10H			;SET BLUE BACKGROUND
	MOV	AX,0B800H
	MOV	DS,AX
	MOV	DX,0
	MOV	AH,1AH
	INT	21H			;SET DTA TO VIDEO MEMORY
	PUSH	CS
	POP	DS			;FIX DS
	MOV	DX,OFFSET PFCB1
	MOV	AH,0FH
	INT	21H			;TRY TO OPEN PIC FILE 1
	INC	AL
	JNZ	OPEN1			;OPEN OK
FILERR:	MOV	DX,OFFSET NOFILE
	MOV	AH,9
	INT	21H			;SAY "NO FILE"
	INT	20H			;AND EXIT
OPEN1:	MOV	AX,WORD PTR PFCB1+16	;GET FILE SIZE
	MOV	WORD PTR PFCB1+14,AX	;FIX RECORD SIZE
	MOV	DX,OFFSET PFCB1
	MOV	AH,14H
	INT	21H			;READ PICTURE
SMMEM1:	CALL	WFKEY
	MOV	DX,OFFSET MSG8
	MOV	AH,9
	INT	21H			;PRINT MSG 8
	MOV	SI,OFFSET MSG9
	CALL	PMMSG			;PRINT MSG 9 VIA MONITOR
	CALL	WFKEY			;WAIT FOR KEY
	MOV	SI,OFFSET MSG10
	CALL	PMMSG			;TURN OFF Z-100 CURSOR
	CMP	BYTE PTR MEMFLG,0	;TEST MEMORY SIZE
	JZ	SMMEM2			;SMALL MEMORY, EXIT
	MOV	DX,OFFSET MSG11
	MOV	AH,9
	INT	21H			;SET HI RES MODE
	MOV	DX,OFFSET PFCB2
	MOV	AH,0FH
	INT	21H			;TRY TO OPEN PIC FILE 1
	INC	AL
	JNZ	OPEN2			;OPEN OK
	JMP	FILERR			;ELSE, ERROR
OPEN2:	MOV	AX,WORD PTR PFCB2+16	;GET FILE SIZE
	MOV	WORD PTR PFCB2+14,AX	;FIX RECORD SIZE
	MOV	DX,OFFSET PFCB2
	MOV	AH,14H
	INT	21H			;READ PICTURE
	MOV	DX,OFFSET MSG12
	MOV	AH,9
	INT	21H			;PRINT MSG 12
	CALL	WFKEY
SMMEM2:	MOV	DX,OFFSET MSGL
	MOV	AH,9
	INT	21H			;PRINT LAST MESSAGE
	MOV	AX,0F400H
	INT	21H			;TURN ANSI OFF
	INT	20H

WFKEY:	MOV	DX,OFFSET HITKEY
	MOV	AH,9
	INT	21H			;PRINT "HIT ANY KEY"
	MOV	AH,0
	INT	16H			;WAIT FOR KEY
	RET

PMMSG:	LODSB				;GET A CHARACTER
	CMP	AL,'$'			;END
	JZ	PMMX			;YES
	PUSH	SI
	PUSH	ES
	CLD
	CALL	ROMOUT			;ELSE, PRINT CHAR
	POP	ES
	POP	SI
	JMP	PMMSG
PMMX:	RET

NOANSI	DB	'ANSYSYS must be installed to use this program.$'
NOIBM	DB	'ZPC must be in the PC mode to use this program.$'
TSTMSG	DB	27,'Z',13,'  ',13,'$'
MSG1	DB	27,'[2J',27,'[=1h'
	DB	'     This is a demonstration of',13,10,10
	DB	27,'[33m'
	DB	'                 ZPC',13,10,10,27,'[0m'
	DB	'     (the ',27,'[1;31mHUG'
	DB	27,'[0;5m Z',27,'[0m-100 '
	DB	27,'[5mPC',27,'[0m emulator)',13,10,10
	DB	27,'[33mZPC',27,'[0m is the '
	DB	27,'[5multimate'
	DB	27,'[0;36m software',27,'[0m solution',13,10
	DB	'to the problem of '
	DB	27,'[1;34mIBM PC',27,'[0m compatibility',13,10
	DB	'on the '
	DB	27,'[33mH/Z-100',27,'[0m desk top computer.',13,10,10
	DB	27,'[33mZPC',27,'[0m emulates all operating modes of the',13,10
	DB	27,'[1;34mIBM',27,'[0m'
	DB	' color/graphics adapter, including:',13,10,10
	DB	27,'[31m',16,27,'[0m'
	DB	' 40 and 80 column text modes.',13,10,10
	DB	27,'[31m',16,27,'[0m'
	DB	' Medium resolution color graphics.',13,10,10
	DB	27,'[31m',16,27,'[0m'
	DB	' High resolution monochrome graphics.',13,10,10
	DB	'In the text modes, ',27,'[33mZPC',27,'[0m supports...$'
HITKEY	DB	27,'[25;1HHit any key to continue...$'
MSG2	DB	27,'[=3h$'
MSG3	DB	27,'[30m',219,219,219,219,219,219,219,219,219,' '
	DB	27,'[34m',219,219,219,219,219,219,219,219,219,' '
	DB	27,'[32m',219,219,219,219,219,219,219,219,219,' '
	DB	27,'[36m',219,219,219,219,219,219,219,219,219,' '
	DB	27,'[31m',219,219,219,219,219,219,219,219,219,' '
	DB	27,'[35m',219,219,219,219,219,219,219,219,219,' '
	DB	27,'[33m',219,219,219,219,219,219,219,219,219,' '
	DB	27,'[37m',219,219,219,219,219,219,219,219,219,13,10
	DB	'$'
MSG4	DB	'BLACK     BLUE      GREEN     CYAN      RED       MAGENTA   '
	DB	'YELLOW    WHITE',13,10,10
	DB	27,'[1m$'
MSG5	DB	27,'[0m'
	DB	'GRAY      LT BLUE   LT GREEN  LT CYAN   LT RED    LT MAG.   '
	DB	'LT YEL.   WHITE',13,10,10
	DB	'INTENSE WHITE IS NOT SUPPORTED, BUT IN THE TEXT MODES...$'
MSG6	DB	27,'[=1h',27,'[33m'
	DB	'Intense white is designated '
	DB	27,'[1;37mthis way',27,'[0;33m,',13,10
	DB	'and blinking is designated '
	DB	27,'[5mthis way',27,'[0;33m,',13,10,10
	DB	'If both intense white and blinking',13,10
	DB	'are present, it looks like '
	DB	27,'[1;5;37mthis',27,'[0;33m!',27,'[0m',13,10,10
	DB	'Notice also that lower case decenders',13,10
	DB	'(g,p,q,y) do not touch the tops of',13,10
	DB	'CHARACTERS immediately below them.',13,10
	DB	'This is because ',27,'[33mZPC',27,'[0m'
	DB	' uses 9 scan',13,10
	DB	'lines per character, instead of 8 scan',13,10
	DB	'lines, as on an ',27,'[1;34mIBM PC',27,'[0m'
	DB	', a Z-150, or',13,10
	DB	'a "brand X" PC emulator.',13,10,10
	DB	'However, in the graphics modes,',13,10,'$'
MSG6A	DB	'8 scan lines are used for maximum',13,10
	DB	'PC compatibility.$'
MSG7	DB	27,'[=4h$'
MSG8	DB	27,'[=1h'
	DB	'Because ',27,'[33mZPC',27,'[0m is a '
	DB	27,'[1msoftware '
	DB	27,'[34mIBM PC',27,'[0m',13,10
	DB	'emulator, you still have the resources',13,10
	DB	'of the H/Z-100 computer at your command,',13,10
	DB	'and you can do tricks like this:$'
MSG9	DB	27,'Y00You can have PC text and H/Z-100 text'
	DB	27,'Y10on the screen at the same time!'
	DB	27,'Y20(Try that on a G_____ board!)'
	DB	27,'Y30You can even have two cursors!'
	DB	27,'y5$'
MSG10	DB	27,'x5$'
MSG11	DB	27,'[=6h$'
MSG12	DB	27,'[24;1HZPC can make you happy with your '
	DB	'computer again!       (PC Palette demo picture)$'
MSGL	DB	27,'[=3h'
	DB	'End of demonstration.',13,10,'$'
NOFILE	DB	27,'[=3hERROR -- Picture file not found.',13,10,'$'

MEMFLG	DB	0			;MEMORY SIZE FLAG

PFCB1	DB	0,'GRAPHIC1PIC'
	DB	0,0
RECSIZ	DW	1			;RECORD SIZE (1 BYTE)
	DB	17 DUP (0)
RNDREC	DW	0,0			;RANDOM RECORD NUMBER
PFCB2	DB	0,'GRAPHIC2PIC'
	DB	0,0
	DW	1			;RECORD SIZE (1 BYTE)
	DB	17 DUP (0)
	DW	0,0			;RANDOM RECORD NUMBER

CODE	ENDS
	END	START
                                                           