	TITLE	UNMAP - DISABLE KEYMAP
	PAGE	,132
;	UNMAP - DISABLE Z-150 KEYMAP PROGRAM
;
;	THIS PROGRAM PERMANENTLY DISABLES AN INSTALLED KEYMAP
;	PROGRAM BY REMOVING ITS VECTORS FROM THE BIOS CONSOLE
;	STATUS AND INPUT ROUTINES.  THIS ALLOWS YOU TO INSTALL
;	ANOTHER KEYMAP PROGRAM.  HOWEVER, THE MEMORY SPACE USED
;	BY THE OLD KEYMAP PROGRAM IS NOT RESTORED, SO YOU WILL
;	LOSE SOME MEMORY EACH TIME YOU RUN THIS PROGRAM AND
;	INSTALL ANOTHER KEYMAP.

;	BY P. SWAYNE, HUG  26-SEP-84

;	ADDRESSES IN KEYMAP

INT16V	EQU	0A2BH			;INT 16 VECTOR
INT10V	EQU	0A2FH			;INT 10 VECTOR
TGLFLG	EQU	0A28H			;OFF/ON TOGGLE FLAG
BLMSG	EQU	0A33H			;BOTTOM LINE MESSAGE

UNMAP	SEGMENT
	ASSUME	CS:UNMAP,ES:UNMAP,ES:UNMAP,SS:UNMAP
	ORG	0
Z:					;ZERO LABEL
	ORG	100H

START:	XOR	AX,AX
	MOV	DS,AX			;PUT DS IN BIOS SEGMENT
	MOV	ES,AX			;ES HERE TOO
	MOV	DI,16H*4		;POINT TO INPUT VECTOR
	LDS	SI,Dword Ptr [DI]	;GET ROUTINE ADDRESS
	CMP	Word Ptr -2[SI],'MK'	;TEST IF KEYMAP IS IN
	JZ	MAPPED			;MAPPED, GO ON
	PUSH	CS
	POP	DS			;ELSE, FIX DS
	MOV	DX,Offset NOTMSG
	MOV	AH,9
	INT	21H			;SAY "NOT MAPPED"
	INT	20H			;AND EXIT
MAPPED:	MOV	SI,Offset INT16V	;POINT TO INT 16 VECTOR
	CLD				;ENSURE FORWARD MOVEMENT
	MOVSW				;MOVE OLD ADDRESS TO VECTOR
	MOVSW
	CMP	DS:Byte Ptr Z+TGLFLG,0	;KEYMAP ON?
	JNZ	NOBL			;NO, EXIT
	CMP	DS:Byte Ptr Z+BLMSG,0	;ANY BOTTOM LINE MSG.?
	JZ	NOBL			;NO
	MOV	DI,10H*4		;POINT TO INT 10 VECTOR
	MOV	SI,Offset INT10V	;AND TO OLD ADDRESS
	MOVSW				;REPLACE OLD ADDRESS
	MOVSW
	MOV	AH,15
	INT	10H			;GET ACTIVE PAGE
	MOV	AH,8
	INT	10H			;GET ATTRIBUTE AT CURSOR POS.
	MOV	BH,AH			;PUT IT IN BH
	MOV	AX,600H			;GET BLANK WINDOW FUNCTION
	MOV	CX,24*256		;UPPER CORNER OF WINDOW
	MOV	DX,24*256+79		;LOWER CORNER
	INT	10H			;BLANK 24TH LINE
NOBL:	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	DX,Offset UNMSG
	MOV	AH,9
	INT	21H			;PRINT UNMAP MESSAGE
	INT	20H			;RETURN TO MS-DOS

UNMSG	DB	13,10,'Z-150 KEYMAP Version 1.0 has been disabled.$'
NOTMSG	DB	13,10,'ERROR -- Z-150 KEYMAP is not installed.$'

UNMAP	ENDS
	END	START
