;	KEYMAP -- MAP FUNCTION KEYS TO USER DEFINED CHARACTERS
;
;	THIS PROGRAM MAPS THE VARIOUS FUNCTION KEYS TO USER
;	DEFINED CHARACTER SEQUENCES.  THE SEQUENCE FOR ANY
;	ONE KEY CAN BE UP TO 10 CHARACTERS.
;
;	TO SET UP KEYMAP TO PRODUCE YOUR SELECTED KEY
;	RESPONSES, ENTER
;
;	A>KEYMAP S
;
;	TO RUN THE CONFIGURED PROGRAM, ENTER
;
;	A>KEYMAP	(RUN KEYMAP JUST BELOW CCP)
;	A>KEYMAP T	(RUN KEYMAP AT THE TOP OF MEMORY)
;	A>KEYMAP nnnn	(RUN KEYMAP AT ADDRESS nnnn (HEX))
;
;	DO NOT RUN KEYMAP AT THE TOP OF MEMORY UNLESS YOU
;	HAVE MOVED YOUR CP/M (MOVCPM) TO RESIDE AT LEAST 1K
;	BELOW THE TOP OF MEMORY (I.E., AT 63K FOR A 64K
;	SYSTEM).  IF YOU SPECIFY AN ADDRESS FOR KEYMAP, BE
;	SURE YOU DO NOT OVERWRITE THE SYSTEM OR ANYTHING ELSE.
;
;	TO UNLOAD KEYMAP FROM MEMORY (IF BELOW CCP), ENTER
;
;	A>KEYMAP U
;
;	BY P. SWAYNE, HUG  19-APR-83  11-MAY-83
;	COPYRIGHT (C) 1983 BY HEATH USERS' GROUP

;	DEFINITIONS

BIOS	EQU	0		;BIOS JUMP VECTOR
CURDSK	EQU	4		;CURRENT DISK CELL
BDOS	EQU	5		;BDOS JUMP VECTOR
FCB	EQU	5CH		;FILE CONTROL BLOCK
FCB2	EQU	6CH		;SECOND FCB
CONIN	EQU	1		;CONSOLE INPUT
CONOUT	EQU	2		;CONSOLE OUTPUT
LSTOUT	EQU	5		;LST OUTPUT
DCIO	EQU	6		;DIRECT CONSOLE I/O
TYPE	EQU	9		;TYPE STRING
LINPUT	EQU	10		;LINE INPUT
RESET	EQU	13		;RESET DISK SYSTEM
OPENF	EQU	15		;OPEN FILE
CLOSEF	EQU	16		;CLOSE FILE
DELETF	EQU	19		;DELETE FILE
READF	EQU	20		;READ FILE (SEQUENTIAL)
WRITEF	EQU	21		;WRITE FILE (SEQ)
MAKEF	EQU	22		;MAKE FILE
SETDMA	EQU	26		;SET DMA ADDRESS
FLAGS	EQU	30		;CHANGE FILE ATTRIBUTES
BCONST	EQU	3		;BIOS CONST VECTOR
BCONIN	EQU	6		;BIOS CONIN VECTOR
CCPSIZ	EQU	800H		;SIZE OF CCP

	ORG	100H		;START AT TPA

START	JMP	CONFIG		;CHECK FOR CONFIGURATION MODE
JBDOS	JMP	0		;PUT BDOS JUMP HERE
SETUP	LHLD	BIOS+1		;GET WARM BOOT ADDR
	LXI	D,BCONST+1
	DAD	D		;FIND CONST ADDRESS
	MOV	E,M
	INX	H
	MOV	D,M		;DE = CONST ADDRESS
	XCHG
	SHLD	CONSTV		;SET UP CONST CALL
	XCHG
	LXI	D,MYCONST	;GET MY CONST VECTOR
	MOV	M,D		;PUT IT IN VECTOR
	DCX	H
	MOV	M,E
	INX	H
	INX	H
	INX	H		;SKIP TO BCONIN ADDRESS
	MOV	E,M
	INX	H
	MOV	D,M		;DE = CONIN ADDRESS
	XCHG
	SHLD	CONINV		;SET UP CONIN CALL
	SHLD	CONINV1
	XCHG
	LXI	D,MYCONIN	;GET MY CONIN VECTOR
	MOV	M,D
	DCX	H
	MOV	M,E		;STICK IT IN BIOS
	LDA	BCFLG
	ORA	A		;BELOW CCP?
	JZ	RETCPM		;IF NOT, EXIT
	LHLD	BDOS+1		;GET BDOS ADDRESS
	SHLD	BDOSADR		;SAVE IT FOR UNLOAD
	LXI	H,JBDOS
	SHLD	BDOS+1		;UPDATE BDOS VECTOR
	LHLD	BIOS+1		;GET WARM BOOT ADDRESS
	INX	H		;SKIP JUMP INST
	MOV	E,M
	INX	H
	MOV	D,M		;DE = ORIGINAL WARM BOOT ADDR
	XCHG
	SHLD	WBADR		;SAVE IT FOR UNLOAD
	XCHG
	LXI	D,MYWBOOT	;GET MY WARM BOOT ADDRESS
	MOV	M,D		;REPLACE ORIGINAL
	DCX	H
	MOV	M,E
RETCPM	LHLD	OLDSP		;GET OLD STACK
	SPHL			;SET IT
	RET			;RETURN TO CP/M
KSIGN	DB	'KM'		;KEYMAP SIGNATURE
BDOSADR	DW	0		;ORIGINAL BDOS ADDRESS
WBADR	DW	0		;ORIGINAL WARM BOOT ADDRESS

;	NOW, WE CAN INTERCEPT BIOS CONST AND CONIN CALLS

MYCONST	LDA	MAPFLG		;GET MAP FLAG
	ORA	A		;ARE WE MAPPING?
	JNZ	MAPST		;YES
XCONST	JMP	0		;ELSE, CHECK STATUS
CONSTV	EQU	$-2		;(PUT CONST VECTOR HERE)
MAPST	LHLD	MAPPTR		;GET MAP CHARACTER POINTER
	MOV	A,M		;GET NEXT CHARACTER
	ORA	A		;DONE MAPPING?
	JZ	CKRST		;YES, CHECK REGULAR STATUS
	MVI	A,0FFH
	RET			;ELSE, RETURN CHAR READY
CKRST	STA	MAPFLG		;CLEAR MAP FLAG
	JMP	XCONST		;CHECK STATUS

MYCONIN	LDA	MAPFLG		;GET MAP FLAG
	ORA	A		;ARE WE MAPPING
	JNZ	MAP		;YES, RETURN MAPPED CHARACTER
XCONIN	CALL	0		;ELSE, GET NEXT REGULAR CHARACTER
CONINV	EQU	$-2		;(PUT CONIN VECTOR HERE)
	CPI	0		;TOGGLE KEYMAP?
TGLK	EQU	$-1		;(PUT TOGGLE KEY CODE HERE)
	JZ	TOGGLE		;GO TOGGLE KEYMAP
	CPI	27		;ESCAPE?
	RNZ			;NO, RETURN
	LXI	H,TGLFLG	;POINT TO TOGGLE FLAG
	INR	M
	DCR	M		;SET FLAGS TO ITS CONDITION
	RNZ			;KEYMAP IS OFF
	MVI	L,100		;TRY FOR ESC-CH 100 TIMES
ESCLP	CALL	XCONST		;CHECK CONSOLE STATUS
	ORA	A		;ANY CHARACTER
	JNZ	GOTCHR		;YES
	DCR	L		;ELSE, DECREMENT COUNTER
	JNZ	ESCLP		;TRY AGAIN
	MVI	A,27
	RET			;RETURN WITH ESC
GOTCHR	CALL	XCONIN		;GET NEXT CHARACTER
	CPI	'@'		;"@" OR MORE?
	RC			;NO
	CPI	'W'+1		;"W" OR LESS?
	RNC			;NO
	STA	CHRSAV		;ELSE, SAVE CHARACTER
	CPI	0		;IS THIS THE FUNCTION SHIFT KEY?
FSKEY	EQU	$-1		;(PUT FUNCTION SHIFT KEY HERE)
	JNZ	NOFS		;NO
	LXI	H,FSFLG
	INR	M		;ELSE, SET SHIFT FLAG
	CALL	0		;GET SECOND KEY
CONINV1	EQU	$-2
	CPI	27		;ESCAPE?
	JZ	GOTFES		;IT'S ESCAPE, GET NEXT CHARACTER
	LXI	H,FSFLG
	DCR	M		;ELSE, CLEAR FUNCTION SHIFT FLAG
	RET
GOTFES	MVI	L,100		;TRY FOR ESC-CH 100 TIMES
ESCLP1	CALL	XCONST		;CHECK CONSOLE STATUS
	ORA	A		;ANY CHARACTER
	JNZ	GOTFS		;YES
	DCR	L		;ELSE, DECREMENT COUNTER
	JNZ	ESCLP1		;TRY AGAIN
	LXI	H,FSFLG
	DCR	M		;CLEAR FUNCTION SHIFT FLAG
	MVI	A,27
	RET			;RETURN WITH ESC
GOTFS	CALL	XCONIN		;GET NEXT CHARACTER
	CPI	'@'		;"@" OR MORE?
	RC			;NO
	CPI	'W'+1		;"W" OR LESS?
	RNC			;NO
	STA	CHRSAV		;ELSE, SAVE CHARACTER
NOFS	LXI	H,MAPFLG
	INR	M		;SET MAP FLAG
	LXI	H,MAPTBL	;POINT TO MAP TABLE
	LDA	CHRSAV		;GET ESC CHARACTER
	SUI	'@'		;REMOVE ASCII
	ADD	A		;DOUBLE IT
	ADD	L		;ADD RESULT TO HL
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A		;HL POINTS TO TABLE ENTRY
	MOV	A,M		;GET IT
	INX	H
	MOV	H,M
	MOV	L,A		;HL POINTS TO MAP STRING
	LDA	FSFLG
	ORA	A		;SHIFTED FUNCTION?
	JZ	NOFS1		;NO
	LXI	D,ERA1-ERA
	DAD	D		;ELSE, USE SECOND SHIFT TABLE ENTRY
	XRA	A
	STA	FSFLG		;CLEAR SHIFT FLAG
NOFS1	SHLD	MAPPTR		;SET UP MAP POINTER
MAP	LHLD	MAPPTR		;GET MAP POINTER
	MOV	A,M		;GET MAPPED CHARACTER
	STA	CHRSAV		;SAVE CHARACTER
	INX	H
	MOV	A,M		;PREVIEW NEXT CHARACTER
	ORA	A		;END OF STRING?
	JNZ	NOTEND		;NO
	STA	MAPFLG		;ELSE, CLEAR MAP FLAG
NOTEND	LDA	CHRSAV		;GET CHARACTER
	SHLD	MAPPTR		;UPDATE MAP POINTER
	RET			;RETURN WITH MAPPED CHARACTER

TOGGLE	LDA	TGLFLG		;GET TOGGLE FLAG
	XRI	1		;TOGGLE IT
	STA	TGLFLG
	LXI	H,ERABL		;ASSUME FLAG SET
	JNZ	TOGGLE1		;FLAG SET, ERASE BOTTOM LINE
	LXI	H,SPADM		;POINT TO BOTTOM LINE MESSAGE
TOGGLE1	MVI	D,128+3		;SET A COUNTER
PBLMSG	MOV	A,M		;GET A CHARACTER
	CPI	1AH		;END OF FILE?
	JZ	XCONIN		;YES, GET ANOTHER CHARACTER
	MOV	C,A		;PUT CHARACTER IN C
	PUSH	H		;SAVE POINTER
	PUSH	D		;SAVE COUNTER
	CALL	0		;ELSE, PRINT THIS ONE
CONOUTV	EQU	$-2		;(PUT CONOUT VECTOR HERE)
	POP	D
	POP	H
	INX	H		;INCREMENT POINTER
	DCR	D		;DONE?
	JNZ	PBLMSG		;IF NOT, CONTINUE
	JMP	XCONIN		;GET ANOTHER INPUT

MYWBOOT	LHLD	JBDOS+1		;GET BDOS ADDRESS
	LXI	D,JBDOS		;AND START OF KEYMAP
	MVI	B,6		;SET A COUNTER
MVSER	DCX	H		;DECREMENT POINTERS
	DCX	D
	MOV	A,M		;MOVE CP/M SERIAL NO.
	STAX	D		;TO BEFORE KEYMAP
	DCR	B
	JNZ	MVSER

ENDCODE	EQU	$		;END OF RELOCATABLE CODE

	LDA	CURDSK		;GET CURRENT DISK
	MOV	C,A		;IN C
	JMP	0		;JUMP TO CCP
JCCP	EQU	$-2

MAPFLG	DB	0
MAPPTR	DW	0
FSFLG	DB	0		;FUNCTION SHIFT FLAG
TGLFLG	DB	0		;ON/OFF TOGGLE FLAG
CHRSAV	DB	0
BCFLG	DB	0		;BELOW CCP FLAG
OLDSP	DW	0		;OLD CP/M STACK
ERABL	DB	27,'y1',27,'y6',1AH

;	TABLE OF MAPPED SEQUENCES

MAPTBL	DW	IC
	DW	UP
	DW	DN
	DW	FWD
	DW	BK
	DW	SERA
	DW	ESCF
	DW	ESCG
	DW	HOME
	DW	ESCI
	DW	ERA
	DW	ESCK
	DW	IL
	DW	DL
	DW	DC
	DW	ESCO
	DW	F6
	DW	F7
	DW	F8
	DW	F1
	DW	F2
	DW	F3
	DW	F4
	DW	F5

;	MAPPED CHARACTER SEQUENCES

ERA	DB	27,'J',0
	DS	8
SERA	DB	27,'E',0
	DS	8
F1	DB	27,'S',0
	DS	8
F2	DB	27,'T',0
	DS	8
F3	DB	27,'U',0
	DS	8
F4	DB	27,'V',0
	DS	8
F5	DB	27,'W',0
	DS	8
F6	DB	27,'P',0
	DS	8
F7	DB	27,'Q',0
	DS	8
F8	DB	27,'R',0
	DS	8
IC	DB	27,'@',0
	DS	8
UP	DB	27,'A',0
	DS	8
DC	DB	27,'N',0
	DS	8
BK	DB	27,'D',0
	DS	8
HOME	DB	27,'H',0
	DS	8
FWD	DB	27,'C',0
	DS	8
IL	DB	27,'L',0
	DS	8
DN	DB	27,'B',0
	DS	8
DL	DB	27,'M',0
	DS	8
ESCF	DB	27,'F',0
ESCG	DB	27,'G',0
ESCI	DB	27,'I',0
ESCK	DB	27,'K',0
ESCO	DB	27,'O',0

;	MAPPED CHARACTER SEQUENCES (SHIFTED KEYS)

ERA1	DB	27,'J',0
	DS	8
SERA1	DB	27,'E',0
	DS	8
F11	DB	27,'S',0
	DS	8
F21	DB	27,'T',0
	DS	8
F31	DB	27,'U',0
	DS	8
F41	DB	27,'V',0
	DS	8
F51	DB	27,'W',0
	DS	8
F61	DB	27,'P',0
	DS	8
F71	DB	27,'Q',0
	DS	8
F81	DB	27,'R',0
	DS	8
IC1	DB	27,'@',0
	DS	8
UP1	DB	27,'A',0
	DS	8
DC1	DB	27,'N',0
	DS	8
BK1	DB	27,'D',0
	DS	8
HOME1	DB	27,'H',0
	DS	8
FWD1	DB	27,'C',0
	DS	8
IL1	DB	27,'L',0
	DS	8
DN1	DB	27,'B',0
	DS	8
DL1	DB	27,'M',0
	DS	8
ESCF1	DB	27,'F',0
ESCG1	DB	27,'G',0
ESCI1	DB	27,'I',0
ESCK1	DB	27,'K',0
ESCO1	DB	27,'O',0

SPADM	DB	0,0,0
BLMSG	DS	128		;BOTTOM LINE MESSAGE

ENDPRG	EQU	$

;	CONFIGURE KEYMAP

CONFIG	LXI	H,0
	DAD	SP		;LOCATE STACK
	LXI	SP,STACK	;SET NEW ONE
	SHLD	OLDSP		;SAVE OLD ONE
	LXI	H,80H
	MOV	A,M
	ORA	A		;ANY ARGUMENT IN COMMAND LINE?
	JZ	LOCATE		;IF NOT, START PROGRAM
	INX	H		;SKIP OVER COUNT
GETARG	MOV	A,M		;GET A CHARACTER
	CPI	' '		;SPACE?
	INX	H		;INCREMENT POINTER
	JZ	GETARG		;SKIP SPACES
	CPI	'U'		;UNLOAD?
	JZ	UNLOAD		;YES
	CPI	'S'		;SET UP?
	JNZ	LOCATE		;IF NOT, START
	LXI	D,CONMSG	;ELSE, PRINT CONFIG MESSAGE
	CALL	PMSG
	LXI	D,CBUF		;POINT TO CONFIG BUFFER
	MVI	C,SETDMA
	CALL	BDOS		;SET DMA THERE
	LDA	CURDSK		;GET CURRENT DISK
	ANI	0FH		;REMOVE USER NO.
	INR	A		;MAKE 1-N
	STA	CFCB		;UPDATE FCB
	LXI	D,CFCB		;POINT TO KEYMAP FILE NAME
	MVI	C,OPENF
	CALL	BDOS		;TRY TO OPEN KEYMAP.COM
	INR	A
	ORA	A
	JNZ	OPENED		;OPENED OK
	LXI	D,OPMSG
	CALL	PMSG		;PRINT "CAN'T FIND KEYMAP"
	JMP	EXIT		;EXIT TO CP/M
OPENED	LXI	D,CFCB
	MVI	C,READF
	CALL	BDOS		;READ A SECTOR
	ORA	A		;ALL READ?
	JNZ	RDONE		;LEAVE IF SO
	LHLD	CURDMA		;ELSE, UPDATE DMA ADDRESS
	LXI	D,80H
	DAD	D
	SHLD	CURDMA
	XCHG
	MVI	C,SETDMA
	CALL	BDOS		;AND SET IT
	LXI	H,SECCNT
	INR	M		;AND INCREMENT SECTOR COUNT
	JMP	OPENED		;READ ANOTHER SECTOR
RDONE	LXI	D,CFCB
	MVI	C,CLOSEF
	CALL	BDOS		;CLOSE FILE
	LXI	H,(BLINFCB+CBUF-256)+1	;POINT TO STATUS LINE FILE FCB
	PUSH	H		;SAVE THIS ADDRESS
	MVI	B,11		;SET A COUNTER
	MVI	A,' '		;GET A SPACE
FBFCB	MOV	M,A		;CLEAR FCB
	INX	H
	DCR	B
	JNZ	FBFCB
	LXI	D,BLINEM
	CALL	PMSG		;ASK FOR BOTTOM LINE FILE
	MVI	A,16		;ALLOW 16 CHARACTERS
	CALL	RDCON		;GET REPLY
	POP	H		;RESTORE FCB ADDRESS
	MVI	M,0		;ASSUME NO ENTRY
	JZ	NBLINE		;NO BOTTOM LINE
GBFCB	LDAX	D		;GET A CHARACTER
	ORA	A		;END OF ENTRY?
	JZ	NBLINE		;YES
	CPI	'.'		;END OF NAME?
	JZ	GBTYP		;YES, GET TYPE
	MOV	M,A		;ELSE, STORE CHARACTER
	INX	H		;INCREMENT POINTERS
	INX	D
	JMP	GBFCB		;GET REST OF NAME
GBTYP	LXI	H,(BLINFCB+CBUF-256)+9	;POINT TO TYPE AREA
	INX	D		;SKIP PERIOD
GBTYP1	LDAX	D		;GET A CHARACTER
	ORA	A		;END OF ENTRY?
	JZ	NBLINE		;YES
	MOV	M,A		;ELSE, STORE CHARACTER
	INX	H
	INX	D
	JMP	GBTYP1		;GET MORE
NBLINE	LXI	D,FSKEYM
	CALL	PMSG		;PRINT "ENTER FS KEY"
	MVI	A,10		;ALLOW 10 CHARACTERS
	CALL	RDCON		;INPUT FUNCTION SHIFT KEY
	MVI	A,0		;ASSUME NO KEY
	JZ	NGOTFSK		;DIDN'T WANT ONE
	INX	D		;SKIP ESCAPE
	LDAX	D		;GET FUNCTION SHIFT KEY
NGOTFSK	STA	FSKEY+CBUF-256	;SAVE KEY ENTERED
	JZ	NGOTFS1		;SKIP MARKING OF KEY
	LXI	H,MAPTBL	;POINT TO MAP TABLE
	SUI	'@'		;REMOVE ASCII FROM FUNC. KEY
	ADD	A		;DOUBLE IT
	ADD	L		;ADD RESULT TO HL
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A		;HL POINTS TO TABLE ENTRY
	MOV	A,M		;GET IT
	INX	H
	MOV	H,M
	MOV	L,A		;HL = MAPPED STRING
	LXI	D,CBUF-256
	DAD	D		;CORRECT FOR LOADED PROGRAM
	MOV	A,M		;GET FIRST CHARACTER
	ORI	80H		;SET 8TH BIT (MARK FS KEY)
	MOV	M,A		;REPLACE CHARACTER
NGOTFS1	LXI	D,KEYM
	CALL	PMSG		;PRINT "ENTER KEYS"
	LXI	H,KEYS
	SHLD	KEYMPTR		;SET KEY MESSAGE POINTER
	LXI	H,ERA+CBUF-256
	SHLD	RESPTR		;SET RESPONSE POINTER
	MVI	A,19		;19 KEYS
	STA	COUNT		;SET COUNTER
GETKLP	CALL	CRLF		;PRINT CRLF
	LHLD	KEYMPTR		;GET KEY MESSAGE POINTER
	CALL	PMSG1		;PRINT PROMPT
	SHLD	KEYMPTR		;UPDATE POINTER
	CALL	OPPAR		;PRINT OPEN PARENTHESES
	LHLD	RESPTR		;GET RESPONSE POINTER
	MOV	A,M		;GET FIRST CHARACTER
	ADD	A		;SHIFT LEFT
	JNC	GETKLPA		;NOT FUNCTION SHIFT KEY
	RRC			;FIX CHARACTER
	MOV	M,A		;REPLACE IT
	LXI	D,SHIFTM
	CALL	PMSG		;SAY "SHIFT KEY"
	JMP	GETKLPB
GETKLPA	CALL	PMSG1		;PRINT CURRENT KEY RESPONSE
GETKLPB	CALL	CLPAR		;PRINT CLOSING PARENTHESES
	MVI	A,10		;ALLOW 10 CHARACTERS
	CALL	RDCON		;INPUT RESPONSE
	JZ	NOCHG		;NO CHANGE
	LHLD	RESPTR		;PUT RESPONSE HERE
	MVI	B,11		;MOVE 11 CHARACTERS
	CALL	MOVE
	SHLD	RESPTR		;UPDATE POINTER
	JMP	INRCNT		;INCREMENT COUNT
NOCHG	LHLD	RESPTR
	LXI	D,11
	DAD	D
	SHLD	RESPTR		;UPDATE RESPONSE POINTER
INRCNT	LDA	COUNT		;GET COUNT
	DCR	A		;DONE?
	STA	COUNT
	JNZ	GETKLP		;IF NOT, CONTINUE
	LDA	FSKEY+CBUF-256	;GET FUNCTION SHIFT KEY
	ORA	A		;WANT SHIFTED KEYS?
	JZ	WRITE		;NO, WRITE CONFIGURED KEYMAP
	LXI	D,FKEYM
	CALL	PMSG		;PRINT "ENTER FUNCTION KEYS"
	LXI	H,KEYS
	SHLD	KEYMPTR		;SET KEY MESSAGE POINTER
	LXI	H,ERA1+CBUF-256
	SHLD	RESPTR		;SET RESPONSE POINTER
	MVI	A,19
	STA	COUNT		;SET COUNTER
GETKLP1	CALL	CRLF		;PRINT CRLF
	LHLD	KEYMPTR		;GET KEY MESSAGE POINTER
	CALL	PMSG1		;PRINT PROMPT
	SHLD	KEYMPTR		;UPDATE POINTER
	CALL	OPPAR		;PRINT OPEN PARENTHESES
	LHLD	RESPTR		;GET RESPONSE POINTER
	CALL	PMSG1		;PRINT CURRENT KEY RESPONSE
	CALL	CLPAR		;PRINT CLOSING PARENTHESES
	MVI	A,10		;ALLOW 10 CHARACTERS
	CALL	RDCON		;INPUT RESPONSE
	JZ	NOCHG1		;NO CHANGE
	LHLD	RESPTR		;PUT RESPONSE HERE
	MVI	B,11		;MOVE 11 CHARACTERS
	CALL	MOVE
	SHLD	RESPTR		;UPDATE POINTER
	JMP	INRCNT1		;INCREMENT COUNT
NOCHG1	LHLD	RESPTR
	LXI	D,11
	DAD	D
	SHLD	RESPTR		;UPDATE RESPONSE POINTER
INRCNT1	LDA	COUNT		;GET COUNT
	DCR	A		;DONE?
	STA	COUNT
	JNZ	GETKLP1		;IF NOT, CONTINUE
WRITE	LXI	D,KPADM
	CALL	PMSG		;ASK FOR KEYPAD SHIFT
	MVI	A,3
	CALL	RDCON		;GET ANSWER
	LXI	H,SPADM+CBUF-256	;POINT TO WORK AREA
	JZ	SHPAD		;SHIFT PAD
	LDAX	D		;GET ANSWER
	ANI	5FH		;CAPITALIZE
	CPI	'N'		;NO?
	JNZ	SHPAD		;NO, SHIFT IT
	XRA	A
	MOV	M,A		;ZERO SHIFT PAD STRING
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A
	JMP	NSHPAD
SHPAD	MVI	M,27		;INSERT SHIFT MESSAGE
	INX	H
	MVI	M,'x'
	INX	H
	MVI	M,'6'
NSHPAD	LXI	D,TGLKM
	CALL	PMSG		;ASK FOR TOGGLE CODE
	MVI	A,4
	CALL	RDCON		;GET ANSWER
	JZ	STGLK		;NO TOGGLE KEY WANTED
	LDAX	D		;GET ANSWER
	ANI	1FH		;MAKE IT A CONTROL CODE
STGLK	STA	TGLK+CBUF-256	;STORE TOGGLE CODE
	CALL	CRLF
	LXI	H,FCBX		;POINT TO AFTER FILE TYPE
	XRA	A		;CLEAR A
	MVI	B,24		;SET COUNTER
FCBCLP	MOV	M,A		;CLEAR THIS PART OF FCB
	INX	H
	DCR	B
	JNZ	FCBCLP
	LXI	H,'CO'
	SHLD	CFCB+9		;CLEAR FLAGS IN FCB
	MVI	C,FLAGS
	LXI	D,CFCB
	CALL	BDOS		;AND ON DISK
	LXI	D,CFCB
	MVI	C,DELETF
	CALL	BDOS		;DELETE OLD KEYMAP
	LXI	D,CFCB
	MVI	C,MAKEF
	CALL	BDOS		;MAKE NEW ENTRY
	LXI	H,CBUF
	SHLD	CURDMA		;RESET DMA POINTER
	XCHG
WRLOOP	MVI	C,SETDMA
	CALL	BDOS		;SET DMA
	MVI	C,WRITEF
	LXI	D,CFCB
	CALL	BDOS		;WRITE A SECTOR
	LHLD	CURDMA
	LXI	D,80H
	DAD	D
	SHLD	CURDMA		;UPDATE DMA ADDRESS
	XCHG
	LDA	SECCNT
	DCR	A
	STA	SECCNT		;DECREMENT SECTOR COUNT
	JNZ	WRLOOP		;LOOP UNTIL FINISHED
	MVI	C,CLOSEF
	LXI	D,CFCB
	CALL	BDOS		;CLOSE FILE
	LXI	D,DONEMSG
	CALL	PMSG		;PRINT "DONE"
EXIT	LXI	D,80H
	MVI	C,SETDMA
	CALL	BDOS		;RESTORE DEFAULT DMA
	LHLD	OLDSP		;RESTORE OLD STACK
	SPHL			;SET IT
	RET			;RETURN TO CP/M

CRLF	LXI	D,CRLFM
	JMP	PMSG
OPPAR	LXI	D,OPPARM
	JMP	PMSG
CLPAR	LXI	D,CLPARM
PMSG	MVI	C,TYPE
	CALL	BDOS		;PRINT MESSAGE
	RET

PMSG1	MOV	A,M		;GET CHARACTER
	INX	H		;INCREMENT POINTER
	ORA	A		;END OF MESSAGE?
	RZ			;YES
	PUSH	H		;ELSE, SAVE HL
	CPI	' '		;LESS THAN SPACE?
	JNC	PABLE		;NO, PRINTABLE
	PUSH	PSW		;ELSE, SAVE CHARACTER
	MVI	E,'^'
	MVI	C,CONOUT
	CALL	BDOS		;PRINT "^"
	POP	PSW		;RESTORE CHARACTER
	ADI	'@'		;ADD ASCII
PABLE	MVI	C,CONOUT
	MOV	E,A
	CALL	BDOS		;PRINT CHARACTER
	POP	H
	JMP	PMSG1		;PRINT NEXT CHARACTER

RDCON	STA	INBUF		;SET IN COUNT
	LXI	D,INBUF		;POINT TO CONSOLE BUFFER
	MVI	C,LINPUT
	PUSH	D		;SAVE ADDRESS
	CALL	BDOS		;READ CONSOLE BUFFER
	POP	D
	INX	D
	LDAX	D		;GET COUNT
	ORA	A		;ANY INPUT
	RZ			;RETURN IF NOT
	INX	D		;MOVE TO START OF WORD
	PUSH	D		;SAVE START OF ENTRY
	ADD	E		;ADD COUNT TO E
	MOV	E,A		;RESULT IN E
	JNC	RDCON0		;NO CARRY FROM ADD
	INR	D		;ELSE, INCREMENT D
RDCON0	XRA	A
	STAX	D		;TERMINATE ENTRY WITH ZERO
	INR	A
	ORA	A		;CLEAR FLAGS
	POP	D		;RESTORE ENTRY ADDRESS
	RET

;	INPUT HEX NUMBER AT (DE)

HEXIN	LXI	H,0		;CLEAR HL
	MVI	B,4		;SET A COUNTER
HEXIN1	LDAX	D		;GET A CHARACTER
	INX	D		;INCREMENT POINTER
	ORA	A		;END OF ENTRY?
	RZ			;YES
	CALL	BIN		;ELSE, CONVERT TO BINARY
	RC			;BAD ENTRY
	DAD	H		;MOVE LAST ENTRY
	DAD	H		;OVER 4 PLACES
	DAD	H
	DAD	H
	ORA	L		;ADD IN LATEST ENTRY
	MOV	L,A
	DCR	B		;DONE?
	JNZ	HEXIN1		;IF NOT, LOOP
	RET			;ELSE, RETURN

BIN	SUI	'0'
	RC			;LESS THAN "0"
	ADI	'0'-'G' AND 0FFH
	RC			;MORE THAN "F"
	ADI	6
	JP	BIN0		;MUST BE "A"-"F"
	ADI	7
	RC			;BETWEEN "9" AND "A"
BIN0	ADI	10		;ADJUST
	ORA	A		;CLEAR CARRY
	RET

;	MOVE B BYTES FROM DE TO HL 

MOVE	LDAX	D		;GET A CHARACTER
	CPI	'^'		;CONTROL CHARACTER?
	JNZ	MOVE1		;NO
	INX	D		;ELSE, SKIP "^"
	LDAX	D		;GET NEXT CHARACTER
	ANI	5FH		;CAPITALIZE
	SUI	'@'		;MAKE IT A CONTROL CHARACTER
MOVE1	MOV	M,A		;MOVE IT IN
	INX	D
	INX	H		;INCREMENT POINTERS
	DCR	B		;DECREMENT COUNTER
	JNZ	MOVE		;LOOP UNTIL DONE
	RET

;	UNLOAD KEYMAP FROM MEMORY

UNLOAD	LHLD	BIOS+1		;GET BIOS VECTOR
	INX	H		;SKIP JUMP
	MOV	E,M
	INX	H
	MOV	D,M		;DE = WARM BOOT
	CALL	CPHD+1		;TEST IF KEYMAP ALREADY OUT
	JC	UNLOAD1		;SOMETHING'S IN, GO AHEAD
NUNLD	LXI	D,ITSOUT
	CALL	PMSG		;ELSE, SAY "IT'S OUT"
	JMP	RETCPM		;RETURN TO CP/M
UNLOAD1	LHLD	BDOS+1		;GET BDOS ADDRESS
	PUSH	H		;SAVE IT
	LXI	D,KSIGN-JBDOS
	DAD	D		;LOCATE KEYMAP SIGNATURE
	MOV	A,M		;GET FIRST CHARACTER
	CPI	'K'		;IS IT "K"?
	JNZ	NUNLD		;IF NOT, DO NOT UNLOAD
	INX	H
	MOV	A,M		;GET SECOND CHARACTER
	CPI	'M'		;IS IT "M"?
	JNZ	NUNLD		;IF NOT, DO NOT UNLOAD
	INX	H		;MOVE TO OLD BDOS ADDRESS
	MOV	E,M		;GET IT
	INX	H
	MOV	D,M
	XCHG
	SHLD	BDOS+1		;RESTORE IT
	XCHG
	INX	H		;MOVE TO ORIGINAL WARM BOOT ADDR
	MOV	E,M		;GET IT
	INX	H
	MOV	D,M
	XCHG
	SHLD	WBADR		;SAVE IT
	POP	H		;RESTORE KEYMAP BDOS ADDRESS
	PUSH	H		;SAVE AGAIN
	LXI	D,CONSTV-JBDOS
	DAD	D		;LOCATE CONST ADDRESS
	MOV	C,M		;GET IT
	INX	H
	MOV	B,M		;BC = CONST ADDRESS
	POP	H		;RESTORE BDOS ADDRESS
	LXI	D,CONINV-JBDOS
	DAD	D		;LOCATE CONIN ADDRESS
	MOV	E,M		;GET IT
	INX	H
	MOV	D,M		;DE = CONIN ADDRESS
	LHLD	BIOS+1		;GET BIOS ADDRESS
	INX	H		;SKIP JUMP
	PUSH	D		;SAVE CONIN ADDRESS
	XCHG
	LHLD	WBADR		;GET WARM BOOT ADDRESS
	XCHG
	MOV	M,E		;REPLACE WARM BOOT ADDRESS
	INX	H
	MOV	M,D
	INX	H
	INX	H		;SKIP JUMP INST.
	MOV	M,C		;REPLACE CONST ADDRESS
	INX	H
	MOV	M,B
	INX	H
	INX	H
	POP	D		;GET CONIN ADDRESS
	MOV	M,E		;REPLACE CONIN
	INX	H
	MOV	M,D
	LXI	D,OUTM
	CALL	PMSG		;REPORT KEYMAP UNLOADED
	JMP	RETCPM		;RETURN TO CP/M

;	LOCATE - LOCATE KEYMAP IN HIGH MEMORY

LOCATE	JNZ	LOCATE1		;DO NOT LOAD BELOW FCB
	LHLD	BIOS+1		;GET BIOS VECTOR
	INX	H		;SKIP JUMP
	MOV	E,M
	INX	H
	MOV	D,M		;DE = WARM BOOT ADDRESS
	CALL	CPHD+1		;TEST IF KEYMAP ALREADY IN
	JNC	LOCATE0		;NO, GO AHEAD
	LXI	D,ITSIN
	CALL	PMSG		;SAY "IT'S IN"
	JMP	RETCPM		;RETURN TO CP/M
LOCATE0	LXI	H,BCFLG
	INR	M		;SET BELOW CCP FLAG
	LXI	H,JBDOS
	SHLD	STRTMV		;FIX START MOVE ADDRESS
	LHLD	BDOS+1		;GET BDOS ADDRESS
	SHLD	JBDOS+1		;SET UP BDOS VECTOR
	MVI	L,0		;GET START OF BDOS
	LXI	D,-(CCPSIZ-3)
	DAD	D		;FIND CCP CLEAR START
	SHLD	JCCP		;SET UP WARM BOOT
	IF	((400H-6)-(ENDPRG-JBDOS)) SHR 8
%	ERROR -- KEYMAP IS TOO BIG
	ENDIF
	LXI	D,-(400H-6)	;ALLOW 1K LESS 6 FOR PROGRAM
	DAD	D		;COMPUTE START ADDRESS
	PUSH	H		;SAVE ENTRY ADDRESS
	DCX	H		;BACK UP TO START ADDRESS
	DCX	H
	DCX	H
	PUSH	H		;SAVE START ADDRESS
	LXI	D,JBDOS		;GET ORG ADDRESS
	CALL	CBIAS		;COMPUTE BIAS
	JMP	LOCATE3		;GO FIX PROGRAM
LOCATE1	PUSH	PSW		;SAVE USER ARGUMENT
	PUSH	H		;SAVE HL
	LHLD	BIOS+1		;GET BIOS ADDRESS
	LXI	D,BCONST+1
	DAD	D		;FIND CONST ADDRESS
	MOV	E,M
	INX	H
	MOV	D,M		;DE = CONST ADDRESS
	CALL	CPHD+1		;TEST FOR ALTERATION
	JNC	LOC1A		;NO ALTERATION
	LXI	D,ITSIN1
	CALL	PMSG		;ELSE, PRINT WARNING
LOC1A	POP	H		;RESTORE HL
	XCHG			;DE = ARGUMENT ADDRESS
	DCX	D		;BACK UP TO FIRST CHARACTER
	CALL	FNDTOP		;FIND TOP OF MEMORY
	POP	PSW
	CPI	'T'		;PUT PROGRAM AT TOP?
	JZ	LOCATE2		;YES
	PUSH	H		;ELSE, SAVE TOP
	CALL	HEXIN		;INPUT NEW ADDRESS
	JNC	GDADR		;GOOD ADDRESS
BDADR	LXI	D,BADADR
	CALL	PMSG		;SAY "BAD ADDRESS"
	JMP	RETCPM
GDADR	LXI	D,3FFFH
	CALL	CPHD+1		;ADDR MUST BE > 3FFFH
	JNC	BDADR		;IT AIN'T
	POP	D		;GET TOP ADDRESS
	CALL	CPHD+1		;GOOD PLACE?
	JNC	LOCATE2		;YES
	LXI	D,TOOHI
	CALL	PMSG		;SAY "TOO HIGH"
	JMP	RETCPM
LOCATE2	PUSH	H		;SAVE DESTINATION ADDRESS
	PUSH	H		;AND ENTRY ADDRESS
	LXI	D,SETUP		;START PROGRAM HERE
	CALL	CBIAS		;COMPUTE RELOCATION BIAS
LOCATE3	LXI	H,SETUP		;HL = ORG ADDR
	LXI	D,ENDCODE 	;END OF CODE TO FIX
LOCAT0	MOV	A,M		;GET OPCODE
	MOV	B,A		;SAVE IT
	PUSH	H		;SAVE ADDRESS

;	LOCATE TWO AND THREE BYTE OPCODES

	LXI	H,THBYT		;THREE BYTE TABLE
LOCAT1	MOV	A,M		;GET TABLE OPCODE
	CMP	B		;MATCHES PROGRAM OPCODE?
	JZ	LOCAT2		;YES, PROCESS IT
	CPI	0F7H		;END OF TABLE?
	INX	H
	JNZ	LOCAT1		;IF NOT, CONTINUE
LOCATA	MOV	A,M		;GET TABLE OPCODE
	CMP	B		;MATCHES PROGRAM OPCODE?
	JZ	LOCATB		;YES, SKIP DATA BYTE
	CPI	0F7H		;END OF TABLE?
	INX	H		;MOVE POINTER
	JNZ	LOCATA		;IF NOT, CONTINUE
	JMP	LOCATC		;ONE BYTE INSTRUCTION
LOCATB	POP	H		;RESTORE ADDRESS POINTER
	INX	H		;SKIP DATA BYTE
	PUSH	H		;SAVE ADDRESS
LOCATC	POP	H		;RESTORE ADDRESS
	CALL	CPHD		;END OF KEYMAP?
	JNC	LOCAT0		;IF NOT, CONTINUE
	JMP	LOCAT5		;CODE FIXED, MOVE IT

;	FIX THREE BYTE INSTRUCTIONS

LOCAT2	POP	H		;RESTORE ADDRESS
	INX	H		;POINT TO CODE ARGUMENT
	PUSH	D		;SAVE END POINTER
	MOV	E,M
	INX	H
	MOV	D,M		;DE = ADDR TO CHECK
	PUSH	H		;SAVE ADDRESS POINTER
	LXI	H,JBDOS-1 	;CHECK IF ADDRESS IS
	CALL	CPHD		;BELOW KEYMAP
	JC	LOCAT3		;IF SO, DO NOT ADJUST
	POP	H		;RESTORE ADDRESS
	POP	D		;RESTORE END POINTER
	DCX	H		;ADDR LOW BYTE
	LDA	BIAS		;FIX CODE
	ADD	M
	MOV	M,A
	INX	H
	LDA	BIAS+1
	ADC	M
	MOV	M,A		;ADDR = ADDR + BIAS
	JMP	LOCAT4
LOCAT3	POP	H		;RESTORE ADDRESS
	POP	D		;RESTORE END POINTER
LOCAT4	CALL	CPHD		;END OF FIXABLE CODE?
	JNC	LOCAT0		;IF NOT, CONTINUE

;	FIX DW TABLE

LOCAT5	LHLD	BIAS		;GET BIAS
	MOV	B,H
	MOV	C,L		;IN BC
	LXI	H,MAPTBL	;POINT TO MAP TABLE
	MVI	A,24		;SET COUNTER (24 TABLE ENTRIES)
FXTBL	MOV	E,M		;GET TABLE ENTRY
	INX	H
	MOV	D,M
	XCHG
	DAD	B		;ADD BIAS
	XCHG
	MOV	M,D		;REPLACE CORRECTED ENTRY
	DCX	H
	MOV	M,E
	INX	H		;MOVE TO NEXT ENTRY
	INX	H
	DCR	A		;DONE?
	JNZ	FXTBL

;	INSERT CONSOLE OUT BIOS VECTOR

	LHLD	BIOS+1		;GET BIOS ADDRESS
	LXI	D,9		;OFFSET TO CONOUT
	DAD	D
	XCHG			;RESULT TO DE
	LXI	H,CONOUTV	;PUT IT HERE
	MOV	M,E
	INX	H
	MOV	M,D

;	PRINT BOTTOM LINE MESSAGE

	MVI	A,1AH
	STA	BLMSG		;CLEAR BOTTOM LINE MESSAGE
	LXI	D,BLINFCB+1
	LDAX	D
	ORA	A		;ANY STATUS FILE
	JZ	PMSGX		;NO
	DCX	D		;ELSE, BACK UP TO FCB
	LDA	CURDSK		;GET CURRENT DISK
	ANI	0FH		;REMOVE USER NO.
	INR	A		;MAKE 1-N
	STAX	D		;UPDATE FCB
	MVI	C,OPENF
	CALL	BDOS		;TRY TO OPEN STATUS LINE FILE
	INR	A		;GOOD OPEN
	JZ	PMSGX		;NO FILE
	LXI	D,BLINFCB
	MVI	C,READF
	CALL	BDOS		;READ FILE
	LXI	D,BLINFCB
	MVI	C,CLOSEF
	CALL	BDOS		;CLOSE FILE
	LXI	D,80H		;MESSAGE IS HERE
	LXI	H,BLMSG		;PUT MESSAGE HERE
	MVI	B,128		;128 CHARACTERS
MMSG	LDAX	D
	MOV	M,A		;MOVE MESSAGE INTO KEYMAP
	INX	H
	INX	D
	DCR	B
	JNZ	MMSG		;LOOP UNTIL DONE
PMSGX	LXI	H,SPADM
	MVI	B,128+3		;128 CHARS PLUS KEYPAD SHIFT
PMSGL	MOV	A,M
	CPI	1AH		;EOF?
	JZ	MOVNEW		;YES, CLOSE MESSAGE FILE
	MOV	E,A
	MVI	C,DCIO
	PUSH	H		;SAVE POINTER
	PUSH	B		;AND COUNTER
	CALL	BDOS		;PRINT CHAR
	POP	B
	POP	H
	INX	H		;INCREMENT POINTER
	DCR	B		;DECREMENT COUNTER
	JNZ	PMSGL

;	MOVE TO NEW LOCATION

MOVNEW	POP	H		;GET DESTINATION
	PUSH	H		;SAVE AGAIN
	MOV	B,H		;PUT IN BC
	MOV	C,L
	LXI	H,SETUP		;HL = START OF KEYMAP
STRTMV	EQU	$-2		;START MOVE ADDRESS
	LXI	D,ENDPRG	;DE = END OF KEYMAP
LOCAT6	MOV	A,M		;GET BYTE TO MOVE
	STAX	B		;STORE AT NEW ADDR
	INX	B		;INCREMENT DEST POINTER
	CALL	CPHD		;DONE?
	JNC	LOCAT6		;NO, KEEP MOVING CODE

;	COPY CP/M SERIAL NO. TO NEW LOCATION

	LHLD	BDOS+1		;GET BDOS ADDRESS
	POP	D		;GET DESTINATION
	MVI	B,6		;SET A COUNTER
MOVSER	DCX	H		;BACK UP POINTERS
	DCX	D
	MOV	A,M		;GET A DIGIT
	STAX	D		;STORE IT
	DCR	B		;DONE?
	JNZ	MOVSER		;LOOP UNTIL DONE

;	JUMP TO NEW KEYMAP

	LXI	D,INSTM
	CALL	PMSG		;PRINT "INSTALLED"
	POP	H		;GET START ADDRESS
	PCHL			;TAKE THE JUMP

;	FNDTOP - FIND TOP OF MEMORY

FNDTOP	LXI	H,0FFH
FNDTOP0	DCR	H		;FIND TOP OF MEMORY
	MOV	A,M
	INR	M
	CMP	M
	MOV	M,A
	JZ	FNDTOP0
	INX	H		;MAKE ADDRESS EVEN PAGE
	DCR	H		;SUBTRACT ONE K
	DCR	H
	DCR	H
	DCR	H
	RET

;	COMPARE HL TO DE
;	RETURNS CARRY IF HL > DE

CPHD	INX	H		;INCREMENT HL
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	RET

;	CBIAS - COMPUTE RELOCATION BIAS

CBIAS	MOV	A,L		;COMPUTE BIAS
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
	SHLD	BIAS
	RET

;	TABLE OF THREE BYTE INSTRUCTIONS
;	THAT REQUIRE FIXING

THBYT	DB	01H		;LXI B
	DB	11H		;LXI D
	DB	21H		;LXI H
	DB	31H		;LXI SP
	DB	22H		;SHLD
	DB	2AH		;LHLD
	DB	32H		;STA
	DB	3AH		;LDA
	DB	0CDH		;CALL
	DB	0CCH		;CZ
	DB	0C3H		;JMP
	DB	0C2H		;JNZ
	DB	0CAH		;JZ
	DB	0D2H		;JNC
	DB	0DAH		;JC
	DB	0F2H		;JP
	DB	0FAH		;JM
	DB	0F7H		;END OF TABLE

;	TWO BYTE OPCODES

TWBYT	DB	3EH		;MVI A
	DB	6		;MVI B
	DB	0EH		;MVI C
	DB	16H		;MVI D
	DB	1EH		;MVI E
	DB	26H		;MVI H
	DB	2EH		;MVI L
	DB	36H		;MVI M
	DB	0C6H		;ADI
	DB	0CEH		;ACI
	DB	0D6H		;SUI
	DB	0E6H		;ANI
	DB	0EEH		;XRI
	DB	0FEH		;CPI
	DB	0D3H		;OUT
	DB	0DBH		;IN
	DB	0F7H		;END OF TABLE

;	DATA AREA

CONMSG	DB	13,10,'KEYMAP Function Key Mapper, '
	DB	'Version 1.1 (Configuration Mode)',13,10,10,'$'
BLINEM	DB	'Enter the name of your status line message '
	DB	'file.',13,10
	DB	'(Or, RETURN only for no message): $'
FSKEYM	DB	13,10,10
	DB	'Press the key you want to use for function '
	DB	'shift, then RETURN.',13,10
	DB	'(Or, RETURN only to disable function shift): $'
KEYM	DB	13,10,10
	DB	'Enter the response for each key when prompted.'
	DB	13,10
	DB	'The current response will be shown in parentheses.'
	DB	13,10,'$'
FKEYM	DB	13,10,10
	DB	'Enter the response for each shifted key when '
	DB	'prompted.',13,10,'$'
SHIFTM	DB	27,'p FUNCTION SHIFT KEY ',27,'q$'
KEYS	DB	'ERASE or F0',0,'SHIFT-ERASE or SHIFT-F0',0
	DB	'f1 or F1',0,'f2 or F2',0,'f3 or F3',0
	DB	'f4 or F4',0,'f5 or F5',0,'BLUE or F6',0
	DB	'RED or F7',0,'WHITE or F8',0,'IC or 7',0
	DB	'Up-Arrow or 8',0,'DC or 9',0,'Back-Arrow or 4',0
	DB	'HOME or 5',0,'Forward-Arrow or 6',0,'IL or 1',0
	DB	'Down-Arrow or 2',0,'DL or 3',0
KPADM	DB	13,10,10
	DB	'Want keypad shifted? (Y or N -- RETURN = Y) $'
TGLKM	DB	13,10,10
	DB	'Enter on/off toggle code. (RETURN = none) $'
CRLFM	DB	13,10,'$'
OPPARM	DB	' ($'
CLPARM	DB	'): $'
DONEMSG	DB	13,10,'KEYMAP configuration completed.',13,10,'$'
OPMSG	DB	13,10,'ERROR - Can''t find KEYMAP.COM.',13,10,'$'
BADADR	DB	13,10,'ERROR - Bad address entered.',13,10,'$'
TOOHI	DB	13,10,'ERROR - Address too high.',13,10,'$'
ITSIN	DB	13,10,'ERROR - KEYMAP or another program '
	DB	'has already been installed.',13,10,'$'
ITSOUT	DB	13,10,'ERROR - KEYMAP 1.1 is not installed.',13,10,'$'
ITSIN1	DB	13,10,'WARNING - KEYMAP or another program '
	DB	'has already been installed.',13,10,'$'
INSTM	DB	13,10,'KEYMAP Version 1.1 Installed.',13,10,'$'
OUTM	DB	13,10,'KEYMAP 1.1 is unloaded.',27,'y1',27,'y6',13,10,'$'
KEYMPTR	DW	0		;KEY MESSAGE POINTER
RESPTR	DW	0		;RESPONSE POINTER
BIAS	DS	2		;RELOCATION BIAS
COUNT	DB	0		;COUNTER
SECCNT	DB	0		;FILE SECTOR COUNT
CURDMA	DW	CBUF		;CURRENT DMA ADDRESS
CFCB	DB	0,'KEYMAP  COM'
FCBX	DB	0,0,0,0
	DS	16
	DB	0,0,0,0
BLINFCB	DB	0,'           ',0,0,0,0
	DS	16
	DB	0,0,0,0
INBUF	DS	13		;INPUT BUFFER
	DS	64		;STACK SPACE
STACK	EQU	$
CBUF	EQU	$		;CONFIG BUFFER

	END	START

	DS	