;	STATLIN - GENERATE STATUS LINE MESSAGE
;
;	THIS PROGRAM GENERATES A FUNCTION KEY PROMPT
;	MESSAGE FOR THE 25TH LINE (STATUS LINE) ON
;	HEATH/ZENITH TERMINALS.  TO USE THIS PROGRAM,
;	ENTER
;
;	A>STATLIN d:FILENAME.TYP
;
;	WHERE FILENAME.TYP IS THE NAME OF THE MESSAGE
;	FILE YOU WISH TO CREATE, AND d: IS THE DRIVE
;	THAT YOU WANT TO PUT THE FILE ON.
;
;	TO VIEW A STATUS LINE FILE, JUST "TYPE" IT:
;
;	A>TYPE d:FILENAME.TYP
;
;	TO ERASE A STATUS LINE MESSAGE, RUN STATLIN WITHOUT
;	AN ARGUMENT:
;
;	A>STATLIN
;
;	BY P. SWAYNE, HUG  10-MAY-83

;	DEFINITIONS

BDOS	EQU	5		;BDOS JUMP VECTOR
FCB	EQU	5CH		;FILE CONTROL BLOCK
FCB2	EQU	6CH		;SECOND FCB
CONIN	EQU	1		;CONSOLE INPUT
CONOUT	EQU	2		;CONSOLE OUTPUT
LSTOUT	EQU	5		;LST OUTPUT
DCIO	EQU	6		;DIRECT CONSOLE I/O
TYPE	EQU	9		;TYPE TEST STRING
LINPUT	EQU	10		;LINE INPUT
OPENF	EQU	15		;OPEN FILE
CLOSEF	EQU	16		;CLOSE FILE
DELETF	EQU	19		;DELETE FILE
READF	EQU	20		;READ FILE (SEQUENTIAL)
WRITEF	EQU	21		;WRITE FILE (SEQ)
MAKEF	EQU	22		;MAKE FILE
SETDMA	EQU	26		;SET DMA ADDRESS

	ORG	100H

START	LXI	H,0
	DAD	SP		;FIND STACK
	LXI	SP,STACK	;SET NEW ONE
	PUSH	H		;SAVE OLD ONE
	LDA	FCB+1
	CPI	' '		;ANY FILE ENTERED?
	JNZ	GOTFIL		;YES
ERASE	LXI	D,ERAM		;ELSE, ERASE BOTTOM LINE
	CALL	PMSG
EXIT	POP	H		;RESTORE OLD STACK
	SPHL			;SET IT
	RET			;RETURN TO CP/M
GOTFIL	LXI	D,FCB
	MVI	C,OPENF
	CALL	BDOS		;TRY TO OPEN FILE
	INR	A		;IS IT THERE?
	JZ	NOFILE		;NO, GO AHEAD
	LXI	D,FILEX
	CALL	PMSG		;SAY "FILE ALREADY EXISTS"
	CALL	RDCON		;GET RESPONSE
	JZ	DELFILE		;DELETE FILE
	LDAX	D		;GET REPLY
	ANI	5FH		;CAPITALIZE
	CPI	'N'		;NO
	JZ	EXIT		;YES, EXIT
DELFILE	LXI	D,FCB
	MVI	C,DELETF
	CALL	BDOS		;ELSE, DELETE FILE
NOFILE	LXI	D,FCB
	MVI	C,MAKEF
	CALL	BDOS		;MAKE FILE
	INR	A		;GOOD MAKE?
	JNZ	GDMAKE		;YES
	LXI	D,NOSPC
	CALL	PMSG		;SAY "NO SPACE"
	JMP	EXIT
GDMAKE	LXI	D,PRMSG
	CALL	PMSG		;PROMPT FOR ENTRIES
	LXI	H,80H
	SHLD	OUTPTR		;SET UP OUTPUT POINTER
	LXI	D,INTRO		;GET INTRO STRING
	MVI	B,20
	CALL	MOVE		;MOVE IT INTO OUTPUT BUFFER
	SHLD	OUTPTR		;UPDATE POINTER
	MVI	C,9		;SET A COUNTER (9 KEYS)
GELP	LXI	D,ENMSG
	CALL	PMSG		;PRINT "ENTER"
	PUSH	B
	CALL	RDCON		;GET REPLY
	LDAX	D		;GET FIRST CHARACTER
	ORA	A		;ZERO? (NULL ENTRY)
	JNZ	NOTNUL		;NO
	MVI	A,' '
	STAX	D		;REPLACE NULL WITH SPACE
NOTNUL	POP	B
	LHLD	OUTPTR
	MVI	B,6
	CALL	MOVE		;MOVE REPLY INTO BUFFER
	LXI	D,ISTR
	MVI	B,5
	CALL	MOVE		;ADD TRAILING "i"
	SHLD	OUTPTR
	DCR	C		;DONE?
	JNZ	GELP		;IF NOT, LOOP
	LXI	D,OUTRO
	MVI	B,5
	CALL	MOVE		;MOVE IN CLOSING STUFF
	LXI	H,80H
	CALL	PMSG1		;TEST PRINT THE MESSAGE
	LXI	D,OKM
	CALL	PMSG		;ASK FOR OK
	CALL	RDCON		;GET REPLY
	JZ	OK		;IT'S OK
	PUSH	D
	LXI	D,ERAM
	CALL	PMSG		;ERASE BOTTOM LINE
	POP	D
	LDAX	D
	ANI	5FH
	CPI	'N'		;NO?
	JZ	GDMAKE		;NOT OK
OK	LXI	D,FCB
	MVI	C,WRITEF
	CALL	BDOS		;WRITE FINISHED FILE
	ORA	A		;GOOD WRITE?
	JZ	CLOSE		;CLOSE AND EXIT
	LXI	D,BADWRT
	CALL	PMSG		;SAY "BAD WRITE"
	JMP	ERASE		;AND LEAVE
CLOSE	LXI	D,FCB
	MVI	C,CLOSEF
	CALL	BDOS		;CLOSE FILE
	JMP	ERASE		;ERASE AND EXIT

RDCON	MVI	A,6		;ALLOW 6 CHARACTERS
	STA	INBUF		;SET IN COUNT
	LXI	H,INBUF+2
CLINB	MVI	M,' '		;CLEAR INPUT BUFFER
	INX	H
	DCR	A
	JNZ	CLINB
	LXI	D,INBUF		;POINT TO CONSOLE BUFFER
	MVI	C,LINPUT
	PUSH	D		;SAVE ADDRESS
	CALL	BDOS		;READ CONSOLE BUFFER
	POP	D
	INX	D
	LDAX	D		;GET COUNT
	ORA	A		;ANY INPUT
	RZ			;RETURN IF NOT
	INX	D		;MOVE TO START OF WORD
	PUSH	D		;SAVE START OF ENTRY
	ADD	E		;ADD COUNT TO E
	MOV	E,A		;RESULT IN E
	JNC	RDCON0		;NO CARRY FROM ADD
	INR	D		;ELSE, INCREMENT D
RDCON0	XCHG			;HL = POSITION
	MVI	A,5
CLEND	MVI	M,' '		;CLEAR END OF MESSAGE
	INX	H
	DCR	A
	JNZ	CLEND
	INR	A		;CLEAR FLAGS
	POP	D		;RESTORE ENTRY ADDRESS
	RET

MOVE	LDAX	D
	MOV	M,A
	INX	H
	INX	D
	DCR	B
	JNZ	MOVE
	RET

PMSG	PUSH	B
	MVI	C,TYPE
	CALL	BDOS
	POP	B
	RET

PMSG1	MOV	A,M
	CPI	1AH
	RZ			;END FOUND, RETURN
	MOV	E,A
	MVI	C,DCIO		;USE DIRECT CONSOLE
	PUSH	H		;SAVE POINTER
	CALL	BDOS
	POP	H
	INX	H
	JMP	PMSG1

;	DATA AND STORAGE

ERAM	DB	27,'y1$'
FILEX	DB	13,10,'File already exists.  '
	DB	'Want to erase it? (Y or N -- RETURN = Y) $'
NOSPC	DB	13,10,'ERROR -- No directory space.',13,10,'$'
BADWRT	DB	13,10,'ERROR -- No disk space.',13,10,'$'
PRMSG	DB	13,10,10,'STATLIN Status Line Message Generator, V 1.0'
	DB	13,10,10
	DB	'Enter messages for each key from left to '
	DB	'right.',13,10,'$'
ENMSG	DB	13,10,'Enter message: $'
OKM	DB	13,10,10
	DB	'Does this look OK? (Y or N -- RETURN = Y) $'

INTRO	DB	27,'j',27,'x1',27,'Y8 ',27,'F    ',27,'pi',27,'G'
ISTR	DB	27,'Fi',27,'G'
OUTRO	DB	27,'q',27,'k',1AH

OUTPTR	DW	0		;OUTPUT POINTER
INBUF	DS	16		;INPUT BUFFER
	DS	32		;STACK SPACE
STACK	EQU	$
	END	START
	27,'q',27,'k',1AH

OUTPTR	DW	0		;OUTPUT POINTER
INBUF	DS	16		;INPUT BUFF