	PAGE	,132
;	Copyright(C) 1985, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	     This computer software and documentation 
;	are provided with RESTRICTED RIGHTS.  Use,
;	duplication or disclosure by the Government is
;	subject to restrictions as set forth in the
;	governing Rights in Technical Data and Computer
;	Software clause -- subdivision (b)(3)(B) of DAR
;	7-104.9(a) (May 1981) or subdivision (b)(3)(ii)
;	of DOD FAR Supp 252.227-7013 (May 1981).
;
;
	TITLE	PBE - Phony BIOS entry points

	.LFCOND
	.TFCOND		; Use /X switch to cause FALSE conds not to list

;  BIOS for MS-DOS 2.00
;
;      This is the so called Basic I/O
;      System for MS-DOS.
;
;      It is loaded into memory at a known
;      location by the MS-DOS Loader.
;
; 10/08/82 - BPE module created
;
;  (C)COPYRIGHT 1982 BY ZENITH DATA SYSTEMS
;
;	This PBE module is used as the entry point for old BIOS
;	functions. It is used here to support those routines needed
;	byte DSKCOxx and FORMAT, et al.
;

	INCLUDE	 PARMS.ASM		; Get program parms
	INCLUDE	 VER.ASM			; Version

    IF1
	%OUT	*Pass 1 started*
    ELSE
	%OUT	*Pass 2 started*
    ENDIF

    IF LISTI
	IF1
	%OUT	*Full listing being generated*
	ENDIF
    ELSE
	IF1
	%OUT	*Include files are not part of listing*
	ENDIF
	.XLIST
    ENDIF

	INCLUDE	 DEFDEV.ASM
	INCLUDE	 DEFCHR.ASM
	INCLUDE	 DEFDSK.ASM
	INCLUDE	 DEFZ207.ASM
	INCLUDE	 DEFZ217.ASM
	.LIST

	PAGE

BIOS_SEG SEGMENT BYTE PUBLIC 'BIOSCODE'

	ASSUME	CS:BIOS_SEG,DS:BIOS_SEG,ES:NOTHING,SS:BIOS_SEG

	PUBLIC	BIOS_DSKFUNC		; Disk functions

	EXTRN	BIOS_CONFUNC:NEAR,BIOS_PRNFUNC:NEAR,BIOS_AUXFUNC:NEAR

	EXTRN	DSK:NEAR
	EXTRN	RECURLV:WORD
	EXTRN	SAVESS:WORD
	EXTRN	SAVESP:WORD
	EXTRN	BIOS_STACK:NEAR
	EXTRN	DSK0_MCHK1:NEAR

	PUBLIC	PBE_STATUS,PBE_CONIN,PBE_CONOUT
	PUBLIC	PBE_PRINT,PBE_AUXIN,PBE_AUXOUT
	PUBLIC	PBE_READ,PBE_WRITE,PBE_DSKCHG
	PUBLIC	PBE_SETDATE,PBE_SETTIME,PBE_GETDATE
	PUBLIC	PBE_FLUSH,PBE_MAPDEV

	ORG	0

;*	BPE - BIOS Phony Entry Points
;
;	Phony entry points for BIOS jump table calls
;

;*	BPE_xxxxxx - Routines not implimented
;

;  PBE_READ - Read from the disk
;
;     Call with:
;         AL = Device number
;         CX = Number of sectors to read
;         DX = Logical sector number
;         DS:BX = transfer addr
;
;     Returns:
;         CX = number of sectors not read
;         Success: CY = 0
;         Failure: CY = 1, AL = error code
;
;     Uses: All other regs(segment regs are preserved)
;

PBE_READ:
	MOV	AH,DSK_READ	; Get function to do
	JMP	NEAR PTR PBE_RDWR ; Join common code

;
;  PBE_WRITE - Write to the disk
;
;     Call with:
;         AL = Device number
;         AH = Verify flag: 0=no verify, 1=verify after write
;         CX = Number of sectors to write
;         DX = Logical sector number
;         DS:BX = transfer addr
;
;     Returns:
;         CX = Number of sectors not written
;         Success: CY = 0
;         Failure: CY = 1, AL = error code
;
;     Uses: All other regs(segment regs are perserved)
;

PBE_WRITE:
	MOV	AH,DSK_WRITE	; Get function to do (ignore verify for now)
	

;
; Common code for read and write
;
PBE_RDWR PROC	FAR
	PUSH	DS		; Save DS
	PUSH	ES		; Save ES
	MOV	CS: WORD PTR DSKPR+DSKPR_BUFF+2,DS ; Store DS
	PUSH	CS		; Set up DS seg reg
	POP	DS

;  Put the parameters in the packet

	MOV	BYTE PTR DSKPR+DSKPR_DRIVE,AL ; Drive number
	MOV	WORD PTR DSKPR+DSKPR_SECTOR,DX ; Logical sector
	MOV	WORD PTR DSKPR+DSKPR_COUNT,CX ; Sector count
	MOV	WORD PTR DSKPR+DSKPR_BUFF,BX ; Offset of buffer
	MOV	BX,OFFSET DSKPR	; Get addr of packet
	PUSH	DS		; Set up ES seg reg
	POP	ES
	MOV	AL,AH		; Get function to do
	PUSHF			; Save interrupt status
	STI			; Turn interrupts on
	CALL	DSK		; Perform the function, Did error occur ?
	LAHF			; Save flags
	POPF			; Restore interrupt status
	SAHF			; Restore flags
	JNC	BIOS_RWF	;   No, success so return
	MOV	SI,-1		; Start with entry -1
RW_EL:	INC	SI		; Bump entry number
	MOV	AH,BYTE PTR RW_ERRB[SI] ; Get error code
	CMP	AH,0FFH		; At end of table ?
	JE	RW_EFI		;   Yes, get out
	TEST	AL,AH		; Do any bits match ?
	JZ	RW_EL		;   No, try next entry
RW_EFI:
	MOV	AL,BYTE PTR RW_ERRC[SI]	;   Yes, get error code
	STC			; Turn on CY to show error
BIOS_RWF:
	MOV	CX,WORD PTR DSKPR+DSKPR_COUNT ; Return remaining sectors

	POP	ES		; Restore ES
	POP	DS		; Restore DS

	RET			;   and return
PBE_RDWR ENDP

;	Corresponding Z-DOS error codes

DSKE_WRITEP	EQU	0
DSKE_NREADY	EQU	2
DSKE_DATA	EQU	4
DSKE_SEEK	EQU	6
DSKE_SECT	EQU	8
DSKE_WFAULT	EQU	10
DSKE_OTHER	EQU	12

RW_ERRC DB	DSKE_WRITEP	; Write protect
	DB	DSKE_NREADY	; Not ready
	DB	DSKE_DATA	; Data error
	DB	DSKE_SEEK	; Seek error
	DB	DSKE_SECT	; Sector error
	DB	DSKE_WFAULT	; Write fault
	DB	DSKE_OTHER	; Catchall error

;	List of errors generated by z207

RW_ERRB DB	FDSWPV		; Write protect
	DB	FDSNRD		; Not ready
	DB	FDSCRC+FDSLDT	; CRC error and Lost data
	DB	FDSSEK		; Seek error
	DB	0
	DB	FDSWTF		; Write fault
	DB	-1

;	Translate z217 errors to z207 errors

RW_ERRD	DB	WIEDNR,FDSNRD	; Drive not ready
	DB	WIENSC,FDSSEK	; No seek complete
	DB	WIENTZ,FDSSEK	; No track zero
	DB	WIENI,FDSNRD	; No index pulse
	DB	WIENDS,FDSNRD	; No drive select
	DB	WIEHNF,FDSSEK	; No header AM found
	DB	WIESKE,FDSSEK	; Seek error
	DB	WIESNF,FDSSEK	; Sector not found
	DB	WIEHECC,FDSSEK	; ECC error in header
	DB	WIEDAM,FDSCRC+FDSLDT	; Data AM not found
	DB	WIENECC,FDSCRC+FDSLDT	; Non-correctable ECC error
	DB	WIECECC,FDSCRC+FDSLDT	; Correctable ECC error
	DB	WIEWF,FDSWTF	; Write fault
	DB	WIEIOC,-1	; Illegal op code
	DB	WIEIDA,FDSSEK	; Illegal disk address
	DB	WIEFP,FDSWTF	; Drive format protected
	DB	WIEWP,FDSWTF	; Drive write protected
	DB	WIEMISC,-1	; Misc. error
	DB	-1,-1		; Terminates table
	EXTRN	BIOS_DATE:WORD
	EXTRN	BIOS_HRS:BYTE
	EXTRN	BIOS_MIN:BYTE
	EXTRN	BIOS_SEC:BYTE
	EXTRN	BIOS_HSEC:WORD

;
;  PBE_SETDATE - Set the date
;
;     Call with:
;         AX = the number of days since Jan 1, 1980.
;
;     Uses: No registers are used.
;
 
PBE_SETDATE PROC FAR
	PUSHF			; Save status
	CLI			; Turn off interrupts
	MOV	CS: BIOS_DATE,AX ; Save it
	POPF			; Restore status
	RET
PBE_SETDATE ENDP


;
;  PBE_SETTIME - Set the time
;
;      CALL with:
;          CH = hours (0-23)
;          CL = minutes (0-59)
;          DH = seconds (0-59)
;          DL = hundredths of seconds (0-99)
;
;     Uses: No registers are used
;

PBE_SETTIME PROC FAR
	PUSHF			; Save current status
	CLI			; Turn off interrupts
	MOV	CS: BIOS_HRS,CH ; Save hours
	MOV	CS: BIOS_MIN,CL ; Save minutes
	MOV	CS: BIOS_SEC,DH	; Save seconds
	MOV	CS: BYTE PTR BIOS_HSEC,DL ; Save hundredths of seconds
	POPF			; Restore status
	RET
PBE_SETTIME ENDP


;
;  PBE_GETDATE - Get time and date
;
;      Returns:
;          AX = count of days since Jan 1, 1980.
;          CH = hours
;          CL = minutes
;          DH = seconds
;          DL = hunderdths of seconds
;
;     Uses: No registers are used
;

PBE_GETDATE PROC FAR
	PUSHF			; Save current status
	CLI			; Turn off interrupts
	MOV	AX,CS: BIOS_DATE ; Get date
	MOV	CH,CS: BIOS_HRS ; Get hours
	MOV	CL,CS: BIOS_MIN ; Get minutes
	MOV	DH,CS: BIOS_SEC ; Get seconds
	MOV	DL,CS: BYTE PTR BIOS_HSEC ; Get hundredths of seconds
	POPF			; Restore status
	RET
PBE_GETDATE ENDP

;
;  PBE_AUXIN - Aux input
;
;     Wait for a character from the MODEM(auxiliary) input device.
;
;     Returns:
;         AL = character read
;
;     Uses: No registers are modified.
;

PBE_AUXIN PROC FAR
	PUSH	BX		; Save regs
	PUSH	DI
	PUSH	SI
	PUSH	DX
BAUXIN1:
	PUSH	AX
	MOV	AH,CHR_READ	; Get read function code
	PUSH	CS		; Make call into far call
	CALL	NEAR PTR BIOS_AUXFUNC ; Read char, any errors
	MOV	BL,AL		; Save char
	POP	AX
	JC	BAUXIN1		; If an error, then try again

	MOV	AL,BL		; Get char
	POP	DX		; Restore regs
	POP	SI
	POP	DI
	POP	BX
	RET			;    and return
PBE_AUXIN ENDP

;
;  PBE_AUXOUT - Aux output
;
;     Output a character to the MODEM(auxiliary) output device.
;
;     Call with:
;         AL = character to output
;
;     Uses: No registers are modified.
;

PBE_AUXOUT PROC FAR
	PUSH	BX		; Save regs
	PUSH	DI
	PUSH	SI
	PUSH	DX
BAUXOUT1:
	PUSH	AX
	MOV	AH,CHR_WRITE	; Get write function code
	PUSH	CS		; Make call into far call
	CALL	NEAR PTR BIOS_AUXFUNC ; Write char, any errors ?
	POP	AX
	JC	BAUXOUT1	; If an error, then try again

	POP	DX		; Restore regs
	POP	SI
	POP	DI
	POP	BX
	RET			;    and return
PBE_AUXOUT ENDP
;
;  PBE_PRINT - Printer output
;
;     Output the character to the printer.
;
;     Call with:
;         AL = character to print
;
;     Uses: No regs are changed.
;

PBE_PRINT PROC FAR
	PUSH	BX		; Save regs
	PUSH	DI
	PUSH	SI
	PUSH	DX
BPRINTL:
	PUSH	AX		
	MOV	AH,CHR_WRITE	; Get write function code
	PUSH	CS		; Make call into far call
	CALL	NEAR PTR BIOS_PRNFUNC ; Print char, any errors
	POP	AX
	JC	BPRINTL		;    Yes, try again

	POP	DX		; Restore regs
	POP	SI
	POP	DI
	POP	BX
	RET
PBE_PRINT ENDP

;
;  PBE_STATUS - Console status
;
;     Check if a character is ready at the console.
;
;     Returns:
;         "Z" clear - character in AL
;         "Z" set - AL = 0 (No character ready)
;
;     Uses: No registers are modified
;

PBE_STATUS PROC FAR
	PUSH	BX		; Save regs
	PUSH	DI
	PUSH	SI
	PUSH	DX
	PUSH	AX
	MOV	AH,CHR_LOOK	; Get Look function
	PUSH	CS		; Make into far call
	CALL	NEAR PTR BIOS_CONFUNC ; Get copy of first char in queue, empty?
	MOV	BL,0		; Assume queue empty, was it ?
	JC	BSTAT1		;    Yes, skip
	MOV	BL,AL		;    No, Save char
BSTAT1:
	MOV	AL,0FFH		; Get -1
	ADC	AL,0		; Set "Z" flag appropriately
	POP	AX		; Recover AX
	MOV	AL,BL		; Get char
	POP	DX		; Restore regs
	POP	SI
	POP	DI
	POP	BX
	RET			;   and return


PBE_STATUS ENDP

;
;  PBE_CONIN - Console input
;
;     Wait for character from the console, then return the character.
;
;     Returns:
;         AL = character 
;
;     Uses: No registers are modified
;

PBE_CONIN PROC FAR
	PUSH	BX		; Save regs
	PUSH	DI
	PUSH	SI
	PUSH	DX
BCONIN1:
	PUSH	AX
	MOV	AH,CHR_READ	; Get read function
	PUSH	CS		; Make call a far call
	CALL	NEAR PTR BIOS_CONFUNC ; Read char, any errors ?
	MOV	BL,AL		; Save char
	POP	AX
	JC	BCONIN1		; If an error, then try again

	MOV	AL,BL		; Get char
	POP	DX		; Restore regs
	POP	SI
	POP	DI
	POP	BX
	RET			;   and return
PBE_CONIN ENDP


;
;  PBE_FLUSH - Flush the keyboard type ahead queue
;
;     Uses:  No registers are changed.
;

PBE_FLUSH PROC	FAR
	PUSH	BX		; Save regs
	PUSH	DI
	PUSH	SI
	PUSH	DX
	PUSH	AX
	MOV	AH,CHR_CONTROL	; Get control function
	MOV	AL,CHR_CFCI	; Get clear input subfunction
	PUSH	CS		; Make call a far call
	CALL	NEAR PTR BIOS_CONFUNC ; Clear input, (ignore errors)
	POP	AX		; Restore regs
	POP	DX
	POP	SI
	POP	DI
	POP	BX
	RET			;   and return
PBE_FLUSH ENDP

;
;  PBE_CONOUT - Console output
;
;     Call with:
;         AL = character to output
;
;     Uses: No registers are changed.
;

PBE_CONOUT PROC FAR
	PUSH	BX		; Save regs
	PUSH	DI
	PUSH	SI
	PUSH	DX
BCONOUT1:
	PUSH	AX
	MOV	AH,CHR_WRITE	; Get write function
	PUSH	CS		; Make call a far call
	CALL	NEAR PTR BIOS_CONFUNC ; Write char, any errors ?
	POP	AX
	JC	BCONOUT1	; If an error, then try again

	POP	DX		; Restore regs
	POP	SI
	POP	DI
	POP	BX
	RET			;   and return
PBE_CONOUT ENDP

DSKPR	DB	0			; Drive
	DW	0			; Start
	DW	0			; Count
	DD	0			; Address

;*	These routines simply return with no errors
;

PBE_DSKCHG	PROC	FAR

;	First, Inform the BIOS of the disk change action

	PUSH	DS
	PUSH	BX
	PUSH	ES
	PUSH	AX
	MOV	BX,CS
	MOV	DS,BX		; DS:BX must point to packet
	MOV	ES,BX
	MOV	BX,OFFSET PBE_DSKCHGA	; Pointer to packet

;	AL = unit number

	MOV	SRH_UNIT[BX],AL	; Save unit number

;	Set the FDC bit for this drive

	MOV	AH,AL
	MOV	AL,DSK_SETFDC
	CALL	DSK

	CALL	DSK0_MCHK1	; Check it
	POP	AX
	POP	ES
	POP	BX
	POP	DS
	MOV	AH,0		; Show disk might have changed
	CLC
	RET
PBE_DSKCHG	ENDP

PBE_DSKCHGA	LABEL	NEAR	; Packet for call to DSK0_MCHK
	SRH_STRUC	<13H,0,SRHC_MCHK,0>

	DB	(TYPE CMC_STRUC) - (TYPE SRH_STRUC) DUP (0)  ; The rest of CMC_STRUC

PBE_MAPDEV	PROC	FAR
	CLC
	RET
PBE_MAPDEV	ENDP

;*	These routines actually do something!
;

BIOS_DSKFUNC	PROC	FAR
	CLI
	INC	WORD PTR CS:RECURLV	; Bump recursion
	JNZ	BDSK1			; If nested call
	MOV	CS:SAVESP,SP		; Save current stack area
	MOV	CS:SAVESS,SS
	PUSH	CS
	POP	SS			; Set up local stack
	MOV	SP,OFFSET BIOS_STACK	;  area for first level call
BDSK1:
	STI
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	CS
	POP	DS
	CALL	DSK			; Do call
	POP	DS
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	CLI
	DEC	WORD PTR CS:RECURLV	; Leaving last level?
	JNS	BDSK2			; Nope, leave stack
	MOV	SS,CS:SAVESS
	MOV	SP,CS:SAVESP		; Restore user stack
BDSK2:
	STI
	RET
BIOS_DSKFUNC	ENDP

BIOS_SEG ENDS
	END

