;	Copyright(C) 1985, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	     This computer software and documentation 
;	are provided with RESTRICTED RIGHTS.  Use,
;	duplication or disclosure by the Government is
;	subject to restrictions as set forth in the
;	governing Rights in Technical Data and Computer
;	Software clause -- subdivision (b)(3)(B) of DAR
;	7-104.9(a) (May 1981) or subdivision (b)(3)(ii)
;	of DOD FAR Supp 252.227-7013 (May 1981).
;
;
;
; Definitions for MS-DOS
;

;
;  System functions for "interrupt 21"
;    (Note: functions followed by "*" are
;           not CP/M compatable
;

DOSF_TERM	EQU  0		; Program terminate
DOSF_CONIN	EQU  1		; Console input
DOSF_CONOUT	EQU  2		; Console output
DOSF_AUXIN	EQU  3		; Aux input
DOSF_AUXOUT	EQU  4		; Aux output
DOSF_PRINTOUT	EQU  5		; Printer output
DOSF_DRCIO	EQU  6		; Direct console I/O
DOSF_DRCI	EQU  7		; * Direct console input
DOSF_DRCINE	EQU  8		; * Console input(no echo)
DOSF_OUTSTR	EQU  9		; Output string
DOSF_INSTR	EQU 10		; Input string
DOSF_STCON	EQU 11		; Status of console
DOSF_CONINF	EQU 12		; * Flush keyboard buffer and input
DOSF_RSDISK	EQU 13		; Disk system reset
DOSF_SELDISK	EQU 14		; Select default disk
DOSF_OPFILE	EQU 15		; Open file
DOSF_CLFILE	EQU 16		; Close file
DOSF_SRHFI	EQU 17		; Search for first
DOSF_SRHNX	EQU 18		; Search for next
DOSF_DEFILE	EQU 19		; Delete file
DOSF_SEQREAD	EQU 20		; Sequential read
DOSF_SEQWRITE	EQU 21		; Sequential write
DOSF_CRFILE	EQU 22		; Create file
DOSF_REFILE	EQU 23		; Rename file
DOSF_GETDISK	EQU 25		; Get default disk
DOSF_SDIOA	EQU 26		; Set disk I/O address
DOSF_DEFDRDAT	EQU 27		; Get default drive data
DOSF_DRDATA	EQU 28		; Get drive data
DOSF_RANREAD	EQU 33		; Random read
DOSF_RANWRITE	EQU 34		; Random write
DOSF_GFSIZE	EQU 35		; Get file size
DOSF_SFPOS	EQU 36		; Set file position

;* The remaining functions are not CP/M compatable

DOSF_SIVEC	EQU 37		; Set interrupt vecter
DOSF_CESEG	EQU 38		; Create segment
DOSF_RBLREAD	EQU 39		; Random block read
DOSF_RBLWRITE	EQU 40		; Random block write
DOSF_PARSE	EQU 41		; Parse file name
DOSF_GDATE	EQU 42		; Get date
DOSF_SDATE	EQU 43		; Set date
DOSF_GTIME	EQU 44		; Get time
DOSF_STIME	EQU 45		; Set time
DOSF_CVERF	EQU 46		; Set/Reset verify flag

;*	DEFMS20 - Define Z-DOS 2.0 system calls
;
;	These calls are the added 2.0 function calls
;
;	10/13/82 - bcb
;

;	Extended functionality group

DOSF_GETDMA	EQU 47		; Get DMA address
DOSF_GETVER	EQU 48		; Get DOS version
DOSF_KEEPPRC	EQU 49		; Keep process (int 27)
DOSF_SETCTLC	EQU 51		; Set ^C trapping
DOSF_INDOS	EQU 52		; Get dos critical flag
DOSF_GIVEC	EQU 53		; Set/get interrupt vector
DOSF_DRVFRE	EQU 54		; Drive free space
DOSF_CHROP	EQU 55		; Character operations
DOSF_INTERN	EQU 56		; International information

  IISTRUC	STRUC			; International Information return
  II_DTF	DW	0		; Date/time format
					;   0 = USA (h:m:s m/d/y)
					;   1 = Europe (h:m:s d/m/y)
					;   2 = Japan (y/m/d h:m:s)
  II_CURR	DB	0		; Ascii currency symbol
  II_THOU	DB	0		; Ascii thousands seperator
  II_DECI	DB	0		; Ascii decimal seperator
  IISTRUC	ENDS

;	XENIX calls

DOSF_MKDIR	EQU 57		; Make directory
DOSF_RMDIR	EQU 58		; Remove directory
DOSF_CHDIR	EQU 59		; Change directory

;	File group

DOSF_CREATH	EQU 60		; Create file
DOSF_OPENH	EQU 61		; Open file
 DOSFO_RED	 EQU 0		;  Open for read
 DOSFO_WRT	 EQU 1		;  Open for write
 DOSFO_RW	 EQU 2		;  Open for read/write
DOSF_CLOSEH	EQU 62		; Close file
DOSF_READH	EQU 63		; Read file
DOSF_WRITEH	EQU 64		; Write file
DOSF_UNLINK	EQU 65		; Unlink file
DOSF_LSEEK	EQU 66		; Logical seek file
 DOSFL_BEG	 EQU 0		;  Seek from begining
 DOSFL_CUR	 EQU 1		;  Seek from current
 DOSFL_END	 EQU 2		;  Seek from end
DOSF_CHMOD	EQU 67		; CHMOD of file
DOSF_IOCTL	EQU 68		; IOCTL value
 DOSFI_GDI	 EQU 0		;  Get device information
 DOSFI_SDI	 EQU 1		;  Set device information
  DI_ISCIC	  EQU 0001H		; If device is STDIN
  DI_ISCOT	  EQU 0002H		; If device is STDOUT
  DI_ISNUL	  EQU 0004H		; If device is NUL
  DI_ISCLK	  EQU 0008H		; If device is CLOCK
  DI_FCOUT	  EQU 0010H		; Special "fast output" device
  DI_RAW	  EQU 0020H		; Is in raw mode
  DI_EOF	  EQU 0040H		; Has hit EOF (or written if DEV=0)
  DI_DEV	  EQU 0080H		; If device, else is file
  DI_RDEV	  EQU 1000H		; If block device is remote
  DI_CTRL	  EQU 4000H		; =1 if can accept control strings
  DI_RHND	  EQU 8000H		; If handle is remote
 DOSFI_RED	 EQU 2		;  Read from device
 DOSFI_WRT	 EQU 3		;  Write to device
 DOSFI_REDB	 EQU 4		;  Read from device (Drive in BL)
 DOSFI_WRTB	 EQU 5		;  Write to device (Drive in BL)
 DOSFI_ISTAT	 EQU 6		;  Input status
 DOSFI_OSTAT	 EQU 7		;  Output status
 DOSFI_REM	 EQU 8		;  Is media removable?
 DOSFI_BREDIR	 EQU 9		;  Is block device redirected?
 DOSFI_HREDIR	 EQU 10		;  Is handle redirected?
 DOSFI_RETRY	 EQU 11		;  Change sharing retry count
DOSF_XDUP	EQU 69		; DUP handle
DOSF_XDUP2	EQU 70		; DUP2 handle
DOSF_CWD	EQU 71		; Current directory

;	Memory allocation group

DOSF_ALLOC	EQU 72		; Allocate block
DOSF_DEALLOC	EQU 73		; Deallocate block
DOSF_SETBLK	EQU 74		; Set block to size

;	Process group

DOSF_EXEC	EQU 75		; Execute
 DOSX_GO	 EQU 0		;  EXEC program

  XGSTRUC	STRUC			; EXEC block for DOSX_GO
  XG_ENV	DW	0		; Segement address of environment
  XG_COMM	DD	0		; Command line at 80h
  XG_FCB1	DD	0		; Default FCB at 5ch
  XG_FCB2	DD	0		; Default FCB at 6ch
  XGSTRUC	ENDS

 DOSX_LOAD	 EQU 2		;  Load only, no PHD, don't run

  XLSTRUC	STRUC			; EXEC block for DOSX_LOAD
  XL_LOAD	DW	0		; Segment to load block at
  XL_RELOC	DW	0		; Relocation facto to apply
  XLSTRUC	ENDS

DOSF_EXIT	EQU 76		; Exit
DOSF_WAIT	EQU 77		; Wait

;	High byte of exit code (low byte defined by program exiting)

  WT_TERM	 EQU 0000H		; Normal terminate/abort
  WT_CTLC	 EQU 0100H		; Exit through ^C
  WT_HRDERR	 EQU 0200H		; Hard error termination
  WT_TSR	 EQU 0300H		; Terminate - stay resident


;	Special group

DOSF_FFIRST	EQU 78		; Find first

  FFSTRUC	STRUC			; Data returned by FFIRST and FNEXT
		DB	21 DUP (?)	; Reserved by system
  FFS_ATTR	DB	0		; Attribute of file found
  FFS_TIME	DW	0		; Time of file
  FFS_DATE	DW	0		; Date of file
  FFS_SIZE	DD	0		; Size of file in bytes 
  FFS_NAME	DB	13 DUP (?)	; ASCIZ name of file found
  FFSTRUC	ENDS

DOSF_FNEXT	EQU 79		; Find next

;	System group

DOSF_GVOW	EQU 84		; Get verify on write
DOSF_RENAME	EQU 86		; Rename to different directory
DOSF_FTIMES	EQU 87		; write date/time of file handle

;	NOTE: All XENIX calls return with 'CY' set if error
;	occurs, and AX = error code. If no error, 'CY' is
;	clear and AX contains returned data

;	The following are new 3.0 system calls

DOSF_GSALLOC	EQU 88		; Get/Set Allocation strategy
DOSF_EXTERR	EQU 89		; Get extended error
DOSF_MKTEMP	EQU 90		; Create temporary file
DOSF_MKNEW	EQU 91		; Create new file
DOSF_LUREGN	EQU 92		; Lock/Unlock file region
 DOSFR_LOCK	 EQU 0		; Lock
 DOSFR_UNLOCK	 EQU 1		; Unlock

;	Network group

DOSF_NETINFO	EQU 94		; Get/Set machine info
 DOSFN_GETNAME	 EQU 1		; Get machine name
 DOSFN_SETRPRN	 EQU 2		; Remote printer setup
DOSF_NETASGN	EQU 95		; Assign names across network
 DOSFN_GETLST	 EQU 2		; Get assign list entry
 DOSFN_ASGNDRV	 EQU 3		; Define macro
 DOSFN_CANASGN	 EQU 4		; Cancel macro

;	System group

DOSF_TRANSL	EQU 96		; Translate
DOSF_PARSEP	EQU 97		; Parse path name
DOSF_GETPSP	EQU 98		; Get current program segment prefix


;	The following are 3.0 error codes

DOSE_NOERR	EQU 0		; No error
DOSE_INVFUNC	EQU 1		; Unknown function
DOSE_NOFILE	EQU 2		; File not found
DOSE_NOPATH	EQU 3		; Path not found
DOSE_TMFILES	EQU 4		; Too many open files
DOSE_ACCESS	EQU 5		; Access denied
DOSE_NOHNDL	EQU 6		; Invalid handle
DOSE_ARENA	EQU 7		; Arena trashed
DOSE_NORAM	EQU 8		; Not enough RAM
DOSE_NOBLK	EQU 9		; Bad Block
DOSE_NOENV	EQU 10		; Bad environment
DOSE_NOFMT	EQU 11		; Bad format
DOSE_INVACC	EQU 12		; Bad Access code
DOSE_INVDAT	EQU 13		; Bad data
DOSE_INVDRV	EQU 15		; Bad drive
DOSE_CURDIR	EQU 16		; Current directory
DOSE_NOTSAM	EQU 17		; Not same device
DOSE_NMFILES	EQU 18		; No more files
DOSE_WRTPROT	EQU 19		; Disk is write protected
DOSE_BADUNIT	EQU 20		; Bad disk unit
DOSE_DRNR	EQU 21		; Drive not ready
DOSE_INVCOM	EQU 22		; Invalid disk command
DOSE_BADCRC	EQU 23		; CRC error
DOSE_INVLEN	EQU 24		; Invalid length (disk operation)
DOSE_SEEK	EQU 25		; Seek error
DOSE_NOTDOS	EQU 26		; Not an MS-DOS disk
DOSE_SECNF	EQU 27		; Sector not found
DOSE_PAPER	EQU 28		; Out of paper
DOSE_WFLT	EQU 29		; Write fault
DOSE_RFLT	EQU 30		; Read fault
DOSE_GEN	EQU 31		; General failure
DOSE_SHARE	EQU 32		; Sharing violation
DOSE_LOCK	EQU 33		; Lock violation
DOSE_WRDISK	EQU 34		; Wrong disk
DOSE_UNFCB	EQU 35		; FCB unavailable
DOSE_NREQ	EQU 50		; Network request not supported
DOSE_REMNL	EQU 51		; Remote computer not listening
DOSE_NDUP	EQU 52		; Duplicate name on network
DOSE_NNONAME	EQU 53		; Network name not found
DOSE_NBUSY	EQU 54		; Network busy
DOSE_NNODEV	EQU 55		; Network device no longer exists
DOSE_NBIOS	EQU 56		; Net BIOS command limit exceeded
DOSE_NADAPT	EQU 57		; Network adapter hardware error
DOSE_NRESP	EQU 58		; Incorrect response from network
DOSE_NERR	EQU 59		; Unexpected network error
DOSE_NIRA	EQU 60		; Incompatible remote adapter
DOSE_PQFULL	EQU 61		; Print queue full
DOSE_NOTFULL	EQU 62		; Queue not full
DOSE_NOSPACE	EQU 63		; Not enough space for print file
DOSE_NNDEL	EQU 64		; Network name deleted
DOSE_NOACCESS	EQU 65		; Access denied
DOSE_NBADDEV	EQU 66		; Network device type incorrect
DOSE_NNONAME2	EQU 67		; Network name not found
DOSE_NLIMIT	EQU 68		; Network name limit exceeded
DOSE_NBIOSL	EQU 69		; Network BIOS session limit exceeded
DOSE_PAUSE	EQU 70		; Temporarily paused
DOSE_NREQNA	EQU 71		; Network request not accepted
DOSE_REDPAU	EQU 72		; Print or disk redirection paused
DOSE_EXIST	EQU 80		; File exists
DOSE_NOMAKE	EQU 82		; Cannot make
DOSE_INT24	EQU 83		; Interrupt 24 failure
DOSE_NOSTRUC	EQU 84		; Out of structures
DOSE_ASGN	EQU 85		; Already assigned
DOSE_INVPASS	EQU 86		; Invalid password
DOSE_INVPARM	EQU 87		; Invalid parameter
DOSE_NWRFLT	EQU 88		; Net write fault

;	These are the 3.0 error classes

DOSEC_RES	EQU 1		; Out of a resource, such as storage or channels
DOSEC_TEMP	EQU 2		; Not an error, but a temporary situation
DOSEC_AUTH	EQU 3		; Authorization problem
DOSEC_INT	EQU 4		; An internal error in system software
DOSEC_HWARE	EQU 5		; Hardware failure
DOSEC_SYST	EQU 6		; System software error external to active process
DOSEC_APP	EQU 7		; Application program error
DOSEC_NFOUND	EQU 8		; File or item not found
DOSEC_TYPE	EQU 9		; File or item of invalid format or type
DOSEC_LOCK	EQU 10		; File or item interlocked
DOSEC_DISK	EQU 11		; Problem with storage medium
DOSEC_OTHER	EQU 12		; Other error

;	These are the 3.0 error suggested actions

DOSEA_RETRY	EQU 1		; Retry, then prompt user
DOSEA_PRET	EQU 2		; Pause, then retry
DOSEA_PROMPT	EQU 3		; Prompt user for data again
DOSEA_CLEAN	EQU 4		; Terminate with cleanup
DOSEA_ABORT	EQU 5		; Terminate immediately
DOSEA_INFO	EQU 6		; Error is informational.  No action
DOSEA_ACTION	EQU 7		; Prompt user to perform some action such as changing
				;   disks, then retry the operation

;	These are the 3.0 error loci

DOSEL_UNK	EQU 1		; Unknown
DOSEL_BLOCK	EQU 2		; Related to random access block device
DOSEL_NET	EQU 3		; Related to network
DOSEL_CHAR	EQU 4		; Related to serial access character devices
DOSEL_RAM	EQU 5		; Related to random access memory


;	Default I/O handles

STDIN	EQU	0		; Standard input (redirectable)
STDOUT	EQU	1		; Standard output (redirectable)
STDERR	EQU	2		; Standard error
STDAUX	EQU	3		; Standard AUX
STDPRN	EQU	4		; Standard PRN

;	Macro for dealing with system software interrupts
;
;	Syntax is:
;
;	SCALL	foo
;
;	The result is a system call to DOSF_foo
;

SCALL	MACRO	ARG
	MOV	AH,DOSF_&ARG
	INT	21H
	ENDM

