/**** diskinfo - get information on disk drive
*
*	Programmer:	Darron J Shaffer
*
*	Date:		Jul 03, 1987
*
*	This subroutine will return a structure with information on
*	the disk in question.
*/

#define LINT_ARGS

#include    <dos.h>
#include    "diskinfo.h"

struct DISKINFO  diskinfo(drive)
int	drive;		/* drive number: 0=default, 1=A, etc. */
{
    union REGS	    regs;   /* register image for dos call */
    struct DISKINFO info;   /* put the information here */

    regs.h.ah = 0x36;	    /* function=36h (disk space) */
    regs.h.dl = drive;

    intdos(&regs,&regs);    /* call dos */

    info.sec_per_cluster = regs.x.ax;	/* set sectors/cluster */
    info.bytes_per_sector = regs.x.cx;	/* set bytes/sector */
    info.total_clusters = regs.x.dx;	/* set total clusters */
    info.avail_clusters = regs.x.bx;	/* set free clusters */

    return info;
}

